<?php

namespace api\v2\dashboards_v2;
use api\v2\Base;
use Exception;

use function api\v2\import_common;
import_common();

/**
 * Manages dashboards including retrieval, creation, deletion, and updates.
 */
class dashlets extends Base {

    /**
     * Auth function for get request method on api/v2/account/dashboards 
     * All necessary auth is done in check_authentication so this just returns true.
     */
    public function authorized_for_get() {
        return true;
    }

    /**
     * Retrieves a dashboard by ID, or all dashboards if no ID is specified.
     * @return array The dashboard data or an error message if not found.
     */
    public function get() {
        global $db_tables;

        $dashboard_id = grab_request_var("dashboard_id", "");
        $user_id = $_SESSION['user_id'];
        $global_dashboard_access = get_user_meta(0, 'global_dashboard_access', 1);
        
        if ($global_dashboard_access == 0 && !is_admin()) {
            $dashsql = "SELECT * FROM " . $db_tables[DB_NAGIOSXI]["dashboards"] . " WHERE dashboard_id='" . $dashboard_id . "' AND user_id= '" . $user_id . "' AND is_global= 0";
        } else {
            $dashsql = "SELECT * FROM " . $db_tables[DB_NAGIOSXI]["dashboards"] . " WHERE dashboard_id='" . $dashboard_id . "' AND (user_id= '" . $user_id . "' OR is_global= 1)";
        }
        $dashboard = exec_sql_query(DB_NAGIOSXI, $dashsql);
        if ($dashboard->RecordCount() == 0) {
            return [];
        }

        $sql = "SELECT * FROM " . $db_tables[DB_NAGIOSXI]["dashlets"] . " WHERE dashboard_id='" . $dashboard_id . "' ORDER BY id ASC";
        $dashlets = exec_sql_query(DB_NAGIOSXI, $sql);
        $response = $dashlets->GetRows();
        
        return $response;
    }

    /**
     * Auth function for post request method on api/v2/account/dashboards 
     * All necessary auth is done in check_authentication so this just returns true.
     */
    public function authorized_for_post() {
        return true;
    }

    /**
     * Adds a new dashlet with provided parameters.
     * @return array Confirmation message of dashboard creation.
     */
    public function post() {
        global $db_tables;
        check_nagios_session_protector();

        $title = grab_request_var("title", "");
        if (empty($title)) {
            throw new Exception(_("No title specified!"), 500);
        }
        $name = grab_request_var("name", "");
        $dashboard_id = grab_request_var("dashboard_id", "");
        $options = grab_request_var("options", "{}");
        $height = grab_request_var("height", 10);
        $width = grab_request_var("width", 10);
        $x = grab_request_var("x", 0);
        $y = grab_request_var("y", 0);
        $dashlet_id = random_string(6);

        if (gettype($options) != "string") {
            $options = json_encode($options);
        }

        $sql = "INSERT INTO " . $db_tables[DB_NAGIOSXI]["dashlets"] . " 
          (title, dashboard_id, name, options, height, width, x, y, dashlet_id) 
          VALUES (
              '" . escape_sql_param($title, DB_NAGIOSXI) . "', 
              '" . escape_sql_param($dashboard_id, DB_NAGIOSXI) . "', 
              '" . escape_sql_param($name, DB_NAGIOSXI) . "', 
              '" . escape_sql_param($options, DB_NAGIOSXI) . "', 
              " . escape_sql_param($height, DB_NAGIOSXI) . ", 
              " . escape_sql_param($width, DB_NAGIOSXI) . ", 
              " . escape_sql_param($x, DB_NAGIOSXI) . ", 
              " . escape_sql_param($y, DB_NAGIOSXI) . ", 
              '" . escape_sql_param($dashlet_id, DB_NAGIOSXI) . "'
          )";

        $response = exec_sql_query(DB_NAGIOSXI, $sql);

        return ["message" => _("Successfully added dashlet")];
    }

    /**
     * Auth function for put request method on api/v2/account/dashboards
     * All necessary auth is done in check_authentication so this just returns true.
     */
    public function authorized_for_put() {
        return true;
    }

    /**
     * Updates an existing dashlet with provided parameters.
     * @return array Confirmation message of dashlet update.
     */
    public function put() {
        global $db_tables;
        check_nagios_session_protector();

        $dashlet_id = grab_request_var("dashlet_id", "");
        if (empty($dashlet_id)) {
            throw new Exception(_("No dashlet ID specified!"), 500);
        }

        $title = grab_request_var("title", "");
        $options = grab_request_var("options", "{}");

        $sql = "UPDATE " . $db_tables[DB_NAGIOSXI]["dashlets"] . " SET
            title = '" . escape_sql_param($title, DB_NAGIOSXI) . "',
            options = '" . escape_sql_param($options, DB_NAGIOSXI) . "'
            WHERE dashlet_id = '" . escape_sql_param($dashlet_id, DB_NAGIOSXI) . "'";

        error_log($sql);
        $response = exec_sql_query(DB_NAGIOSXI, $sql);
        if (!$response) {
            throw new Exception(_("Could not edit dashlet."), 500);
        }

        return ["message" => _("Successfully updated dashlet")];
    }

    /**
     * Auth function for delete request method on api/v2/account/dashboards 
     * All necessary auth is done in check_authentication so this just returns true.
     */
    public function authorized_for_delete() {
        return true;
    }

    /**
     * Deletes a specified dashboard by its ID.
     * @return array Confirmation or error message based on the operation result.
     */

    public function delete() {
        check_nagios_session_protector();
        global $db_tables;

        $dashlet_id = grab_request_var("id", -1);
       
        $sql = "DELETE FROM " . $db_tables[DB_NAGIOSXI]["dashlets"] . " WHERE dashlet_id='" . $dashlet_id . "'";
        $response = exec_sql_query(DB_NAGIOSXI, $sql);
        if (!$response) {
            throw new Exception(_("Could not delete dashlet."), 500);
        }

        // Add a default dashboard if that was the last one
        // $dashboards = get_dashboards(0);
        // if (count($dashboards) == 0) {
        //     $opts = array();
        //     add_dashboard(0, "Default Dashboard", $opts);
        // }
        return ["message" => _("Successfully deleted dashlet")];
    }
}