<?php

namespace api\v2\system;
use api\v2\Base;

use function api\v2\import_common;
import_common();

class os extends Base {
    public function authorized_for_get() {
        return true;
    }

    public function get() {
        $distro = '';
        $version = '';
        $ver = '';
        $architecture = '';
        
        global $cfg;
        $xisys_file = $cfg['root_dir'] . '/var/xi-sys.cfg';

        if (file_exists($xisys_file)) {
            $xisys = parse_ini_file($xisys_file);
            $distro = isset($xisys['distro']) ? $xisys['distro'] : '';
            $version = isset($xisys['version']) ? $xisys['version'] : '';
            $ver = isset($xisys['ver']) ? $xisys['ver'] : '';
            $architecture = isset($xisys['architecture']) ? $xisys['architecture'] : '';
        }

        $response = [
            'distro' => $distro,
            'version' => $version,
            'ver' => $ver,
            'dist' => strtolower($distro) . $ver,
            'architecture' => $architecture
        ];
        
        return $response;
    }
}
