#!/bin/bash

BASEDIR=$(dirname $(readlink -f $0))

. $BASEDIR/../../../../var/xi-sys.cfg

if [ "$distro" == "Ubuntu" ] || [ "$distro" == "Debian" ]; then

	if [ "$dist" == "debian11" ]; then
		apt remove --purge -y php-ssh2
	else
		# Removes php-ssh2 this includes php*-ssh2 
		apt remove --purge -y $(dpkg --get-selections | awk '{print $1}' | grep -E '^php[0-9-]+.*-ssh2$')
	fi

	printf "\n" | pecl install ssh2
	
    echo "extension=ssh2.so" | tee -a $(find /etc/php -name "php.ini" | grep apache2)
	systemctl restart apache2
else

	yum remove -y --noautoremove php-pecl-ssh2

	#
	# Special handling for RHEL 8 systems
	# 
	if [ "$dist" == "el8" ]; then
		wget https://libssh2.org/download/libssh2-1.10.0.tar.gz
		tar -zxvf libssh2-1.10.0.tar.gz
		cd libssh2-1.10.0

		# Configure and install libssh2:
		./configure
		make
		make install
	else
		yum install libssh2 libssh2-devel -y
	fi

	printf "\n" | pecl install ssh2

	echo "extension=ssh2" > /etc/php.d/ssh2.ini
	systemctl restart httpd php-fpm
fi   

$BASEDIR/../../../../scripts/manage_services.sh restart httpd
chown $nagiosuser.$nagiosgroup /store/backups/nagiosxi
exit 0
