USE `nagiosxi`;

-- Grab default host object IDs
SELECT @localhost_id := object_id FROM nagios.nagios_objects WHERE name1 = "localhost" AND objecttype_id = 1 LIMIT 1;
SELECT @localhost_current_load := object_id FROM nagios.nagios_objects WHERE name1 = "localhost" AND name2 = "Current Load" LIMIT 1;
SELECT @localhost_swap_usage := object_id FROM nagios.nagios_objects WHERE name1 = "localhost" AND name2 = "Swap Usage" LIMIT 1;
SELECT @localhost_total_processes := object_id FROM nagios.nagios_objects WHERE name1 = "localhost" AND name2 = "Total Processes" LIMIT 1;
SELECT @localhost_current_users := object_id FROM nagios.nagios_objects WHERE name1 = "localhost" AND name2 = "Current Users" LIMIT 1;
SELECT @localhost_root_partition := object_id FROM nagios.nagios_objects WHERE name1 = "localhost" AND name2 = "Root Partition" LIMIT 1;
SELECT @localhost_memory_usage := object_id FROM nagios.nagios_objects WHERE name1 = "localhost" AND name2 = "Memory Usage" LIMIT 1;
SELECT @localhost_ping := object_id FROM nagios.nagios_objects WHERE name1 = "localhost" AND name2 = "PING" LIMIT 1;
SELECT @linux_servers_hostgroup := object_id FROM nagios.nagios_objects WHERE name1 = "linux-servers" AND objecttype_id = 3 LIMIT 1;
SELECT @websites_hostgroup := object_id FROM nagios.nagios_objects WHERE name1 = "websites" AND objecttype_id = 3 LIMIT 1;

-- localhost dashboard dashlets
INSERT INTO xi_dashlets VALUES (1,'PieChart','Pie Chart','localhost','TA9rnp',CONCAT('{\"host\": \"', IFNULL(@localhost_id, ''), '\", \"label\": \"total\", \"datatype\": \"host\", \"group_by\": \"service_status\", \"ok_enabled\": \"true\", \"up_enabled\": \"true\", \"down_enabled\": \"true\", \"unknown_enabled\": \"false\", \"warning_enabled\": \"true\", \"critical_enabled\": \"true\"}'),8,11,0,0),(2,'Statistic','OK','localhost','FZRQdG',CONCAT('{\"label\": \"OK\", \"host_id\": \"', IFNULL(@localhost_id, ''), '\", \"font_size\": \"36\", \"hostgroup\": \"\", \"service_id\": \"\", \"data_source\": \"\", \"servicegroup\": \"\", \"step_1_option\": \"service_status\", \"step_2_option\": \"service_status_host\", \"step_3_option\": \"service_status_host\", \"step_4_option\": \"\", \"match_bg_color\": \"false\", \"final_step_option\": \"service_status_host_ok\"}'),4,8,22,0),(3,'Graph','Load','localhost','arZI9a',CONCAT('{\"host_id\": \"', IFNULL(@localhost_id, ''), '\", \"service_id\": \"', IFNULL(@localhost_current_load, ''), '\", \"data_source\": \"all\", \"time_period\": \"24h\"}'),8,11,12,8),(4,'Graph','Memory','localhost','rhPMI0',CONCAT('{\"host_id\": \"', IFNULL(@localhost_id, ''), '\", \"service_id\": \"', IFNULL(@localhost_memory_usage, ''), '\", \"data_source\": \"used\", \"time_period\": \"24h\"}'),8,12,0,16),(5,'Graph','Host Performance','localhost','CjBHjV',CONCAT('{\"host_id\": \"', IFNULL(@localhost_id, ''), '\", \"service_id\": \"none\", \"data_source\": \"all\", \"time_period\": \"24h\"}'),8,12,0,8),(6,'Statistic','Warning','localhost','2eAcjO',CONCAT('{\"label\": \"Warning\", \"host_id\": \"', IFNULL(@localhost_id, ''), '\", \"font_size\": \"36\", \"hostgroup\": \"\", \"service_id\": \"\", \"data_source\": \"\", \"servicegroup\": \"\", \"step_1_option\": \"service_status\", \"step_2_option\": \"service_status_host\", \"step_3_option\": \"service_status_host\", \"step_4_option\": \"\", \"match_bg_color\": \"false\", \"final_step_option\": \"service_status_host_warning\"}'),4,8,30,0),(7,'Statistic','Critical','localhost','cnW3B3',CONCAT('{\"label\": \"Critical\", \"host_id\": \"', IFNULL(@localhost_id, ''), '\", \"font_size\": \"36\", \"hostgroup\": \"\", \"service_id\": \"\", \"data_source\": \"\", \"servicegroup\": \"\", \"step_1_option\": \"service_status\", \"step_2_option\": \"service_status_host\", \"step_3_option\": \"service_status_host\", \"step_4_option\": \"\", \"match_bg_color\": \"false\", \"final_step_option\": \"service_status_host_critical\"}'),4,8,38,0),(8,'Statistic','crond','localhost','UNVgOY',CONCAT('{\"label\": \"crond\", \"host_id\": \"', IFNULL(@localhost_id, ''), '\", \"font_size\": \"36\", \"hostgroup\": \"\", \"service_id\": \"201\", \"data_source\": \"\", \"servicegroup\": \"\", \"step_1_option\": \"service_status\", \"step_2_option\": \"service_status_single_service\", \"step_3_option\": \"service_status_single_service\", \"step_4_option\": \"\", \"match_bg_color\": \"true\", \"final_step_option\": \"service_status_single_service\"}'),4,8,22,4),(9,'Treemap','Treemap','localhost','2oU0OU',CONCAT('{\"host\": \"', IFNULL(@localhost_id, ''), '\", \"datatype\": \"host\", \"split_into\": \"service\", \"group_by\": \"service_status\"}'),8,11,11,0),(10,'Statistic','httpd','localhost','ShlNiJ',CONCAT('{\"label\": \"httpd\", \"host_id\": \"', IFNULL(@localhost_id, ''), '\", \"font_size\": \"36\", \"hostgroup\": \"\", \"service_id\": \"202\", \"data_source\": \"\", \"servicegroup\": \"\", \"step_1_option\": \"service_status\", \"step_2_option\": \"service_status_single_service\", \"step_3_option\": \"service_status_single_service\", \"step_4_option\": \"\", \"match_bg_color\": \"true\", \"final_step_option\": \"service_status_single_service\"}'),4,8,30,4),(11,'Statistic','mysqld','localhost','PLUqlV',CONCAT('{\"label\": \"mysqld\", \"host_id\": \"', IFNULL(@localhost_id, ''), '\", \"font_size\": \"36\", \"hostgroup\": \"\", \"service_id\": \"203\", \"data_source\": \"\", \"servicegroup\": \"\", \"step_1_option\": \"service_status\", \"step_2_option\": \"service_status_single_service\", \"step_3_option\": \"service_status_single_service\", \"step_4_option\": \"\", \"match_bg_color\": \"true\", \"final_step_option\": \"service_status_single_service\"}'),4,8,38,4),(12,'Gauge','Total Processes','localhost','TRjCW4',CONCAT('{\"max\": \"500\", \"host_id\": \"', IFNULL(@localhost_id, ''), '\", \"perf_data\": \"procs\", \"service_id\": \"', IFNULL(@localhost_total_processes, ''), '\"}'),8,12,34,8),(13,'Gauge','Current Users','localhost','4VCQBM',CONCAT('{\"max\": \"50\", \"host_id\": \"', IFNULL(@localhost_id, ''), '\", \"perf_data\": \"users\", \"service_id\": \"', IFNULL(@localhost_current_users, ''), '\"}'),8,12,34,16),(14,'Graph','Swap','localhost','5MtjIi',CONCAT('{\"host_id\": \"', IFNULL(@localhost_id, ''), '\", \"service_id\": \"', IFNULL(@localhost_swap_usage, ''), '\", \"data_source\": \"swap\", \"time_period\": \"24h\"}'),8,11,23,8),(15,'Graph','Root Partition','localhost','qhWvB5',CONCAT('{\"host_id\": \"', IFNULL(@localhost_id, ''), '\", \"service_id\": \"', IFNULL(@localhost_root_partition, ''), '\", \"data_source\": \"all\", \"time_period\": \"24h\"}'),8,11,12,16),(16,'Graph','PING','localhost','nVLKJS',CONCAT('{\"host_id\": \"', IFNULL(@localhost_id, ''), '\", \"service_id\": \"', IFNULL(@localhost_ping, ''), '\", \"data_source\": \"\", \"time_period\": \"24h\"}'),8,11,23,16);

-- Linux Servers dashboard dashlets
INSERT INTO xi_dashlets VALUES (17,'Treemap','Treemap','linux','scfKHA',CONCAT('{\"host\": \"\", \"datatype\": \"hostgroup\", \"hostgroup\": \"', IFNULL(@linux_servers_hostgroup, ''), '\", \"split_into\": \"service\", \"group_by\": \"host_parent\"}'),8,10,16,0),(18,'PieChart','Host Pie Chart','linux','R8M5qG',CONCAT('{\"label\": \"total\", \"datatype\": \"hostgroup\", \"group_by\": \"host_status\", \"hostgroup\": \"', IFNULL(@linux_servers_hostgroup, ''), '\", \"up_enabled\": \"true\", \"down_enabled\": \"true\", \"unknown_enabled\": \"false\"}'),8,10,0,0),(19,'PieChart','Service Pie Chart','linux','rKP5pH',CONCAT('{\"label\": \"total\", \"datatype\": \"hostgroup\", \"group_by\": \"service_status\", \"hostgroup\": \"', IFNULL(@linux_servers_hostgroup, ''), '\", \"up_enabled\": \"true\", \"down_enabled\": \"true\", \"unknown_enabled\": \"false\"}'),8,10,0,8),(20,'Statistic','OK Hosts','linux','9iJ7gi',CONCAT('{\"label\": \"OK Hosts\", \"host_id\": \"\", \"font_size\": \"36\", \"hostgroup\": \"', IFNULL(@linux_servers_hostgroup, ''), '\", \"service_id\": \"\", \"data_source\": \"\", \"servicegroup\": \"\", \"step_1_option\": \"host_status\", \"step_2_option\": \"host_status_hostgroup\", \"step_3_option\": \"host_status_hostgroup\", \"step_4_option\": \"\", \"match_bg_color\": \"false\", \"final_step_option\": \"host_status_hostgroup_up\"}'),4,6,10,0),(21,'Statistic','Down Hosts','linux','al00UG',CONCAT('{\"label\": \"Down Hosts\", \"host_id\": \"\", \"font_size\": \"36\", \"hostgroup\": \"', IFNULL(@linux_servers_hostgroup, ''), '\", \"service_id\": \"\", \"data_source\": \"\", \"servicegroup\": \"\", \"step_1_option\": \"host_status\", \"step_2_option\": \"host_status_hostgroup\", \"step_3_option\": \"host_status_hostgroup\", \"step_4_option\": \"\", \"match_bg_color\": \"false\", \"final_step_option\": \"host_status_hostgroup_down\"}'),4,6,10,4),(22,'BarChart','Bar Chart','linux','OXECVU',CONCAT('{\"bartype\": \"stacked\", \"datatype\": \"hostgroup\", \"group_by\": \"service_status\", \"hostgroup\": \"', IFNULL(@linux_servers_hostgroup, ''), '\", \"up_enabled\": \"true\", \"orientation\": \"horizontal\", \"down_enabled\": \"true\", \"unknown_enabled\": \"false\"}'),8,16,10,8),(23,'Map','Minemap','linux','HFUaJg','{\"dargs\": \"{\\\"group_select\\\": \\\"hostgroup\\\", \\\"hostgroup\\\": \\\"linux-servers\\\", \\\"servicegroup\\\": \\\"\\\"}\", \"autoscale\": \"false\", \"dashlet_name\": \"minemap\"}',16,22,26,0);

-- Websites dashboard dashlets
INSERT INTO xi_dashlets VALUES (24,'Treemap','Treemap','websites','Dk57i4',CONCAT('{\"datatype\": \"hostgroup\", \"hostgroup\": \"', IFNULL(@websites_hostgroup, ''), '\", \"split_into\": \"host\", \"group_by\": \"host_status\"}'),8,12,0,0),(25,'BarChart','Bar Graph','websites','RIDLHY',CONCAT('{\"bartype\": \"stacked\", \"datatype\": \"hostgroup\", \"group_by\": \"service_status\", \"hostgroup\": \"', IFNULL(@websites_hostgroup, ''), '\", \"ok_enabled\": \"true\", \"orientation\": \"vertical\", \"unknown_enabled\": \"false\", \"warning_enabled\": \"true\", \"critical_enabled\": \"true\"}'),8,22,0,8),(26,'Statistic','Up Hosts','websites','bXnZdJ',CONCAT('{\"label\": \"Up Hosts\", \"host_id\": \"\", \"font_size\": \"36\", \"hostgroup\": \"', IFNULL(@websites_hostgroup, ''), '\", \"service_id\": \"\", \"data_source\": \"\", \"servicegroup\": \"\", \"step_1_option\": \"host_status\", \"step_2_option\": \"host_status_hostgroup\", \"step_3_option\": \"host_status_hostgroup\", \"step_4_option\": \"\", \"match_bg_color\": \"false\", \"final_step_option\": \"host_status_hostgroup_up\"}'),4,6,22,0),(27,'Statistic','Problems','websites','m7C6Tk',CONCAT('{\"label\": \"Problems\", \"host_id\": \"\", \"font_size\": \"36\", \"hostgroup\": \"', IFNULL(@websites_hostgroup, ''), '\", \"service_id\": \"\", \"data_source\": \"\", \"servicegroup\": \"\", \"step_1_option\": \"host_status\", \"step_2_option\": \"host_status_hostgroup\", \"step_3_option\": \"host_status_hostgroup\", \"step_4_option\": \"\", \"match_bg_color\": \"false\", \"final_step_option\": \"host_status_hostgroup_problems\"}'),4,6,22,8),(28,'Statistic','Down Hosts','websites','7r99Sj',CONCAT('{\"label\": \"Down Hosts\", \"host_id\": \"\", \"font_size\": \"36\", \"hostgroup\": \"', IFNULL(@websites_hostgroup, ''), '\", \"service_id\": \"\", \"data_source\": \"\", \"servicegroup\": \"\", \"step_1_option\": \"host_status\", \"step_2_option\": \"host_status_hostgroup\", \"step_3_option\": \"host_status_hostgroup\", \"step_4_option\": \"\", \"match_bg_color\": \"false\", \"final_step_option\": \"host_status_hostgroup_down\"}'),4,6,22,4),(29,'Statistic','Pending Hosts','websites','QuIFkY',CONCAT('{\"label\": \"Pending Hosts\", \"host_id\": \"\", \"font_size\": \"36\", \"hostgroup\": \"', IFNULL(@websites_hostgroup, ''), '\", \"service_id\": \"\", \"data_source\": \"\", \"servicegroup\": \"\", \"step_1_option\": \"host_status\", \"step_2_option\": \"host_status_hostgroup\", \"step_3_option\": \"host_status_hostgroup\", \"step_4_option\": \"\", \"match_bg_color\": \"false\", \"final_step_option\": \"host_status_hostgroup_pending\"}'),4,6,22,12),(30,'PieChart','Pie','websites','7bXFeO',CONCAT('{\"label\": \"none\", \"datatype\": \"hostgroup\", \"group_by\": \"host_status\", \"hostgroup\": \"', IFNULL(@linux_servers_hostgroup, ''), '\", \"ok_enabled\": \"true\", \"up_enabled\": \"true\", \"down_enabled\": \"true\", \"inner_radius\": \"0\", \"padding_angle\": \"0\", \"unknown_enabled\": \"true\", \"warning_enabled\": \"true\", \"critical_enabled\": \"true\"}'),8,10,12,0),(31,'StatusSummary','Web Services','websites','rNCDce','{\"dargs\": \"{\\\"group_select\\\": \\\"servicegroup\\\", \\\"servicegroup\\\": \\\"web-services\\\"}\", \"autoscale\": \"false\", \"dashlet_name\": \"xicore_servicegroup_status_summary\"}',8,20,28,0),(32,'StatusSummary','SSL Certificates','websites','bJdOrf','{\"dargs\": \"{\\\"group_select\\\": \\\"servicegroup\\\", \\\"servicegroup\\\": \\\"ssl-certificates\\\"}\", \"autoscale\": \"false\", \"dashlet_name\": \"xicore_servicegroup_status_summary\"}',8,20,28,8);
