    <!--                                   -->
    <!-- The initial data set from Step 1. -->
    <!--                                   -->
    <input type="hidden" id="hostname" name="hostname" value="<?= encode_form_val($hostname) ?>">    
    <input type="hidden" id="services_serial" name="services_serial" value="<?= (!empty($services)) ? base64_encode(json_encode($services)) : "" ?>" />
    <input type="hidden" id="serviceargs_serial" name="serviceargs_serial" value="<?= (!empty($serviceargs)) ? base64_encode(json_encode($serviceargs)) : "" ?>" />
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />

    <input type="hidden" name="ip_address" value="<?= encode_form_val($address) ?>" />
    <input type="hidden" name="ssh" value="<?= encode_form_val($ssh) ?>" />
    <input type="hidden" name="ssh_username" value="<?= encode_form_val($ssh_username) ?>" />
    <input type="hidden" name="dirpath" value="<?= encode_form_val($dirpath) ?>" />
    <input type="hidden" name="hostname" value="<?= encode_form_val($hostname) ?>" />
    <input type="hidden" name="warning" value="<?= encode_form_val($warning) ?>" />
    <input type="hidden" name="critical" value="<?= encode_form_val($critical) ?>" />
<?php
    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';
?>
    <div class="container m-0 g-0">

        <h2 class="mb-2"><?= _('Directory Details') ?></h2>
        
        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="dirpath" class="form-label form-item-required"><?= _('Folder to Watch') ?> <?= xi6_info_tooltip(_('The directory to watch. The associated statistics are below.')) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="dirpath" id="dirpath" value="<?= encode_form_val($dirpath) ?>" class="form-control form-control-sm rounded" disabled>
                    <i id="dirpath_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div id="stat_div" class="row m-3">
            <div class="col-sm-6">
                <label class="form-label"><?= _('Statistics') ?></label>
                <table class="table table-sm table-hover table-bordered">
                    <tbody>
                        <tr>
                            <th scope="row" class="align-text-top pt-2 fa-12">
                                <label class="label-b"><?= _('File Count') ?></label>
                            </th>
                            <td class="pt-2 fa-12">
                                <p><b><?= @$filecount[0] ?></b></p>
                                <div class="subtext"><?= _('The number of non-hidden files in the directory') ?></div>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row" class="align-text-top pt-2 fa-12">
                                <label class="label-b"><?= _('File Age') ?></label>
                            </th>
                            <td class="pt-2 fa-12">
                                <div>
                                    <span class="fw-bold"><?= _('Oldest') ?>:</span>&nbsp;&nbsp;&nbsp;<?= date("r", time() - @$oldest[1]) ?>&nbsp; (<?= @$oldest[1] ?>)<br>
                                    <span class="fw-bold"><?= _('Newest') ?>:</span>&nbsp;<?= date("r", time() - @$newest[1]) ?>&nbsp;(<?= @$newest[1] ?>)
                                </div>
                                <div class="subtext"><?= _('Current File Ages (seconds)') ?></div>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row" class="align-text-top pt-2 fa-12">
                                <label class="label-b"><?= _('File Size') ?></label>
                            </th>
                            <td class="pt-2 fa-12">
                                <p>
                                    <span class="fw-bold"><?= _('Largest') ?>:&nbsp;&nbsp;&nbsp;</span><?= @$largest[1] ?><br>
                                    <span class="fw-bold"><?= _('Smallest') ?>:</b>&nbsp;</span><?= @$smallest[1] ?>
                                </p>
                                <div class="subtext"><?= _('Current File Sizes in bytes') ?></div>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div> <!-- col-sm -->
        </div> <!-- row -->

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="ip_address" class="form-label form-item-required"><?= _('Host Name') ?> <?= xi6_info_tooltip(_('The name to associate with this directory.')) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="hostname" id="hostname" value="<?= encode_form_val($hostname) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Server Address") ?>" required>
                    <div class="invalid-feedback">
                        <?= _("Please enter a Host Name") ?>
                    </div>
                    <i id="ip_address_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
            <div class="col-sm d-flex align-items-center mt-4 ps-0">
                <span><?=  $ssh_message ?></span>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="servicename" class="form-label"><?= _('Service Description') ?> <?= xi6_info_tooltip(_('The service description to use for the services specified, below.')) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="servicename" id="servicename" value="<?= encode_form_val($servicename) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter the Service Description") ?>" >
                    <div class="invalid-feedback">
                        <?= _("Please enter the Service Description") ?>
                    </div>
                    <i id="servicename_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <!--                         -->
        <!-- The metrics to monitor. -->
        <!--                         -->
        <h2 class="mt-4"><?= _('Wizard Options') ?></h2>
        <p><?= _('Specify which options you want to monitor a directory with') ?></p>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm mt-0 pt-1">
                        <input type="checkbox" id="recursive" class="form-check-input" name="serviceargs[recursive]"  <?= is_checked(grab_array_var($serviceargs,"recursive")) ?> >
                        <label for="recursive" class="form-check-label bold"><?= _('Include Subdirectories') ?> <?= xi6_info_tooltip(_("This option will recursively include subdirectories in all directory searches.")) ?></label>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm mt-0 pt-1">
                        <input type="checkbox" id="hidden" class="form-check-input" name="serviceargs[hidden]"  <?= is_checked(grab_array_var($serviceargs,"hidden")) ?> >
                        <label for="hidden" class="form-check-label bold"><?= _('Include Hidden Files') ?> <?= xi6_info_tooltip(_("This option will include hidden files in all directory searches.")) ?></label>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="serviceargs[checktype]" class="form-label form-item-required"><?= _("Query Type") ?> <?= xi6_info_tooltip(_('Query files, directories or both.')) ?></label>
                <div class="input-group position-relative">
                    <select name="serviceargs[checktype]" id="checktype" class="form-control form-control-sm form-select form-select-sm monitor rounded security_level" required>                    
                        <option value="" <?= is_selected(grab_array_var($serviceargs, "checktype"), "") ?> disabled ><?= _("Select Query Type") ?></option>
                        <option value="both" <?= is_selected(grab_array_var($serviceargs, "checktype"), "both") ?>>Both</option>
                        <option value="files" <?= is_selected(grab_array_var($serviceargs, "checktype"), "files") ?>>Files</option>
                        <option value="dir" <?= is_selected(grab_array_var($serviceargs, "checktype"), "dir") ?>>Directories</option>
                    </select>
                    <div class="invalid-feedback">
                        Please select Query Type
                    </div>
                    <i id="serviceargs_checktype_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <h2 class="mt-4"><?= _('Directory Services') ?></h2>
        <p class="w-50">
            <?= _('Monitor the directory with by selecting services, below') ?>.
            <ul>
                <li><?= _('The Regex Expression will be used for all the selected services') ?>.</li>
                <li><?= _('To include an age or size query select the corresponding checkbox') ?>.</li>
            </ul>
        </p>

        <div class="alert alert-info w-50">
            <?= _('The default regex for all files/directories is') ?>
            <span class="fw-bold">[^]+</span>.
            <?= _('This translates into one or more non-null characters and is intended to be used as a wildcard.') ?>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="servicename" class="form-label"><?= _('Regular Expression') ?> <?= xi6_info_tooltip(_('The Regex pattern to use for the query.')) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="services[query]" id="query" value="<?= encode_form_val($services["query"]) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter the Regular Expression") ?>" >
                    <div class="invalid-feedback">
                        <?= _("Please enter the Regular Expression") ?>
                    </div>
                    <i id="services_query_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="fcount" class="form-check-input" name="services[fcount]"  <?= is_checked(grab_array_var($services, "fcount")) ?>>
                        <label for="fcount" class="form-check-label bold"><?= _('File Count') ?> <?= xi6_info_tooltip(_("Check the number of files matching the regex query with this service.")) ?></label>
                    </div>
                    <div class="col-sm-4 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400">warning</i>
                            </span>
                            <select name="serviceargs[warning_prefix]" id="warning_prefix" class="form-control form-control-sm form-select form-select-sm monitor">
                                <option value=">" <?= is_selected(grab_array_var($serviceargs, "warning_prefix"), ">") ?>> > </option>
                                <option value="<" <?= is_selected(grab_array_var($serviceargs, "warning_prefix"), "<") ?>> < </option>
                                <option value="=" <?= is_selected(grab_array_var($serviceargs, "warning_prefix"), "=") ?>> = </option>
                            </select>
                            <i id="serviceargs_warning_prefix_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            <input type="text" name="warning" id="warning" placeholder="Warning" value="<?= encode_form_val($warning) ?>" class="form-control form-control-sm monitor w-50" />
                            <i id="warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-4 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i>
                            </span>
                            <select name="serviceargs[critical_prefix]" id="critical_prefix" class="form-control form-control-sm form-select form-select-sm monitor">
                                <option value=">" <?= is_selected(grab_array_var($serviceargs, "critical_prefix"), ">") ?>> > </option>
                                <option value="<" <?= is_selected(grab_array_var($serviceargs, "critical_prefix"), "<") ?>> < </option>
                                <option value="=" <?= is_selected(grab_array_var($serviceargs, "critical_prefix"), "=") ?>> = </option>
                            </select>
                            <i id="serviceargs_critical_prefix_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            <input type="text" name="critical" id="critical" placeholder="Critical" value="<?= encode_form_val($critical) ?>" class="form-control form-control-sm monitor w-50" />
                            <i id="critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="fage" class="form-check-input" name="services[fage]" <?= is_checked(grab_array_var($services, "fage")) ?>>
                        <label for="fage" class="form-check-label bold"><?= _('File Age') ?> <?= xi6_info_tooltip(_("Check file age of the regex query in seconds with this service. Use ranges or Warning/Critical to check for age.")) ?></label>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400">warning</i>
                            </span>
                            <input type="text" name="serviceargs[fagewarn]" id="fagewarn" placeholder="Warning" value="<?= encode_form_val($serviceargs["fagewarn"]) ?>" class="form-control form-control-sm monitor rounded-end">
                            <i id="fagewarn_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-5 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i>
                            </span>
                            <input type="text" name="serviceargs[fagecrit]" id="fagecrit" placeholder="Critical" value="<?= encode_form_val($serviceargs["fagecrit"]) ?>" class="form-control form-control-sm monitor">
                            <i id="serviceargs_fagecrit_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            <select name="serviceargs[fagecompare]" id="fagecompare" class="form-control form-control-sm form-select form-select-sm rounded-end">
                                <option value="regular" <?= is_selected(grab_array_var($serviceargs, "fagecompare"), "regular") ?>>Warning/Critical</option>
                                <option value="inrange" <?= is_selected(grab_array_var($serviceargs, "fagecompare"), "inrange") ?>>Inside Range</option>
                                <option value="outrange" <?= is_selected(grab_array_var($serviceargs, "fagecompare"), "outrange") ?>>Outside Range</option>
                            </select>
                            <i id="serviceargs_fagecompare_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="fsize" class="form-check-input" name="services[fsize]" <?= is_checked(grab_array_var($services, "fsize")) ?>>
                        <label for="fsize" class="form-check-label bold"><?= _('File Size') ?> <?= xi6_info_tooltip(_("Check file size of the regex query in bytes with this service. Use ranges or Warning/Critical to check for size.")) ?></label>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400">warning</i>
                            </span>
                            <input type="text" name="serviceargs[fsizewarn]" id="fsizewarn" placeholder="Warning" value="<?= encode_form_val($serviceargs["fsizewarn"]) ?>" class="form-control form-control-sm monitor rounded-end">
                            <i id="fsizewarn_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-5 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i>
                            </span>
                            <input type="text" name="serviceargs[fsizecrit]" id="fsizecrit" placeholder="Critical" value="<?= encode_form_val($serviceargs["fsizecrit"]) ?>" class="form-control form-control-sm monitor">
                            <i id="serviceargs_fsizecrit_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            <select name="serviceargs[fsizecompare]" id="fsizecompare" class="form-control form-control-sm form-select form-select-sm rounded-end">
                                <option value="regular" <?= is_selected(grab_array_var($serviceargs, "fsizecompare"), "regular") ?>>Warning/Critical</option>
                                <option value="inrange" <?= is_selected(grab_array_var($serviceargs, "fsizecompare"), "inrange") ?>>Inside Range</option>
                                <option value="outrange" <?= is_selected(grab_array_var($serviceargs, "fsizecompare"), "outrange") ?>>Outside Range</option>
                            </select>
                            <i id="serviceargs_fsizecompare_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

    </div> <!-- container -->

    <script type="text/javascript">
        $(document).ready(function() {
            var ssh_stats = <?= json_encode($ssh_stats) ?>;
            var stat_div = document.getElementById("stat_div");
            var stat_title = document.getElementById("stat_title");

            if (ssh_stats == false) {
                stat_div.parentNode.removeChild(stat_div);
                stat_title.parentNode.removeChild(stat_title);
            }
        });
    </script>

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
