    <!--                                   -->
    <!-- The initial data set from Step 1. -->
    <!--                                   -->
    <input type="hidden" id="hostname" name="hostname" value="<?= encode_form_val($hostname) ?>">
    <input type="hidden" id="operation" name="operation" value="<?= encode_form_val($operation) ?>">
    <input type="hidden" id="selectedhostconfig" name="selectedhostconfig" value="<?= encode_form_val($selectedhostconfig) ?>">
    <input type="hidden" id="services_serial" name="services_serial" value="<?= (!empty($services)) ? base64_encode(json_encode($services)) : "" ?>" />
    <input type="hidden" id="serviceargs_serial" name="serviceargs_serial" value="<?= (!empty($serviceargs)) ? base64_encode(json_encode($serviceargs)) : "" ?>" />
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />

    <input type="hidden" name="ip_address" value="<?= encode_form_val($ip_address) ?>">
    <input type="hidden" name="port" value="<?= encode_form_val($port) ?>">
    <input type="hidden" name="token" value="<?= encode_form_val($token) ?>">
    <input type="hidden" name="no_ssl_verify" value="<?= intval($no_ssl_verify) ?>">
<?php
    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';
?>
    <div class="container-fluid m-0 g-0">

        <h2 class="mb-2"><?= _("Connection Information") ?></h2>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="" class="form-label"><?= _("Address") ?> </label>
                <div class="input-group position-relative">
                    <input type="text" name="ip_address" id="ip_address" value="<?= encode_form_val($ip_address) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Address") ?>" disabled="on">
                    <i id="_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="hostname" class="form-label"><?= _("Host Name") ?> <?= xi6_info_tooltip(_("The hostname associated with the new host.")) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="hostname" id="hostname" value="<?= encode_form_val($hostname) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Host Name") ?>" >
                    <div class="invalid-feedback">
                        <?= _("Please enter the Host Name") ?>
                    </div>
                    <i id="hostname_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="" class="form-label"><?= _("Port") ?> </label>
                <div class="input-group position-relative">
                    <input type="text" name="port" id="port" value="<?= encode_form_val($port) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Port") ?>" disabled="on">
                    <i id="_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="" class="form-label"><?= _("Token") ?> </label>
                <div class="input-group position-relative">
                    <input type="text" name="token" id="token" value="<?= encode_form_val($token) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Token") ?>" disabled="on">
                    <i id="_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <h2 class="mt-4"><?= _('Event Log Checks') ?></h2>
        <p><?= _('Specify what logs you are looking for and the filters that you want to apply to the logs. If any logs are found it will return a CRITICAL otherwise it will return an OK') ?></p>

        <div id="services-listDiv">
            <div class="services-list addrow">
                 <div class="row">
                    <div class="col-sm-12">
                        <fieldset class="row g-2 mb-1">
                            <div class="d-flex align-items-end form-check col-sm-3">
                                <div class="input-group input-group-sm">
                                    <label class="form-check-label bold"><?= _('Service Name') ?></label>
                                </div>
                            </div>
                            <div class="d-flex align-items-end col-sm-2">
                                <label class="form-check-label bold"><?= _('Log') ?> <?= xi6_info_tooltip('The name of the windows event log. Examples: Application, Security, System, Setup.') ?></label>
                            </div>
                            <div class="d-flex align-items-end col-sm">
                                <label class="form-check-label bold"><?= _('Filters') ?> <?= xi6_info_tooltip('Optional. Add filters to only include specific logs.') ?></label>
                            </div>
                        </fieldset>
                    </div>
                </div>
<?php
    foreach ($services as $sid => $svc) {
        $id = intval($sid);
?>
                <div class="row">
                    <div class="col-sm-12">
                        <fieldset class="row g-2 mb-1 wz-fieldset">
                            <div class="form-check col-sm-3 mt-0">
                                <div class="input-group input-group-sm">
                                    <input type="checkbox" class="form-check-input mt-2 me-2 rounded-end" name="services[<?= $id ?>][check]" id="services[<?= $id ?>][check]" value="1" <?= is_checked($svc['check'], 1) ?>>
                                    <input type="text" name="services[<?= $id ?>][name]" id="services[<?= $id ?>][name]" value="<?= encode_form_val($svc['name']) ?>" class="form-control form-control-sm rounded monitor">
                                    <i id="services_<?= $id ?>_name_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                </div>
                            </div>
                            <div class="col-sm-2 mt-0">
                                <input type="text" name="services[<?= $id ?>][log]" id="services[<?= $id ?>][log]" value="<?= encode_form_val($svc['log']) ?>" class="form-control form-control-sm rounded monitor">
                                <i id="services_<?= $id ?>_log_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                            <div class="col-sm mt-0">
                                <div class="d-inline-flex">
                                    <div class="input-group input-group-sm">
                                        <span class="input-group-text"><?= _('EventType') ?></span>
                                        <select name="services[<?= $id ?>][severity]" id="services[<?= $id ?>][severity]" class="form-control form-control-sm form-select form-select-sm">
                                            <option value="" <?= is_selected($svc['severity'], '') ?>><?= _('Any') ?></option>
                                            <option value="ERROR" <?= is_selected($svc['severity'], 'ERROR') ?>><?= _('Error') ?></option>
                                            <option value="WARNING" <?= is_selected($svc['severity'], 'WARNING') ?>><?= _('Warning') ?></option>
                                            <option value="INFORMATION" <?= is_selected($svc['severity'], 'INFORMATION') ?>><?= _('Information') ?></option>
                                            <option value="AUDIT_FAILURE" <?= is_selected($svc['severity'], 'AUDIT_FAILURE') ?>><?= _('Audit Failure') ?></option>
                                            <option value="AUDIT_SUCCESS" <?= is_selected($svc['severity'], 'AUDIT_SUCCESS') ?>><?= _('Audit Success') ?></option>
                                            <option value="UNKNOWN" <?= is_selected($svc['severity'], 'UNKNOWN') ?>><?= _('Unknown') ?></option>
                                        </select>
                                        <i id="serviceargs_eventlog_<?= $id ?>_severity_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                    </div>
                                </div>
                                <div class="d-inline-flex">
                                    <div class="input-group input-group-sm">
                                        <span class="input-group-text"><?= _('EventID') ?></span>
                                        <input type="text" name="services[<?= $id ?>][event_id]" id="services[<?= $id ?>][event_id]" value="<?= encode_form_val($svc['event_id']) ?>" class="form-control form-control-sm">
                                        <i id="services_<?= $id ?>_event_id_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                    </div>
                                </div>
                                <div class="d-inline-flex">
                                    <div class="input-group input-group-sm">
                                        <label class="form-check-label input-group-text"><?= _('SourceName') ?></label>
                                        <input type="text" name="services[<?= $id ?>][application]" id="services[<?= $id ?>][application]" value="<?= encode_form_val($svc['application']) ?>" class="form-control form-control-sm rounded-end">
                                        <i id="services_<?= $id ?>_application_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                    </div>
                                </div>
                                <div class="d-inline-flex">
                                    <div class="input-group input-group-sm">
                                        <span class="input-group-text"><?= _('ComputerName') ?></span>
                                        <input type="text" name="services[<?= $id ?>][computer_name]" id="services[<?= $id ?>][computer_name]" value="<?= encode_form_val($svc['computer_name']) ?>" class="form-control form-control-sm rounded-end">
                                        <i id="servics_<?= $id ?>_computer_name_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                    </div>
                                </div>
                                <div class="d-inline-flex">
                                    <div class="input-group input-group-sm">
                                        <span class="input-group-text"><?= _('EventCategory') ?></span>
                                        <input type="text" name="services[<?= $id ?>][category]" id="services[<?= $id ?>][category]" value="<?= encode_form_val($svc['category']) ?>" class="form-control form-control-sm">
                                        <i id="services_<?= $id ?>_category_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                    </div>
                                </div>
                                <div class="d-inline-flex">
                                    <div class="input-group input-group-sm">
                                        <span class="input-group-text"><?= _('Message') ?></span>
                                        <input type="text" name="services[<?= $id ?>][message]" id="services[<?= $id ?>][message]" value="<?= encode_form_val($svc['message']) ?>" placeholder="<?= _('search or regex') ?>" class="form-control form-control-sm">
                                        <i id="services_<?= $id ?>_message_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                    </div>
                                </div>
                            </div>
                        </fieldset>
                    </div>
                </div>
<?php
    }
?>
            </div> <!-- service-list addrow -->
        </div> <!-- services-listDiv -->

    </div> <!-- container -->

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
