    <!--                                   -->
    <!-- The initial data set from Step 1. -->
    <!--                                   -->
    <input type="hidden" id="hostname" name="hostname" value="<?= encode_form_val($hostname) ?>">
    <input type="hidden" id="operation" name="operation" value="<?= encode_form_val($operation) ?>">
    <input type="hidden" id="selectedhostconfig" name="selectedhostconfig" value="<?= encode_form_val($selectedhostconfig) ?>">
    <input type="hidden" id="services_serial" name="services_serial" value="<?= (!empty($services)) ? base64_encode(json_encode($services)) : "" ?>" />
    <input type="hidden" id="serviceargs_serial" name="serviceargs_serial" value="<?= (!empty($serviceargs)) ? base64_encode(json_encode($serviceargs)) : "" ?>" />
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />

<?php
    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';
?>
    <div class="container m-0 g-0">
        <h2><?= _('Add Services') ?></h2>
        <p><label for="prepend"><?= _('Prepend for Service Descriptions (optional)') ?></label></p>
        <p><input type="text" name="prepend" class="form-control" id="prepend" value="<?= _('BPI Process') ?>: "></p>

        <h2 class="mt-4"><?= _("Groups") ?></h2>
        <p><?= _("Specify which groups should be running or stopped.") ?> <?= xi6_info_tooltip(_("Depending on the selected state, you will receive an OK when the process is in the selected state and a CRITICAL if the process is not in the state selected.")) ?></p>

        <div class="row">
            <div class="col-sm-3">
                <div class="multi-select-label"><?= _('Make your group Selections')?><?= xi6_info_tooltip(_("Click with shift or CRTL/CMD key to adjust your selection.")) ?></div>
                    <?= $group_select_html ?>
                    <div class="select-undo-wrap">
                        <button type="button"  id="groups-undo" class="select-undo"><i class="material-symbols-outlined md-button md-20 md-400">undo</i></button>
                    </div>
            </div>
            <div class="col-sm-9">
                <div class="row">
                    <div class="col-sm-9">
                        <div class="multi-select-label"><?= _('Selected groups')?></div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-12">
                        <fieldset class="row g-2">
                            <div class="col-sm-3 mt-0">
                                <label class="form-label bold mb-3 ms-3 ps-1"><?= _('Group ID') ?></label>
                            </div>
                            <div class="col-sm-3 mt-0">
                                <label class="form-label bold mb-3 ms-3 ps-1"><?= _('Display Name') ?></label>
                            </div>
                            <div class="col-sm-3 mt-0">
                                <label class="form-label bold mb-3 ms-3 ps-1"><?= _('Description') ?></label>
                            </div>
                        </fieldset>
                        </div>
                    </div>

        <div id="groups-list" class="select-table-wrap">
<?php

    foreach ($groups_array as $name => $group) {
        $monitor = isset($groups[$name]) && $groups[$name] != '';
        $title = $group['title'];
        $desc = $group['desc'];
        $safe_name = clean_str_for_dom($name);

        ?>
            <div class="row">
                <div class="col-sm-12">
                    <fieldset class="row g-2 mb-1 wz-fieldset">
                        <div class="form-check col-sm-3 mt-0 pt-0">
                            <input type="checkbox" name="groups[<?= $name ?>]" id="groups[<?= $name ?>]" class="form-check-input mt-2 me-2 service-item groups-<?= $safe_name ?>" <?= is_checked($monitor, 'on') ?>>
                            <div class="input-group input-group-sm">
                                <?= $name ?>
                            </div>
                        </div>
                        <div class="form-check col-sm-3 mt-0 pt-0">
                            <div class="input-group input-group-sm">
                                 <?= $title ?>
                            </div>
                        </div>
                        <div class="form-check col-sm-3 mt-0 pt-0">
                            <div class="input-group input-group-sm">
                                 <?= $desc ?>
                            </div>
                        </div>
                        <div class="col-sm-1 mt-0 pt-0">
                            <div class="input-group input-group-sm">
                                <button type="button" class="btn-close multi-select-remove" value="groups-<?= $safe_name ?>" aria-label="Remove"></button>
                            </div>
                        </div>
                    </fieldset>
                </div>
            </div>

            <?php
    }
    ?>
            </div>
        </div>
        </div> <!-- groups-list -->

    </div> <!-- container -->

    <script type="text/javascript">
        $(document).ready(function() {
            // Set up undo buffers by "category" (thing m_select is managing)
            m_select_cats = ["groups"];
            m_select_states = {};

            // Set up handlers and current state for multi-selects
            $.each(m_select_cats, function(i, category) {
                m_select_states[category] = [];

                $("#"+category+"-select").on("change", function($this) {
                    manageMultiSelectForTable(category);
                });

                $("#"+category+"-undo").on("click", function($this) {
                    multiSelectUndo(category);
                });

                // Set initial state for m selects
                manageMultiSelectForTable(category);
                $("#"+category+"-undo").prop( "disabled", true );
            });

            $(".multiselect").on("mouseenter", function($this) {
                $(this).trigger("focus");
            });

            $(".multi-select-remove").on("click", function($this) {
                // Figure out which was clicked
                fullName = $(this).attr("value");
                elem = "." + fullName;
                category = fullName.split('-')[0];
                name = fullName.replace(category+ '-', '')

                // Update multi select
                optn = $('#' + category + '-select option[value="'+ name +'"]');
                optn.prop('selected', false);

                // Update table
                manageMultiSelectForTable(category);
            });

            function manageMultiSelectForTable(category) {
                container = "#"+category+"-list";
                select = "#"+category+"-select";
                selVal =  $(select).val();

                // Add new state to undo buffer
                m_select_states[category].push(selVal);
                $("#"+category+"-undo").prop( "disabled", false );

                // Clear multi select and table
                $(container +" .service-item").prop( "checked", false );
                $(container +" .service-item").closest(".row").hide();

                // Apply updated settings
                $.each(selVal, function(i, val) {
                    elem = "." + category + "-" + val;
                    $(elem).prop( "checked", true );
                    $(elem).closest(".row").show();
                });
            }

            function multiSelectUndo(category) {
                container = "#"+category+"-list";
                select = "#"+category+"-select";

                // Ignore current state
                m_select_states[category].pop();

                // Get previous state and apply
                selVal = m_select_states[category].pop();
                $(select).val(selVal);
                manageMultiSelectForTable(category);
                $(select).trigger("focus");

                // Disable undo button if appropriate
                if (m_select_states[category][0].length <= 0 ) {
                    m_select_states[category] = [];
                    $("#"+category+"-undo").prop( "disabled", true );
                }
            }
        });
    </script>

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
