$(document).ready(function() {

    var service_selector_default_text = $('#default-service-selector').html();
    var perfdata_selector_default_text = $('#default-data-selector').html();
    var remove_row = $('#default-remove-row').html();
    var no_threshold = $('#no-threshold-message').html();
    var need_custom = $('#needs-custom-value').html();
    var threshold_template = $('#threshold-message').html();
    var counter = $('.remove-row').length - 1;

    var ajax_url = base_url + 'includes/configwizards/capacity-planning/capacity-planning-ajax-handler.php'; 

    var old_service;
    var old_perfdata;

    function populate_perfdata(host, service, old_perfdata) {

        $.post(ajax_url, { host: host, service: service, mode: 'track_name_from_host_service'}, function(data) {

            var html = '';
            var exists = false;

            for (idx in data) {

                html += '<option value="' + data[idx]['name'] + '" data-warn="' + data[idx]['warn'] + '" data-crit="' + data[idx]['crit'] + '">' + data[idx]['name'] + '</option>';
                if (data[idx]['name'] === old_perfdata) {
                    exists = true;
                }
            }

            if (html === '') {
                html = perfdata_selector_default_text;
            }

            $('#data-selector').html(html);

            perfdata = $('#data-selector option:nth-child(1)').val();
            if (exists) {
                perfdata = old_perfdata;
            }

            $('#data-selector').val(perfdata);
        }, 'json');
    }

    $('#host-selector').change(function() {
        var host = $(this).val();
        old_service = $('#service-selector').val();
        old_perfdata = $('#data-selector').val();

        if (host) {

            $.post(ajax_url, { host: host , mode: "service_from_host"}, function(data) {

                var html = '<option value="_HOST_">_HOST_</option>';
                var exists = false;
                for (idx in data) {
                    html += '<option value="' + data[idx] + '">' + data[idx] + '</option>';
                    if (data[idx] === old_service) {
                        exists = true;
                    }
                }

                $('#service-selector').html(html);

                service = '_HOST_';
                if (exists) {
                    service = old_service;
                }
                $('#service-selector').val(service);

                // Services list now has a selected element, so populate the perfdata list and select something.
                populate_perfdata(host, service, old_perfdata);
            }, 'json');
        }
        else {

            // clear both other lists
            $('#service-selector').html(service_selector_default_text);
            $('#data-selector').html(perfdata_selector_default_text);
        }
    });

    $('#service-selector').change(function() {

        var host = $('#host-selector').val();
        var service = $(this).val();

        old_perfdata = $('#data-selector').val();

        if (service) {
            populate_perfdata(host, service, old_perfdata);
        } else {
            $('#data-selector').html(perfdata_selector_default_text);
        }
    });

    function make_alert_criteria(type, value, counter) {
        var threshold_message = threshold_template.replace('%d', value);
        var input = '<input type="hidden" name="serviceargs[' + counter + '][' + type + ']" value="' + value + '" />\
            <input type="text" class="textfield form-control" size="3" autocomplete="off" \
            name="serviceargs[' + counter + '][' + type + '-days]" value="'+ (value === no_threshold ? '' : '7') +'"\
             ' + (value === no_threshold ? 'disabled' : '') +'/>';

        threshold_message = threshold_message.replace('%s', input);
        return threshold_message;
    }

    $('#add-to-list').click(function() {

        var host = $('#host-selector').val();
        var service = $('#service-selector').val();
        var perfdata = $('#data-selector').val();

        if (host === '' || service === '' || perfdata === '') {
            alert($('#unselected-error').html());
            return;
        }

        $('#configDiv').removeClass('visually-hidden');

        var warn = $('#data-selector option:selected').data('warn');

        if (typeof warn === "undefined" || warn === "") {
            // Use translated notice message in place of numeric value
            warn = no_threshold;
        }

        var warn_days = (warn === no_threshold ? '' : '7');
        var warn_disabled = (warn === no_threshold ? 'disabled' : '');

        var crit = $('#data-selector option:selected').data('crit');

        if (typeof crit === "undefined" || crit === "") {
            // Use translated notice message in place of numeric value
            crit = no_threshold;
        }

        var crit_days = (crit === no_threshold ? '' : '7');
        var crit_disabled = (crit === no_threshold ? 'disabled' : '');

        needs_custom_value = (warn === no_threshold && crit === no_threshold);

        var needs_custom_input = '';
        var needs_custom_value_text = '';

        if (needs_custom_value) {
            needs_custom_input = '<input type="hidden" name="serviceargs[' + counter + '][need_custom]" value="1" />';
            needs_custom_value_text = $('#needs-custom-value').html();
        }

        var table_row = $('#default-row').html();

        table_row = table_row.replace(new RegExp('counter_here', 'g'), counter);
        table_row = table_row.replace(new RegExp('host_here', 'g'), host);
        table_row = table_row.replace(new RegExp('service_here', 'g'), service);
        table_row = table_row.replace(new RegExp('perfdata_here', 'g'), perfdata);
        table_row = table_row.replace(new RegExp('needs_custom_input_here', 'g'), needs_custom_input);
        table_row = table_row.replace(new RegExp('needs_custom_value_here', 'g'), needs_custom_value_text);
        table_row = table_row.replace(new RegExp('warn_here', 'g'), warn);
        table_row = table_row.replace(new RegExp('crit_here', 'g'), crit);
        table_row = table_row.replace(new RegExp('warn_days_here', 'g'), warn_days);
        table_row = table_row.replace(new RegExp('warn_disabled_here', 'g'), warn_disabled);
        table_row = table_row.replace(new RegExp('crit_days_here', 'g'), crit_days);
        table_row = table_row.replace(new RegExp('crit_disabled_here', 'g'), crit_disabled);

        // global
        counter += 1;

        $('.basic-grid').css('grid-row-templates', 'repeat(' + counter + ', 50px)');

        $('#table_insert_here').append(table_row);

        // Remove the line that says "No entries yet!"
        $('.remove-on-addition').eq(1).remove();

        register_remove_row_buttons();
    });

    function register_remove_row_buttons() {
        $('.remove-row').click(function() {
            row = $(this).closest('.flex-row');
            row.remove();
        });
    }
    register_remove_row_buttons();
});
