<?php
//
// Nagios XI Operations Center Component
// Copyright (c) 2010-2024 Nagios Enterprises, LLC. All rights reserved.
//

require_once(dirname(__FILE__) . '/../componenthelper.inc.php');

$nocscreen_component_name = "nocscreen";
nocscreen_component_init();

////////////////////////////////////////////////////////////////////////
// COMPONENT INIT FUNCTIONS
////////////////////////////////////////////////////////////////////////

function nocscreen_component_init()
{
    global $nocscreen_component_name;

    // Boolean to check for latest version
    $versionok = nocscreen_component_checkversion();

    // Component description
    $desc = _("This component adds a read-only NOC screen for all current unhandled problems to the home menu.");

    if (!$versionok) {
        $desc = "<b>" . _("Error") . ": " . _("This component requires Nagios XI 2024R1.1 or later.") . "</b>";
    }

    // All components require a few arguments to be initialized correctly.
    $args = array(
        COMPONENT_NAME => $nocscreen_component_name,
        COMPONENT_VERSION => '1.5.0',
        COMPONENT_DATE => '05/28/2024',
        COMPONENT_AUTHOR => "Nagios Enterprises, LLC",
        COMPONENT_DESCRIPTION => $desc,
        COMPONENT_TITLE => _("Operations Center"),
        COMPONENT_REQUIRES_VERSION => 570
    );

    // Register this component with XI
    register_component($nocscreen_component_name, $args);

    // Register the addmenu function
    if ($versionok) {
        register_callback(CALLBACK_MENUS_INITIALIZED, 'nocscreen_component_addmenu');
    }
}

///////////////////////////////////////////////////////////////////////////////////////////
// MISC FUNCTIONS
///////////////////////////////////////////////////////////////////////////////////////////

// Requires XI 2024R1.1 or later
function nocscreen_component_checkversion()
{
    if (!function_exists('get_product_release')) { return false; }
    if (get_product_release() < 60100) { return false; }
    return true;
}

function nocscreen_component_addmenu($arg = null)
{
    global $nocscreen_component_name;

    // Retrieve the URL for this component
    $component_url = get_component_url_base($nocscreen_component_name);

    // Figure out where I'm going on the menu
    $mi = find_menu_item(MENU_HOME, "menu-home-tacticaloverview", "id");
    if ($mi == null) {
        return;
    }

    $order = grab_array_var($mi, "order", "");
    if ($order == "") {
        return;
    }

    $neworder = $order + 0.1;

    // Add this to the main home menu
    add_menu_item(MENU_HOME, array(
        "type" => "link",
        "title" => _("Operations Center"),
        "id" => "menu-home-nocscreen",
        "order" => $neworder,
        "opts" => array(
            "href" => $component_url . "/noc.php",
            "neptune-icon" => "Globe"
        )
    ));
}
