    <!--                                   -->
    <!-- The initial data set from Step 1. -->
    <!--                                   -->
<?php    
// Get variables that were passed to us
$address = grab_array_var($inargs, "ip_address");
$check_method = grab_array_var($inargs, "check_method", "");
$ssl = grab_array_var($inargs, "ssl", "");

$ha = @gethostbyaddr($address);

if (empty($ha)) {
    $ha = $address;
}

$hostname = grab_array_var($inargs, "hostname", $ha);
$password = "";

$services = "";
$services_serial = grab_array_var($inargs, "services_serial", "");

if ($services_serial != "") {
    $services = json_decode(base64_decode($services_serial), true);
}

if (!is_array($services)) {
    $services_default = array(
        "ping" => 1,
        "commands" => array(),
    );
    $services_default["commands"][0] = "on";
    $services_default["commands"][1] = "on";
    $services_default["commands"][2] = "on";
    $services = grab_array_var($inargs, "services", $services_default);
}

$serviceargs = "";
$serviceargs_serial = grab_array_var($inargs, "serviceargs_serial", "");

if ($serviceargs_serial != "") {
    $serviceargs = json_decode(base64_decode($serviceargs_serial), true);
}
$serviceargs_default = array(
    "commands" => array(),
);
$commands_file = dirname(__FILE__) . '/../nsclient_default_nrpe_commands.json';
if (file_exists($commands_file)) {
    $commands_json = file_get_contents($commands_file);
    $commands_array = json_decode($commands_json, true);
    foreach ($commands_array['commands'] as $idx => $command) {
        $serviceargs_default["commands"][$idx] = array(
            "name" => $command["name"],
            "command" => $command["command"],
            "args" => $command["args"],
        );
    }
} else {
    echo "File not found: $commands_file";
}

$serviceargs = grab_array_var($inargs, "serviceargs", $serviceargs_default);
?>

<!--                                   -->
<!--           Show the page.          -->
<!--                                   -->
    <!--                                   -->
    <!-- The initial data set from Step 1. -->
    <!--                                   -->
    <input type="hidden" id="hostname" name="hostname" value="<?= encode_form_val(isset($hostname) ? $hostname : '') ?>">
    <input type="hidden" id="operation" name="operation" value="<?= encode_form_val(isset($operation) ? $operation : '') ?>">
    <input type="hidden" id="selectedhostconfig" name="selectedhostconfig" value="<?= encode_form_val(isset($selectedhostconfig) ? $selectedhostconfig : '') ?>">
    <input type="hidden" id="services_serial" name="services_serial" value="<?= (!empty($services)) ? base64_encode(json_encode($services)) : "" ?>" />
    <input type="hidden" id="serviceargs_serial" name="serviceargs_serial" value="<?= (!empty($serviceargs)) ? base64_encode(json_encode($serviceargs)) : "" ?>" />
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />
    <input type="hidden" name="ip_address" value="<?= encode_form_val($address) ?>">
    <input type="hidden" name="check_method" value="<?= encode_form_val($check_method) ?>">
<?php
    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';
?>
    <div class="container m-0 g-0">
        <h2 class="ul"><?= _('Server Details') ?></h2>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="ip_address" class="form-label"><?= _('IP Address') ?> </label>
                <div class="input-group position-relative">
                    <input type="text" name="ip_address" id="ip_address" value="<?= encode_form_val($address) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter IP Address") ?>" disabled="on">
                    <div class="invalid-feedback">
                        <?= isset($labelText) ? _("Please enter the ".$labelText) : _("Please enter the required information") ?>    </div>
                    <i id="ip_address_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="hostname" class="form-label"><?= _('Host Name') ?> <?= xi6_info_tooltip(_("The name you'd like to have associated with this host")) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="hostname" id="hostname" value="<?= encode_form_val($hostname) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Host Name") ?>" >
                    <div class="invalid-feedback">
                        <?= isset($labelText) ? _("Please enter the ".$labelText) : _("Please enter the required information") ?>    </div>
                    <i id="hostname_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <h2 class="mt-4"><?= _('NRPE Agent') ?></h2>
        <p><?= _('Specify options that should be used to communicate with the remote NRPE agent') ?>.</p>
<?php
    if (!empty($agent_url) && !empty($install_doc_url)) {
?>
        <div class="col-sm-4 border-block ms-3 mb-3">
            <div class="row mb-2">
                <div class="col-sm">
                    <a href="<?= $agent_url ?>"><i class="material-symbols-outlined md-20 md-400 md-action md-middle">download</i></a>
                    <a href="<?= $agent_url ?>"><b><?= _("Download Agent") ?></b></a>
                </div>
            </div>
            <div class="row mb-2">
                <div class="col-sm">
                    <a href="<?= $install_doc_url ?>"><i class="material-symbols-outlined md-20 md-400 md-action md-middle">description</i></a>
                    <a href="<?= $install_doc_url ?>"><b><?= _('Agent Installation Instructions') ?></b></a>
                </div>
            </div>
        </div>
<?php
    }
?>
        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="ssl" class="form-label form-item-required"><?= _("SSL Encryption") ?> <?= xi6_info_tooltip(_('Determines whether or not data between the Nagios XI server and NRPE agent is encrypted. Note: Legacy NRPE installations may require that SSL support be disabled')) ?></label>
                <div class="input-group position-relative">
                    <select name="ssl" id="ssl" class="form-control form-control-sm form-select monitor rounded" placeholder="<?= _("Select SSL Encryption") ?>" >
                        <option value="on" <?= is_selected($ssl, "on") ?>><?= _('Enabled (Default)') ?></option>
                        <option value="off" <?= is_selected($ssl, "off") ?>><?= _('Disabled') ?></option>
                    </select>
                    <div class="invalid-feedback">
                        <?= isset($labelText) ? _("Please select ".$labelText) : _("Please select the required information") ?>    </div>
                    <i id="ssl_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <!--                         -->
        <!-- The metrics to monitor. -->
        <!--                         -->
        <h2 class="mt-4"><?= _('Server Metrics') ?></h2>
        <p><?= _("Specify which services you'd like to monitor for the server") ?>.</p>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="ping" class="form-check-input" name="services[ping]"  <?= is_checked(checkbox_binary($services['ping']), "1") ?> >
                        <label for="ping" class="form-check-label bold"><?= _('Ping') ?> <?= xi6_info_tooltip(_("Monitors the server with an ICMP Ping. Useful for watching network latency and general uptime.")) ?></label>
                    </div>
                </fieldset>
            </div>
        </div>
        
        <h2 class="mt-4"><?= _('NRPE Commands') ?></h2>
        <p><?= _('Specify any remote NRPE commands that should be monitored on the server. Multiple command arguments should be separated with a space.') ?><br>
        <?= _('Arguments are defined with check_nrpe using -a and are single quoted on the command line. If you put in <b>-w 10, -c 20</b> then the config wizard will do')." <b>-a '-w 10, -c 20'</b><br><br>".
        _('Note: By default, NSClient++ disables arguments for security reasons. To use arguments with check_nrpe for NSClient++, you need to enable arguments in the NSClient++ configuration.') ?></p>    
        
        <div class="mb-3">
            <input type="checkbox" class="form-check-input" id="enable_all_args" onclick="toggleArgs(this)">
            <label class="form-check-label" for="enable_all_args"><?= _('I acknowledge that I have enabled arguments on my NSClient++ client') ?></label>
        </div>

        <div class="row">
            <div class="col-sm-10">
                <fieldset class="row g-2 mb-1">
                    <div class="col-sm-4">
                        <label class="form-check-label bold ps-3"><?= _('Display Name') ?></label>
                    </div>
                    <div class="col-sm-4">
                        <label class="form-check-label bold"><?= _('Remote NRPE Command') ?></label>
                    </div>
                    <div class="col-sm-4">
                        <label class="form-check-label bold"><?= _('Command Args') ?></label>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="position-relative adddeleterow commandsList">
            <?php
            for ($x = 0; $x < count($serviceargs['commands']); $x++) {
                $commandstring = encode_form_val($serviceargs['commands'][$x]['command']);
                $commandargs = encode_form_val($serviceargs['commands'][$x]['args']);
                $commandname = encode_form_val($serviceargs['commands'][$x]['name']);
                $is_checked = (isset($services['commands'][$x]) ? is_checked($services['commands'][$x]) : '');
            ?>
                <div class="row">
                    <div class="col-sm-10">
                        <fieldset class="row g-2 mb-1 wz-fieldset">
                            <div class="form-check col-sm-4 mt-0 pt-0">
                                <div class="input-group input-group-sm">
                                    <input type="checkbox" class="form-check-input mt-2 me-2" name="services[commands][<?= $x ?>]" id="services[commands][<?= $x ?>][monitor]" <?= $is_checked ?>>
                                    <input type="text" class="form-control form-control-sm ps-1 rounded" name="serviceargs[commands][<?= $x ?>][name]" id="services[commands][<?= $x ?>][name]" value="<?= $commandname ?>">
                                    <i id="serviceargs_commands_<?= $x ?>_name_Alert-cust-sm" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                </div>
                            </div>
                            <div class="col-sm-4 mt-0">
                                <div class="input-group input-group-sm">
                                    <input type="text" class="form-control form-control-sm monitor" name="serviceargs[commands][<?= $x ?>][command]" id="services[commands][<?= $x ?>][command]" value="<?= $commandstring ?>">
                                    <i id="services_commands_<?= $x ?>_name_Alert-cust-sm" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                </div>
                            </div>
                            <div class="col-sm-4 mt-0">
                                <div class="input-group input-group-sm">
                                    <input type="text" class="form-control form-control-sm rounded monitor" name="serviceargs[commands][<?= $x ?>][args]" id="services[commands][<?= $x ?>][args]" value="<?= $commandargs ?>" disabled>
                                    <i id="serviceargs_commands_<?= $x ?>_args_Alert-cust-sm" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                </div>
                            </div>
                        </fieldset>
                    </div>
                </div>
            <?php
            }
            ?>
        </div> <!-- commandsList -->

        <script type="text/javascript">
            function toggleArgs(checkbox) {
                var commandArgs = document.querySelectorAll('input[name^="serviceargs[commands]"][name$="[args]"]');
                commandArgs.forEach(function(input) {
                    input.disabled = !checkbox.checked;
                });
            }
        </script>
    </div> <!-- container -->

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
