<?php
    // Get variables that were passed to us
    $address = grab_array_var($inargs, "ip_address");
    $port = grab_array_var($inargs, "port", "12489");
    $hostname = grab_array_var($inargs, "hostname", @gethostbyaddr($address));
    $password = grab_array_var($inargs, "password", "");

    $services = "";
    $services_serial = grab_array_var($inargs, "services_serial", "");
    if ($services_serial != "")
        $services = json_decode(base64_decode($services_serial), true);
    if (!is_array($services)) {
        $services_default = array(
            "ping" => 1,
            "cpu" => 1,
            "memory" => 1,
            "uptime" => 1,
            "disk" => 1,
        );
        $services = grab_array_var($inargs, "services", $services_default);
    }

    $serviceargs = "";
    $serviceargs_serial = grab_array_var($inargs, "serviceargs_serial", "");
    if ($serviceargs_serial != "")
        $serviceargs = json_decode(base64_decode($serviceargs_serial), true);

    if (!is_array($serviceargs)) {
        $serviceargs_default = array(

            "memory_warning" => 80,
            "memory_critical" => 90,

            "cpu_warning" => 80,
            "cpu_critical" => 90,

            "processstate" => array(),
            "servicestate" => array(),
            "counter" => array(),
        );
        for ($x = 0; $x < 5; $x++) {
            $serviceargs_default["disk_warning"][$x] = 80;
            $serviceargs_default["disk_critical"][$x] = 95;
            $serviceargs_default["disk"][$x] = ($x == 0) ? "C" : "";
        }
        for ($x = 0; $x < 4; $x++) {
            if ($x == 0) {
                $serviceargs_default['processstate'][$x]['process'] = 'explorer.exe';
                $serviceargs_default['processstate'][$x]['name'] = 'Explorer';
                $services["processstate"][$x] = ""; // defaults for checkboxes, enter on to be checked by default
            } else {
                $serviceargs_default['processstate'][$x]['process'] = '';
                $serviceargs_default['processstate'][$x]['name'] = '';
                $services["processstate"][$x] = ""; // defaults for checkboxes, enter on to be checked by default
            }
        }

        for ($x = 0; $x < 4; $x++) {
            if ($x == 0) {
                $serviceargs_default['servicestate'][$x]['service'] = "W3SVC";
                $serviceargs_default['servicestate'][$x]['name'] = "IIS Web Server";
                $services["servicestate"][$x] = ""; // defaults for checkboxes, enter on to be checked by default
            } else if ($x == 1) {
                $serviceargs_default['servicestate'][$x]['service'] = "MSSQLSERVER";
                $serviceargs_default['servicestate'][$x]['name'] = "SQL Server";
                $services["servicestate"][$x] = ""; // defaults for checkboxes, enter on to be checked by default
            } else {
                $serviceargs_default['servicestate'][$x]['service'] = "";
                $serviceargs_default['servicestate'][$x]['name'] = "";
                $services["servicestate"][$x] = ""; // defaults for checkboxes, enter on to be checked by default
            }
        }
        for ($x = 0; $x < 6; $x++) {
            if ($x == 0) {
                $serviceargs_default['counter'][$x]['counter'] = "\\\\Paging File(_Total)\\\\% Usage";
                $serviceargs_default['counter'][$x]['name'] = "Page File Usage";
                $serviceargs_default['counter'][$x]['format'] = "Paging File usage is %.2f %%";
                $serviceargs_default['counter'][$x]['warning'] = "70";
                $serviceargs_default['counter'][$x]['critical'] = "90";
                $services["counter"][$x] = ""; // defaults for checkboxes, enter on to be checked by default
            } else if ($x == 1) {
                $serviceargs_default['counter'][$x]['counter'] = "\\\\Server\\\\Errors Logon";
                $serviceargs_default['counter'][$x]['name'] = "Logon Errors";
                $serviceargs_default['counter'][$x]['format'] = "Login Errors since last reboot is %.f";
                $serviceargs_default['counter'][$x]['warning'] = "2";
                $serviceargs_default['counter'][$x]['critical'] = "20";
                $services["counter"][$x] = ""; // defaults for checkboxes, enter on to be checked by default
            } else if ($x == 2) {
                $serviceargs_default['counter'][$x]['counter'] = "\\\\Server Work Queues(0)\\\\Queue Length";
                $serviceargs_default['counter'][$x]['name'] = "Server Work Queues";
                $serviceargs_default['counter'][$x]['format'] = "Current work queue (an indication of processing load) is %.f ";
                $serviceargs_default['counter'][$x]['warning'] = "4";
                $serviceargs_default['counter'][$x]['critical'] = "7";
                $services["counter"][$x] = ""; // defaults for checkboxes, enter on to be checked by default
            } else {
                $serviceargs_default['counter'][$x]['counter'] = "";
                $serviceargs_default['counter'][$x]['name'] = "";
                $serviceargs_default['counter'][$x]['format'] = "";
                $serviceargs_default['counter'][$x]['warning'] = "";
                $serviceargs_default['counter'][$x]['critical'] = "";
                $services["counter"][$x] = ""; // defaults for checkboxes, enter on to be checked by default
            }
        }

        $serviceargs = grab_array_var($inargs, "serviceargs", $serviceargs_default);
    }
?>

<input type="hidden" name="ip_address" value="<?php echo encode_form_val($address); ?>">
<input type="hidden" name="check_method" value="<?php echo encode_form_val($check_method); ?>">

<h5 class="ul"><?php echo _('Host Details'); ?></h5>
<table class="table table-condensed table-no-border table-auto-width">
    <tr>
        <td>
            <label><?php echo _('IP Address'); ?>:</label>
        </td>
        <td>
            <input type="text" size="40" name="ip_address" id="ip_address" value="<?php echo encode_form_val($address); ?>" class="form-control" disabled>
        </td>
    </tr>
    <tr>
        <td class="vt">
            <label><?php echo _('Host Name'); ?>:</label>
        </td>
        <td>
            <input type="text" size="20" name="hostname" id="hostname" value="<?php echo encode_form_val($hostname); ?>" class="form-control">
            <div class="subtext">
                <?php echo _("The name you'd like to have associated with this Windows system."); ?>
            </div>
        </td>
    </tr>
</table>

<h5 class="ul"><?php echo _('NSClient++ Agent'); ?></h5>
<p>
    <?php echo _("You'll need to install an agent on the Windows system in order to monitor it.  For security purposes, it is recommended to use a password with the agent."); ?>
</p>

<div class="alert alert-info" style="margin-bottom: 0; width: 50%; min-width: 300px;">
    <?php echo _("This config wizard is now <b>legacy</b>. We recommend using the"); ?>
    <a href="monitoringwizard.php?wizard=windowsserver&amp;nextstep=2&amp;nsp=<?php echo get_nagios_session_protector_id(); ?>">
        <?php echo _("Windows Server"); ?>
    </a> 
    <?php echo _("or"); ?>
    <a href="monitoringwizard.php?wizard=windowsdesktop&amp;nextstep=2&amp;nsp=<?php echo get_nagios_session_protector_id(); ?>">
        <?php echo _("Windows Desktop"); ?>
    </a>
    <?php echo _("configuration wizard instead."); ?>
</div>

<table class="table table-condensed table-no-border table-auto-width">
    <tr>
        <td valign="top">
            <label><?php echo _('Agent Password'); ?>:</label>
        </td>
        <td>
            <input type="text" size="20" name="password" id="password" value="<?php echo encode_form_val($password); ?>" class="form-control">
            <div class="subtext">
                <?php echo _('Valid characters include'); ?>: <b>a-zA-Z0-9 .\:_-@</b>
            </div>
        </td>
    </tr>
</table>

<h5 class="ul"><?php echo _('Server Metrics'); ?></h5>
<p><?php echo _("Specify which services you'd like to monitor for the system."); ?></p>
<table class="table table-no-border table-auto-width">
    <tr>
        <td>
            <input type="checkbox" id="p" class="checkbox" name="services[ping]" <?php echo is_checked(checkbox_binary($services["ping"]), "1"); ?>>
        </td>
        <td>
            <label class="normal" for="p">
                <b>Ping</b><br>
                <?php echo _('Monitors the server with an ICMP ping.  Useful for watching network latency and general uptime.'); ?>
            </label>
        </td>
    </tr>
    <tr>
        <td class="vt">
            <input type="checkbox" id="cpu" class="checkbox" name="services[cpu]" <?php echo is_checked(checkbox_binary($services["cpu"]), "1"); ?>>
        </td>
        <td>
            <label class="normal" for="cpu">
                <b><?php echo _('CPU'); ?></b><br>
                <?php echo _('Monitors the CPU (processor usage) on the server.'); ?>
            </label>
            <div class="pad-t5">
                <label class="flex-v-align">
                    <i title="<?php echo _('Warning Threshold'); ?>" class="material-symbols-outlined md-warning md-18 md-400 md-middle tt-bind">warning</i>
                </label>
                <input type="text" size="2" name="serviceargs[cpu_warning]" value="<?php echo encode_form_val($serviceargs["cpu_warning"]); ?>" class="form-control"> % &nbsp;
                <label class="input-group-addon input-grouped">
                    <i title="<?php echo _('Critical Threshold'); ?>" class="flex-v-align material-symbols-outlined md-critical md-18 md-400 md-middle tt-bind">error</i>
                </label>
                <input type="text" size="2" name="serviceargs[cpu_critical]" value="<?php echo encode_form_val($serviceargs["cpu_critical"]); ?>" class="form-control"> %
            </div>
        </td>
    </tr>
    <tr>
        <td class="vt">
            <input type="checkbox" id="mu" class="checkbox" name="services[memory]" <?php echo is_checked(checkbox_binary($services["memory"]), "1"); ?>>
        </td>
        <td>
            <label class="normal" for="mu">
                <b><?php echo _('Memory Usage'); ?></b><br>
                <?php echo _('Monitors the memory usage on the server.'); ?>
            </label>
            <div class="pad-t5">
                <label class="flex-v-align">
                    <i title="<?php echo _('Warning Threshold'); ?>" class="material-symbols-outlined md-warning md-18 md-400 md-middle tt-bind">warning</i>
                </label>
                <input type="text" size="2" name="serviceargs[memory_warning]" value="<?php echo encode_form_val($serviceargs["memory_warning"]); ?>" class="form-control"> % &nbsp;
                <label class="input-group-addon input-grouped">
                    <i title="<?php echo _('Critical Threshold'); ?>" class="flex-v-align material-symbols-outlined md-critical md-18 md-400 md-middle tt-bind">error</i>
                </label>
                <input type="text" size="2" name="serviceargs[memory_critical]" value="<?php echo encode_form_val($serviceargs["memory_critical"]); ?>" class="form-control"> %
            </div>
        </td>
    </tr>
    <tr>
        <td>
            <input type="checkbox" id="up" class="checkbox" name="services[uptime]" <?php echo is_checked(checkbox_binary($services["uptime"]), "1"); ?>>
        </td>
        <td>
            <label class="normal" for="up">
                <b><?php echo _('Uptime'); ?></b><br>
                <?php echo _('Monitors the uptime on the server.'); ?>
            </label>
        </td>
    </tr>
    <tr>
        <td class="vt">
            <input type="checkbox" id="du" class="checkbox" name="services[disk]" <?php echo is_checked(checkbox_binary($services["disk"]), "1"); ?>>
        </td>
        <td>
            <label class="normal" for="du">
                <b><?php echo _('Disk Usage'); ?></b><br>
                <?php echo _('Monitors disk usage on the server.'); ?>
            </label>
            <div class="pad-t5">
                <table class="adddeleterow table table-condensed table-no-border table-auto-width" style="margin-bottom: 10px;">
                    <?php for ($x = 0; $x < count($serviceargs["disk"]); $x++): ?>
                        <tr>
                            <td class="w-auto pt-3">
                                <label><?php echo _('Drive'); ?>:</label>
                            </td>
                            <td>
                                <select name="serviceargs[disk][<?php echo $x; ?>]" class="form-control">
                                    <option value=""></option>
                                    <?php for ($y = 0; $y < 26; $y++): 
                                        $diskname = chr(ord('A') + $y);
                                    ?>
                                        <option value="<?php echo $diskname; ?>" <?php echo is_selected($serviceargs["disk"][$x], $diskname); ?>><?php echo $diskname; ?>:</option>
                                    <?php endfor; ?>
                                </select>
                            </td>
                            <td>
                                <div class="pad-t5">
                                    <label class="flex-v-align me-1">
                                        <i title="<?php echo _('Warning Threshold'); ?>" class="material-symbols-outlined md-warning md-18 md-400 md-middle tt-bind">warning</i>
                                    </label>
                                    <input type="text" name="serviceargs[disk_warning][<?php echo $x; ?>]" value="<?php echo encode_form_val($serviceargs["disk_warning"][$x]); ?>" class="form-control form-control-sm ps-1 rounded"> %
                    
                                    <label class="flex-v-align me-1">
                                        <i title="<?php echo _('Critical Threshold'); ?>" class="material-symbols-outlined md-critical md-18 md-400 md-middle tt-bind">error</i>
                                    </label>
                                    <input type="text" name="serviceargs[disk_critical][<?php echo $x; ?>]" value="<?php echo encode_form_val($serviceargs["disk_critical"][$x]); ?>" class="form-control form-control-sm ps-1 rounded"> %
                                </div>
                            </td>
                        </tr>
                    <?php endfor; ?>
                </table>
            </div>
        </td>
    </tr>
</table>

<h5 class="ul"><?php echo _('Services'); ?></h5>
<p><?php echo _("Specify any services that should be monitored to ensure they're in a running state."); ?></p>
<table class="adddeleterow table table-condensed table-no-border table-auto-width" style="margin-bottom: 10px;">
    <tr>
        <th class="form-check-label bold"></th>
        <th class="form-check-label bold"><?php echo _('Windows Service'); ?></th>
        <th class="form-check-label bold"><?php echo _('Display Name'); ?></th>
    </tr>
    <?php for ($x = 0; $x < count($serviceargs['servicestate']); $x++): 
        $servicestring = encode_form_val($serviceargs['servicestate'][$x]['service']);
        $servicename = encode_form_val($serviceargs['servicestate'][$x]['name']);
    ?>
        <tr>
            <td>
                <input type="checkbox" class="checkbox" name="services[servicestate][<?php echo $x; ?>]" <?php echo (isset($services['servicestate'][$x]) ? is_checked($services['servicestate'][$x]) : ''); ?>>
            </td>
            <td>
                <input type="text" size="15" name="serviceargs[servicestate][<?php echo $x; ?>][service]" value="<?php echo $servicestring; ?>" class="form-control">
            </td>
            <td>
                <input type="text" size="20" name="serviceargs[servicestate][<?php echo $x; ?>][name]" value="<?php echo $servicename; ?>" class="form-control">
            </td>
        </tr>
    <?php endfor; ?>
</table>
<div style="height: 20px;"></div>

<h5 class="ul"><?php echo _('Processes'); ?></h5>
<p><?php echo _("Specify any processes that should be monitored to ensure they're running."); ?></p>
<table class="adddeleterow table table-condensed table-no-border table-auto-width" style="margin-bottom: 10px;">
    <tr>
        <th class="form-check-label bold"></th>
        <th class="form-check-label bold"><?php echo _('Windows Process'); ?></th>
        <th class="form-check-label bold"><?php echo _('Display Name'); ?></th>
    </tr>
    <?php for ($x = 0; $x < count($serviceargs['processstate']); $x++): 
        $processstring = encode_form_val($serviceargs['processstate'][$x]['process']);
        $processname = encode_form_val($serviceargs['processstate'][$x]['name']);
    ?>
        <tr>
            <td>
                <input type="checkbox" class="checkbox" name="services[processstate][<?php echo $x; ?>]" <?php echo (isset($services['processstate'][$x]) ? is_checked($services['processstate'][$x]) : ''); ?>>
            </td>
            <td>
                <input type="text" size="15" name="serviceargs[processstate][<?php echo $x; ?>][process]" value="<?php echo $processstring; ?>" class="form-control">
            </td>
            <td>
                <input type="text" size="20" name="serviceargs[processstate][<?php echo $x; ?>][name]" value="<?php echo $processname; ?>" class="form-control">
            </td>
        </tr>
    <?php endfor; ?>
</table>
<div style="height: 20px;"></div>

<h5 class="ul"><?php echo _('Performance Counters'); ?></h5>
<p><?php echo _("Specify any performance counters that should be monitored."); ?></p>
<table class="adddeleterow table table-condensed table-no-border table-auto-width" style="margin-bottom: 10px;">
    <tr>
        <th class="form-check-label bold"></th>
        <th class="form-check-label bold"><?php echo _('Performance Counter'); ?></th>
        <th class="form-check-label bold"><?php echo _('Display Name'); ?></th>
        <th class="form-check-label bold"><?php echo _('Counter Output Format'); ?></th>
        <th class="form-check-label bold"><?php echo _('Warning'); ?></th>
        <th class="form-check-label bold"><?php echo _('Critical'); ?></th>
    </tr>
    <?php for ($x = 0; $x < count($serviceargs['counter']); $x++): 
        $counterstring = encode_form_val($serviceargs['counter'][$x]['counter']);
        $countername = encode_form_val($serviceargs['counter'][$x]['name']);
        $counterformat = encode_form_val($serviceargs['counter'][$x]['format']);
        $warnlevel = encode_form_val($serviceargs['counter'][$x]['warning']);
        $critlevel = encode_form_val($serviceargs['counter'][$x]['critical']);
    ?>
        <tr>
            <td>
                <input type="checkbox" class="checkbox" name="services[counter][<?php echo $x; ?>]" <?php echo (isset($services['counter'][$x]) ? is_checked($services['counter'][$x]) : ''); ?>>
            </td>
            <td>
                <input type="text" size="25" name="serviceargs[counter][<?php echo $x; ?>][counter]" value="<?php echo $counterstring; ?>" class="form-control">
            </td>
            <td>
                <input type="text" size="20" name="serviceargs[counter][<?php echo $x; ?>][name]" value="<?php echo $countername; ?>" class="form-control">
            </td>
            <td>
                <input type="text" size="25" name="serviceargs[counter][<?php echo $x; ?>][format]" value="<?php echo $counterformat; ?>" class="form-control">
            </td>
            <td>
                <input type="text" size="2" name="serviceargs[counter][<?php echo $x; ?>][warning]" value="<?php echo $warnlevel; ?>" class="form-control">
            </td>
            <td>
                <input type="text" size="2" name="serviceargs[counter][<?php echo $x; ?>][critical]" value="<?php echo $critlevel; ?>" class="form-control">
            </td>
        </tr>
    <?php endfor; ?>
</table>
<div style="height: 20px;"></div>

