    <input type="hidden" id="selectedhostconfig" name="selectedhostconfig" value="<?= encode_form_val($selectedhostconfig) ?>" />
    <input type="hidden" id="services_serial" name="services_serial" value="<?= (!empty($services)) ? base64_encode(json_encode($services)) : "" ?>" />
    <input type="hidden" id="serviceargs_serial" name="serviceargs_serial" value="<?= (!empty($serviceargs)) ? base64_encode(json_encode($serviceargs)) : "" ?>" />
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />

    <input type="hidden" id="old_auth" name="old_auth" value="<?= intval($old_auth) ?>">

<?php
    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';
?>
    <div class="container m-0 g-0">
        <!--                         -->
        <!-- The configuration form. -->
        <!--                         -->
        <div id="configForm">

            <h2 class="ul"><?= _('Nagios XI Server') ?></h2>
            <p><?= _('Specify the details for the remote Nagios XI server you want to monitor') ?></p>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="" class="form-label form-item-required"><?= _('Address') ?> <?= xi6_info_tooltip(_('The IP address or hostname of the remote Nagios XI server')) ?></label>
                    <div class="input-group position-relative">
                        <input type="text" name="ip_address" id="ip_address" value="<?= encode_form_val($address) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter Address") ?>" required>
                        <div class="invalid-feedback">
                            Please enter the IP Address
                        </div>
                        <i id="ip_address_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="" class="form-label form-item-required">URL <?= xi6_info_tooltip(_('The full URL used to the remote Nagios XI server\'s web interface. Make sure you include the full path. Example:').' http://192.168.1.1/nagiosxi/') ?></label>
                    <div class="input-group position-relative">
                        <input type="text" name="url" id="url" value="<?= encode_form_val($url) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter URL, e.g., http://192.168.1.1/nagiosxi/") ?>" required>
                        <div class="invalid-feedback">
                            Please enter the URL
                        </div>
                        <i id="url_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <h2 class="mt-4"><?= _('Authentication Settings') ?></h2>
            <p><?= _("An admin user's API key for the Nagios XI server is required.") ?></p>

            <div class="row mb-3">
                <div class="col-sm">
                    <input type="checkbox" id=auth-type name="auth-type" class="form-check-input mt-1 me-2 change-auth-type" <?= (isset($old_auth) && $old_auth == 1) ? 'checked' : '' ?>>
                    <label for="no_ssl_verify" class="form-check-label bold">
                        <?= _("Legacy Nagios XI authentication") ?>
                        <?= xi6_info_tooltip(_("If this box is checked, the legacy authentication version will be available. Use only with versions of Nagios XI < 5.5.")) ?>
                    </label>
                </div>
            </div>

            <div class="row mb-2 new-auth">
                <div class="col-sm-6">
                    <label for="" class="form-label form-item-required"><?= _('API Key') ?> <?= xi6_info_tooltip(_('To find this, log in to the target Nagios XI server and in the top right corner click the <em>profile icon</em> then <em>Account Settings</em>. This will open your profile, where the API Key will be displayed.')) ?></label>
                    <div class="input-group position-relative">
                        <input type="text" name="apikey" id="apikey" value="<?= encode_form_val($apikey) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter API Key (Nagios XI 5.5+)") ?>" required>
                        <div class="invalid-feedback">
                            Please enter the API Key
                        </div>
                        <i id="apikey_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <div class="col-sm-6 border-block old-auth visually-hidden">
                <h2><?= _('Legacy Authentication') ?></h2>
                <p><?= _("Only for versions of Nagios XI, prior to than 5.5") ?></p>

                <div class="row mb-2">
                    <div class="col-sm">
                        <label for="" class="form-label form-item-required"><?= _('Username') ?> <?= xi6_info_tooltip(_('The username used to authenticate to the remote Nagios XI server')) ?></label>
                        <div class="input-group position-relative">
                            <input type="text" name="username" id="username" value="<?= encode_form_val($username) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter Username") ?>" required>
                            <div class="invalid-feedback">
                                Please enter the Username
                            </div>
                            <i id="username_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </div>

                <div class="row mb-2">
                    <div class="col-sm">
                        <label for="" class="form-label form-item-required"><?= _('Password') ?> <?= xi6_info_tooltip(_('The password used to authenticate to the remote Nagios XI server')) ?></label>
                        <div class="input-group position-relative">
                            <input type="text" name="password" id="password" value="<?= encode_form_val($password) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter Password") ?>" required>
                            <div class="invalid-feedback">
                                Please enter the Password
                            </div>
                            <i id="password_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </div>
            </div>

        </div> <!-- config -->
    </div> <!-- container -->

    <script type="text/javascript">
        $(document).ready(function() {
            // Initialize
            if ($('#auth-type').is(':checked')) {
                $(".new-auth").addClass('visually-hidden');
                $(".old-auth").removeClass('visually-hidden');
                $("#apikey").removeAttr('required');
                $("#username").attr('required');
                $("#password").attr('required');
                $("#old_auth").val(1);
            } else {
                $(".new-auth").removeClass('visually-hidden');
                $(".old-auth").addClass('visually-hidden');
                $("#apikey").attr('required');
                $("#username").removeAttr('required');
                $("#password").removeAttr('required');
                $("#old_auth").val(0);
            }

            $(".change-auth-type").change(function() {
                if ($(this).is(':checked')) {
                    $(".new-auth").addClass('visually-hidden');
                    $(".old-auth").removeClass('visually-hidden');
                    $("#apikey").removeAttr('required');
                    $("#username").attr('required');
                    $("#password").attr('required');
                    $("#old_auth").val(1);
                } else {
                    $(".new-auth").removeClass('visually-hidden');
                    $(".old-auth").addClass('visually-hidden');
                    $("#apikey").attr('required');
                    $("#username").removeAttr('required');
                    $("#password").removeAttr('required');
                    $("#old_auth").val(0);
                }
            });
        });
    </script>

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
