$(document).ready(function() {

    hyperv_configwizard.ncpa_ip = $('#ip_address').val();
    hyperv_configwizard.ncpa_token = $('#token').html();
    hyperv_configwizard.ncpa_port = $('#port').html();

    hyperv_configwizard.instance_ok = $('#instance-ok').html();
    hyperv_configwizard.instance_pending = $('#instance-pending').html();
    hyperv_configwizard.instance_critical = $('#instance-critical').html();

    // Keeps a count of how many rows are in each section so that we can monitor multiple instances per performance counter
    hyperv_configwizard.row_counters = {
        cpu: hyperv_configwizard.get_section_size('cpu'),
        memory: hyperv_configwizard.get_section_size('memory'),
        networking: hyperv_configwizard.get_section_size('networking'),
        local_storage: hyperv_configwizard.get_section_size('local-storage'),
        virtual_storage: hyperv_configwizard.get_section_size('virtual-storage'),
        ha_storage: hyperv_configwizard.get_section_size('ha-storage')
    };

    $('input.enable-windows-perf-counter').each(function() {
        hyperv_configwizard.verify_from_checkbox(this);
    });

    function register_events() {

        $('input.instance-name').off('focusout');
        $('input.instance-name').focusout(function() {
            var parent_fieldset = $(this).parents('fieldset');
            var perf_object = parent_fieldset.find('input[id*=object]').val();
            var instance_name = $(this).val();
            var perf_counter = parent_fieldset.find('input[id*=counter]').val();
            var insert_location = parent_fieldset.find('span.instance-status');
            var factor = parent_fieldset.find('input[id*=factor]').val();

            hyperv_configwizard.verify_instance_name(perf_object, instance_name, perf_counter, insert_location, factor);
        });

        $('input[id*=factor]').off('focusout');
        $('input[id*=factor]').focusout(function() {
            var parent_fieldset = $(this).parents('fieldset');
            var perf_object = parent_fieldset.find('input[id*=object]').val();
            var instance_name = parent_fieldset.find('input.instance-name').val();
            var perf_counter = parent_fieldset.find('input[id*=counter]').val();
            var insert_location = parent_fieldset.find('span.instance-status');
            var factor = $(this).val();

            hyperv_configwizard.verify_instance_name(perf_object, instance_name, perf_counter, insert_location, factor);
        })

        $('input.enable-windows-perf-counter').off('change');
        $('input.enable-windows-perf-counter').change(function() {
            hyperv_configwizard.verify_from_checkbox(this);
        });

        $('a.hyperv-new-counter').off('click');
        $('a.hyperv-new-counter').click(function() {
            var parent_fieldset = $(this).parents('fieldset');
            //var full_row = $(this).parent().parent().parent(); // .after
            var full_row = parent_fieldset.parent().parent(); // .after
            //var section = $(this).parent().siblings('span').data('sa-section');
            var section = parent_fieldset.find('span.instance-status').data('sa-section');
            //var original_index = $(this).parent().siblings('span').data('sa-index');
            var original_index = parent_fieldset.find('span.instance-status').data('sa-section');
            var current_index = hyperv_configwizard.get_section_size(section);
            var text = full_row.html();

            // Replace any instances of 'name="serviceargs[section-name][old-index]' in form inputs
            form_name_pattern = "serviceargs\\["+section+"\\]\\["+original_index+"\\]";
            form_name_pattern_regex = new RegExp(form_name_pattern, 'g');
            form_name_replace = "serviceargs["+section+"]["+current_index+"]";
            text = text.replace(form_name_pattern_regex, form_name_replace);

            // Replace hidden input ids, which look like 'section-name-old-index-'
            form_id_pattern = section+'-'+original_index;
            form_id_pattern_regex = new RegExp(form_id_pattern, 'g');
            form_id_replace = section+'-'+current_index;
            text = text.replace(form_id_pattern_regex, form_id_replace);

            // Replace the data section of the instance-status span
            form_span_pattern = 'data-sa-index="'+original_index+'" data-sa-section="'+section+'"';
            form_span_pattern_regex = new RegExp(form_id_pattern, 'g');
            form_span_replace = 'data-sa-index="'+current_index+'" data-sa-section="'+section+'"';
            text = text.replace(form_span_pattern_regex, form_span_replace);

            full_row.parent('div[id='+section+']').append(text);
            $('input[name="serviceargs['+section+']['+current_index+'][instance]"]').select();
            register_events();
        });
    }

    register_events();
});

var hyperv_configwizard = {};
hyperv_configwizard.verify_instance_name = function(perf_object, instance_name, perf_counter, insert_location, factor) {

    if (typeof factor === "undefined") {
        factor = '0';
    }

    console.log('factor is '+factor);
    perf_object = encodeURI(perf_object);
    instance_name = encodeURI(instance_name);
    perf_counter = encodeURI(perf_counter);
    factor = encodeURI(factor);
    console.log('now factor is '+factor);

    ajax_url = '../includes/configwizards/hyperv/hyperv-ajax.php';

    query = {
        perf_object: perf_object,
        instance_name: instance_name,
        perf_counter: perf_counter,
        ip_address: this.ncpa_ip,
        token: this.ncpa_token,
        port: this.ncpa_port,
        factor: factor
    };

    insert_location.html(this.instance_pending);

    $.post(ajax_url, query, function(data) {
        var value = data['windowscounters'][0];
        var endpoint_or_errcheck = data['windowscounters'][1];

        if (endpoint_or_errcheck === "c" || ((typeof value) === "object")) {
            row_index = hyperv_configwizard.get_row_index(insert_location);
            section = hyperv_configwizard.get_section(insert_location);
            insert_location.html(hyperv_configwizard.instance_critical);
            insert_location.append('<input type="hidden" name="serviceargs['+row_index+'][invalid]" value="true">' )

        } else {
            insert_location.html(hyperv_configwizard.instance_ok+" "+value.toString());
        }
    });
};

hyperv_configwizard.get_row_index = function(insert_location) {
    return insert_location.data('sa-index');
};

hyperv_configwizard.get_section = function(insert_location) {
    return insert_location.data('sa-section');
};

hyperv_configwizard.get_section_size = function(section_name) {
    return $('div.row.'+section_name).length;
};

// If the checkbox is checked, try to connect to NCPA. Otherwise do nothing.
hyperv_configwizard.verify_from_checkbox = function(checkbox_this) {
    // These hoist anyways I'm just trying to be explicit about it
    var parent_fieldset;
    var perf_object;
    var instance_name;
    var perf_counter;
    var insert_location;
    var factor;

    if (checkbox_this.checked) {
        parent_fieldset = $(checkbox_this).parents('fieldset');
        perf_object = parent_fieldset.find('input[id*=object]').val();
        instance_name = $(checkbox_this).siblings('input').val();
        perf_counter = parent_fieldset.find('input[id*=counter]').val();
        insert_location = parent_fieldset.find('span.instance-status');
        factor = parent_fieldset.find('input[id*=factor]').val();

        this.verify_instance_name(perf_object, instance_name, perf_counter, insert_location, factor);
    }
}