<?php
//
// Windows Server Config Wizard
// Copyright (c) 2012-2024 Nagios Enterprises, LLC. All rights reserved.
//

include_once(dirname(__FILE__) . '/../configwizardhelper.inc.php');

windowsserver_configwizard_init();

// Check if user has old windowsdesktop
if (!function_exists('windowsdesktop_configwizard_init')) {
    function windowsdesktop_configwizard_init()
    {
        $name = "windowsdesktop";
        $args = array(
            CONFIGWIZARD_NAME => $name,
            CONFIGWIZARD_VERSION => "3.0.1",
            CONFIGWIZARD_TYPE => CONFIGWIZARD_TYPE_MONITORING,
            CONFIGWIZARD_DESCRIPTION => _("Monitor a Microsoft&reg; Windows Vista, 7, 8, 8.1 and 10 desktop with NCPA."),
            CONFIGWIZARD_DISPLAYTITLE => _("Windows Desktop"),
            CONFIGWIZARD_FUNCTION => "ncpa_configwizard_func",
            CONFIGWIZARD_FUNCTION_ARGS => array('os' => 'windows', 'defaults' => 'desktop'),
            CONFIGWIZARD_PREVIEWIMAGE => "windows.png",
            CONFIGWIZARD_FILTER_GROUPS => array('windows', 'ncpa', 'server'),
            CONFIGWIZARD_REQUIRES_VERSION => 60100
        );
        register_configwizard($name, $args);
    }

    windowsdesktop_configwizard_init();
}

function windowsserver_configwizard_init()
{
    $name = "windowsserver";
    $args = array(
        CONFIGWIZARD_NAME => $name,
        CONFIGWIZARD_VERSION => "3.0.1",
        CONFIGWIZARD_TYPE => CONFIGWIZARD_TYPE_MONITORING,
        CONFIGWIZARD_DESCRIPTION => _("Monitor a Microsoft&reg; Windows 2008, 2012, 2016, or 2019 server with NCPA."),
        CONFIGWIZARD_DISPLAYTITLE => _("Windows Server"),
        CONFIGWIZARD_FUNCTION => "ncpa_configwizard_func",
        CONFIGWIZARD_FUNCTION_ARGS => array('os' => 'windows', 'defaults' => 'server'),
        CONFIGWIZARD_PREVIEWIMAGE => "win_server.png",
        CONFIGWIZARD_FILTER_GROUPS => array('windows'),
        CONFIGWIZARD_REQUIRES_VERSION => 60100
    );
    register_configwizard($name, $args);
}
