    <input type="hidden" id="selectedhostconfig" name="selectedhostconfig" value="<?= encode_form_val($selectedhostconfig) ?>" />
    <input type="hidden" id="services_serial" name="services_serial" value="<?= (!empty($services)) ? base64_encode(json_encode($services)) : "" ?>" />
    <input type="hidden" id="serviceargs_serial" name="serviceargs_serial" value="<?= (!empty($serviceargs)) ? base64_encode(json_encode($serviceargs)) : "" ?>" />
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />

    <input type="hidden" name="snmpversion" id="snmpversion" value="<?= encode_form_val($snmpversion); ?>">
<?php
    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';
?>
    <div class="container m-0 g-0">
        <!--                         -->
        <!-- The configuration form. -->
        <!--                         -->
        <div id="configForm">

            <h2 class="mb-2"><?= _("WatchGuard Information") ?></h2>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="ip_address" class="form-label form-item-required"><?= _("IP Address") ?> <?= xi6_info_tooltip(_("The IP address of the WatchGuard device.")) ?></label>
                    <div class="input-group position-relative">
                        <input type="text" name="ip_address" id="ip_address" value="<?= encode_form_val($address) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter IP Address") ?>" required>
                        <div class="invalid-feedback">
                            Please enter the IP Address
                        </div>
                        <i id="ip_address_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="port" class="form-label form-item-required"><?= _("Port") ?> <?= xi6_info_tooltip(_("The access port of the WatchGuard device.")) ?></label>
                    <div class="input-group position-relative">
                        <input type="text" name="port" id="port" value="<?= encode_form_val($address_port) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter Port") ?>" required>
                        <div class="invalid-feedback">
                            Please enter the Port
                        </div>
                        <i id="port_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <!-- Watchguard Setup Tabs -->
            <div class="col-sm-6 border-block mt-4">
                <ul class="nav nav-pills mb-3" id="pills-tab" role="tablist">
                    <li class="nav-item"><a class="nav-link" id="pills-selectv1-tab" data-bs-toggle="pill" data-bs-target="#pills-selectv2c" type="button" role="tab" aria-controls="pills-selectv2c" aria-selected="false">SNMPv1</a></li>
                    <li class="nav-item"><a class="nav-link active" id="pills-selectv2c-tab" data-bs-toggle="pill" data-bs-target="#pills-selectv2c" type="button" role="tab" aria-controls="pills-selectv2c" aria-selected="true">SNMPv2c</a></li>
                    <li class="nav-item"><a class="nav-link" id="pills-selectv3-tab" data-bs-toggle="pill" data-bs-target="#pills-selectv3" type="button" role="tab" aria-controls="pills-selectv3" aria-selected="false">SNMPv3</a></li>
                </ul>

                <div class="tab-content" id="pills-tabContent">

                    <div id="pills-selectv2c" class="tab-pane fade show active" role="tabpanel" aria-labelledby="pills-selectv2c-tab">

                        <div id="snmpv2" class="position-relative">

                            <div class="row mb-2">
                                <div class="col-sm">
                                    <label for="snmpopts[snmpcommunity]" class="form-label form-item-required"><?= _("SNMP Community") ?> <?= xi6_info_tooltip(_("The SNMP community string for the WatchGuard device.")) ?></label>
                                    <div class="input-group position-relative">
                                        <input type="text" name="snmpopts[snmpcommunity]" id="snmpopts[snmpcommunity]" value="<?= encode_form_val($snmpopts['snmpcommunity']) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter SNMP Community") ?>" required>
                                        <div class="invalid-feedback">
                                            Please enter the SNMP Community
                                        </div>
                                        <i id="snmpopts_snmpcommunity_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                    </div>
                                </div>
                            </div>

                        </div> <!-- snmpv2 -->
                    </div> <!-- Closes #pills-selectv2-tab -->

                    <div id="pills-selectv3" class="tab-pane fade show" role="tabpanel" aria-labelledby="pills-selectv3-tab">
                        <div id="snmpv3" class="position-relative">

                            <p><?= _("SNMP v3 requires authentication information.") ?>.</p>

                            <div class="row mb-2">
                                <div class="col-sm">
                                    <label for="snmpopts[v3_security_level]" class="form-label form-item-required"><?= _("Security Level") ?> </label>
                                    <div class="input-group position-relative">
                                        <select name="snmpopts[v3_security_level]" id="snmpopts[v3_security_level]" class="form-select monitor rounded security_level" placeholder="<?= _("Select a Security Level") ?> ">
                                            <option value="authPriv" <?= is_selected($snmpopts["v3_security_level"], "authPriv") ?>>authPriv</option>
                                            <option value="authNoPriv" <?= is_selected($snmpopts["v3_security_level"], "authNoPriv") ?>>authNoPriv</option>
                                            <option value="noAuthNoPriv" <?= is_selected($snmpopts["v3_security_level"], "noAuthNoPriv") ?>>noAuthNoPriv</option>
                                        </select>
                                        <div class="invalid-feedback">
                                            Please select a Security Level
                                        </div>
                                        <i id="snmpopts_v3_security_level_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                    </div>
                                </div>
                            </div>

                            <div class="row mb-2">
                                <div class="col-sm">
                                    <label for="snmpopts[v3_username]" class="form-label form-item-required"><?= _("Username") ?> </label>
                                    <div class="input-group position-relative">
                                        <!-- <input type="text" name="snmpopts[v3_username]" id="snmpopts[v3_username]" value="<?= encode_form_val($snmpopts['v3_username']) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter Username") ?>"> -->
                                        <input type="text" name="snmpopts[v3_username]" id="snmp_username" value="<?= encode_form_val($snmpopts['v3_username']) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter Username") ?>">
                                        <div class="invalid-feedback">
                                            Please enter the Username
                                        </div>
                                        <i id="snmpopts_v3_username_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                    </div>
                                </div>
                            </div>

                            <div class="row mb-2">
                                <div class="col-sm">
                                    <label for="snmpopts[v3_auth_password]" class="form-label form-item-required"><?= _("Authentication Password") ?> </label>
                                    <div class="input-group position-relative">
                                        <input type="text" name="snmpopts[v3_auth_password]" id="snmpopts[v3_auth_password]" value="<?= encode_form_val($snmpopts['v3_auth_password']) ?>" class="form-control monitor rounded authPriv-enable authNoPriv-enable noAuthNoPriv-disable" placeholder="<?= _("Enter Authentication Password") ?>">
                                        <div class="invalid-feedback">
                                            Please enter the Authentication Password
                                        </div>
                                        <i id="snmpopts_v3_auth_password_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                    </div>
                                </div>
                            </div>

                            <div class="row mb-2">
                                <div class="col-sm">
                                    <label for="snmpopts[v3_auth_proto]" class="form-label form-item-required"><?= _("Authentication Protocol") ?> </label>
                                    <div class="input-group position-relative">
                                        <select name="snmpopts[v3_auth_proto]" id="snmpopts[v3_auth_proto]" class="form-select monitor rounded authPriv-enable authNoPriv-enable noAuthNoPriv-disable" placeholder="<?= _("Select Authentication Protocol") ?>">
                                            <option value="MD5" <?= is_selected($snmpopts["v3_auth_proto"], "MD5") ?>>MD5</option>
                                            <option value="SHA" <?= is_selected($snmpopts["v3_auth_proto"], "SHA") ?>>SHA</option>
                                        </select>
                                        <div class="invalid-feedback">
                                            Please select Authentication Protocol
                                        </div>
                                        <i id="snmpopts_v3_auth_proto_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                    </div>
                                </div>
                            </div>

                            <div class="row mb-2">
                                <div class="col-sm">
                                    <label for="snmpopts[v3_priv_password]" class="form-label form-item-required"><?= _("Privileged Password") ?> </label>
                                    <div class="input-group position-relative">
                                        <input type="text" name="snmpopts[v3_priv_password]" id="snmpopts[v3_priv_password]" value="<?= encode_form_val($snmpopts['v3_priv_password']) ?>" class="form-control monitor rounded authPriv-enable authNoPriv-disable noAuthNoPriv-disable" placeholder="<?= _("Enter Privileged Password") ?>">
                                        <div class="invalid-feedback">
                                            Please enter the Privileged Password
                                        </div>
                                        <i id="snmpopts_v3_priv_password_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                    </div>
                                </div>
                            </div>

                            <div class="row mb-2">
                                <div class="col-sm">
                                    <label for="snmpopts[v3_priv_proto]" class="form-label form-item-required"><?= _("Privileged Protocol") ?> </label>
                                    <div class="input-group position-relative">
                                        <select name="snmpopts[v3_priv_proto]" id="snmpopts[v3_priv_proto]" class="form-select monitor rounded authPriv-enable authNoPriv-disable noAuthNoPriv-disable" placeholder="<?= _("Select Privileged Protocol") ?> ">
                                            <option value="DES" <?= is_selected($snmpopts["v3_priv_proto"], "DES") ?>>DES</option>
                                            <option value="AES" <?= is_selected($snmpopts["v3_priv_proto"], "AES") ?>>AES</option>
                                        </select>
                                        <div class="invalid-feedback">
                                            Please select Privileged Protocol
                                        </div>
                                        <i id="snmpopts_v3_priv_proto_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                    </div>
                                </div>
                            </div>
                        </div> <!-- snmpv3 -->
                    </div> <!-- Closes #pills-selectv3-tab -->

                </div> <!-- End #tabs -->
            </div> <!-- #tabs - border-block -->

            <h2 class="mt-4 mb-2"><?= _("Monitoring Options") ?></h2>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="portnames" class="form-label"><?= _("Monitoring Scheme") ?> <?= xi6_info_tooltip(_("Select the port naming scheme to use.")) ?></label>
                    <div class="input-group position-relative">
                        <select name="portnames" id="portnames" class="form-select monitor rounded" placeholder="<?= _("Select Port Naming Monitoring Scheme") ?> " required>
                            <option value="number" <?= is_selected($portnames, "number") ?>><?= _("Port's Number") ?></option>
                            <option value="name" <?= is_selected($portnames, "name") ?>><?= _("Port's Name") ?></option>
                        </select>
                        <div class="invalid-feedback">
                            Please select the Port Naming Monitoring scheme
                        </div>
                        <i id="portnames_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-sm-8">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="scaninterfaces" class="form-check-input" name="scaninterfaces"  <?= is_checked($scaninterfaces) ?>>
                        <label for="scaninterfaces" class="form-check-label bold"><?= _('Scan Interfaces') ?> <?= xi6_info_tooltip(_("Scan the WatchGuard device to auto-detect interfaces, that can be monitored for link up/down status and bandwidth usage. The scanning process may take several seconds to complete.")) ?></label>
                    </div>
                </div>
            </div>

            <h2 class="mt-4 mb-2"><?= _("Value Defaults") ?></h2>

            <div class="row">
                <div class="col-sm-8">
                    <fieldset class="row g-2 mb-1 wz-fieldset">
                        <div class="col-sm-3 mt-0 pt-1">
                            <label for="warn_speed_in_percent" class="form-label bold"><?= _('Input Rate') ?></label>
                        </div>
                        <div class="col-sm-3 mt-0">
                            <div class="input-group input-group-sm">
                                <span class="input-group-text">
                                    <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                                </span>
                                <input type="text" id="warn_speed_in_percent" name="warn_speed_in_percent" value="<?= $warn_speed_in_percent ?>" class="form-control monitor">
                                <span class="input-group-text rounded-end">%</span>
                                <i id="warn_speed_in_percent_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                        <div class="col-sm-3 mt-0">
                            <div class="input-group input-group-sm">
                                <span class="input-group-text">
                                    <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                                </span>
                                <input type="text" id="crit_speed_in_percent" name="crit_speed_in_percent" value="<?= encode_form_val($crit_speed_in_percent) ?>" class="form-control monitor">
                                <span class="input-group-text rounded-end">%</span>
                                <i id="crit_speed_in_percent_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                    </fieldset>
                </div>
            </div>

            <div class="row">
                <div class="col-sm-8">
                    <fieldset class="row g-2 mb-1 wz-fieldset">
                        <div class="col-sm-3 mt-0 pt-1">
                            <label for="warn_speed_out_percent" class="form-label bold"><?= _('Output Rate') ?></label>
                        </div>
                        <div class="col-sm-3 mt-0">
                            <div class="input-group input-group-sm position-relative">
                                <span class="input-group-text">
                                    <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                                </span>
                                <input type="text" id="warn_speed_out_percent" name="warn_speed_out_percent" value="<?= $warn_speed_out_percent ?>" class="form-control monitor">
                                <span class="input-group-text rounded-end">%</span>
                                <i id="warn_speed_out_percent_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                        <div class="col-sm-3 mt-0">
                            <div class="input-group input-group-sm position-relative">
                                <span class="input-group-text">
                                    <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                                </span>
                                <input type="text" id="crit_speed_out_percent" name="crit_speed_out_percent" value="<?= encode_form_val($crit_speed_out_percent) ?>" class="form-control monitor">
                                <span class="input-group-text rounded-end">%</span>
                                <i id="crit_speed_out_percent_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                    </fieldset>
                </div>
            </div>

            <div class="row mb-2">
                <div class="col-sm-8">
                    <fieldset class="row g-2 mb-1 wz-fieldset">
                        <div class="col-sm-3 mt-0 pt-1">
                            <label for="default_port_speed" class="form-label form-item-required"><?= _("Default Port Speed") ?></label>
                        </div>
                        <div class="col-sm-3 mt-0 pt-1">
                            <div class="input-group input-group-sm position-relative">
                                <input type="text" name="default_port_speed" id="default_port_speed" value="<?= $default_port_speed ?>" class="form-control monitor" required>                                
                                <span class="input-group-text rounded-end">%</span>
                                <div class="invalid-feedback">
                                    Please enter the Default Port Speed
                                </div>
                                <i id="default_port_speed_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                    </fieldset>
                </div>
            </div>

        </div> <!-- config -->
    </div> <!-- container -->

    <script type="text/javascript">
        $(document).ready(function() {
            // Initial check
            select_default_proto();

            // Detection
            $("[name='snmpopts[v3_security_level]']").change(function() {
                select_default_proto();
            });

            // Upon clicking the tabs, set the invisible radio selector
            // to be true, based on the tab clicked
            $("#pills-selectv1-tab").click(function() {
                $("#snmpversion").val("1");
                // $("#snmpopts\[snmpcommunity\]").attr('required', true);
                // $("#snmpopts\[v3_username\]").removeAttr('required');
                // $("#snmpopts\[v3_auth_password\]").removeAttr('required');
                // $("#snmpopts\[v3_priv_password\]").removeAttr('required');
                $('#pills-selectv2c :input').attr('required', true)
                $('#pills-selectv3 :input').removeAttr('required')
            });

            $("#pills-selectv2c-tab").click(function() {
                $("#snmpversion").val("2c");
                // $("#snmpopts\[snmpcommunity\]").attr('required', true);
                // $("#snmpopts\[v3_username\]").removeAttr('required');
                // $("#snmpopts\[v3_auth_password\]").removeAttr('required');
                // $("#snmpopts\[v3_priv_password\]").removeAttr('required');
                $('#pills-selectv2c :input').attr('required', true)
                $('#pills-selectv3 :input').removeAttr('required')
            });

            $("#pills-selectv3-tab").click(function() {                                
                $("#snmpversion").val("3");
                // $("#snmp_username").attr('required', true);
                // $("#snmpopts\[snmpcommunity\]").removeAttr('required');
                // $("#snmpopts\[v3_username\]").attr('required', true);
                // $("#snmpopts\[v3_auth_password\]").attr('required', true);
                // $("#snmpopts\[v3_priv_password\]").attr('required', true);
                $('#pills-selectv2c :input').removeAttr('required')
                $('#pills-selectv3 :input').attr('required', true)                
            });

            $("#pills-selectv<?= $snmpversion ?>").click();
            // End of above commented section

            // Disable any fields that are not required for v3's various security levels.
            function select_default_proto(level_val) {
                var level_val = $("[name='snmpopts[v3_security_level]']").val();

                if (level_val == "authNoPriv") {
                    $("[name='snmpopts[v3_auth_proto]']").val("MD5");
                    $("[name='snmpopts[v3_priv_proto]']").val("");
                    $('label[for="snmpopts\[v3_auth_password\]"]').addClass('form-item-required');
                    $('label[for="snmpopts\[v3_auth_proto\]"]').addClass('form-item-required');
                    $('label[for="snmpopts\[v3_priv_password\]"]').removeClass('form-item-required');
                    $('label[for="snmpopts\[v3_priv_proto\]"]').removeClass('form-item-required');
                } else if (level_val == "authPriv") {
                    $("[name='snmpopts[v3_auth_proto]']").val("MD5");
                    $("[name='snmpopts[v3_priv_proto]']").val("DES");
                    $('label[for="snmpopts\[v3_priv_password\]"]').addClass('form-item-required');
                    $('label[for="snmpopts\[v3_priv_proto\]"]').addClass('form-item-required');
                    $('label[for="snmpopts\[v3_auth_password\]"]').addClass('form-item-required');
                    $('label[for="snmpopts\[v3_auth_proto\]"]').addClass('form-item-required');
                } else {
                    $("[name='snmpopts[v3_auth_proto]']").val("");
                    $("[name='snmpopts[v3_priv_proto]']").val("");
                    $('label[for="snmpopts\[v3_auth_password\]"]').removeClass('form-item-required');
                    $('label[for="snmpopts\[v3_auth_proto\]"]').removeClass('form-item-required');
                    $('label[for="snmpopts\[v3_priv_password\]"]').removeClass('form-item-required');
                    $('label[for="snmpopts\[v3_priv_proto\]"]').removeClass('form-item-required');
                }
            }

            security_level = $(".security_level").val();
            enable_fields_by_security_level(security_level);
            $(".security_level").change(function () {
                enable_fields_by_security_level($(this).val());
            });
        });

        function enable_fields_by_security_level(level) {
            $("." + level + "-enable").attr("disabled", false);
            $("." + level + "-disable").attr("disabled", true);
        }
    </script>

    <script type='text/javascript' src='<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>'></script>
