<?php
//
// BBMap Dashlet
// Copyright (c) 2010-2021 Nagios Enterprises, LLC. All rights reserved.
//

include_once(dirname(__FILE__) . '/../../dashlets/dashlethelper.inc.php');


function bbmap_dashlet_func($mode = DASHLET_MODE_PREVIEW, $id = "", $args = null)
{

    $imgbase = get_base_url() . "includes/components/bbmap/images/";

    switch ($mode) {

        case DASHLET_MODE_GETCONFIGHTML:
            $LabelShowOnlyHardStates = _("Show only HARD states");
            $LabelHostgroupLimit = _("Limit by Hostgroup");
            $LabelServicegroupLimit = _("Limit by Servicegroup");

            // Option to show only hard states
            $output = '
            <div class="popup-form-box">
                <div class="input-group checkbox">
                    <label for="hardStates">
                        <input type="checkbox" id="hardStates" name="hardStates">
                        ' . $LabelShowOnlyHardStates . '
                    </label>
                </div>
            </div>
            <br class="nobr" />
            ';

            // Option to limit by Hostgroup or Servicegroup
            $output .= '
            <label>' . $LabelHostgroupLimit . '</label>
                <div class="popup-form-box">
                    <div class="input-group">
                        <select name="hostgroup" id="hostgroupList" style="width: 150px;" class="form-control">
                            <option value="">' . _("Hostgroup") . '</option>';

            $args = array("orderby" => "hostgroup_name:a");
            $oxml = get_xml_hostgroup_objects($args);
            if ($oxml) {
                foreach ($oxml->hostgroup as $hg) {
                    $name = strval($hg->hostgroup_name);
                    $output .= "<option value='" . $name . "' " . is_selected($hg, $name) . ">$name</option>\n";
                }
            }

            $output .= '</select>
                </div>
            </div>
            <label>' . $LabelServicegroupLimit . '</label>
                <div class="popup-form-box">
                    <div class="input-group">
                        <select name="servicegroup" id="servicegroupList" style="width: 150px;" class="form-control">
                            <option value="">' . _("Servicegroup") . '</option>';

            $args = array('orderby' => 'servicegroup_name:a');
            $oxml = get_xml_servicegroup_objects($args);
            if ($oxml) {
                foreach ($oxml->servicegroup as $sg) {
                    $name = strval($sg->servicegroup_name);
                    $output .= "<option value='" . $name . "' " . is_selected($sg, $name) . ">$name</option>\n";
                }
            }

            $output .= '</select>
                </div>
            </div>
        </div>';
            return $output;
            break;

        case DASHLET_MODE_OUTBOARD:
        case DASHLET_MODE_INBOARD:

            $id = "bbmap_" . random_string(6);

            // ajax updater args
            $ajaxargs = $args;

            // build args for javascript
            $n = 0;
            $jargs = "{";

            foreach ($ajaxargs as $var => $val) {
                if ($n > 0)
                    $jargs .= ", ";
                $jargs .= "\"$var\" : \"$val\"";
                $n++;
            }

            $jargs .= "}";

            $base_url = get_base_url();
?>
    <script type='text/javascript' src='<?= $base_url ?>includes/components/bbmap/js/datatables.min.js'></script>
    <link rel='stylesheet' type='text/css' href='<?= $base_url ?>includes/components/bbmap/css/datatables.min.css?' />
    <link rel='stylesheet' type='text/css' href='<?= $base_url ?>includes/components/bbmap/css/bbmap.css' />

    <div class="bbmap_dashlet dashlet-auto-overflow" id="<?= $id ?>">

        <div class="infotable_title"><?= _('Status Grid') ?></div>
            <?= get_throbber_html() ?>

    </div><!--ahost_status_summary_dashlet-->

    <script type="text/javascript">

        function get_<?= $id ?>_resize(data) {
            setTimeout(function() {
                    thWidth = 1

                    $("#<?= $id ?>").find("th").each(function() {
                        if ($(this).outerWidth() > thWidth)
                            thWidth = $(this).outerWidth();
                    });

                    thWidth = thWidth + 10

                    $("#<?= $id ?>").find("div.inner").css("margin-left", thWidth + "px");
                    $("#<?= $id ?>").find("div.outer div.inner table.infotable th").css("width", thWidth + "px");
            }, 500);
        }

        $(document).ready(function() {

            $("#<?= $id ?>").tooltip({ selector: ".tt-bind-d", placement: "right", container: "body" });
            
            get_<?= $id ?>_content();

            $("#<?= $id ?>").everyTime(30*1000, "timer-' . $id . '", function(i) {
                get_<?= $id ?>_content();
            });

            function get_<?= $id ?>_content() {
                $("#<?= $id ?>").each(function() {
                    var optsarr = {
                            "func": "get_bbmap_dashlet_html",
                            "args": <?= $jargs ?>
                        }

                    var opts=JSON.stringify(optsarr);

                    get_ajax_data_innerHTML_with_callback("getxicoreajax", opts, true, this, "get_<?= $id ?>_resize");
                });
            }
        });
                    
    </script>
<?php
            break;

        case DASHLET_MODE_PREVIEW:
?>
            <?php
             if(!is_neptune()) { ?>
                <p><img src='<?= $imgbase ?>preview.png'></p>
            <?php } else if(get_theme() == 'neptunelight') { ?>
                <img src='<?= $imgbase ?>bbmap_neptune_light_preview.png'>
            <?php } else { ?>
                <img src='<?= $imgbase ?>neptune_preview.png'>
            <?php }
            break;
    }

    return;
}

?>