    <!--                                   -->
    <!-- The initial data set from Step 1. -->
    <!--                                   -->
    <input type="hidden" id="hostname" name="hostname" value="<?= encode_form_val($hostname) ?>">
    <input type="hidden" id="operation" name="operation" value="<?= encode_form_val($operation) ?>">
    <input type="hidden" id="selectedhostconfig" name="selectedhostconfig" value="<?= encode_form_val($selectedhostconfig) ?>">
    <input type="hidden" id="services_serial" name="services_serial" value="<?= (!empty($services)) ? base64_encode(json_encode($services)) : "" ?>" />
    <input type="hidden" id="serviceargs_serial" name="serviceargs_serial" value="<?= (!empty($serviceargs)) ? base64_encode(json_encode($serviceargs)) : "" ?>" />
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />

    <input type="hidden" name="ip_address" value="<?= encode_form_val($ip_address) ?>">
    <input type="hidden" name="port" value="<?= encode_form_val($port) ?>">
    <input type="hidden" name="token" value="<?= encode_form_val($token) ?>">
    <input type="hidden" name="no_ssl_verify" value="<?= intval($no_ssl_verify) ?>">
    <input type="hidden" name="os" value="<?= encode_form_val($os) ?>">
    <input type="hidden" name="job_id" value="<?= intval($job_id) ?>">

<?php
    if (!empty($hosts)) {
        foreach ($hosts as $host) {
?>
    <input type="hidden" name="hosts[]" value="<?= encode_form_val($host) ?>">
<?php
        }
    }

    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';
?>
    <div class="container m-0 g-0">
<?php
    # TODO: Test multi-host
    if (!empty($hosts)) {
?>
        <!--                            -->
        <!-- Multiple Hosts Information -->
        <!--                            -->
        <h2><?= _("Host Information") ?></h2>
        <p><?= _('Adding the following service checks to the below hosts') ?></p>

        <div class="row mb-3 mt-4">
            <div class="col-sm">
                <label class="form-check-label bold"><?= _('Hostname') ?></label>
            </div>
        </div>
        <div class="row mb-2">
            <div class="col-sm-6">
<?php
        foreach ($hosts as $host) {
?>
                <?= encode_form_val($host) ?><br>
<?php
        }
?>
            </div>
        </div>
<?php
    } else {
?>
        <!--                            -->
        <!-- Host Information           -->
        <!--                            -->
        <h2 class="mt-4 mb-2"><?= _("Host Information") ?></h2>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="ip_address" class="form-label"><?= _("Address") ?> </label>
                <div class="input-group position-relative">
                    <input type="text" name="ip_address" id="ip_address" value="<?= encode_form_val($ip_address) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Address") ?>" disabled="on">
                    <i id="_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="hostname" class="form-label"><?= _("Host Name") ?> <?= xi6_info_tooltip(_("The hostname you'd like to have associated with this NCPA Agent")) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="hostname" id="hostname" value="<?= encode_form_val($hostname) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Host Name") ?>" >
                    <i id="hostname_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="" class="form-label"><?= _("Port") ?> </label>
                <div class="input-group position-relative">
                    <input type="text" name="" id="" value="<?= encode_form_val($port) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Port") ?>" disabled="on">
                    <i id="_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>
        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="" class="form-label"><?= _("System") ?> </label>
                <div><?= $icon ?></div>
            </div>
        </div>
<?php
    }
?>
        <!--                         -->
        <!-- The metrics to monitor. -->
        <!--                         -->

        <!--                            -->
        <!-- System Metrics             -->
        <!--                            -->
        <h2 class="mt-4"><?= _("System Metrics") ?></h2>
        <p><?= _("Specify the metrics you'd like to monitor with the NCPA Agent") ?>.</p>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="cpum" class="form-check-input" name="services[cpu_usage][monitor]"  <?= is_checked(grab_array_var($services['cpu_usage'], "monitor"), "on") ?> >
                        <label for="cpum" class="form-check-label bold"><?= _('CPU Usage') ?> <?= xi6_info_tooltip(_('Check the CPU usage of the system')) ?></label>
                    </div>
                    <div class="col-sm-9 mt-0">
                        <div class="row g-0 p-0">
                            <div class="col-sm-4 mt-0 pe-1">
                                <div class="input-group input-group-sm">
                                    <span class="input-group-text">
                                        <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400">warning</i>
                                    </span>
                                    <input type="text" id="services[cpu_usage][warning]" name="services[cpu_usage][warning]" value="<?= encode_form_val($services['cpu_usage']['warning']) ?>" class="form-control form-control-sm monitor">
                                    <span class="input-group-text rounded-end">%</span>
                                    <i id="services_cpu_usage_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                </div>
                            </div>
                            <div class="col-sm-4 mt-0 pe-1">
                                <div class="input-group input-group-sm">
                                    <span class="input-group-text">
                                        <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i>
                                    </span>
                                    <input type="text" id="services[cpu_usage][critical]" name="services[cpu_usage][critical]" value="<?= encode_form_val($services['cpu_usage']['critical']) ?>" class="form-control form-control-sm monitor">
                                    <span class="input-group-text rounded-end">%</span>
                                    <i id="services_cpu_usage_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                </div>
                            </div>
<?php
    if (!empty($cpu_data)) {
?>
                            <div class="col-sm-4 mt-0 ps-2">
                                <div class="input-group input-group-sm">
                                    <span class="input-group-text form-check-label bold"><?= _('CPU') ?></span>
                                    <input type="text" id="currentCPU" value="<?= floatval($cpu_data[0][0]) ?>" class="form-control form-control-sm">
                                    <span class="input-group-text rounded-end">%</span>
                                    <label for="currentCPU" class="form-check-label bold mt-1 ps-1"><?= xi6_info_tooltip(_('Current CPU Usage')) ?></label>
                                </div>
                            </div>
<?php
    }
?>
                        </div>
                        <div class="row g-0 p-0">
                            <div class="col-sm-12 mt-2 pe-1">
                                <input type="checkbox" class="form-check-input" name="services[cpu_usage][average]" id="services[cpu_usage][average]" <?= is_checked($services['cpu_usage']['average'], 1) ?>>
                                <label for="services[cpu_usage][average]" class="form-check-label bold"><?= _('Show average CPU usage instead of per cpu core') ?></label>
                            </div>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" class="form-check-input" name="services[users][monitor]" id="ucount" <?= is_checked(grab_array_var($services['users'], "monitor"), "on") ?>>
                        <label for="ucount" class="form-check-label bold"><?= _('User Count') ?> <?= xi6_info_tooltip(_('Check the number of users currently logged into the system.')) ?></label>
                    </div>
                    <div class="col-sm-9 mt-0">
                        <div class="row g-0 p-0">
                            <div class="col-md-4 mt-0 pe-1">
                                <div class="input-group input-group-sm">
                                    <span class="input-group-text">
                                        <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400">warning</i>
                                    </span>
                                    <input type="text" id="services[users][warning]" name="services[users][warning]" value="<?= encode_form_val($services['users']['warning']) ?>" class="form-control form-control-sm monitor">
                                    <i id="services_users_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                </div>
                            </div>
                            <div class="col-sm-4 mt-0 pe-1">
                                <div class="input-group input-group-sm">
                                    <span class="input-group-text">
                                        <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i>
                                    </span>
                                    <input type="text" id="services[users][critical]" name="services[users][critical]" value="<?= encode_form_val($services['users']['critical']) ?>" class="form-control form-control-sm monitor">
                                    <i id="services_users_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                </div>
                            </div>
<?php
    if (!empty($user_data)) {
?>
                            <div class="col-sm-4 mt-0 ps-2">
                                <div class="input-group input-group-sm">
                                    <span class="input-group-text"><i class="material-symbols-outlined md-18 md-400" aria-hidden="true">groups</i></span>
                                    <input type="text" id="currentUsers" value="<?= $user_data[0] ?>" class="form-control form-control-sm">
                                    <label for="currentUsers" class="form-check-label bold mt-1 ps-1"><?= xi6_info_tooltip(_('Current User Count')) ?></label>
                                </div>
                            </div>
<?php
    }
?>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <!--                            -->
        <!-- Memory Metrics             -->
        <!--                            -->
        <h2 class="mt-4 mb-2"><?= _('Memory Metrics') ?></h2>

        <div class="row mb-2">
            <div class="col-sm-8">
                <fieldset class="row g-2 mt-0 mb-1 wz-fieldset">
                    <div class="form-check col-sm-9 mt-0 pt-0 ps-0">
                        <label for="default_mem_units" class="form-check-label bold select-cf-option"><?= _('Default units for memory metric ouput') ?></label>
                        <div class="input-group position-relative col-sm-8">
                            <select class="form-select form-select-sm form-control-sm monitor rounded" id="default_mem_units" name="default_mem_units">
                                <option value="b" <?= is_selected($default_mem_units, 'b') ?>>b</option>
                                <option value="B" <?= is_selected($default_mem_units, 'B') ?>>B</option>
                                <option value="k" <?= is_selected($default_mem_units, 'k') ?>>k</option>
                                <option value="Ki" <?= is_selected($default_mem_units, 'Ki') ?>>Ki</option>
                                <option value="G" <?= is_selected($default_mem_units, 'G') ?>>G</option>
                                <option value="Gi" <?= is_selected($default_mem_units, 'Gi') ?>>Gi</option>
                                <option value="T" <?= is_selected($default_mem_units, 'T') ?>>T</option>
                                <option value="Ti" <?= is_selected($default_mem_units, 'Ti') ?>>Ti</option>
                            </select>
                            <div class="invalid-feedback">
                                Please select the default units of measure.
                            </div>
                            <i id="default_mem_units_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="mainm" class="form-check-input" name="services[memory_usage][monitor]"  <?= is_checked(grab_array_var($services['memory_usage'], 'monitor'), 'on') ?> >
                        <label for="mainm" class="form-check-label bold"><?= _('Memory Usage') ?> <?= xi6_info_tooltip(_("Monitor memory usage as percentage of memory used")) ?></label>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400">warning</i>
                            </span>
                            <input type="text" id="services[memory_usage][warning]" name="services[memory_usage][warning]" value="<?= encode_form_val($services['memory_usage']['warning']) ?>" class="form-control form-control-sm monitor">
                            <span class="input-group-text">%</span>
                            <i id="services_memory_usage_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i>
                            </span>
                            <input type="text" id="services[memory_usage][critical]" name="services[memory_usage][critical]" value="<?= encode_form_val($services['memory_usage']['critical']) ?>" class="form-control form-control-sm monitor">
                            <span class="input-group-text">%</span>
                            <i id="services_memory_usage_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
<?php
    if (!empty($mem_data)) {
?>
                    <div class="col-sm-3 mt-0 ps-2">
                        <div class="input-group input-group-sm">
                            <input type="text" id="currentMem" value="<?= floatval($mem_data[0]) ?>" class="form-control form-control-sm">
                            <span class="input-group-text rounded-end">%</span>
                            <label for="currentMem" class="form-check-label bold mt-1 ps-1"><?= xi6_info_tooltip(_('Current Memory Usage')) ?></label>
                        </div>
                    </div>
<?php
    }
?>              </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="swapm" class="form-check-input" name="services[swap_usage][monitor]"  <?= is_checked(grab_array_var($services['swap_usage'], 'monitor'), 'on') ?>>
                        <label for="swapm" class="form-check-label bold"><?= _('Swap Usage') ?> <?= xi6_info_tooltip(_("Monitor the percentage of allocated swap used.")) ?></label>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400">warning</i>
                            </span>
                            <input type="text" id="services[swap_usage][warning]" name="services[swap_usage][warning]" value="<?= encode_form_val($services['swap_usage']['warning']) ?>" class="form-control form-control-sm monitor">
                            <span class="input-group-text">%</span>
                            <i id="services_swap_usage_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i>
                            </span>
                            <input type="text" id="services[swap_usage][critical]" name="services[swap_usage][critical]" value="<?= encode_form_val($services['swap_usage']['critical']) ?>" class="form-control form-control-sm monitor">
                            <span class="input-group-text">%</span>
                            <i id="services_swap_usage_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
<?php
    if (!empty($swap_data)) {
?>
                    <div class="col-sm-3 mt-0 ps-2">
                        <div class="input-group input-group-sm">
                            <input type="text" id="currentSwap" value="<?= floatval($swap_data[0]) ?>" class="form-control form-control-sm">
                            <span class="input-group-text rounded-end">%</span>
                            <label for="currentSwap" class="form-check-label bold mt-1 ps-1"><?= xi6_info_tooltip(_('Current Swap Usage')) ?></label>
                        </div>
                    </div>
<?php
    }
?>
                </fieldset>
            </div>
        </div>

        <!--                            -->
        <!-- Disk Metrics               -->
        <!--                            -->
        <h2 class="mt-4"><?= _("Disk Metrics") ?></h2>
        <p><?= _("Specify the disks the the warning and critical percentages for disk capacity") ?>.</p>

<?php
    if (!empty($hosts)) {
?>
    <p><b><?= _('Disk checks specified will be applied to all hosts. If the disk name does not exist it will show CRITICAL') ?></b></p>

<?php
    }
?>
        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2">
                    <div class="col-sm-6 mt-0">
                        <label class="form-label bold mb-3 ms-3 ps-1"><?= _('Disk/Mount') ?></label>
                    </div>
<?php
    if (empty($hosts)) {
?>
                    <div class="col-sm-2 mt-0">
                        <label class="form-label bold mb-3 ps-1"><?= _('Current Usage') ?></label>
                    </div>
<?php
    }
?>
                    <div class="col-sm-2 mt-0">
                        <label class="form-label bold mb-3 ps-1"><?= _('Thresholds') ?></label>
                    </div>
                    <div class="col-sm-2 mt-0"></div>
                </fieldset>
            </div>
        </div>
<?php
    $disabled = ' readonly';

    if (!empty($hosts)) {
        $disabled = '';
    }

    $id = 0;

    foreach ($services['disk'] as $id => $metrics) {
        $title = !empty($metrics['title']) ? $metrics['title'] : $metrics['name'];
        $titleout = str_replace('|', '\\', $title);

        if (isset($root['disk']['logical']) && is_array($root['disk']['logical']) && $title !== null && array_key_exists($title, $root['disk']['logical'])) {
            $disk_total = $root['disk']['logical'][$title]['total'][0].' '.$root['disk']['logical'][$title]['total'][1].' '._('Total');
        }
?>
        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-6 mt-0 pt-0">
                        <div class="input-group input-group-sm">
                            <input type="checkbox" id="d<?= $id ?>" class="form-check-input mt-2 me-2" name="services[disk][<?= $id ?>][monitor]" <?= is_checked(grab_array_var($services['disk'][$id], 'monitor'), 'on') ?>>
                            <input type="hidden" name="services[disk][<?= $id ?>][title]" value="<?= encode_form_val($title) ?>">
                            <input type="text" class="form-control form-control-sm ps-1 rounded" name="services[disk][<?= $id ?>][name]" id="services[disk][<?= $id ?>][name]" value="<?= encode_form_val($titleout) ?>" <?= $disabled ?>>
                            <input type="hidden" name="services[disk][<?= $id ?>][name]" value="<?= encode_form_val($titleout) ?>">
                        </div>
                    </div>
<?php
        if (isset($root['disk']['logical']) && is_array($root['disk']['logical']) && $title !== null && array_key_exists($title, $root['disk']['logical'])) 
{
?>
                    <div class="col-sm-2 mt-0">
                        <div class="input-group input-group-sm">
                            <input type="text" name="services[disk][<?= $id ?>][warning]" id="services[disk][<?= $id ?>][warning]" value="<?= floatval($root['disk']['logical'][$title]['used_percent'][0]) ?>" class="form-control form-control-sm monitor" readonly>
                            <span class="input-group-text rounded-end">%</span>
                            <span class="me-2 mt-1 ps-1"><?= xi6_info_tooltip(encode_form_val($disk_total)) ?></span>
                            <i id="services_disk_<?= $id ?>_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
<?php
        }
?>
                    <div class="col-sm-2 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400">warning</i>
                            </span>
                            <input type="text" name="services[disk][<?= $id ?>][warning]" id="services[disk][<?= $id ?>][warning]" value="<?= encode_form_val($services['disk'][$id]['warning']) ?>" class="form-control form-control-sm monitor">
                            <span class="input-group-text rounded-end">%</span>
                            <i id="services_disk_<?= $id ?>_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-2 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i>
                            </span>
                            <input type="text" name="services[disk][<?= $id ?>][critical]" id="services[disk][<?= $id ?>][critical]" value="<?= encode_form_val($services['disk'][$id]['critical']) ?>" class="form-control form-control-sm monitor">
                            <span class="input-group-text rounded-end">%</span>
                            <i id="services_disk_<?= $id ?>_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>
<?php
        $id++;
    }
?>

<?php
    if (!empty($hosts)) {
?>
        <p><a id="add-disk"><?= _("Add Disk Check") ?></a></p>
<?php
    }
?>
        <!--                            -->
        <!-- Network Interface Metrics  -->
        <!--                            -->
        <h2 class="mt-4"><?= _('Network Interface Metrics') ?></h2>
        <p><?= _("Specify bandwidth limits for your network interfaces. Note that these measurements are per second, not a counter.") ?></p>
<?php
    if (!empty($hosts)) {
?>
        <p><b><?= _('Interface checks specified will be applied to all hosts. If the interface name does not exist it will show CRITICAL') ?></b></p>
<?php
    }
?>
        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2">
                    <div class="col-sm-3 mt-0">
                        <label class="form-label bold mb-3 ms-3 ps-1"><?= _('Interface Name') ?></label>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <label class="form-label bold mb-3 ms-3 ps-1"><?= _('Thresholds') ?></label>
                    </div>
                </fieldset>
            </div>
        </div>

        <div id="interfaces-list">
<?php
    $disabled = ' readonly';

    if (!empty($hosts)) {
        $disabled = '';
    }

    $id = 0;
    $hidden = false;

    foreach ($services['interface'] as $id => $metrics) {
        $hide = '';
        $title = $metrics['name'];

        if (!is_checked(grab_array_var($services['interface'][$id], 'monitor'), 'on') && empty($hosts)) {
            $hide = 'hidden-interface visually-hidden';
        }
?>
            <div class="row interface <?= $hide ?>">
                <div class="col-sm-8">
                    <fieldset class="row g-2 mb-1 wz-fieldset">
                        <div class="form-check col-sm-3 mt-0 pt-0">
                            <div class="input-group input-group-sm">
                                <input type="checkbox" id="ni<?= $id ?>" class="form-check-input mt-2 me-2" name="services[interface][<?= $id ?>][monitor]" <?= is_checked(grab_array_var($services['interface'][$id], 'monitor'), 'on') ?>>
                                <input type="text" class="form-control form-control-sm ps-1 rounded" name="services[interface][<?= $id ?>][name]" id="services[interface][<?= $id ?>][name]" value="<?= encode_form_val(str_replace("|", "/", $title)) ?>"<?= $disabled ?>>
                            </div>
                        </div>
                        <div class="col-sm-3 mt-0">
                            <div class="input-group input-group-sm">
                                <span class="input-group-text">
                                    <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400">warning</i>
                                </span>
                                <input type="text" name="services[interface][<?= $id ?>][warning]" id="services[interface][<?= $id ?>][warning]" value="<?= encode_form_val($services['interface'][$id]['warning']) ?>" class="form-control form-control-sm monitor">
                                <span class="input-group-text rounded-end">MB/s</span>
                                <i id="services_interface_<?= $id ?>_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                        <div class="col-sm-3 mt-0">
                            <div class="input-group input-group-sm">
                                <span class="input-group-text">
                                    <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i>
                                </span>
                                <input type="text" name="services[interface][<?= $id ?>][critical]" id="services[interface][<?= $id ?>][critical]" value="<?= encode_form_val($services['interface'][$id]['critical']) ?>" class="form-control form-control-sm monitor">
                                <span class="input-group-text rounded-end">MB/s</span>
                                <i id="services_interface_<?= $id ?>_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                    </fieldset>
                </div>
            </div>
<?php
        $id++;
    }
?>
        </div> <!-- interfaces-list -->

<?php
    if (empty($hosts)) {
?>
        <p><a class="btn btn-link show-hidden-interfaces"><?= _("Show all interfaces") ?></a></p>
<?php
    } else {
?>
        <p><a id="add-interface"><?= _("Add Interface Check") ?></a></p>
<?php
    }

/*    *    *    *    *    *    *    *    *    *    *    *    *    *      *    *    *    *
                                     0000    22222      00     00
                                    0    0   22   22    00     00
                                     0       22   22     00   00
                                      0      22222       00   00
                                        0    22   22      00 00
                                    0    0   22   22       000
                                     0000    22    22       0
*    *    *    *    *    *    *    *    *    *    *    *    *    *      *    *    *    */


?>
        <!--                            -->
        <!-- Services                   -->
        <!--                            -->

<script type="text/javascript">
    $(document).ready(function() {
        // Set up undo buffers by "category" (thing m_select is managing)
        m_select_cats = ["services", "processes", "plugins"];
        m_select_states = {};

        // Set up handlers and current state for multi-selects
        $.each(m_select_cats, function(i, category) {
            m_select_states[category] = [];

            $("#"+category+"-select").on("change", function($this) {
                manageMultiSelectForTable(category);
            });

            $("#"+category+"-undo").on("click", function($this) {
                multiSelectUndo(category);
            });

            // Set initial state for m selects
            manageMultiSelectForTable(category);
            $("#"+category+"-undo").prop( "disabled", true );

            // $("#"+category+"-list").show();
        });

        $(".multiselect").on("mouseenter", function($this) {
            $(this).trigger("focus");
        });

        $(".multi-select-remove").on("click", function($this) {
            // Figure out which was clicked
            fullName = $(this).attr("value");
            elem = "." + fullName;
            category = fullName.split('-')[0];
            name = fullName.replace(category+ '-', '')

            // Update multi select
            optn = $('#' + category + '-select option[value="'+ name +'"]');
            optn.prop('selected', false);
            // console.log("multi-select-remove: ", category, fullName, elem, name, optn)

            // Update table
            manageMultiSelectForTable(category);
        });

        function manageMultiSelectForTable(category) {
            container = "#"+category+"-list";
            select = "#"+category+"-select";
            selVal =  $(select).val();

            // Add new state to undo buffer
            m_select_states[category].push(selVal);
            $("#"+category+"-undo").prop( "disabled", false );
            // console.log("manageMultiSelectForTable: ", category, container, select, selVal)
            // console.log("manageMultiSelectForTable " + category + " buffer: ", m_select_states[category])

            // Clear multi select and table
            $(container +" .service-item").prop( "checked", false );
            $(container +" .service-item").closest(".row").hide();

            // Apply updated settings
            $.each(selVal, function(i, val) {
                elem = "." + category + "-" + val;
                $(elem).prop( "checked", true );
                $(elem).closest(".row").show();
            });
        }

        function multiSelectUndo(category) {
            container = "#"+category+"-list";
            select = "#"+category+"-select";

            // Ignore current state
            m_select_states[category].pop();

            // Get previous state and apply
            selVal = m_select_states[category].pop();
            $(select).val(selVal);
            manageMultiSelectForTable(category);
            $(select).trigger("focus");

            // Disable undo button if appropriate
            if (m_select_states[category].length <= 1 ) {
                // m_select_states[category] = [];
                $("#"+category+"-undo").prop( "disabled", true );
            }
        }

        function removeClonedRow() {
            $(this).closest('.row').remove();
        }

        // Removes the current dynamically added row.
        $(document).on('click', '.remove-cloned-row', removeClonedRow);

        // Adds a new row to a parent row when the "clone-row" button is clicked,
        // while also updating the buttons for row cloning and removal.
        $(document).on("click", ".clone-row", function() {
            parentRow = $(this).closest('.row');
            row = parentRow.clone();
            nextI = $('[name^="services[plugins]"][name$="[desc]"]').length;
            row.find('[name^="services[plugins]"]').each(function() {
                name = $(this).attr('name');
                $(this).attr('name', name.replace(/\[(\d+)\]/, '[' + nextI + ']'));
                $(this).attr('id', name.replace(/\[(\d+)\]/, '[' + nextI + ']'));
            });
            row.find('[name^="services[plugins]"][name$="[desc]"]').each(function(index) {
                currentValue = $(this).val();
                $(this).val(currentValue + ' (' + _('copy') + ')');
            });
            row.find('.multi-select-remove').removeClass('multi-select-remove').addClass('remove-cloned-row');
            parentRow.after(row);
        });        

    });
</script>

<?php
    if ($wizard_name != 'macosx') {
?>
        <h2 class="mt-4"><?= _("Services") ?></h2>
        <p><?= _("Specify which services should be running or stopped.") ?> <?= xi6_info_tooltip(_("Depending on the selected state, you will recieve an OK when the process is in the selected state and a CRITICAL if the process is not in the state selected.")) ?></p>

        <div class="row">
            <div class="col-sm-3">
                <div class="multi-select-label"><?= _('Make your Service Selections')?><?= xi6_info_tooltip(_("Click with shift or CRTL/CMD key to adjust your selection.")) ?></div>
                <?= $service_select_html ?>
                <div class="select-undo-wrap">
                    <button type="button" id="services-undo" <?= xi6_title_tooltip(_('Undo')) ?> class="select-undo"><i class="material-symbols-outlined md-button md-20 md-400">undo</i></button>
                </div>
            </div>
            <div class="col-sm-9">
                <div class="row">
                    <div class="col-sm-9">
                        <div class="multi-select-label"><?= _('Selected Services')?></div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-12">
                        <fieldset class="row g-2">
                            <div class="col-sm-3 mt-0">
                                <label class="form-label bold mb-3 ms-3 ps-1"><?= _('Service Description') ?></label>
                            </div>
                            <div class="col-sm-3 mt-0">
                                <label class="form-label bold mb-3 ms-3 ps-1"><?= _('Service Name') ?></label>
                            </div>
                            <div class="col-sm-4 mt-0 ps-4">
                                <label class="form-label bold mb-3 ms-3 ps-1"><?= _('Expected Status') ?></label>
                            </div>
                        </fieldset>
                    </div>
                </div>

        <div id="services-list" class="select-table-wrap">
<?php
        $i = 0;

        foreach ($services_array as $name => $status) {
            if (isset($services_by_name[$name])) {
                $monitor = (array_key_exists('monitor', $services_by_name[$name]) ? $services_by_name[$name]['monitor'] : 'off');
                $desc = $services_by_name[$name]['desc'];
                $status = $services_by_name[$name]['state'];
            } else {
                $monitor = 'off';
                $desc = $name;
            }

            $safe_name = clean_str_for_dom($name);
?>
            <div class="row">
                <div class="col-sm-12">
                    <fieldset class="row g-2 mb-1 wz-fieldset">
                        <div class="form-check col-sm-3 mt-0 pt-0">
                            <div class="input-group input-group-sm">
                                <input type="checkbox" name="services[services][<?= $i ?>][monitor]" id="services[services][<?= $i ?>][monitor]" class="form-check-input mt-2 me-2 service-item services-<?= $safe_name ?>" <?= is_checked($monitor, 'on') ?>>
                                <input type="text" class="form-control form-control-sm ps-1" name="services[services][<?= $i ?>][desc]" id="services[services][<?= $i ?>][desc]" value="<?= $desc ?>">
                            </div>
                        </div>
                        <div class="form-check col-sm-3 mt-0 pt-0">
                            <div class="input-group input-group-sm">
                                <input type="text" class="form-control form-control-sm ps-1" name="services[services][<?= $i ?>][name]" id="services[services][<?= $i ?>][name]" value="<?= $name ?>" >
                            </div>
                        </div>
                        <div class="form-check col-sm-auto ms-3 mt-0 d-flex align-items-center gap-2 service-status">
                            <input type="radio" value="running" name="services[services][<?= $i ?>][state]" id="services[services][<?= $i ?>][state]" class="form-check-input" <?= is_checked($status, 'running') ?>>
                            <label class="form-check-label"> <?= _("Running") ?></label>
                        </div>
                        <div class="form-check col-sm-auto ms-3 mt-0 d-flex align-items-center gap-2 service-status">
                            <input type="radio" value="stopped" name="services[services][<?= $i ?>][state]" id="services[services][<?= $i ?>][state]" class="form-check-input" <?= is_checked($status, 'stopped') ?>>
                            <label class="form-check-label"> <?= _("Stopped") ?></label>
                        </div>
                        <div class="col-sm-1 mt-0 d-flex align-items-center">
                            <div class="input-group input-group-sm">
                            <?php if (!is_neptune()) { ?>
                                <button type="button" <?= xi6_title_tooltip(_('Delete')) ?> class="multi-select-remove transparent-button material-symbols-outlined md-24" value="services-<?= $safe_name ?>" aria-label="Remove">close</button>
                            <?php } else { ?>
                                <button type="button" <?= xi6_title_tooltip(_('Delete')) ?> class="multi-select-remove transparent-button material-symbols-outlined md-action md-button md-24" style="border-radius: 5px;" value="services-<?= $safe_name ?>" aria-label="Remove">close</button>
                            <?php } ?>
                            </div>
                        </div>
                    </fieldset>
                </div>
            </div>
<?php
            $i++;
        }
?>
            </div>
        </div>
        </div> <!-- services-list -->
<?php
    }
?>
        <!--                            -->
        <!-- Processes                  -->
        <!--                            -->
        <h2 class="mt-4"><?= _('Processes') ?></h2>
        <p><?= _("Specify which processes should be running and how many of them there should be.") ?></p>

        <div class="row">
            <div class="col-sm-3">
                <div class="multi-select-label"><?= _('Make your Process Selections')?><?= xi6_info_tooltip(_("Click with shift or CRTL/CMD key to adjust your selection.")) ?></div>
                <?= $process_select_html ?>
                <div class="select-undo-wrap">
                    <button type="button" id="processes-undo" <?= xi6_title_tooltip(_('Undo')) ?> class="select-undo"><i class="material-symbols-outlined md-button md-20 md-400">undo</i></button>
                </div>
            </div>
            <div class="col-sm-9">
                <div class="row">
                    <div class="col-sm-9">
                        <div class="multi-select-label"><?= _('Selected Processes')?></div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-12">
                        <fieldset class="row g-2">
                            <div class="col-sm-3">
                                <label class="form-label bold mb-3 ms-3 ps-1"><?= _('Service Description') ?></label>
                            </div>
                            <div class="col-sm-3">
                                <label class="form-label bold mb-3 ms-3 ps-1"><?= _('Process Name') ?></label>
                            </div>
                            <div class="col-sm-4">
                                <label class="form-label bold mb-3 ms-3 ps-1"><?= _('Thresholds (Process count)') ?> <?= xi6_info_tooltip(_('If a value should be warning or critical when it is 0, you can use the threshold 1: which will trigger a warning or critical when the value is outside 1 to ∞')) ?></label>
                            </div>
                        </fieldset>
                    </div>
                </div>

        <div id="processes-list" class="select-table-wrap">
<?php
    $i = 0;
    foreach ($processes_array as $name => $amount) {
        if (isset($processes_by_name[$name])) {
            $monitor = (array_key_exists('monitor', $processes_by_name[$name]) ? $processes_by_name[$name]['monitor'] : 'off');
            $desc = $processes_by_name[$name]['desc'];
            $warning = $processes_by_name[$name]['warning'];
            $critical = $processes_by_name[$name]['critical'];
        } else {
            $monitor = 'off';
            $desc = $name;
            $warning = '';
            $critical = '';
        }

        $safe_name = clean_str_for_dom($name);
?>
            <div class="row">
                <div class="col-sm-12">
                    <fieldset class="row g-2 mb-1 wz-fieldset">
                        <div class="form-check col-sm-3 mt-0 pt-0">
                            <div class="input-group input-group-sm">
                                <input type="checkbox" class="form-check-input mt-2 me-2 service-item processes-<?= $safe_name ?>" name="services[processes][<?= $i ?>][monitor]" id="services[processes][<?= $i ?>][monitor]" <?= is_checked($monitor, 'on') ?>>
                                <input type="text" class="form-control form-control-sm rounded-end ps-1" name="services[processes][<?= $i ?>][desc]" id="services[processes][<?= $i ?>][desc]" value="<?= $desc ?>">
                                <i id="services_process_<?= $i ?>_desc_Alert-cust-sm" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                        <div class="col-sm-3 mt-0">
                            <div class="input-group input-group-sm">
                                <input type="text" class="form-control form-control-sm monitor" name="services[processes][<?= $i ?>][name]" id="services[processes][<?= $i ?>][name]" value="<?= $name ?>" >
                                <i id="services_process_<?= $i ?>_display_name_Alert-cust-sm" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                        <div class="col-sm-2 mt-0">
                            <div class="input-group input-group-sm">
                                <span class="input-group-text">
                                    <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400">warning</i>
                                </span>
                                <input type="text" class="form-control form-control-sm rounded-end monitor" name="services[processes][<?= $i ?>][warning]" id="services[processes][<?= $i ?>][warning]" value="<?= encode_form_val($warning) ?>">
                                <i id="services_process_<?= $i ?>_warning_Alert-cust-sm" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                        <div class="col-sm-2 mt-0">
                            <div class="input-group input-group-sm">
                                <span class="input-group-text">
                                    <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i>
                                </span>
                                <input type="text" class="form-control form-control-sm rounded-end monitor" name="services[processes][<?= $i ?>][critical]" id="services[processes][<?= $i ?>][critical]" value="<?= encode_form_val($critical) ?>">
                                <i id="services_process_<?= $i ?>_critical_Alert-cust-sm" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                        <div class="col-sm-1 mt-0 d-flex align-items-center">
                            <div class="input-group input-group-sm">
                            <?php if (!is_neptune()) { ?>
                                <button type="button" <?= xi6_title_tooltip(_('Delete')) ?> class="multi-select-remove transparent-button material-symbols-outlined md-24" value="processes-<?= $safe_name ?>" aria-label="Remove">close</button>
                            <?php } else { ?>
                                <button type="button" <?= xi6_title_tooltip(_('Delete')) ?> class="multi-select-remove transparent-button material-symbols-outlined md-action md-button md-24" style="border-radius: 5px;" value="processes-<?= $safe_name ?>" aria-label="Remove">close</button>
                            <?php } ?>
                            </div>
                        </div>
                    </fieldset>
                    </div>
                </div>
<?php
        $i++;
    }
?>
            </div>
        </div>
        </div> <!-- processes-list -->


<?php
    if ($os == "windows") {
?>
        <!--                            -->
        <!-- Windows Counters           -->
        <!--                            -->
        <h2 class="mt-4"><?= _('Windows Counters') ?></h2>
        <p><?= _("Specify any windows counters you would like NCPA to check the value of. Per second counters require a sleep time.") ?></p>

        <div class="row">
            <div class="col-sm-12">
                <fieldset class="row g-2">
                    <div class="col-sm-3">
                        <label class="form-label bold mb-3 ms-3 ps-1"><?= _('Service Description') ?></label>
                    </div>
                    <div class="col-sm-4">
                        <label class="form-label bold mb-3 ms-3 ps-1"><?= _('Counter Name') ?> <?= xi6_info_tooltip(_('This value can be any Windows performance counter. To view available counters run in cmd.exe')) ?></label>
                    </div>
                    <div class="col-sm-1">
                        <label class="form-label bold mb-3 ms-3 ps-1"><?= _('Sleep') ?> <?= xi6_info_tooltip(_('If the counter is per second (/sec in name) then you must put a sleep value to see data. Sleep value is in seconds. Most counters are fine with 1-5 seconds')) ?></label>
                    </div>
                    <div class="col-sm-4">
                        <label class="form-label bold mb-3 ms-3 ps-1"><?= _('Thresholds') ?></label>
                    </div>
                </fieldset>
            </div>
        </div>

        <div id="counter-list">
<?php
        foreach ($services['counters'] as $i => $metrics) {
?>
            <div class="row">
                <div class="col-sm-12">
                    <fieldset class="row g-2 mb-1 wz-fieldset">
                        <div class="form-check col-sm-3 mt-0 pt-0">
                            <div class="input-group input-group-sm">
                                <input type="checkbox" class="form-check-input mt-2 me-2" name="services[counters][<?= $i ?>][monitor]" id="services[counters][<?= $i ?>][monitor]" <?= is_checked($metrics['monitor'], 'on') ?>>
                                <input type="text" class="form-control form-control-sm rounded ps-1" name="services[counters][<?= $i ?>][desc]" id="services[counters][<?= $i ?>][desc]" value="<?= encode_form_val($metrics['desc']) ?>">
                                <i id="services_counters_<?= $i ?>_name_Alert-cust-sm" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                        <div class="col-sm-4 mt-0">
                            <div class="input-group input-group-sm">
                                <input type="text" class="form-control form-control-sm rounded monitor" name="services[counters][<?= $i ?>][name]" id="services[counters][<?= $i ?>][name]" value="<?= encode_form_val($metrics['name']) ?>">
                                <i id="services_counters_<?= $i ?>_name_Alert-cust-sm" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                        <div class="col-sm-1 mt-0">
                            <div class="input-group input-group-sm">
                                <input type="text" class="form-control form-control-sm rounded-end monitor" name="services[counters][<?= $i ?>][sleep]" id="services[counters][<?= $i ?>][sleep]" value="<?= encode_form_val($metrics['sleep']) ?>">
                                <i id="services_counters_<?= $i ?>_sleep_Alert-cust-sm" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                        <div class="col-sm-2 mt-0">
                            <div class="input-group input-group-sm">
                                <span class="input-group-text">
                                    <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400">warning</i>
                                </span>
                                <input type="text" class="form-control form-control-sm rounded-end monitor" name="services[counters][<?= $i ?>][warning]" id="services[counters][<?= $i ?>][warning]" value="<?= encode_form_val($metrics['warning']) ?>">
                                <i id="services_counters_<?= $i ?>_warning_Alert-cust-sm" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                        <div class="col-sm-2 mt-0">
                            <div class="input-group input-group-sm">
                                <span class="input-group-text">
                                    <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i>
                                </span>
                                <input type="text" class="form-control form-control-sm rounded-end monitor" name="services[counters][<?= $i ?>][critical]" id="services[counters][<?= $i ?>][critical]" value="<?= encode_form_val($metrics['critical']) ?>">
                                <i id="services_counters_<?= $i ?>_critical_Alert-cust-sm" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                    </fieldset>
                </div>
            </div>
<?php
        }
?>
        </div> <!-- counter-list -->

        <p><a style="cursor: pointer;" id="add-new-counter" class="btn btn-link"><i class="fa fa-plus"></i> <?= _('Add Another Windows Counter Check') ?></a></p>
<?php
    }
?>
        <!--                            -->
        <!-- Plugins                    -->
        <!--                            -->
        <?php
            $plugin_selector = '';

            if (empty($hosts)) {
                $plugin_selector = '<div class="input-group-addon" style="padding-bottom: 5px;"><span style="cursor: pointer;" class="plugin-selector" data-id="\'+pluginnum+\'"><i class="material-symbols-outlined md-16 md-400 md-action md-middle tt-bind" title="<?= _("Select a plugin from the list") ?>">list_alt</i></span></div>';
            }
        ?>

        <h2 class="mt-4"><?= _('Plugins') ?></h2>
        <p><?= _("If you have provided plugins on the client that you would like NCPA to run, specify them and the arguments to be passed here.") ?></p>

        <div class="row">
            <div class="col-sm-3">
                <div class="multi-select-label"><?= _('Make your Plugin Selections')?><?= xi6_info_tooltip(_("Click with shift or CRTL/CMD key to adjust your selection.")) ?></div>
                <?= $plugin_select_html ?>
                <div class="select-undo-wrap">
                    <button type="button" id="plugins-undo" <?= xi6_title_tooltip(_('Undo')) ?> class="select-undo"><i class="material-symbols-outlined md-button md-20 md-400">undo</i></button>
                </div>
            </div>
            <div class="col-sm-9">
                <div class="row">
                    <div class="col-sm-9">
                        <div class="multi-select-label"><?= _('Selected Plugins')?></div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-12">
                        <fieldset class="row g-2">
                        <fieldset class="row g-2">
                            <div class="col-sm-3">
                                <label class="form-label bold mb-0 ms-3 ps-1"><?= _('Service Description') ?></label>
                            </div>
                            <div class="col-sm-3">
                                <label class="form-label bold mb-3 ms-3 ps-1"><?= _('Plugin Name') ?></label>
                            </div>
                            <div class="col-sm-3">
                                <label class="form-label bold mb-3 ms-3 ps-1"><?= _('Plugin Arguments') ?> <?= xi6_info_tooltip(_("Write out all your arguments as they would be passed via the command line. Example: -w 10 -c 20 --search='error'")) ?></label>
                            </div>
                        </fieldset>
                    </div>
                </div>

        <div id="plugins-list" class="select-table-wrap">
        <?php
    $i = 0;
    foreach ($plugins_array as $name => $amount) {
        if (isset($plugins_by_name[$name])) {
            $monitor = (array_key_exists('monitor', $plugins_by_name[$name]) ? $plugins_by_name[$name]['monitor'] : 'off');
            $desc = $plugins_by_name[$name]['desc'];
            $args = $plugins_by_name[$name]['args'];
        } else {
            $monitor = 'off';
            $desc = $name;
            $args = '';
        }
        $safe_name = clean_str_for_dom($name);

        ?>
            <div class="row">
                <div class="col-sm-12">
                    <fieldset class="row g-2 mb-1 wz-fieldset">
                        <div class="form-check col-sm-3 mt-0 pt-0">
                            <div class="input-group input-group-sm">
                                <input type="checkbox" class="form-check-input mt-2 me-2 service-item plugins-<?= $safe_name ?>" name="services[plugins][<?= $i ?>][monitor]" id="services[plugins][<?= $i ?>][monitor]" <?= is_checked($monitor, 'on') ?>>
                                <input type="text" class="form-control form-control-sm ps-1 rounded" name="services[plugins][<?= $i ?>][desc]" id="services[plugins][<?= $i ?>][desc]" value="<?= $desc ?>">
                                <i id="services_plugins_<?= $i ?>_name_Alert-cust-sm" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                        <div class="col-sm-3 mt-0">
                            <div class="input-group input-group-sm">
                                <input type="text" class="form-control form-control-sm monitor" name="services[plugins][<?= $i ?>][name]" id="services[plugins][<?= $i ?>][name]" value="<?= $name ?>">
                                <i id="services_plugins_<?= $i ?>_name_Alert-cust-sm" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                        <div class="col-sm-3 mt-0">
                            <div class="input-group input-group-sm">
                                <input type="text" class="form-control form-control-sm rounded monitor" name="services[plugins][<?= $i ?>][args]" id="services[plugins][<?= $i ?>][args]" value="<?= $args ?>">
                                <i id="services_plugins_<?= $i ?>_name_Alert-cust-sm" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                        <div class="col-sm-1 mt-0 d-flex align-items-center">
                            <div class="input-group input-group-sm" style="flex-wrap: nowrap; gap: 5px;">
                            <?php if (!is_neptune()) { ?>
                                <button type="button" <?= xi6_title_tooltip(_('Clone')) ?> class="clone-row transparent-button material-symbols-outlined md-24" value="plugins-<?= $safe_name ?>" aria-label="Add">add</button>
                                <button type="button" <?= xi6_title_tooltip(_('Delete')) ?> class="multi-select-remove transparent-button material-symbols-outlined md-24" value="plugins-<?= $safe_name ?>" aria-label="Remove">close</button>
                            <?php } else { ?>
 
                                <button type="button" <?= xi6_title_tooltip(_('Clone')) ?> class="clone-row transparent-button material-symbols-outlined md-action md-button md-24" style="border-radius: 5px;" value="plugins-<?= $safe_name ?>" aria-label="Add">add</button>
                                <button type="button" <?= xi6_title_tooltip(_('Delete')) ?> class="multi-select-remove transparent-button material-symbols-outlined md-action md-button md-24" style="border-radius: 5px;" value="plugins-<?= $safe_name ?>" aria-label="Remove">close</button>
                            <?php } ?>
                            </div>
                        </div>
                    </fieldset>
                </div>
            </div>
            <?php
        $i++;
    }
    ?>
            </div>
        </div>
        </div> <!-- plugins-list -->

    </div> <!-- container -->

    <script type="text/javascript">
        var pluginnum = <?= isset($services['plugins']) ? (count($services['plugins']) - 1) : 0 ?>;
        var counternum = <?= isset($services['counters']) ? (count($services['counters']) - 1) : 0 ?>;
        var inum = <?= isset($services['interface']) ? (count($services['interface']) - 1) : 0 ?>;
        var dnum = <?= isset($services['disk']) ? (count($services['disk']) - 1) : 0 ?>;

        var IF_SHOW = 0;

        $(document).ready(function() {

            // Network Interface && empty($hosts)
            $(".show-hidden-interfaces").click(function() {
                if (!IF_SHOW) {
                    IF_SHOW = 1;

                    $(this).html("<?= _('Hide unselected interfaces') ?>");
                    $(".interface").removeClass("visually-hidden");

                } else {
                    IF_SHOW = 0;

                    $(this).html("<?= _('Show all interfaces') ?>");

                    $(".interface").each(function() {
                        if (!$(this).find("input[type=checkbox]").is(":checked")) {
                            $(this).addClass("visually-hidden");
                        }
                    });
                }
            });

            // TODO: Is this NOT USED or used?
            // NOnly used with multi-hostsOT USED
            $("#add-disk").click(function() {
                dnum++;

                row = "".concat(
'        <div class="row">',
'            <div class="col-sm-8">',
'                <fieldset class="row g-2 mb-1 wz-fieldset">',
'                    <div class="form-check col-sm-3 mt-0 pt-0">',
'                        <div class="input-group input-group-sm">',
'                            <input type="checkbox" id="d'+dnum+'" class="form-check-input mt-2 me-2" name="services[disk]['+dnum+'][monitor]">',
'                            <input type="hidden" name="services[disk]['+dnum+'][title]" value="">',
'                            <input type="text" class="form-control form-control-sm ps-1 rounded" name="services[disk]['+dnum+'][name]" id="services[disk]['+dnum+'][name]" value="" <?= $disabled ?>>',
'                            <input type="hidden" name="services[disk]['+dnum+'][name]" value="">',
'                        </div>',
'                    </div>');
<?php
    if (isset($root['disk']['logical'][$title]) && is_array($root['disk']['logical'][$title]) && array_key_exists('total', $root['disk']['logical'][$title]) && $title !== null) {
?>
                row = row.concat(
'                    <div class="col-sm-3 mt-0">',
'                        <div class="input-group input-group-sm">',
'                            <input type="text" name="services[disk]['+dnum+'][warning]" id="services[disk]['+dnum+'][warning]" value="" class="form-control form-control-sm monitor" readonly>',
'                            <span class="input-group-text rounded-end">%</span>',
'                            <span class="me-2"><?= xi6_info_tooltip(encode_form_val($disk_total)) ?></span>',
'                            <i id="services_disk_'+dnum+'_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>',
'                        </div>',
'                    </div>');
<?php
        }
?>
                row = row.concat(
'                    <div class="col-sm-3 mt-0">',
'                        <div class="input-group input-group-sm">',
'                            <span class="input-group-text">',
'                                <i title="<?= str_replace("'", "\'", _('Warning Threshold')) ?>" class="material-symbols-outlined md-warning md-18 md-400">warning</i>',
'                            </span>',
'                            <input type="text" name="services[disk]['+dnum+'][warning]" id="services[disk]['+dnum+'][warning]" value="" class="form-control form-control-sm monitor">',
'                            <span class="input-group-text rounded-end">%</span>',
'                            <i id="services_disk_'+dnum+'_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>',
'                        </div>',
'                    </div>',
'                    <div class="col-sm-3 mt-0">',
'                        <div class="input-group input-group-sm">',
'                            <span class="input-group-text">',
'                                <i title="<?= str_replace("'", "\'", _('Critical Threshold')) ?>" class="material-symbols-outlined md-critical md-18 md-400">error</i>',
'                            </span>',
'                            <input type="text" name="services[disk]['+dnum+'][critical]" id="services[disk]['+dnum+'][critical]" value="" class="form-control form-control-sm monitor">',
'                            <span class="input-group-text rounded-end">%</span>',
'                            <i id="services_disk_'+dnum+'_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>',
'                        </div>',
'                    </div>',
'                </fieldset>',
'            </div>',
'        </div>');

                $("#disk-list").append(row);
            });

            // Only used with multi-hosts
            $("#add-interface").click(function() {
                inum++;

                row = "".concat(
'            <div class="row">',
'                <div class="col-sm-10">',
'                    <fieldset class="row g-2 mb-1 wz-fieldset">',
'                        <div class="form-check col-sm-4 mt-0 pt-0">',
'                            <div class="input-group input-group-sm">',
'                                <input type="checkbox" name="services[services]['+inum+'][monitor]" id="services[services]['+inum+'][monitor]" class="form-check-input mt-2 me-2">',
'                                <input type="text" class="form-control form-control-sm ps-1" name="services[services]['+inum+'][desc]" id="services[services]['+inum+'][desc]" value="">',
'                            </div>',
'                        </div>',
'                        <div class="form-check col-sm-4 mt-0 pt-0">',
'                            <div class="input-group input-group-sm">',
'                                <input type="text" class="form-control form-control-sm ps-1" name="services[services]['+inum+'][name]" id="services[services]['+inum+'][name]" value="">');
<?php
        if (empty($hosts)) {
?>
                row = row.concat(
'                                <div class="input-group-text">',
'                                    <span style="cursor: pointer;" class="service-selector" data-id="'+inum+'">',
'                                        <i class="material-symbols-outlined md-16 md-400 md-action md-middle tt-bind" title="<?= _("Select services from currently running services list") ?>">list_alt</i>',
'                                    </span>',
'                                </div>');
<?php
        }
?>
                row = row.concat(
'                            </div>',
'                        </div>',
'                        <div class="form-check col-sm-auto ms-4 mt-0 pt-1">',
'                            <input type="radio" value="running" name="services[services]['+inum+'][state]" id="services[services]['+inum+'][state]" class="form-check-input" checked>',
'                            <label class="form-check-label"><?= str_replace("'", "\'", _("Running")) ?></label>',
'                        </div>',
'                        <div class="form-check col-sm-auto ms-3 mt-0 pt-1">',
'                            <input type="radio" value="stopped" name="services[services]['+inum+'][state]" id="services[services]['+inum+'][state]" class="form-check-input">',
'                            <label class="form-check-label"><?= _("Stopped") ?></label>',
'                        </div>',
'                    </fieldset>',
'                </div>',
'            </div>');

                $("#interfaces-list").append(row);
            });

            $("#add-new-counter").click(function() {
                counternum++;

                row = "".concat(
'            <div class="row">',
'                <div class="col-sm-10">',
'                    <fieldset class="row g-2 mb-1 wz-fieldset">',
'                        <div class="form-check col-sm-3 mt-0 pt-0">',
'                            <div class="input-group input-group-sm">',
'                                <input type="checkbox" class="form-check-input mt-2 me-2" name="services[counters]['+counternum+'][monitor]" id="services[counters]['+counternum+'][monitor]">',
'                                <input type="text" class="form-control form-control-sm ps-1" name="services[counters]['+counternum+'][desc]" id="services[counters]['+counternum+'][desc]" value="">',
'                                <i id="services_counters_'+counternum+'_name_Alert-cust-sm" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>',
'                            </div>',
'                        </div>',
'                        <div class="col-sm-4 mt-0">',
'                            <div class="input-group input-group-sm">',
'                                <input type="text" class="form-control form-control-sm monitor" name="services[counters]['+counternum+'][name]" id="services[counters]['+counternum+'][name]" value="">',
'                                <i id="services_counters_'+counternum+'_name_Alert-cust-sm" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>',
'                            </div>',
'                        </div>',
'                        <div class="col-sm-1 mt-0">',
'                            <div class="input-group input-group-sm">',
'                                <input type="text" class="form-control form-control-sm monitor" name="services[counters]['+counternum+'][sleep]" id="services[counters]['+counternum+'][sleep]" value="">',
'                                <i id="services_counters_'+counternum+'_sleep_Alert-cust-sm" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>',
'                            </div>',
'                        </div>',
'                        <div class="col-sm-2 mt-0">',
'                            <div class="input-group input-group-sm">',
'                                <span class="input-group-text">',
'                                    <i title="<?= str_replace("'", "\'", _('Warning Threshold')) ?>" class="material-symbols-outlined md-warning md-18 md-400">warning</i>',
'                                </span>',
'                                <input type="text" class="form-control form-control-sm monitor" name="services[counters]['+counternum+'][warning]" id="services[counters]['+counternum+'][warning]" value="">',
'                                <i id="services_counters_'+counternum+'_warning_Alert-cust-sm" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>',
'                            </div>',
'                        </div>',
'                        <div class="col-sm-2 mt-0">',
'                            <div class="input-group input-group-sm">',
'                                <span class="input-group-text">',
'                                    <i title="<?= str_replace("'", "\'", _('Critical Threshold')) ?>" class="material-symbols-outlined md-critical md-18 md-400">error</i>',
'                                </span>',
'                                <input type="text" class="form-control form-control-sm monitor" name="services[counters]['+counternum+'][critical]" id="services[counters]['+counternum+'][critical]" value="">',
'                                <i id="services_counters_'+counternum+'_critical_Alert-cust-sm" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>',
'                            </div>',
'                        </div>',
'                    </fieldset>',
'                </div>',
'            </div>');

                $("#counter-list").append(row);

            });
        });
    </script>

    <script src="../includes/configwizards/ncpa/ncpa.inc.js"></script>

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
