<?php

/*
 * hopscotch-ajaxhelper.php
 * 
 * This file handles AJAX requests from the client related to the Hopscotch tours
 * 
 * 
 */

require_once(dirname(__FILE__) . '/../../common.inc.php');

// Initialization stuff
pre_init();
init_session();
grab_request_vars();
decode_request_vars();

// Check prereqs and authentication
check_prereqs();
check_authentication(false);

route_request();

function route_request()
{
    
    global $request;
    $cmd = grab_request_var('cmd', '');

    switch ($cmd) {
        case 'set_step':
            set_tour_step();
            break;
        case 'get_step':
            get_tour_step();
            break;
        case 'set_tour_done':
            set_tour_done();
            break;
    }
    exit;
}

function set_tour_step(){
    global $request;
    $step = grab_request_var('step', '');
    $step = intval($step);
    $tour = grab_request_var('tour', '');
    $tour = encode_form_val($tour);
    $user = intval($_SESSION['user_id']);
    
    if(set_user_meta($user, $tour, $step)) {
        echo json_encode(['result' => 'success']);
    } else {
        echo json_encode(['result' => 'error']);
    }
}

function get_tour_step(){
    global $request;
    $user = intval($_SESSION['user_id']);
    $tour = grab_request_var('tour', '');

    $tour = encode_form_val($tour);

    if(empty($tour)){
        echo json_encode(['result' => 'error, no tour specified']);
    }
    
    
    $tourval = intval(get_user_meta($user, $tour));
    if(empty($tourval)){
        echo json_encode(['result' => 'error, no tour value, defaulting to 0', 'step' => 0]);
    } else {
        echo json_encode(['result' => 'success', 'step' => $tourval]);
    }
}