<?php
    // Prevent undefined variable warnings
    $operation = $operation ?? '';
    $services = $services ?? [];
    $serviceargs = $serviceargs ?? [];
    $config = $config ?? [];
    foreach (['bytes', 'flows', 'packets', 'behavior'] as $metric) {
        if (!isset($serviceargs[$metric])) {
            $serviceargs[$metric] = [
                'warning'  => '',
                'critical' => '',
                'monitor'  => ''
            ];
        }
        if (!isset($services[$metric])) {
            $services[$metric] = [
                'monitor'  => ''
            ];
        }
    }
?>

    <!--                                   -->
    <!-- The initial data set from Step 1. -->
    <!--                                   -->
    <input type="hidden" id="hostname" name="hostname" value="<?= encode_form_val($hostname) ?>">
    <input type="hidden" id="operation" name="operation" value="<?= encode_form_val($operation) ?>">
    <input type="hidden" id="services_serial" name="services_serial" value="<?= (!empty($services)) ? base64_encode(json_encode($services)) : "" ?>" />
    <input type="hidden" id="serviceargs_serial" name="serviceargs_serial" value="<?= (!empty($serviceargs)) ? base64_encode(json_encode($serviceargs)) : "" ?>" />
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />

    <input type='hidden' name='nna_server' value='<?= $nna_server ?>'>
    <input type='hidden' name='object_type' value='<?= $object_type ?>'>
    <input type='hidden' name='object_id' value='<?= $object_id ?>'>
    <input type='hidden' name='use_view' value='<?= $use_view ?>'>
    <input type='hidden' name='view_id' value='<?= $view_id ?>'>
    <input type='hidden' name='view_name' value='<?= $view_name ?>'>
<?php
    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';
?>
    <div class="container m-0 g-0 position-relative">

        <h2 class="mb-2"><?= _('Nagios Network Analyzer Server') ?></h2>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="" class="form-label"><?= _("NNA Server") ?> </label>
                <div class="input-group position-relative">
                    <input type="text" name="nna_server" id="nna_server" value="<?= get_nna_server_name($nna_server) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter NNA Server") ?>" disabled="on">
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="hostname" class="form-label form-item-required"><?= _("Host Name") ?> </label>
                <div class="input-group position-relative">
                    <input type="text" name="hostname" id="hostname" value="<?= encode_form_val($hostname) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Host Name") ?>" required>
                    <div class="invalid-feedback">
                        <?= _("Please enter a Host Name") ?>
                    </div>
                    <i id="hostname_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <!--                         -->
        <!-- The metrics to monitor. -->
        <!--                         -->
        <h2 class="mt-4"><?= _('Select What to Monitor') ?></h2>
        <p class="w-50"><?= _("Select what you would like to monitor.<br/>The graph on the right is provided to help with estimating the warning and critical thresholds.") ?></p>
        <p class="w-50"><?= _("Default values are created by the following:<br/> Warning Threshold: <strong>20% above max value</strong>,<br/> Critical Threshold: <strong>40% above max value</strong>") ?></p>

         <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="bytes" class="form-check-input" name="services[bytes][monitor]"  <?= is_checked(grab_array_var($services['bytes'], "monitor"), "on") ?>>
                        <label for="bytes" class="form-check-label bold"><?= _('Bytes') ?> <?= xi6_info_tooltip(_("Amount of bytes being transferred")) ?></label>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                            </span>
                            <input type="text" id="bytes-warning" name="services[bytes][warning]" value="<?= encode_form_val($serviceargs['bytes']['warning']) ?>" class="form-control form-control-sm monitor">
                            <span class="input-group-text">/sec</span>
                            <i id="serviceargs_bytes_warning_Alert-sm" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i>
                            </span>
                            <input type="text" id="bytes-critical" name="services[bytes][critical]" value="<?= encode_form_val($serviceargs['bytes']['critical']) ?>" class="form-control form-control-sm monitor">
                            <span class="input-group-text">/sec</span>
                            <i id="serviceargs_bytes_critical_Alert-sm" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

         <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="flows" class="form-check-input" name="services[flows][monitor]"  <?= is_checked(grab_array_var($services['flows'], "monitor"), "on") ?>>
                        <label for="flows" class="form-check-label bold"><?= _('Flows') ?> <?= xi6_info_tooltip(_("Amount of flows being transferred")) ?></label>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                            </span>
                            <input type="text" id="flows-warning" name="services[flows][warning]" value="<?= encode_form_val($serviceargs['flows']['warning']) ?>" class="form-control form-control-sm monitor">
                            <span class="input-group-text">/sec</span>
                            <i id="serviceargs_flows_warning_Alert-sm" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i>
                            </span>
                            <input type="text" id="flows-critical" name="services[flows][critical]" value="<?= encode_form_val($serviceargs['flows']['critical']) ?>" class="form-control form-control-sm monitor">
                            <span class="input-group-text">/sec</span>
                            <i id="serviceargs_flows_critical_Alert-sm" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

         <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="packets" class="form-check-input" name="services[packets][monitor]"  <?= is_checked(grab_array_var($services['packets'], "monitor"), "on") ?>>
                        <label for="packets" class="form-check-label bold"><?= _('Packets') ?> <?= xi6_info_tooltip(_("Amount of packets being transferred")) ?></label>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                            </span>
                            <input type="text" id="packets-warning" name="services[packets][warning]" value="<?= encode_form_val($serviceargs['packets']['warning']) ?>" class="form-control form-control-sm monitor">
                            <span class="input-group-text">/sec</span>
                            <i id="serviceargs_packets_warning_Alert-sm" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i>
                            </span>
                            <input type="text" id="packets-critical" name="services[packets][critical]" value="<?= encode_form_val($serviceargs['packets']['critical']) ?>" class="form-control form-control-sm monitor">
                            <span class="input-group-text">/sec</span>
                            <i id="serviceargs_packets_critical_Alert-sm" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>
<?php
    // If the service is going on a source, we can add abnormal behavior
    if ($object_type == "sources" && $version === "1") {
?>
         <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="behavior" class="form-check-input" name="services[behavior][monitor]"  <?= is_checked(grab_array_var($services['behavior'], "monitor"), "on") ?>>
                        <label for="behavior" class="form-check-label bold"><?= _('Abnormal Behavior') ?> <?= xi6_info_tooltip(_("If there is abnormal behavior on the source this check will return critical")) ?></label>
                    </div>
                </fieldset>
            </div>
        </div>
<?php
    }
?>
        <div class="position-absolute bottom-0 end-0 w-50">
            <div id="nna-graph"></div>
        </div>

    </div> <!-- container -->

    <script type='text/javascript'>
        $(document).ready(function() {

            $.post('<?php get_base_url();?> /nagiosxi/includes/configwizards/networkanalyzer/networkanalyzer-ajaxhelper.php', {
                    cmd: 'get_graph_data',
                    nsp: '<?php echo get_nagios_session_protector_id(); ?>',
                    server: '<?= $address ?>',
                    token: '<?= $token ?>',
                    version: '<?= $version ?>',
                    ssl: '<?= $ssl ?>',
                    allow_invalid_cert: '<?= $allow_invalid_cert ?>',
                    object_id: '<?= $object_id ?>',
                    object_type: '<?= $object_type ?>',
                    use_views: '<?= $use_view ?>',
                    view_id: '<?= $view_id ?>',
            }, function() {}, "json")
            .done(function(data){

                var top_bytes = 0;
                $.each(data[0].data, function(k,bytes) {
                    if (top_bytes < bytes) {
                        top_bytes = bytes;
                    }
                })

                var top_packets = 0;
                $.each(data[2].data, function(k,packets) {
                    if (top_packets < packets) {
                        top_packets = packets;
                    }
                })

                var top_flows = 0;
                $.each(data[1].data, function(k,flows) {
                    if (top_flows < flows) {
                        top_flows = flows;
                    }
                })

                $('#bytes-critical').val(Math.round(top_bytes * 1.4));
                $('#bytes-warning').val(Math.round(top_bytes * 1.2));

                $('#packets-critical').val(Math.round(top_packets * 1.4));
                $('#packets-warning').val(Math.round(top_packets * 1.2));

                $('#flows-critical').val(Math.round(top_flows * 1.4));
                $('#flows-warning').val(Math.round(top_flows * 1.2));

                var title = 'Last Week of Bandwidth Data';
                var text = 'Select or deselect the types of data to show on the graph using the legend';
                var series;

                if (data.error || data[0].total == 0) {
                    title = 'No Data Available';
                    text = 'There is no data available for the currently selected time period.';
                    series= [];

                } else {
                    series = [{
                        name: data[0].name,
                        pointInterval: data[0].pointInterval,
                        pointStart: data[0].pointStart,
                        data: data[0].data
                    },
                    {
                        name: data[2].name,
                        pointInterval: data[2].pointInterval,
                        pointStart: data[2].pointStart,
                        data: data[2].data
                    },
                    {
                        name: data[1].name,
                        pointInterval: data[1].pointInterval,
                        pointStart: data[1].pointStart,
                        data: data[1].data
                    }]
                }

                GRAPH = new Highcharts.Chart({
                    chart: {
                        type: 'line',
                        renderTo: 'nna-graph'
                    },
                    credits: {
                            enabled: false
                    },
                    colors: [
                        '#5e8ff6',
                        '#2156c3',
                        '#2e2929'
                    ],
                    exporting: {
                        enabled: false
                    },
                    title: {
                        text: title
                    },
                    xAxis: {
                        type: 'datetime'
                    },
                    yAxis: {
                        title: {
                            text: ''
                        }
                    },
                    tooltip: {
                        formatter: function() {
                                var h = '<b>' + Highcharts.dateFormat('%m/%d/%Y %H:%M', this.x) + '</b>';

                                $.each(this.points, function(i, point) {
                                    h += '<br/>' + point.series.name + ': ' + (point.y).toFixed(0);
                                });

                                return h;
                            },
                        shared: true
                    },
                    legend: {
                        borderWidth: 0
                    },
                    plotOptions: {
                        line: {
                            lineWidth: 1,
                            marker: {
                                enabled: false
                            }
                        }
                    },
                    series: series
                })

            }, 'json');
        });
    </script>

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
