    <input type="hidden" id="selectedhostconfig" name="selectedhostconfig" value="<?= encode_form_val($selectedhostconfig) ?>" />
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />
<?php
    $bulk_fields_serial = base64_encode(json_encode($bulk_fields));
    /*<input type="hidden" id="backloaded-fields" value="<?= $bulk_fields ?>">*/
?>
    <input type="hidden" id="bulk_fields_serial" value="<?= $bulk_fields_serial ?>">
    <input type="hidden" name="snmpversion" id="snmpversion" value="<?= encode_form_val($snmpversion) ?>">
<?php
    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';
?>
    <div class="container m-0 g-0">
        <!--                         -->
        <!-- The configuration form. -->
        <!--                         -->
        <div id="configForm">

            <h2 class="mb-2"><?= _('Router/Switch Information') ?></h2>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="ip_address" class="form-label form-item-required"><?= _("IP Address") ?> <?= xi6_info_tooltip(_("The IP address of the network device to monitor.")) ?></label>
                    <div class="input-group position-relative">
                        <input type="text" name="ip_address" id="ip_address" value="<?= encode_form_val($address) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter IP Address") ?>" required>
                        <div class="invalid-feedback">
                            <?= _("Please enter the IP Address") ?>
                        </div>
                        <i id="ip_address_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="port" class="form-label form-item-required"><?= _("Port") ?> <?= xi6_info_tooltip(_("The port of the network device.")) ?></label>
                    <div class="input-group position-relative">
                        <input type="text" name="port" id="port" value="<?= encode_form_val($address_port) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter Port") ?>" required>
                        <div class="invalid-feedback">
                            <?= _("Please enter the Port") ?>
                        </div>
                        <i id="port_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <!-- SNMP Version Tabs -->
            <div class="col-sm-6 border-block mt-4">
                <ul class="nav nav-pills mb-3" id="pills-tab" role="tablist">
                    <li class="nav-item"><a class="nav-link" id="pills-snmpv1-tab" data-bs-toggle="pill" data-bs-target="#pills-snmpv1" type="button" role="tab" aria-controls="pills-snmpv1" aria-selected="false">SNMPv1</a></li>
                    <li class="nav-item"><a class="nav-link active" id="pills-snmpv2c-tab" data-bs-toggle="pill" data-bs-target="#pills-snmpv2c" type="button" role="tab" aria-controls="pills-snmpv2c" aria-selected="true">SNMPv2c</a></li>
                    <li class="nav-item"><a class="nav-link" id="pills-snmpv3-tab" data-bs-toggle="pill" data-bs-target="#pills-snmpv3" type="button" role="tab" aria-controls="pills-snmpv3" aria-selected="false">SNMPv3</a></li>
                </ul>

                <div class="tab-content" id="pills-tabContent">

                    <div id="pills-snmpv1" class="tab-pane fade show" role="tabpanel" aria-labelledby="pills-snmpv1-tab">

                        <div class="row mb-2">
                            <div class="col-sm">
                                <label for="snmpopts[snmpcommunity]" class="form-label form-item-required"><?= _("SNMP Community") ?> <?= xi6_info_tooltip(_("The SNMP community string required used to to query the network device")) ?></label>
                                <div class="input-group position-relative">
                                    <input type="text" name="snmpopts[snmpcommunity]" id="snmpopts[snmpcommunity]" value="<?= encode_form_val($snmpopts['snmpcommunity']) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter SNMP Community") ?>" required>
                                    <div class="invalid-feedback">
                                        <?= _("Please enter the SNMP Community") ?>
                                    </div>
                                    <i id="snmpopts_snmpcommunity_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                </div>
                            </div>
                        </div>
                    </div> <!-- Closes #snmpv1 -->

                    <div id="pills-snmpv2c" class="tab-pane fade show active" role="tabpanel" aria-labelledby="pills-snmpv2c-tab">

                        <div class="row mb-2">
                            <div class="col-sm">
                                <label for="snmpopts[snmpcommunity]" class="form-label form-item-required"><?= _("SNMP Community") ?> <?= xi6_info_tooltip(_("The SNMP community string required used to to query the network device")) ?></label>
                                <div class="input-group position-relative">
                                    <input type="text" name="snmpopts[snmpcommunity]" id="snmpopts[snmpcommunity]" value="<?= encode_form_val($snmpopts['snmpcommunity']) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter SNMP Community") ?>" required>
                                    <div class="invalid-feedback">
                                        <?= _("Please enter the SNMP Community") ?>
                                    </div>
                                    <i id="snmpopts_snmpcommunity_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                </div>
                            </div>
                        </div>
                    </div> <!-- Closes #snmpv2c -->

                    <div id="pills-snmpv3" class="tab-pane fade show" role="tabpanel" aria-labelledby="pills-snmpv3-tab">
                        <p><?= _("When using SNMP v3 authentication information is required.") ?>.</p>

                        <div class="row mb-2">
                            <div class="col-sm">
                                <label for="snmpopts[v3_security_level]" class="form-label form-item-required"><?= _("Security Level") ?> </label>
                                <div class="input-group position-relative">
                                    <select name="snmpopts[v3_security_level]" id="snmpopts[v3_security_level]" class="form-control form-select monitor rounded" placeholder="<?= _("Select a Security Level") ?> " required>
                                        <option value="authPriv" <?= is_selected($snmpopts["v3_security_level"], "authPriv") ?>>authPriv</option>
                                        <option value="authNoPriv" <?= is_selected($snmpopts["v3_security_level"], "authNoPriv") ?>>authNoPriv</option>
                                        <option value="noAuthNoPriv" <?= is_selected($snmpopts["v3_security_level"], "noAuthNoPriv") ?>>noAuthNoPriv</option>
                                    </select>
                                    <div class="invalid-feedback">
                                        <?= _("Please select a Security Level") ?>
                                    </div>
                                    <i id="snmpopts_v3_security_level_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                </div>
                            </div>
                        </div>

                        <div class="row mb-2">
                            <div class="col-sm">
                                <label for="snmpopts[v3_username]" class="form-label form-item-required"><?= _("Username") ?> </label>
                                <div class="input-group position-relative">
                                    <input type="text" id="snmpopts[v3_username]" name="snmpopts[v3_username]" value="<?= encode_form_val($snmpopts["v3_username"]) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter Username") ?>" required>
                                    <div class="invalid-feedback">
                                        <?= _("Please enter the Username") ?>
                                    </div>
                                    <i id="snmpopts_v3_username_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                </div>
                            </div>
                        </div>

                        <div class="row mb-2">
                            <div class="col-sm">
                                <label for="snmpopts[v3_auth_password]" class="form-label form-item-required"><?= _("Authentication Password") ?> </label>
                                <div class="input-group position-relative">
                                    <input type="text" id="snmpopts[v3_auth_password]" name="snmpopts[v3_auth_password]" value="<?= grab_array_var($snmpopts, "v3_auth_password"); ?>" class="form-control monitor rounded authPriv-enable authNoPriv-enable noAuthNoPriv-disable" placeholder="<?= _("Enter Authentication Password") ?>" required>
                                    <div class="invalid-feedback">
                                        <?= _("Please enter the Authentication Password") ?>
                                    </div>
                                    <i id="snmpopts_v3_auth_password_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                </div>
                            </div>
                        </div>

                        <div class="row mb-2">
                            <div class="col-sm">
                                <label for="snmpopts[v3_auth_proto]" class="form-label form-item-required"><?= _("Authentication Protocol") ?> </label>
                                <div class="input-group position-relative">
                                    <select name="snmpopts[v3_auth_proto]" id="snmpopts[v3_auth_proto]" class="form-select monitor rounded authPriv-enable authNoPriv-enable noAuthNoPriv-disable" placeholder="<?= _("Select Authentication Protocol") ?> " required>
                                        <option value="MD5" <?= is_selected(grab_array_var($snmpopts, "v3_auth_proto"), "MD5") ?>>MD5</option>
                                        <option value="SHA" <?= is_selected(grab_array_var($snmpopts, "v3_auth_proto"), "SHA") ?>>SHA</option>
                                    </select>
                                    <div class="invalid-feedback">
                                        <?= _("Please select Authentication Protocol") ?>
                                    </div>
                                    <i id="snmpopts_v3_auth_proto_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                </div>
                            </div>
                        </div>

                        <div class="row mb-2">
                            <div class="col-sm">
                                <label for="snmpopts[v3_priv_password]" class="form-label form-item-required"><?= _("Privacy Password") ?> </label>
                                <div class="input-group position-relative">
                                    <input type="text" id="snmpopts[v3_priv_password]" name="snmpopts[v3_priv_password]" value="<?= grab_array_var($snmpopts, "v3_priv_password") ?>" class="form-control monitor rounded authPriv-enable authNoPriv-disable noAuthNoPriv-disable" placeholder="<?= _("Enter Privacy Password") ?>" required>
                                    <div class="invalid-feedback">
                                        <?= _("Please enter the Privacy Password") ?>
                                    </div>
                                    <i id="snmpopts_v3_priv_password_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                </div>
                            </div>
                        </div>

                        <div class="row mb-2">
                            <div class="col-sm">
                                <label for="snmpopts[v3_priv_proto]" class="form-label form-item-required"><?= _("Privacy Protocol") ?> </label>
                                <div class="input-group position-relative">
                                    <select name="snmpopts[v3_priv_proto]" id="snmpopts[v3_priv_proto]" class="form-select monitor rounded authPriv-enable authNoPriv-disable noAuthNoPriv-disable" placeholder="<?= _("Select Privacy Protocol") ?> " required>
<?php
            $xisys = $cfg['root_dir'].'/var/xi-sys.cfg';
            $ini = parse_ini_file($xisys);

            $des_option = '';

            if ($ini['dist'] != "el9" && $ini['dist'] != "ubuntu22" && $ini['dist'] != "ubuntu24") {
?>
                                        <option value="DES" <?= is_selected((array_key_exists("v3_priv_proto", $snmpopts) && !empty($snmpopts["v3_priv_proto"]) ? $snmpopts["v3_priv_proto"] : "DES"), "DES") ?>>DES</option>
<?php
            }
?>
                                        <option value="AES" <?= is_selected((array_key_exists("v3_priv_proto", $snmpopts) && !empty($snmpopts["v3_priv_proto"]) ? $snmpopts["v3_priv_proto"] : "AES"), "AES") ?>>AES128</option>
                                    </select>
                                    <div class="invalid-feedback">
                                        <?= _("Please select Privacy Protocol") ?>
                                    </div>
                                    <i id="snmpopts_v3_priv_proto_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                </div>
                            </div>
                        </div>
                    </div> <!-- Closes #snmpv3 -->
                </div> <!-- End #tabs -->
            </div> <!-- #tabs - border-block -->

            <h2 class="mt-4 mb-2"><?= _("Monitoring Options") ?></h2>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="interface_reference_style" class="form-label form-item-required"><?= _("Interface Reference Style"); ?> <?= xi6_info_tooltip(_("This determines how the monitoring engine will find your interface ports. Please select a stable identifier")); ?></label>
                    <div class="input-group position-relative">
                        <select name="interface_reference_style" id="interface_reference_style" class="form-select monitor rounded" required>
                            <option value="nr" <?= is_selected($interface_reference_style, "nr"); ?>><?= _("Port Number"); ?></option>
                            <option value="name" <?= is_selected($interface_reference_style, "name"); ?>><?= _("Port Name"); ?></option>
                            <option value="descr" <?= is_selected($interface_reference_style, "descr"); ?>><?= _("Port Description"); ?></option>
                            <!--<option value="eth" <?= is_selected($interface_reference_style, "eth"); ?>><?= _("Port Physical Address"); ?></option>-->
                            <option value="type" <?= is_selected($interface_reference_style, "type"); ?>><?= _("Port Type"); ?></option>
                        </select>
                    </div>
                </div>
            </div>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="portnames" class="form-label form-item-required"><?= _("Monitoring Scheme") ?> <?= xi6_info_tooltip(_("This determines how your services will be named")) ?></label>
                    <div class="input-group position-relative">
                        <select name="portnames" id="portnames" class="form-select monitor rounded" placeholder="<?= _("Select Port Naming Monitoring Scheme") ?> " required>
                            <option value="number" <?= is_selected($portnames, "number") ?>><?= encode_form_val(_("<Use Interface Reference Style>")); ?></option>
                            <option value="name" <?= is_selected($portnames, "name") ?>><?= _("Port Name") ?></option>
                            <option value="description" <?= is_selected($portnames, "description") ?>><?= _("Port Description") ?></option>
                            <option value="alias" <?= is_selected($portnames, "alias") ?>><?= _("Port Alias") ?></option>
                        </select>
                        <div class="invalid-feedback">
                            <?= _("Please select the Port Naming Monitoring scheme") ?>
                        </div>
                        <i id="portnames_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-sm-8">
                    <div class="form-check mt-0 pt-1">
                        <input type="checkbox" id="scaninterfaces" class="form-check-input" name="scaninterfaces" <?= is_checked($scaninterfaces, "on") ?>>
                        <label for="scaninterfaces" class="form-check-label bold"><?= _("Scan Interfaces") ?> <?= xi6_info_tooltip(_("Scan the switch or router to auto-detect interfaces, that can be monitored for link up/down status and bandwidth usage. The scanning process may take several seconds to complete.")) ?></label>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-sm-8">
                    <div class="form-check mt-0 pt-1">
                        <input type="checkbox" id="admindown" class="form-check-input" name="admindown" <?= is_checked($admindown) ?>>
                        <label for="admindown" class="form-check-label bold"><?= _("Administratively Down Interfaces") ?> <?= xi6_info_tooltip(_("Include administratively down interfaces in the scan for monitoring link status and bandwidth usage.")) ?></label>    
                    </div>
                </div>
            </div>

            <h2 class="mt-4"><?= _("Bulk Configuration")  ?></h2>
            <p><?= _('If you have many devices with the same port bandwidth and desired alerting thresholds, paste each configuration as a CSV in the space below.') ?></p>
            <ul class="list-group w-75">
                <li class="list-group-item"><?= _('The "IP Address" is required. Optionally, columns for "hostname", "snmpcommunity", can be included.') ?></li>
                <li class="list-group-item"><?= _('Additionally, with SNMP v3 columns "v3_security_level", "v3_username", "v3_auth_password", "v3_priv_password", "v3_auth_proto", and/or "v3_priv_proto", can be included.') ?></li>
            </ul>
<?php
    $example1 =
"192.168.1.23
192.168.1.34
10.1.1.134";

    # TODO: When second field is chosen, display example2.
    $example2 =
"192.168.1.23,Server
192.168.1.34,WebSphere
10.1.1.134,DBServer";
?>
            <div class="col-sm-10">
                <div class="row mt-4 mb-3" id="bulk-append-fields">
                    <div class="col-sm pe-0">
                        <label for="field1" class="form-label form-item-required"><?= _('Field') ?> 1 <?= xi6_info_tooltip(_('Specify the type of data present in the fields of data, below')) ?></label>
                        <div class="input-group position-relative">
                            <select name="bulk_fields[]" id="bulk_fields[]" class="form-select form-select-sm form-control-sm monitor rounded">
                                <option value="ip_address"><?= _('IP Address') ?></option>
                            </select>
                        </div>
                    </div>
                </div>

                <div class="row mb-4">
                    <div class="col-sm pe-0">
                        <label for="bulk_options" class="form-label"><?= _('Data') ?><?= xi6_info_tooltip(_('The addresses of new hosts that should be created by cloning the template host and services specified above. Multiple fields should be separated by a comma. One entry per line')) ?></label>
                        <textarea name="bulk_options" id="bulk_options" style="font-family: Consolas, Courier New, monospace;" class="form-control form-control-sm" placeholder="<?= $example1 ?>" rows="10"><?= $bulk_options ?></textarea>
                    </div>
                </div>

                <!-- # 2-3 -->
                <div id="sample-fields-v12c" class="hide">
                    <div class="col-sm ps-1 pe-0 bulk-remove-me">
                        <label for="field" class="form-label form-item-required"><?= _('Field') ?> </label>
                        <div class="input-group position-relative">
                            <select name="bulk_fields[]" id="bulk_fields[]" class="form-select form-select-sm form-control-sm monitor rounded">
                                <option value=""><?= _('IGNORE') ?></option>
                                <option value="hostname"><?= _("Hostname") ?></option>
                                <option value="snmpcommunity"><?= _('SNMP Community') ?></option>
                            </select>
                        </div>
                    </div>
                </div>

                <!-- # 2-7 -->
                <div id="sample-fields-v3" class="hide">
                    <div class="col-sm ps-1 pe-0 bulk-remove-me">
                        <label for="field" class="form-label form-item-required"><?= _('Field') ?> </label>
                        <div class="input-group position-relative">
                            <select name="bulk_fields[]" id="bulk_fields[]" class="form-select form-select-sm form-control-sm monitor rounded">
                                <option value=""><?= _('IGNORE') ?></option>
                                <option value="hostname"><?= _("Hostname") ?></option>
                                <option value="v3_username"><?= _('Username') ?></option>
                                <option value="v3_auth_password"><?= _('Auth Password') ?></option>
                                <option value="v3_priv_password"><?= _('Priv Password') ?></option>
                                <option value="v3_auth_proto"><?= _('Auth Protocol') ?></option>
                                <option value="v3_priv_proto"><?= _('Priv Protocol') ?></option>
                            </select>
                        </div>
                    </div>
                </div>
            </div>

            <h2 class="mt-4 mb-2"><?= _("Default Values") ?></h2>
            <div class="row">
                <div class="col-sm-8">
                    <fieldset class="row g-2 mb-1 wz-fieldset">
                        <div class="col-sm-3 mt-0 pt-1">
                            <label for="warn_speed_in_percent" class="form-label form-item-required bold"><?= _('Input Rate') ?></label>
                        </div>
                        <div class="col-sm-3 mt-0">
                            <div class="input-group input-group-sm">
                                <span class="input-group-text">
                                    <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                                </span>
                                <input type="text" id="warn_speed_in_percent" name="warn_speed_in_percent" value="<?= $warn_speed_in_percent ?>" class="form-control monitor" required>
                                <span class="input-group-text rounded-end">%</span>
                                <div class="invalid-feedback">
                                    <?= _("Please enter the warning threshold") ?>
                                 </div>
                                <i id="warn_speed_in_percent_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            
                            </div>
                        </div>
                        <div class="col-sm-3 mt-0">
                            <div class="input-group input-group-sm">
                                <span class="input-group-text">
                                    <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                                </span>
                                <input type="text" id="crit_speed_in_percent" name="crit_speed_in_percent" value="<?= encode_form_val($crit_speed_in_percent) ?>" class="form-control monitor" required>
                                <span class="input-group-text rounded-end">%</span>
                                <div class="invalid-feedback">
                                    <?= _("Please enter the critical threshold") ?>
                                </div>
                                <i id="crit_speed_in_percent_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                    </fieldset>
                </div>
            </div>

            <div class="row">
                <div class="col-sm-8">
                    <fieldset class="row g-2 mb-1 wz-fieldset">
                        <div class="col-sm-3 mt-0 pt-1">
                            <label for="warn_speed_out_percent" class="form-label form-item-required bold"><?= _('Output Rate') ?></label>
                        </div>
                        <div class="col-sm-3 mt-0">
                            <div class="input-group input-group-sm position-relative">
                                <span class="input-group-text">
                                    <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                                </span>
                                <input type="text" id="warn_speed_out_percent" name="warn_speed_out_percent" value="<?= $warn_speed_out_percent ?>" class="form-control monitor" required>
                                <span class="input-group-text rounded-end">%</span>
                                <div class="invalid-feedback">
                                    <?= _("Please enter the warning threshold") ?>
                                </div>
                                <i id="warn_speed_out_percent_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                        <div class="col-sm-3 mt-0">
                            <div class="input-group input-group-sm position-relative">
                                <span class="input-group-text">
                                    <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                                </span>
                                <input type="text" id="crit_speed_out_percent" name="crit_speed_out_percent" value="<?= encode_form_val($crit_speed_out_percent) ?>" class="form-control monitor" required> 
                                <span class="input-group-text rounded-end">%</span>
                                <div class="invalid-feedback">
                                    <?= _("Please enter the critical threshold") ?>
                                </div>
                                <i id="crit_speed_out_percent_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                    </fieldset>
                </div>
            </div>

            <div class="row mb-2">
                <div class="col-sm-8">
                    <fieldset class="row g-2 mb-1 wz-fieldset">
                        <div class="col-sm-3 mt-0 pt-1">
                            <label for="default_port_speed" class="form-label form-item-required"><?= _("Default Port Speed") ?></label>
                        </div>
                        <div class="col-sm-3 mt-0 pt-1">
                            <div class="input-group input-group-sm position-relative">
                                <input type="text" name="default_port_speed" id="default_port_speed" value="<?= $default_port_speed ?>" class="form-control monitor" required>
                                <span class="input-group-text rounded-end">Mbps</span>
                                <div class="invalid-feedback">
                                    <?= _("Please enter the Default Port Speed") ?>
                                </div>
                                <i id="default_port_speed_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                    </fieldset>
                </div>
            </div>
        </div> <!-- config -->
    </div> <!-- container -->

    <script type="text/javascript">
        $(document).ready(function() {
            // On page load, determine which snmp version is selected,
            // and populate the Bulk Configuration fields accordingly
            set_bulk_config_fields();

            $("#pills-snmpv1-tab, #pills-snmpv2c-tab, #pills-snmpv3-tab").click(function() {
                $("#bulk-append-fields").find(".bulk-remove-me").remove();

                set_bulk_config_fields(this.id);
            });

            // Then, if the back button was pressed, select the fields that were chosen last time()
            var backpop_array = ['<?= implode("','", $bulk_fields) ?>'];
            var fields = $("select[name*=\"bulk_fields[]\"");
            console.log(backpop_array);
            console.log(fields);

            // backpop_array will be an array of the empty string if "Next" was pressed
            if (backpop_array.length > 1) {

                for (x in backpop_array) {
                    $(fields[x]).val(backpop_array[x]);
                }
            }

            security_level = $('.form-control[name=\"snmpopts[v3_security_level]\"]').val();
            enable_fields_by_security_level(security_level);

            $(".form-control[name=\"snmpopts[v3_security_level]\"]").change(function () {
                enable_fields_by_security_level($(this).val());
            });

            // Initial check
            select_default_proto();
            update_security_display();

            // Detection
            $("[name='snmpopts[v3_security_level]']").change(function() {
                select_default_proto();
            });

            // Upon clicking the tabs, set the invisible radio selector
            // to be true, based on the tab clicked
            $("#pills-snmpv1-tab").click(function() {
                $("#snmpversion").val("1");
                update_security_display();
            });

            $("#pills-snmpv2c-tab").click(function() {
                $("#snmpversion").val("2c");
                update_security_display();
            });

            $("#pills-snmpv3-tab").click(function() {
                $("#snmpversion").val("3");
                update_security_display();
            });

            // I wasn't able to determine why jQuery wouldn't be able to trigger a click event,
            // but it turns out that the built-in browser API is working fine. -swolf 2024-07-18
            const initial_snmp_version = $('#snmpversion').val();
            $('#pills-snmpv'+initial_snmp_version +'-tab')[0].click();

            // Disable any fields that are not required for v3's various security levels.
            function select_default_proto(level_val) {
                var level_val = $("[name='snmpopts[v3_security_level]']").val();

                if (level_val == "authNoPriv") {
                    $("[name='snmpopts[v3_auth_proto]']").val("MD5");
                    $("[name='snmpopts[v3_priv_proto]']").val("");
                    $('label[for="snmpopts\[v3_auth_password\]"]').addClass('form-item-required');
                    $('label[for="snmpopts\[v3_auth_proto\]"]').addClass('form-item-required');
                    $('label[for="snmpopts\[v3_priv_password\]"]').removeClass('form-item-required');
                    $('label[for="snmpopts\[v3_priv_proto\]"]').removeClass('form-item-required');
                } else if (level_val == "authPriv") {
                    $("[name='snmpopts[v3_auth_proto]']").val("MD5");

                    // "DES" does not always exist, so set to first one.
                    //$("[name='snmpopts[v3_priv_proto]']").val("DES");
                    $("[name='snmpopts[v3_priv_proto]'] > option:first").prop("selected", true);

                    $('label[for="snmpopts\[v3_priv_password\]"]').addClass('form-item-required');
                    $('label[for="snmpopts\[v3_priv_proto\]"]').addClass('form-item-required');
                    $('label[for="snmpopts\[v3_auth_password\]"]').addClass('form-item-required');
                    $('label[for="snmpopts\[v3_auth_proto\]"]').addClass('form-item-required');
                } else {
                    $("[name='snmpopts[v3_auth_proto]']").val("");
                    $("[name='snmpopts[v3_priv_proto]']").val("");
                    $('label[for="snmpopts\[v3_auth_password\]"]').removeClass('form-item-required');
                    $('label[for="snmpopts\[v3_auth_proto\]"]').removeClass('form-item-required');
                    $('label[for="snmpopts\[v3_priv_password\]"]').removeClass('form-item-required');
                    $('label[for="snmpopts\[v3_priv_proto\]"]').removeClass('form-item-required');
                }
            }
        });


        function update_security_display() {
            var version_val = $("#snmpversion").val();
            console.log("update_security_display - version_val: ", version_val)
            if (version_val == "3") {                
                $('#pills-snmpv3 :input').attr('required', true);                
            } else {
                $('#pills-snmpv3 :input').removeAttr('required');
            }
        }

        function enable_fields_by_security_level(level) {
            $("." + level + "-enable").attr("disabled", false);
            $("." + level + "-disable").attr("disabled", true);
        }

        function set_bulk_config_fields(button_id) {
            var new_fields = $("#sample-fields-v12c");
            var selectObj = new_fields.find("select");

            if (button_id === "pills-snmpv3-tab") {
                // version 3
                new_fields = $("#sample-fields-v3");
                selectObj = new_fields.find("select");
            }

            var idx = 1;
            var fieldName = new_fields.find("label").text().replace(/[0-9]/g, '');
            var fieldLabel = new_fields.find("label").attr("for").replace(/[0-9]/g, '');

            selectObj.children("option").each(function(idx) {
                idx++;
                // Skip the "IGNORE" entry, while adding fields, from the sample select statements.
                if ($(this).val() === "") {
                    return;
                }

                new_fields.find("label").text(fieldName+idx);
                new_fields.find("label").attr("for", fieldLabel+idx);

                $("#bulk-append-fields").append(new_fields.html());
            });
        }
    </script>

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
