    <input type="hidden" id="services_serial" name="services_serial" value="<?= (!empty($services)) ? base64_encode(json_encode($services)) : "" ?>" />
    <input type="hidden" id="serviceargs_serial" name="serviceargs_serial" value="<?= (!empty($serviceargs)) ? base64_encode(json_encode($serviceargs)) : "" ?>" />
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />

    <div class="container m-0 g-0">
<?php
    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';
?>
        <!--                         -->
        <!-- The configuration form. -->
        <!--                         -->
        <div id="configForm">
            <h2 class="mb-2"><?= _("Folder Path and Server Information") ?></h2>

            <div class="col-sm-7 border-block mb-2">
                <b><?= _("Folder Watch by SSH") ?></b>
                <p><?= _("The remote host must be configured to allow open SSH from this wizard. Refer to this document: <a href='https://assets.nagios.com/downloads/nagiosxi/docs/Monitoring_Hosts_Using_SSH.pdf' target='_blank'>Monitoring_Hosts_Using_SSH.pdf</a>").".<br><br>"._("Login with passwordless SSH from this server, to the remote host is required for this Wizard to run properly.") ?></p>
            </div>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="dirpath" class="form-label form-item-required"><?= _('Folder to Watch') ?> <?= xi6_info_tooltip(_('The path of the folder or file to monitor.')) ?></label>
                    <div class="input-group position-relative">
                        <input type="text" name="dirpath" id="dirpath" value="<?= encode_form_val($dirpath) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter Folder to Watch") ?>" required>
                        <div class="invalid-feedback">
                            <?= _("Please enter the Folder to watch") ?>
                        </div>
                        <i id="dirpath_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="ip_address" class="form-label form-item-required"><?= _('Server Address') ?> <?= xi6_info_tooltip(_('The IP address or FQDNS name of the server to connect to using SSH.')) ?></label>
                    <div class="input-group position-relative">
                        <input type="text" name="ip_address" id="ip_address" value="<?= encode_form_val($address) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter Server Address") ?>" required>
                        <div class="invalid-feedback">
                            <?= _("Please enter the Server Address") ?>
                        </div>
                        <i id="ip_address_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <div class="row mb-3 mt-4">
                <div class="col-sm">
                    <input type="checkbox" id=ssh class="form-check-input" name="ssh"  <?= is_checked($ssh) ?>>
                    <label for="ssh" class="form-check-label bold">
                        <?= _('SSH') ?>
                        <?= xi6_info_tooltip(_('If this box is checked the wizard will use SSH to connect to a remote host. To run this wizard locally, uncheck this box.')) ?>
                    </label>
                </div>
            </div>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="ssh_username" class="form-label form-item-required"><?= _('Username') ?> </label>
                    <div class="input-group position-relative">
                        <input type="text" name="ssh_username" id="ssh_username" value="<?= encode_form_val($ssh_username) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter Username") ?>" required>
                        <div class="invalid-feedback">
                            <?= _("Please enter the Username") ?>
                        </div>
                        <i id="ssh_username_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>
        </div> <!-- config -->
    </div> <!-- container -->

    <script type="text/javascript">
        $(document).ready(function() {
            var ssh_check = document.getElementById("ssh");

            $(ssh_check).click(function() {
                if ($(ssh_check).is(":checked") == true) {
                    $('#ssh_username').removeAttr("disabled");
                    $('#ssh_username').attr("enabled", "enabled");
                }

                if ($(ssh_check).is(":checked") == false) {
                    $('#ssh_username').removeAttr("enabled");
                    $('#ssh_username').attr("disabled", "disabled");
                }
            });
        });
    </script>

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
