    <input type="hidden" id="selectedhostconfig" name="selectedhostconfig" value="<?= encode_form_val($selectedhostconfig) ?>" />
    <input type="hidden" id="services_serial" name="services_serial" value="<?= (!empty($services)) ? base64_encode(json_encode($services)) : "" ?>" />
    <input type="hidden" id="serviceargs_serial" name="serviceargs_serial" value="<?= (!empty($serviceargs)) ? base64_encode(json_encode($serviceargs)) : "" ?>" />
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />

<?php
    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';
?>
    <div class="container m-0 g-0">
        <!--                         -->
        <!-- The configuration form. -->
        <!--                         -->
        <div id="information">
            <h5><?= _('Microsoft/Office 365 - Setup') ?></h5>
            <p>
                <?= _("You can now monitor your Microsoft Office 365 subscription services with Nagios XI.")."<br>" ?>
                <?= _("See ").'<a target="blank" href="https://support.nagios.com/kb/article/monitoring-office-365-subscription-services-881.html">Monitoring Office 365 Subscription Services</a>, ' ?>
                <?= _("for step by step instructions.") ?>
            </p>

    <b>Notes for Administrators:</b><br>
    You will need to setup an app registration, with a client secret and these API permissions...
    </p>
    <ul style="padding: 0 0 0 20px;">
    <b>Microsoft Graph</b>
        <li style="margin-left: 15px;">Group.Read.All</li>
        <li style="margin-left: 15px;">Reports.Read.All</li>
        <li style="margin-left: 15px;">User.Read.All</li>
    </ul>
    <p style="margin-top: 0;">
    Plus, <b><i>Global Administrator</i></b> role is required in order to provide admin consent for application permissions to the Microsoft Graph API.
    </p>
    <p>
    For more information, see <a target="blank" href="https://docs.microsoft.com/en-us/azure/active-directory/manage-apps/grant-admin-consent">Grant Tenant-Wide Admin Consent to an Application</a> on the Microsoft site.
    </p>
        </div>

        <div id="configForm">
            <h5><?= _('Microsoft/Office 365') ?></h5>
            <p><?= _('Specify the details for connecting to the Microsoft/Office 365 statistics to be monitored') ?>.</p>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="appid" class="form-label form-item-required"><?= _("Application (client) ID") ?> <?= xi6_info_tooltip(_("Application (client) ID (GUID) created during plugin registration in Azure AD")) ?></label>
                    <div class="input-group position-relative">
                        <input type="text" name="appid" id="appid" value="<?= encode_form_val($appid) ?>" class="form-control rounded-end monitor" placeholder="<?= _("Enter Application (client) ID") ?>" required>
                        <div class="invalid-feedback">
                            Please enter the Application (client) ID.
                        </div>
                        <i id="appid_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="tenant" class="form-label form-item-required"><?= _("Directory (tenant) ID") ?> <?= xi6_info_tooltip(_("Azure Directory (tenant) ID (GUID), of your organization or domain")) ?></label>
                    <div class="input-group position-relative">
                        <input type="text" name="tenant" id="tenant" value="<?= encode_form_val($tenant) ?>" class="form-control rounded-end monitor" placeholder="<?= _("Enter Directory (tenant) ID") ?>" required>
                        <div class="invalid-feedback">
                            Please enter the Directory (tenant) ID.
                        </div>
                        <i id="tenant_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <div id="setPassword" class="row mb-2">
                <div class="col-sm-6">
                    <label for="password" class="form-label form-item-required"><?= _("Client Secret") ?> <?= xi6_info_tooltip(_("Client secret - plugin authentication credentials, created in Azure AD")) ?></label>
                    <div class="input-group">
                        <input type="password" name="secret" id="password" value="<?= encode_form_val($secret) ?>" class="usermacro-detection form-control" autocomplete="off" placeholder="<?= _("Enter Client Secret") ?>"  required>
                        <button type="button" class="btn btn-outline-secondary btn-show-secret rounded-end tt-bind" id="password-secret" title="<?= _("Show") ?>">
                            <span class="material-symbols-outlined md-22 md-pointer">Visibility</span>
                            <i id="secret_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </button>
                        <div class="invalid-feedback">
                            Please enter the Client Secret.
                        </div>
                    </div>
                </div>
            </div>

        </div> <!-- config -->
    </div> <!-- container -->

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
