    <!--                                   -->
    <!-- The initial data set from Step 1. -->
    <!--                                   -->
    <input type="hidden" id="hostname" name="hostname" value="<?= encode_form_val($hostname) ?>">
    <input type="hidden" id="operation" name="operation" value="<?= encode_form_val($operation) ?>">
    <input type="hidden" id="selectedhostconfig" name="selectedhostconfig" value="<?= encode_form_val($selectedhostconfig) ?>">
    <input type="hidden" id="services_serial" name="services_serial" value="<?= (!empty($services)) ? base64_encode(json_encode($services)) : "" ?>" />
    <input type="hidden" id="serviceargs_serial" name="serviceargs_serial" value="<?= (!empty($serviceargs)) ? base64_encode(json_encode($serviceargs)) : "" ?>" />
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />

    <input type="hidden" name="ip_address" value="<?= encode_form_val($address) ?>">
<?php
    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';

    $services = array();
    if (array_key_exists('snmp_wizard_services', $_SESSION)) {
        $services = $_SESSION['snmp_wizard_services'];
    }
?>
    <div class="container m-0 g-0">

        <h2 class="mb-2"><?= _('Device Details') ?></h2>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="ip_address" class="form-label"><?= _('Device Address') ?> </label>
                <div class="input-group position-relative">
                    <input type="text" name="ip_address" id="ip_address" value="<?= encode_form_val($address) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Device Address") ?>" disabled="on">
                    <i id="ip_address_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="hostname" class="form-label form-item-required"><?= _('Host Name') ?> <?= xi6_info_tooltip(_('The name you would like to have associated with this server or device')) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="hostname" id="hostname" value="<?= encode_form_val($hostname) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Host Name") ?>" >
                    <div class="invalid-feedback">
                        <?= _("Please enter the Host Name") ?>
                    </div>
                    <i id="hostname_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <h2 class="mt-4"><?= _('SNMP Settings') ?></h2>
        <p><?= _('Specify the settings used to monitor the server or device via SNMP') ?></p>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="snmpversion" class="form-label form-item-required"><?= _('SNMP Version') ?> <?= xi6_info_tooltip(_('The SNMP protocol version used to communicate with the device')) ?></label>
                <div class="input-group position-relative">
                    <select name="snmpversion" id="snmpversion" class="form-control form-control-sm form-select form-select-sm monitor rounded" placeholder="<?= _("Select SNMP Version") ?>" >
                        <option value="" disabled selected>Choose a version...</option>
                        <option value="1" <?= is_selected($snmpversion, "1") ?>>1</option>
                        <option value="2c" <?= is_selected($snmpversion, "2c") ?>>2c</option>
                        <option value="3" <?= is_selected($snmpversion, "3") ?>>3</option>
                    </select>
                    <div class="invalid-feedback">
                        <?= _("Please select SNMP Version") ?>
                    </div>
                    <i id="snmpversion_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>
        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="port" class="form-label"><?= _('SNMP Port') ?> <?= xi6_info_tooltip(_('The SNMP port to use, the default is port 161')) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="port" id="port" value="<?= (!empty($port)) ? encode_form_val($port) : "" ?>"  class="form-control form-control-sm monitor rounded" placeholder="161">
                    <div class="invalid-feedback">
                        <?= _("Please enter the SNMP Port") ?>
                    </div>
                    <i id="port_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <h2 class="mt-4 mb-2"><?= _('SNMP Version Settings') ?></h2>

        <div id="auth2">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="snmpcommunity" class="form-label form-item-required"><?= _('SNMP Community') ?> <?= xi6_info_tooltip(_('The SNMP community string required to query the device')) ?></label>
                    <div class="input-group position-relative">
                        <input type="text" name="snmpcommunity" id="snmpcommunity" value="<?= encode_form_val($snmpcommunity) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter SNMP Community") ?>" required >
                        <div class="invalid-feedback">
                            <?= _("Please enter the SNMP Community") ?>
                        </div>
                        <i id="snmpcommunity_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>
        </div>

        <div id="auth3" class="hide">
            <p><?= _('When using SNMP v3 you must specify authentication information') ?></p>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="serviceargs[v3_security_level]" class="form-label form-item-required"><?= _('Security Level') ?> </label>
                    <div class="input-group position-relative">
                        <select name="serviceargs[v3_security_level]" id="serviceargs[v3_security_level]" class="form-control form-control-sm form-select form-select-sm monitor rounded" placeholder="<?= _("Select Security Level") ?>" >
                            <option value="" disabled selected>Choose a version...</option>
                            <option value="authPriv" <?= is_selected($serviceargs["v3_security_level"], "authPriv") ?>>authPriv</option>
                            <option value="authNoPriv" <?= is_selected($serviceargs["v3_security_level"], "authNoPriv") ?>>authNoPriv</option>
                            <option value="noAuthNoPriv" <?= is_selected($serviceargs["v3_security_level"], "noAuthNoPriv") ?>>noAuthNoPriv</option>
                        </select>
                        <div class="invalid-feedback">
                            <?= _("Please select Security Level") ?>
                        </div>
                        <i id="serviceargs_v3_security_level_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="serviceargs[v3_username]" class="form-label form-item-required"><?= _('Username') ?> </label>
                    <div class="input-group position-relative">
                        <input type="text" name="serviceargs[v3_username]" id="serviceargs[v3_username]" value="<?= encode_form_val($serviceargs['v3_username']) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Username") ?>" >
                        <div class="invalid-feedback">
                            <?= _("Please enter the Username") ?>
                        </div>
                        <i id="serviceargs_v3_username_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="serviceargs[v3_auth_password]" class="form-label form-item-required"><?= _('Authentication Password') ?> </label>
                    <div class="input-group position-relative">
                        <input type="text" name="serviceargs[v3_auth_password]" id="serviceargs[v3_auth_password]" value="<?= encode_form_val($serviceargs['v3_auth_password']) ?>" class="form-control form-control-sm monitor rounded noAuthNoPriv-disable" placeholder="<?= _("Enter Authentication Password") ?>" >
                        <div class="invalid-feedback">
                            <?= _("Please enter the Password") ?>
                        </div>
                        <i id="serviceargs_v3_auth_password_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="serviceargs[v3_auth_proto]" class="form-label form-item-required"><?= _('Authentication Protocol') ?> </label>
                    <div class="input-group position-relative">
                        <select name="serviceargs[v3_auth_proto]" id="serviceargs[v3_auth_proto]" class="form-control form-control-sm form-select form-select-sm monitor rounded" placeholder="<?= _("Select Authentication Protocol") ?>" >
                            <option value="" disabled selected>Choose a version...</option>
                            <option value="" <?= is_selected($serviceargs["v3_auth_proto"], "") ?>>None</option>
                            <option value="md5" <?= is_selected($serviceargs["v3_auth_proto"], "md5") ?>>MD5</option>
                            <option value="sha" <?= is_selected($serviceargs["v3_auth_proto"], "sha") ?>>SHA</option>
                        </select>
                        <div class="invalid-feedback">
                            <?= _("Please select Authentication Protocol") ?>
                        </div>
                        <i id="serviceargs_v3_auth_proto_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="serviceargs[v3_privacy_password]" class="form-label form-item-required"><?= _('Privacy Password') ?> </label>
                    <div class="input-group position-relative">
                        <input type="text" name="serviceargs[v3_privacy_password]" id="serviceargs[v3_privacy_password]" value="<?= encode_form_val($serviceargs['v3_privacy_password']) ?>" class="form-control form-control-sm monitor rounded noAuthNoPriv-disable" placeholder="<?= _("Enter Privacy Password") ?>" >
                        <div class="invalid-feedback">
                            <?= _("Please enter the Privacy Password") ?>
                        </div>
                        <i id="serviceargs_v3_privacy_password_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="serviceargs[v3_priv_proto]" class="form-label form-item-required"><?= _('Privacy Protocol') ?> </label>
                    <div class="input-group position-relative">
                        <select name="serviceargs[v3_priv_proto]" id="serviceargs[v3_priv_proto]" class="form-control form-control-sm form-select form-select-sm monitor rounded" placeholder="<?= _("Select Privacy Protocol") ?>" >
                            <option value="" disabled selected>Choose a version...</option>
                            <option value="" <?= is_selected($serviceargs["v3_priv_proto"], "") ?>>None</option>
<?php
    $xisys = $cfg['root_dir'] . '/var/xi-sys.cfg';
    $ini = parse_ini_file($xisys);

    $des_option = '';

    if ($ini['dist'] != "el9" && $ini['dist'] != "ubuntu22") {
?>
                            <option value="des" <?= is_selected($serviceargs["v3_priv_proto"], "des") ?>>DES</option>
<?php
    }
?>
                            <option value="aes" <?= is_selected($serviceargs["v3_priv_proto"], "aes") ?>>AES</option>
                        </select>
                        <div class="invalid-feedback">
                            <?= _("Please select Privacy Protocol") ?>
                        </div>
                        <i id="serviceargs_v3_priv_proto_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>
        </div> <!-- auth3 -->
        
        <h2 class="mt-4"><?= _('SNMP Services') ?></h2>
        <p class= "mb-0"><?= _('Specify any OIDs you would like to monitor via SNMP. Sample entries have been provided as examples') ?></p>

        <div class="adddeleterow">
             <div class="row">
                <div class="col-sm-12">
                    <fieldset class="row g-2 mb-1">
                        <div class="d-flex align-items-end form-check col-sm-2 pe-1">
                            <div class="input-group input-group-sm">
                                <label class="form-check-label bold"><?= _('OID') ?> <?= xi6_info_tooltip(_('Enter the Object Identifier (OID) for the SNMP variable you want to monitor. This is a unique identifier in the MIB hierarchy.')) ?></label>
                            </div>
                        </div>
                        <div class="d-flex align-items-end col-sm-2 p-0 pe-1">
                            <label class="form-check-label bold"><?= _('Display Name') ?> <?= xi6_info_tooltip(_('Specify a name for this monitoring service.')) ?></label>
                        </div>
                        <div class="d-flex align-items-end col-sm-1 p-0 pe-1">
                            <label class="form-check-label bold"><?= _('Data Label') ?> <?= xi6_info_tooltip(_('Define a label for the data collected from this OID. This will help identify the data in performance graphs and reports.')) ?></label>
                        </div>
                        <div class="d-flex align-items-end col-sm-1 p-0 pe-1">
                            <label class="form-check-label bold"><?= _('Data Units (Optional)') ?> <?= xi6_info_tooltip(_('Optionally, specify the units for the collected data (e.g., %, MB, ms). This makes interpreting the results easier in graphs and dashboards.')) ?></label>
                        </div>
                        <div class="d-flex align-items-end col-sm-1 p-0 pe-1 text-center">
                            <label class="form-check-label bold"><?= _('Match Type') ?></label>
                        </div>
                        <div class="d-flex align-items-end col-sm-1 p-0 pe-1 text-center">
                            <label class="form-check-label bold"><?= _('Warning Range') ?> <?= xi6_info_tooltip(_('Use the following syntax to define value ranges for the thresholds:<br>10 -> alert triggered when outside range of {0 .. 10}<br> 10: -> alert triggered when outside range of {10 .. inf}<br> ~10 -> alert triggered when outside range of {-inf .. 10}<br>10:20 -> alert triggered when outside range of {10 .. 20}<br> @10:20 -> alert triggered when inside range of {10 .. 20}')) ?></label>
                        </div>
                        <div class="d-flex align-items-end col-sm-1 p-0 pe-1">
                            <label class="form-check-label bold text-center"><?= _('Critical Range') ?> <?= xi6_info_tooltip(_('Use the following syntax to define value ranges for the thresholds:<br>10 -> alert triggered when outside range of {0 .. 10}<br> 10: -> alert triggered when outside range of {10 .. inf}<br> ~10 -> alert triggered when outside range of {-inf .. 10}<br>10:20 -> alert triggered when outside range of {10 .. 20}<br> @10:20 -> alert triggered when inside range of {10 .. 20}')) ?></label>
                        </div>
                        <div class="d-flex align-items-end col-sm-1 p-0 pe-1">
                            <label class="form-check-label bold"><?= _('String To Match') ?> <?= xi6_info_tooltip(_('If monitoring text-based SNMP data, enter the exact string you expect. An alert will trigger if the string doesnt match the received SNMP data.')) ?></label>
                        </div>
                        <div class="d-flex align-items-end col-sm-2 p-0 pe-1">
                            <label class="form-check-label bold"><?= _('MIB To Use') ?> <?= xi6_info_tooltip(_('Enter the name of the Management Information 
Base (MIB) file to use for decoding the OID.')) ?></label>
                        </div>
                    </fieldset>
                </div>
            </div>
<?php
    for ($x = 0; $x < count($serviceargs["oid"]); $x++) {
?>
             <div class="row">
                <div class="col-sm-12">
                    <fieldset class="row g-2 mb-1 wz-fieldset">
                        <div class="form-check col-sm-2 mt-0 pe-1">
                            <div class="input-group input-group-sm">
                                <input type="checkbox" class="form-check-input mt-2 me-2" name="services[oid][<?= $x ?>]" <?= is_checked($services['oid'][$x], "on") ?>>
                                <input type="text" name="serviceargs[oid][<?= $x ?>][oid]" id="serviceargs[oid][<?= $x ?>][oid]" value="<?= encode_form_val($serviceargs['oid'][$x]['oid']) ?>" class="form-control form-control-sm rounded monitor">
                                <i id="serviceargs_oid_<?= $x ?>_oid_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                        <div class="col-sm-2 mt-0 p-0 pe-1">
                            <input type="text" name="serviceargs[oid][<?= $x ?>][name]" id="serviceargs[oid][<?= $x ?>][name]" value="<?= encode_form_val($serviceargs['oid'][$x]['name']) ?>" class="form-control form-control-sm rounded monitor">
                            <i id="serviceargs_oid_<?= $x ?>_name_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                        <div class="col-sm-1 mt-0 p-0 pe-1">
                            <input type="text" name="serviceargs[oid][<?= $x ?>][label]" id="serviceargs[oid][<?= $x ?>][label]" value="<?= encode_form_val($serviceargs['oid'][$x]['label']) ?>" class="form-control form-control-sm rounded monitor">
                            <i id="serviceargs_oid_<?= $x ?>_label_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                        <div class="col-sm-1 mt-0 p-0 pe-1">
                            <input type="text" name="serviceargs[oid][<?= $x ?>][units]" id="serviceargs[oid][<?= $x ?>][units]" value="<?= encode_form_val($serviceargs['oid'][$x]['units']) ?>" class="form-control form-control-sm">
                            <i id="serviceargs_oid_<?= $x ?>_units_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                        <div class="col-sm-1 mt-0 p-0 pe-1">
                            <select name="serviceargs[oid][<?= $x ?>][matchtype]" id="serviceargs[oid][<?= $x ?>][matchtype]" class="form-control form-control-sm form-select form-select-sm">
                                <option value="none" <?= is_selected($serviceargs["oid"][$x]["matchtype"], "none") ?>><?= _('None') ?></option>
                                <option value="numeric" <?= is_selected($serviceargs["oid"][$x]["matchtype"], "numeric") ?>><?= _('Numeric') ?></option>
                                <option value="string" <?= is_selected($serviceargs["oid"][$x]["matchtype"], "string") ?>><?= _('String') ?></option>
                            </select>
                            <i id="serviceargs_oid_<?= $x ?>_matchtype_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                        <div class="col-sm-1 mt-0 p-0 pe-1">
                            <input type="text" name="serviceargs[oid][<?= $x ?>][warning]" id="serviceargs[oid][<?= $x ?>][warning]" value="<?= encode_form_val($serviceargs['oid'][$x]['warning']) ?>" class="form-control form-control-sm">
                            <i id="serviceargs_oid_<?= $x ?>_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                        <div class="col-sm-1 mt-0 p-0 pe-1">
                            <input type="text" name="serviceargs[oid][<?= $x ?>][critical]" id="serviceargs[oid][<?= $x ?>][critical]" value="<?= encode_form_val($serviceargs['oid'][$x]['critical']) ?>" class="form-control form-control-sm">
                            <i id="serviceargs_oid_<?= $x ?>_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                        <div class="col-sm-1 mt-0 p-0 pe-1">
                            <input type="text" name="serviceargs[oid][<?= $x ?>][string]" id="serviceargs[oid][<?= $x ?>][string]" value="<?= encode_form_val($serviceargs['oid'][$x]['string']) ?>" class="form-control form-control-sm">
                            <i id="serviceargs_oid_<?= $x ?>_string_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                        <div class="col-sm-2 mt-0 p-0 pe-1">
                            <input type="text" name="serviceargs[oid][<?= $x ?>][mib]" id="serviceargs[oid][<?= $x ?>][mib]" value="<?= encode_form_val($serviceargs['oid'][$x]['mib']) ?>" class="form-control form-control-sm">
                            <i id="serviceargs_oid_<?= $x ?>_mib_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </fieldset>
                </div>
            </div>
<?php
    }
?>
        </div>
    </div> <!-- container -->

    <script type="text/javascript">
        $(document).ready(function() {

            // Initial check
            update_security_display();
            select_default_proto();

            // Detection
            $("#snmpversion").change(function() {
                update_security_display();
            });

            $("[name='serviceargs[v3_security_level]']").change(function() {
                select_default_proto();
            });

            function update_security_display(version_val) {
                var version_val = $("#snmpversion").val();

                if (version_val == "3") {
                    $("#auth3").show();
                    $("#auth2").hide();
                } else {
                    $("#auth3").hide();
                    $("#auth2").show();
                }
            }

            function select_default_proto(level_val) {
                var level_val = $("[name='serviceargs[v3_security_level]']").val();

                if (level_val == "noAuthNoPriv") {
                    $("[name='serviceargs[v3_auth_proto]']").val("");
                    $("[name='serviceargs[v3_priv_proto]']").val("");
                } else if (level_val == "authNoPriv") {
                    $("[name='serviceargs[v3_auth_proto]']").val("md5");
                    $("[name='serviceargs[v3_priv_proto]']").val("");
                } else if (level_val == "authPriv") {
                    $("[name='serviceargs[v3_auth_proto]']").val("md5");
                    $("[name='serviceargs[v3_priv_proto]']").val("des");
                }
            }

            security_level = $(".security_level").val();
            enable_fields_by_security_level(security_level);
            $(".security_level").change(function () {
                enable_fields_by_security_level($(this).val());
            });
        });

        function enable_fields_by_security_level(level) {
            $("." + level + "-enable").attr("disabled", false);
            $("." + level + "-disable").attr("disabled", true);
        }
    </script>

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
