    <!--                                   -->
    <!-- The initial data set from Step 1. -->
    <!--                                   -->
    <input type="hidden" id="hostname" name="hostname" value="<?= encode_form_val($hostname) ?>">
    <input type="hidden" id="operation" name="operation" value="<?= encode_form_val($operation) ?>">
    <input type="hidden" id="selectedhostconfig" name="selectedhostconfig" value="<?= encode_form_val($selectedhostconfig) ?>">
    <input type="hidden" id="services_serial" name="services_serial" value="<?= (!empty($services)) ? base64_encode(json_encode($services)) : "" ?>" />
    <input type="hidden" id="serviceargs_serial" name="serviceargs_serial" value="<?= (!empty($serviceargs)) ? base64_encode(json_encode($serviceargs)) : "" ?>" />
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />

    <input type="hidden" name="ip_address" value="<?= encode_form_val($address) ?>">
    <input type="hidden" name="port" value="<?= encode_form_val($port) ?>">
    <input type="hidden" name="username" value="<?= encode_form_val($username) ?>">
    <input type="hidden" name="password" value="<?= encode_form_val($password) ?>">
    <input type="hidden" name="database" value="<?= encode_form_val($database) ?>">
<?php
    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';
?>
    <div class="container m-0 g-0">

        <h2 class="mb-2"><?= _('MySQL Server') ?></h2>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="ip_address" class="form-label"><?= _('Address') ?> </label>
                <div class="input-group position-relative">
                    <input type="text" name="ip_address" id="ip_address" value="<?= encode_form_val($address) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Address") ?>" disabled="on">
                    <div class="invalid-feedback">
                        <?= _("Please enter the ".$labelText) ?>
                    </div>
                    <i id="ip_address_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="hostname" class="form-label"><?= _('Host Name') ?> <?= xi6_info_tooltip(_("The name you want associated with the MySQL server")) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="hostname" id="hostname" value="<?= encode_form_val($hostname) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Host Name") ?>" >
                    <div class="invalid-feedback">
                        <?= _("Please enter the ".$labelText) ?>
                    </div>
                    <i id="hostname_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="port" class="form-label"><?= _('Port') ?> </label>
                <div class="input-group position-relative">
                    <input type="text" name="port" id="port" value="<?= encode_form_val($port) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Port") ?>" disabled="on">
                    <div class="invalid-feedback">
                        <?= _("Please enter the ".$labelText) ?>
                    </div>
                    <i id="port_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="username" class="form-label"><?= _('Username') ?> </label>
                <div class="input-group position-relative">
                    <input type="text" name="username" id="username" value="<?= encode_form_val($username) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Username") ?>" disabled="on">
                    <div class="invalid-feedback">
                        <?= _("Please enter the ".$labelText) ?>
                    </div>
                    <i id="username_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="password" class="form-label"><?= _('Password') ?> </label>
                <div class="input-group input-group-sm">
                    <input type="password" name="password" id="password" value="<?= encode_form_val($password) ?>" class="usermacro-detection form-control form-control-sm rounded-start" autocomplete="off" placeholder="<?= _("Enter Password") ?>" >
                    <button type="button" class="btn btn-outline-secondary btn-show-secret rounded-end" id="password-secret" title="<?= _("Show Password") ?>">
                        <span class="material-symbols-outlined md-22 md-pointer">Visibility</span>
                        <i id="password_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </button>
                    <div class="invalid-feedback">
                        <?= _("Please enter the ".$labelText) ?>
                    </div>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="database" class="form-label"><?= _('Database') ?> </label>
                <div class="input-group position-relative">
                    <input type="text" name="database" id="database" value="<?= encode_form_val($database) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Database") ?>" disabled="on">
                    <div class="invalid-feedback">
                        <?= _("Please enter the ".$labelText) ?>
                    </div>
                    <i id="database_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <h2 class="mt-4"><?= _('MySQL Query') ?></h2>
        <p><?= _("Specify the details of the query you'd like to monitor") ?>.</p>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="queryname" class="form-label"><?= _('Query Name') ?> <?= xi6_info_tooltip(_('A friendly name for the SQL query')) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="queryname" id="queryname" value="<?= encode_form_val($queryname) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Query Name") ?>" >
                    <div class="invalid-feedback">
                        <?= _("Please enter the ".$labelText) ?>
                    </div>
                    <i id="queryname_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="query" class="form-label"><?= _('Query') ?> <?= xi6_info_tooltip(_('The SQL query to run. Must return an integer')) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="query" id="query" value="<?= encode_form_val($query) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Query") ?>" style="width: 650px;">
                    <div class="invalid-feedback">
                        <?= _("Please enter the ".$labelText) ?>
                    </div>
                    <i id="query_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="warning" class="form-label"><?= _('Warning') ?> <?= xi6_info_tooltip(_('An optional warning threshold to use when checking the result of the SQL query')) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="warning" id="warning" value="<?= encode_form_val($warning) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Warning") ?>" >
                    <div class="invalid-feedback">
                        <?= _("Please enter the ".$labelText) ?>
                    </div>
                    <i id="warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="critical" class="form-label"><?= _('Critical') ?> <?= xi6_info_tooltip(_('An optional critical threshold to use when checking the result of the SQL query')) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="critical" id="critical" value="<?= encode_form_val($critical) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Critical") ?>" >
                    <div class="invalid-feedback">
                        <?= _("Please enter the ".$labelText) ?>
                    </div>
                    <i id="critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

    </div> <!-- container -->

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
