<?php
namespace api\v2\admin;
use api\v2\Base;

use function api\v2\import_common;
import_common();

class snmpwalk extends Base {

    public function authorized_for_get() {
        return true;
    }

    public function authorized_for_post() {
        return true;
    }

    public function authorized_for_delete() {
        return true;
    }

    public function get() {
        return get_all_snmpwalk_jobs();
    }

    // create SNMP Walk job
    public function post() {
        $script_dir =  get_root_dir() . "/scripts";
        $output_file_dir = get_tmp_dir();
        $snmp_args['device_address'] = grab_request_var('device_address', '');
        $snmp_args['device_port'] = grab_request_var('device_port', 161);
        $snmp_args['snmp_version'] = grab_request_var('snmp_version', '2c');
        $snmp_args['snmp_community'] = grab_request_var('snmp_community', 'public');
        $snmp_args['oid'] = grab_request_var('oid', '');
        $snmp_args['timeout'] = grab_request_var('timeout', 15);
        $snmp_args['max_results'] = grab_request_var('max_results', '');
        $snmp_args['mib_scan_options'] = grab_request_var('mib_scan_options', '');

        // set SNMP v1/2 args
        $snmp_v2_args = '';
        if (($snmp_args['snmp_version'] == '1' || $snmp_args['snmp_version'] == '2c') && !empty($snmp_args['snmp_community'])) {
            $snmp_v2_args = " --snmp_community=" . escapeshellarg($snmp_args['snmp_community']);
        }

        // set SNMP v3 args
        $snmp_v3_args = '';
        if ($snmp_args['snmp_version'] == "3") {

            $snmp_v3_args .= " --v3_security_level=" . escapeshellarg(grab_request_var('security_level', 'authPriv'));
            $snmp_v3_args .= " --v3_username=" . escapeshellarg(grab_request_var('username', ''));
            $snmp_v3_args .= " --v3_auth_password=" . escapeshellarg(grab_request_var('auth_password', 'MD5'));
            $snmp_v3_args .= " --v3_auth_protocol=" . escapeshellarg(grab_request_var('auth_protocol', ''));
            $snmp_v3_args .= " --v3_privacy_password=" . escapeshellarg(grab_request_var('privacy_password', ''));
            $snmp_v3_args .= " --v3_privacy_protocol=" . escapeshellarg(grab_request_var('privacy_protocol', 'AES'));
        }

        // ensure only one set of version arguments are accepted
        if ($snmp_v2_args && $snmp_v3_args) {
            $snmp_v2_args = '';
        }

        $oid_args = (!empty($snmp_args['oid'])) ? " --oid=" . escapeshellarg($snmp_args['oid']) : '';

        $command = $script_dir . "/start_snmpwalk_job.sh " . 
         " --device_address=" . escapeshellarg($snmp_args['device_address']) .
         " --device_port=" . escapeshellarg($snmp_args['device_port']) .
         " --snmp_version=" . escapeshellarg($snmp_args['snmp_version']) .
         " --timeout=" . escapeshellarg($snmp_args['timeout']) .
         " --max_results=" . escapeshellarg($snmp_args['max_results']) .
         " --output_dir=" . escapeshellarg($output_file_dir) .
         " --oid_scan_options=" . escapeshellarg($snmp_args['oid']) .
         $snmp_v2_args .
         $snmp_v3_args;

        $result = exec($command);
    }

    // delete SNMP Walk job (and PID file)
    public function delete() {
        $hostname = grab_request_var('hostname', null);
        $date = grab_request_var('date', null);

        if (!is_null($hostname) && !is_null($date)) {
            $job_file_dir = get_tmp_dir();
            $job_pattern = $job_file_dir . '/snmpwalk_' . $hostname . '_' . $date;

            $job_location = $job_pattern . '.log';
            $pid_location = $job_pattern . '.pid';

            if (file_exists($job_location)) {
                unlink($job_location);
                if (file_exists($pid_location)) {
                    unlink($pid_location);
                }
            } else {
                return "No job file found, unable to delete.";
            }
        } else {
            return "Hostname and date are required.";
        }
    }
}
