<?php

require_once(dirname(__FILE__) . '/../../../includes/utils.inc.php');
require_once(dirname(__FILE__) . '/../../../../includes/auth.inc.php');

header("Content-Type: application/json");

if (!is_authenticated()) {
    echo json_encode(["error" => "Unauthorized"]);
    exit;
}

$xml = get_xml_sysstat_data();
if (!$xml) {
    echo json_encode(["error" => "get_xml_sysstat_data() returned null"]);
    exit;
}

$response = [
    "load" => [
        "load1" => floatval($xml->load->load1),
        "load5" => floatval($xml->load->load5),
        "load15" => floatval($xml->load->load15),
    ],
    "iostat" => array_map('floatval', (array) $xml->iostat),
    "memory" => array_map('intval', (array) $xml->memory),
    "swap" => array_map('intval', (array) $xml->swap),
];

echo json_encode($response);
exit;
