<?php
    
// Set info language strings
$infolang["domain"]["domain"] = _('Common name of this domain. This field is for internal use only.');
$infolang["domain"]["basedir"] = '<p>'._('Absolute path to your NagiosQL configuration directory.').'<br><br>'._('Examples:').'<br>/etc/nagiosql/ <br>/usr/local/nagiosql/etc/<br><br>'._('Be sure, that your configuration path settings are matching with your').' nagios.cfg! (cfg_file=<span style="color: red;">/etc/nagiosql</span>/timeperiods.cfg)</p>';
$infolang["domain"]["hostdir"] = _('NagiosQL writes one configuration file for every host. It is useful to store this files inside an own subdirectory below your Nagios configuration path.').'<br><br>'._('Examples:').'<br>/etc/nagios/hosts <br>/usr/local/nagios/etc/hosts<br><br>'._('Be sure, that your configuration settings are matching with your').' nagios.cfg!<br> (cfg_dir=<font color="red">/etc/nagios/hosts</font>)';
$infolang["domain"]["servicedir"] = _('NagiosQL writes services grouped into files identified by the service configuration names. It is useful to store this files inside an own subdirectory below your Nagios configuration path.').'<br><br>'._('Examples').':<br>/etc/nagios/services <br>/usr/local/nagios/etc/services<br><br>'._('Be sure, that your configuration settings are matching with your').' nagios.cfg!<br> (cfg_dir=<font color="red">/etc/nagios/services</font>)';
$infolang["domain"]["backupdir"] = ''._('Absolute path to your NagiosQL configuration backup directory').'.<br><br>'._('Examples').':<br>/etc/nagios/backup <br>/usr/local/nagios/etc/backup<br><br>'._('This directory is for internal configuration backups of NagiosQL and is not used by Nagios itself.').' ';
$infolang["domain"]["backuphostdir"] = ''._('Absolute path to your NagiosQL host configuration backup directory.').'<br><br>'._('Examples').':<br>/etc/nagios/backup/hosts <br>/usr/local/nagios/etc/backup/hosts<br><br>'._('This directory is for internal configuration backups of NagiosQL only and is not used by Nagios itself.').'';
$infolang["domain"]["backupservicedir"] = ''._('Absolute path to your NagiosQL service configuration backup directory.').'<br><br>'._('Examples:').'<br>/etc/nagios/backup/services <br>/usr/local/nagios/etc/backup/services<br><br>'._('This directory is for internal configuration backups of NagiosQL only and is not used by Nagios itself.').'';
$infolang["domain"]["commandfile"] = ''._('Absolute path to your Nagios command file.').'<br><br>'._('Examples:').'<br>/var/spool/nagios/nagios.cmd<br>/usr/local/nagios/var/rw/nagios.cmd<br><br>'._('Be sure, that your command file path settings are matching with your').' nagios.cfg! (command_file=<font color="red">/var/spool/nagios/nagios.cmd</font>)<br>(check_external_commands=1)<br><br>'._('This is used to reload Nagios directly from NagiosQL after changing a configuration.').'';
$infolang["common"]["accesskeys"] = '<p><strong>'._('Access key/keyholes').'</strong></p><p>'._('NagiosQL uses a very simplified access control mechanism by using up to 8 keys.').'</p><p>'._('To access a secure object (menu, domain), a user must have a key for every defined keyhole.').'</p><p><em>'._('Example:').'</em></p><p>'._('User A has key 1,2,5,7 (can be defined in user management)<br>User B has key 3,5,7,8 (can be defined in user management)').'</p><p>'._('Menu 1 has keyhole 3,5<br>Menu 2 has keyhole 2,5,7').'<br>'._('Menu 3 has no keyhole').'<br>'._('Menu 4 has keyhole 4').'<br><br>'._('User A has access to menu 2 and menu 3 (key 3 for menu 1 and key 4 for menu 4 are missing)').'<br>'._('User B has access to menu 1 and menu 3 (key 2 for menu 2 and key 4 for menu 4 are missing)').'</p><p>&nbsp;</p><p>&nbsp;</p>';
$infolang["user"]["webserverauth"] = '<p><strong>'._('User - webserver authentification').'</strong></p><p>'._('If your webserver uses authentification and the NagiosQL user name is the same which is actually logged in - the NagiosQL login process will passed. This means, that NagiosQL no longer shows a login page if this user is already logged in by webserver authentification.').'</p><p><span style="color: #ff0000;">'._('This function will be implemented in a future NagiosQL version. Actually, this option is not implemented!').'</span></p>';
$infolang["domain"]["nagiosbasedir"] = '<p>'._('Absolute path to your Nagios configuration directory.').'<br><br>Examples:'._('Examples:').'<br>/etc/nagios/ <br>/usr/local/nagios/etc/</p><p>'._('Be sure, that your').' <span style="color: #ff0000;">nagios.cfg</span> '._('and').' <span style="color: #ff0000;">cfg.cfg</span> '._('ist located inside this directory. NagiosQL uses this to handle this two files.').'</p>';
$infolang["domain"]["importdir"] = '<p>'._('Absolute path to your configuration import directory.').'<br><br>'._('Examples:').'<br>/etc/nagiosql/import/ <br>/usr/local/nagios/etc/import/</p><p>'._('You can use this directory to store old or example configuration files in it which should be accessable by the importer of NagiosQL.').'</p>';
$infolang["domain"]["binary"] = '<p>'._('Absolute path to your Nagios binary file.').'<br><br>Examples:<br>/usr/bin/nagios<br>/usr/local/nagios/bin/nagios<br><br> '._('This is used to verify your configuration.').'</p>';
$infolang["domain"]["pidfile"] = '<p>'._('Absolute path to your Nagios process file.').'<br><br>'._('Examples:').'<br>/var/run/nagios/nagios.pid<br>/var/run/nagios/nagios.lock<br><br> '._('This is used to check if nagios is running before sending a reload command to the nagios command file.').'</p>';
$infolang["domain"]["version"] = '<p>'._('The nagios version which is running in this domain.').'</p><p>'._('Be sure you select the correct version here - otherweise not all configuration options are available or not supported options are shown.').'</p><p>'._('You can change this with a running configuration - NagiosQL will then upgrade or downgrade your configuration. Don\'t forget to write your complete configuration after a version change!').'</p>';
$infolang["host"]["hostname"] = '<p><strong>'._('Host - host name').'</strong><br><br>'._('This directive is used to define a short name used to identify the host. It is used in host group and service definitions to reference this particular host. Hosts can have multiple services (which are monitored) associated with them. When used properly, the').' $HOSTNAME$ '._('macro will contain this short name.').'</p><p><em>'._('Parameter name:').'</em> host_name<br><em>'._('Required:').'</em> '._('yes').'</p>';
$infolang["host"]["alias"] = '<p><strong>'._('Host - alias').'</strong><br><br>'._('This directive is used to define a longer name or description used to identify the host. It is provided in order to allow you to more easily identify a particular host. When used properly, the').' $HOSTALIAS$ '._('macro will contain this alias/description.').'</p><p><em>'._('Parameter name:').'</em> alias<br><em>'._('Required:').'</em> '._('yes').'</p>';
$infolang["host"]["address"] = '<p><strong>'._('Host - address').'</strong></p><p>'._('This directive is used to define the address of the host. Normally, this is an IP address, although it could really be anything you want (so long as it can be used to check the status of the host). You can use a FQDN to identify the host instead of an IP address, but if DNS services are not availble this could cause problems. When used properly, the $HOSTADDRESS$ macro will contain this address.</p><p><strong>Note:</strong> If you do not specify an address directive in a host definition, the name of the host will be used as its address. A word of caution about doing this, however - if DNS fails, most of your service checks will fail because the plugins will be unable to resolve the host name.').'</p><p><em>'._('Parameter name:').'</em> address<br><em>'._('Required:').'</em> '._('yes').'</p>';
$infolang["host"]["display_name"] = '<p><strong>'._('Host - display name').'</strong></p><p>'._('This directive is used to define an alternate name that should be displayed in the web interface for this host. If not specified, this defaults to the value you specify for the').' <em>host_name</em> '._('directive.').'</p><p><strong>'._('Note:').'</strong> '._('The current CGIs do not use this option, although future versions of the web interface will.').'</p><p><em>'._('Parameter name:').'</em> display_name<br><em>'._('Required:').'</em> '._('no').'</p>';
$infolang["host"]["parents"] = '<p><strong>'._('Host - parents').'</strong></p><p>'._('This directive is used to define a comma-delimited list of short names of the "parent" hosts for this particular host. Parent hosts are typically routers, switches, firewalls, etc. that lie between the monitoring host and a remote hosts. A router, switch, etc. which is closest to the remote host is considered to be that host\'s "parent". Read the "Determining Status and Reachability of Network Hosts" document for more information.</p><p>If this host is on the same network segment as the host doing the monitoring (without any intermediate routers, etc.) the host is considered to be on the local network and will not have a parent host. Leave this value blank if the host does not have a parent host (i.e. it is on the same segment as the Nagios host). The order in which you specify parent hosts has no effect on how things are monitored.').'</p><p><em>'._('Parameter name:').'</em> parents<br><em>'._('Required:').'</em> '._('no').'</p>';
$infolang["host"]["hostgroups"] = '<p><strong>'._('Host - hostgroup names').'</strong></p><p>'._('This directive is used to identify the').' <em>'._('short name(s)').'</em> '._('of the hostgroup(s) that the host belongs to. Multiple hostgroups should be separated by commas. This directive may be used as an alternative to (or in addition to) using the members directive in hostgroup definitions.').'<span style="color: #ff0000;"><span style="color: #000000;"> </span></span></p><p><span><span><strong>NagiosQL:</strong> '._('If a hostgroup is defined here - this host will').'<strong>'._(' not be selected').'</strong> '._('inside the member field of the same hostgroup definition!').' <br></span></span></p><p><em>'._('Parameter name:').'</em> hostgroups<br><em>'._('Required:').'</em> '._('no').'</p>';
$infolang["common"]["tploptions"] = '<p><strong>'._('Cancelling Inheritance of String Values').'</strong></p><p>'._('In some cases you may not want your host, service, or contact definitions to inherit values of string variables from the templates they reference. If this is the case, you can specify ').'"<strong>null</strong>" '._('as the value of the variable that you do not want to inherit.').'</p><p><strong><br>'._('Additive Inheritance of String Values').'</strong></p><p>'._('Nagios gives preference to local variables instead of values inherited from templates. In most cases local variable values override those that are defined in templates. In some cases it makes sense to allow Nagios to use the values of inherited').' <em>'._('and').'</em> '._('local variables together.').'</p><p>'._('This "additive inheritance" can be accomplished by prepending the local variable value with a plus sign (<strong>+</strong>).  This features is only available for standard (non-custom) variables that contain string values.').'</p>';
$infolang["host"]["check_command"] = '<p><strong>'._('Host - check command').'</strong><br><br>'._('This directive is used to specify the').' <em>'._('short name').'</em> '._('of the command that should be used to check if the host is up or down. Typically, this command would try and ping the host to see if it is "alive". The command must return a status of OK (0) or Nagios will assume the host is down.').'</p><p>'._('If you leave this argument blank, the host will').' <em>'._('not').'</em> '._('be actively checked. Thus, Nagios will likely always assume the host is up (it may show up as being in a "PENDING" state in the web interface). This is useful if you are monitoring printers or other devices that are frequently turned off. The maximum amount of time that the notification command can run is controlled by the host_check_timeout option.').'</p><p><em>'._('Parameter name:').'</em> check_command<br><em>'._('Required:').'</em> '._('no').'</p>';
$infolang["host"]["arguments"] = '<p><strong>'._('Host - arguments').'</strong></p><p>'._('The values defined here will replace the according argument variable behind the selected command. Up to 8 argument variables are supported. Be sure, that you defines a valid value for each required argument variable.').'</p>';
$infolang["host"]["templateadd"] = '<p><strong>'._('Host - Templates').'</strong></p><p>'._('You can add one or more host templates to a host configuration. Nagios will add the definitions from each template to a host configuration.').'</p><p>'._('If you add more than one template - the templates from the bottom to the top will be used to overwrite configuration items which are defined inside templates before.').'</p><p>'._('The host configuration itselves will overwrite all values which are defined in templates before and pass all values which are not defined.').'</p>';
$infolang["host"]["initial_state"] = '<p><strong>'._('Host - initial state').'</strong></p><p>'._('By default Nagios will assume that all hosts are in UP states when in starts. You can override the initial state for a host by using this directive. Valid options are:').' <strong><br>o</strong> = '._('UP, ').'<br><strong>d</strong> = '._('DOWN, and').' <br><strong>u</strong> = '._('UNREACHABLE.').'</p><p><em>'._('Parameter name:').'</em> initial_state<em><br>Required:</em> no</p><p>&nbsp;</p>';
$infolang["host"]["retry_interval"] = '<p><strong>'._('Host - retry interval').'</strong></p><p>'._('This directive is used to define the number of "time units" to wait before scheduling a re-check of the hosts. Hosts are rescheduled at the retry interval when they have changed to a non-UP state. Once the host has been retried').' <strong>max_check_attempts</strong> '._('times without a change in its status, it will revert to being scheduled at its "normal" rate as defined by the').' <strong>check_interval</strong> '._('value. Unless you\'ve changed the interval_length directive from the default value of 60, this number will mean minutes.  More information on this value can be found in the check scheduling documentation.').'</p><p><em>'._('Parameter name:').'</em> retry_interval<em><br>Required:</em> no</p>';
$infolang["host"]["max_check_attempts"] = '<p><strong>'._('Host - max check attempts').'</strong></p><p>'._('This directive is used to define the number of times that Nagios will retry the host check command if it returns any state other than an OK state. Setting this value to 1 will cause Nagios to generate an alert without retrying the host check again. Note: If you do not want to check the status of the host, you must still set this to a minimum value of 1. To bypass the host check, just leave the').' <em>check_command</em> '._('option blank.').'</p><p><em>'._('Parameter name:').'</em> max_check_attempts<em><br>'._('Required:').'</em> '._('yes').'</p>';
$infolang["host"]["check_interval"] = '<p><strong>'._('Host - check interval').'</strong></p><p>'._('This directive is used to define the number of "time units" between regularly scheduled checks of the host. Unless you\'ve changed the interval_length directive from the default value of 60, this number will mean minutes.  More information on this value can be found in the check scheduling documentation.').'</p><p><em>'._('Parameter name:').'</em> check_interval<em><br>'._('Required:').'</em> '._('no').'</p>';
$infolang["host"]["active_checks_enabled"] = '<p><strong>'._('Host - active checks enabled').'<br></strong></p><p>'._('This directive is used to determine whether or not active checks (either regularly scheduled or on-demand) of this host are enabled. Values:').' 0 = '._('disable active host checks,').' 1 = '._('enable active host checks.').'</p><p><em>'._('Parameter name:').'</em> active_checks_enabled<br><em>'._('Required:').'</em> '._('no').'</p>';
$infolang["host"]["passive_checks_enabled"] = '<p><strong>'._('Host - passive checks enabled').'<br> </strong></p><p>'._('This directive is used to determine whether or not passive checks are enabled for this host. Values:').' 0 = '._('disable passive host checks,').' 1 = '._('enable passive host checks.').'</p><p><em>'._('Parameter name:').'</em> passive_checks_enabled<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["host"]["check_period"] = '<p><strong>'._('Host - check period').'<br> </strong></p><p'._('>This directive is used to specify the short name of the time period during which active checks of this host can be made.').'</p><p><em>'._('Parameter name:').'</em> check_period<br> <em>'._('Required:').'</em> '._('yes').'</p>';
$infolang["host"]["freshness_threshold"] = '<p><strong>'._('Host - freshness threshold').'<br> </strong></p><p>'._('This directive is used to specify the freshness threshold (in seconds) for this host. If you set this directive to a value of 0, Nagios will determine a freshness threshold to use automatically.').'</p><p><em>'._('Parameter name:').'</em> freshness_threshold<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["host"]["check_freshness"] = '<p><strong>'._('Host - check freshness').'<br> </strong></p><p>'._('This directive is used to determine whether or not freshness checks are enabled for this host. Values:').' 0 = '._('disable freshness checks,').' 1 = '._('enable freshness checks.').'</p><p><em>'._('Parameter name:').'</em> check_freshness<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["host"]["obsess_over_host"] = '<p><strong>'._('Host - obsess over host').'<br> </strong></p><p>'._('This directive determines whether or not checks for the host will be "obsessed" over using the ochp_command.').'</p><p><em>'._('Parameter name:').'</em> obsess_over_host<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["host"]["event_handler"] = '<p><strong>'._('Host - event handler').'<br> </strong></p><p>'._('This directive is used to specify the').' <em>'._('short name').'</em> '._('of the command that should be run whenever a change in the state of the host is detected (i.e. whenever it goes down or recovers). Read the documentation on event handlers for a more detailed explanation of how to write scripts for handling events. The maximum amount of time that the event handler command can run is controlled by the event_handler_timeout option.').'</p><p><em>'._('Parameter name:').'</em> event_handler<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["host"]["event_handler_enabled"] = '<p><strong>'._('Host - event handler enabled').'<br> </strong></p><p>'._('This directive is used to determine whether or not the event handler for this host is enabled. Values:').' 0 = '._('disable host event handler,').' 1 = '._('enable host event handler.').'</p><p><em>'._('Parameter name:').'</em> event_handler_enabled<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["host"]["low_flap_threshold"] = '<p><strong>'._('Host - low flap threshold').'<br> </strong></p><p>'._('This directive is used to specify the low state change threshold used in flap detection for this host. If you set this directive to a value of 0, the program-wide value specified by the ').'low_host_flap_threshold '._('directive will be used.').'</p><p><em>'._('Parameter name:').'</em> low_flap_threshold<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["host"]["high_flap_threshold"] = '<p><strong>'._('Host - high flap threshold').'<br> </strong></p><p>'._('This directive is used to specify the high state change threshold used in flap detection for this host. If you set this directive to a value of 0, the program-wide value specified by the ').'high_host_flap_threshold '._('directive will be used.').'</p><p><em>'._('Parameter name:').'</em> high_flap_threshold<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["host"]["flap_detection_enabled"] = '<p><strong>'._('Host - flap detection enabled').'<br> </strong></p><p>'._('This directive is used to determine whether or not flap detection is enabled for this host. Values:').' 0 = '._('disable host flap detection,').' 1 = '._('enable host flap detection.').'</p><p><em>'._('Parameter name:').'</em> flap_detection_enabled<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["host"]["flap_detection_options"] = '<p><strong>'._('Host - flap detection options').'<br> </strong></p><p>'._('This directive is used to determine what host states the flap detection logic will use for this host.  Valid options are a combination of one or more of the following:').' <strong><br>o</strong> = '._('UP states,').' <br><strong>d</strong> = '._('DOWN states,').' <br><strong>u</strong> =  '._('UNREACHABLE states.').'</p><p><em>'._('Parameter name:').'</em> flap_detection_options<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["host"]["retain_status_information"] = '<p><strong>'._('Host - retain status information').'<br></strong></p><p>'._('This directive is used to determine whether or not status-related information about the host is retained across program restarts. This is only useful if you have enabled state retention using the retain_state_information directive.').'  Value: 0 = '._('disable status information retention,').' 1 = '._('enable status information retention.').'</p><p><em>'._('Parameter name:').'</em> retain_status_information<em><br>Required:</em> no</p>';
$infolang["host"]["retain_nonstatus_information"] = '<p><strong>'._('Host - retain nonstatus information').'<br></strong></p><p>'._('This directive is used to determine whether or not non-status information about the host is retained across program restarts. This is only useful if you have enabled state retention using the retain_state_information directive.').'  Value: 0 = '._('disable non-status information retention,').' 1 = '._('enable non-status information retention.').'</p><p><em>'._('Parameter name:').'</em> retain_nonstatus_information<em><br>Required:</em> no</p>';
$infolang["host"]["contacts"] = '<p><strong>Host - contacts<br></strong></p><p>'._('This is a list of the').' <em>'._('short names').'</em> '._('of the contacts that should be notified whenever there are problems (or recoveries) with this host. Multiple contacts should be separated by commas. Useful if you want notifications to go to just a few people and don\'t want to configure contact groups.  You must specify at least one contact or contact group in each host definition.').'</p><p><em>'._('Parameter name:').'</em> <em>contacs<br>Required:</em> yes (at least one contact <strong>or</strong> contact group)</p>';
$infolang["host"]["contactgroups"] = '<p><strong>'._('Host - contact groups').'<br></strong></p><p>'._('This is a list of the').' <em>'._('short names').'</em> '._('of the contact groups that should be notified whenever there are problems (or recoveries) with this host. Multiple contact groups should be separated by commas. You must specify at least one contact or contact group in each host definition.').'</p><p><em>'._('Parameter name:').'</em> contact_groups<br><em>'._('Required:').'</em> yes (at least one contact <strong>or</strong> contact group)</p>';
$infolang["host"]["notification_period"] = '<p><strong>'._('Host - notification period').'<br></strong></p><p>'._('This directive is used to specify the short name of the time period during which notifications of events for this host can be sent out to contacts. If a host goes down, becomes unreachable, or recoveries during a time which is not covered by the time period, no notifications will be sent out.').'</p><p><em>'._('Parameter name:').'</em> notification_period<br><em>'._('Required:').'</em> '._('yes').'</p>';
$infolang["host"]["notification_options"] = '<p><strong>'._('Host - notification options').'<br></strong></p><p>'._('This directive is used to determine when notifications for the host should be sent out. Valid options are a combination of one or more of the following:').' <br><strong>d</strong> = '._('send notifications on a DOWN state,').' <br><strong>u</strong> = '._('send notifications on an UNREACHABLE state,').' <strong><br>r</strong> = '._('send notifications on recoveries (OK state),').' <br><strong>f</strong> = '._('send notifications when the host starts and stops flapping, and').' <br><strong>s</strong> = '._('send notifications when scheduled downtime starts and ends.').'  <br>'._('If you do not specify any notification options, Nagios will assume that you want notifications to be sent out for all possible states.').'</p><p>'._('Example: If you specify <strong>d,r</strong> in this field, notifications will only be sent out when the host goes DOWN and when it recovers from a DOWN state.').'</p><p><em>'._('Parameter name:').'</em> notification_options<br><em>'._('Required:').'</em> '._('yes').'</p>';
$infolang["host"]["notification_enabled"] = '<p><strong>'._('Host - notification enabled').'<br></strong></p><p>'._('This directive is used to determine whether or not notifications for this host are enabled. Values:').' 0 = '._('disable host notifications,').' 1 = '._('enable host notifications.').'</p><p><em>'._('Parameter name:').'</em> notification_enabled<br><em>'._('Required:').'</em> '._('yes').'</p>';
$infolang["host"]["stalking_options"] = '<p><strong>'._('Host - stalking options').'<br></strong></p><p>'._('This directive determines which host states "stalking" is enabled for. Valid options are a combination of one or more of the following:').' <strong><br>o</strong> = '._('stalk on UP states,').' <br><strong>d</strong> = '._('stalk on DOWN states, and').' <br><strong>u</strong> = '._('stalk on UNREACHABLE states.').'</p><p><em>'._('Parameter name:').'</em> stalking_options<br><em>'._('Required:').'</em> '._('yes').'</p>';
$infolang["host"]["process_perf_data"] = '<p><strong>'._('Host - process performance data').'<br></strong></p><p>'._('This directive is used to determine whether or not the processing of performance data is enabled for this host. Values:').' 0 = '._('disable performance data processing,').' 1 = '._('enable performance data processing.').'</p><p><em>'._('Parameter name:').'</em> process_perf_data<em><br>'._('Required:').'</em> no</p>';
$infolang["host"]["notification_interval"] = '<p><strong>'._('Host - notification interval').'<br></strong></p><p>'._('This directive is used to define the number of "time units" to wait before re-notifying a contact that this service is').' <em>'._('still').'</em> '._('down or unreachable.  Unless you\'ve changed the ').'interval_length '._('directive from the default value of 60, this number will mean minutes.  If you set this value to 0, Nagios will').' <em>'._('not').'</em> '._('re-notify contacts about problems for this host - only one problem notification will be sent out.').'</p><p><em>'._('Parameter name:').'</em> notification_interval<br><em>'._('Required:').'</em> '._('yes').'</p>';
$infolang["host"]["first_notification_delay"] = '<p><strong>'._('Host - first notification delay').'<br></strong></p><p>'._('This directive is used to define the number of "time units" to wait before sending out the first problem notification when this host enters a non-UP state. Unless you\'ve changed the interval_length directive from the default value of 60, this number will mean minutes. If you set this value to 0, Nagios will start sending out notifications immediately.').'</p><p><em>'._('Parameter name:').'</em> first_notification_delay<br><em>'._('Required:').'</em> '._('no').'</p>';
$infolang["host"]["notes"] = '<p><strong>'._('Host - notes').'<br> </strong></p><p>'._('This directive is used to define an optional string of notes pertaining to the host. If you specify a note here, you will see the it in the extended information CGI (when you are viewing information about the specified host).').'</p><p><em>'._('Parameter name:').'</em> notes<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["host"]["vrml_image"] = '<p><strong>'._('Host - vrml image').'<br> </strong></p><p>'._('This variable is used to define the name of a GIF, PNG, or JPG image that should be associated with this host. This image will be used as the texture map for the specified host in the statuswrl CGI.  Unlike the image you use for the').' <em>icon_image</em> '._('variable, this one should probably').' <em>'._('not').'</em> '._('have any transparency.').'</p><p>'._('If it does, the host object will look a bit wierd.  Images for hosts are assumed to be in the <strong>logos/</strong> subdirectory in your HTML images directory (i.e. ').'<em>/usr/local/nagios/share/images/logos</em>).</p><p><em>'._('Parameter name:').'</em> vrml_image<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["host"]["notes_url"] = '<p><strong>Host - notes url<br> </strong></p><p>'._('This variable is used to define an optional URL that can be used to provide more information about the host. If you specify an URL, you will see a red folder icon in the CGIs (when you are viewing host information) that links to the URL you specify here. Any valid URL can be used.</p><p>If you plan on using relative paths, the base path will the the same as what is used to access the CGIs').' (i.e. <em>/cgi-bin/nagios/</em>). '._('This can be very useful if you want to make detailed information on the host, emergency contact methods, etc. available to other support staff.').'</p><p><em>'._('Parameter name:').'</em> notes_url<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["host"]["status_image"] = '<p><strong>'._('Host - statusmap image').'<br> </strong></p><p>'._('This variable is used to define the name of an image that should be associated with this host in the statusmap CGI. You can specify a JPEG, PNG, and GIF image if you want, although I would strongly suggest using a GD2 format image, as other image formats will result in a lot of wasted CPU time when the statusmap image is generated.').'</p><p>'._('GD2 images can be created from PNG images by using the').' <strong>pngtogd2</strong> '._('utility supplied with Thomas Boutell\'s gd library .  The GD2 images should be created in').' <em>'._('uncompressed').'</em> '._('format in order to minimize CPU load when the statusmap CGI is generating the network map image.').'</p><p>'._('The image will look best if it is 40x40 pixels in size. You can leave these option blank if you are not using the statusmap CGI. Images for hosts are assumed to be in the').' <strong>logos/</strong> '._('subdirectory in your HTML images directory').' (i.e. <em>/usr/local/nagios/share/images/logos</em>).</p><p><em>'._('Parameter name:').'</em> statusmap_image<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["host"]["action_url"] = '<p><strong>'._('Host - action url').'<br> </strong></p><p>'._('This directive is used to define an optional URL that can be used to provide more actions to be performed on the host. If you specify an URL, you will see a red "splat" icon in the CGIs (when you are viewing host information) that links to the URL you specify here. Any valid URL can be used').'.</p><p>'._('If you plan on using relative paths, the base path will the the same as what is used to access the CGIs').' (i.e. <em>/cgi-bin/nagios/</em>).</p><p><em>'._('Parameter name:').'</em> action_url<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["host"]["icon_image"] = '<p><strong>'._('Host - icon image').'<br> </strong></p><p>'._('This variable is used to define the name of a GIF, PNG, or JPG image that should be associated with this host. This image will be displayed in the various places in the CGIs. The image will look best if it is 40x40 pixels in size. Images for hosts are assumed to be in the').' <strong>logos/</strong> '._('subdirectory in your HTML images directory').' (i.e. <em>/usr/local/nagios/share/images/logos</em>).</p><p><em>'._('Parameter name:').'</em> icon_image<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["host"]["2d_coords"] = '<p><strong>'._('Host - 2D coords').'<br> </strong></p><p>'._('This variable is used to define coordinates to use when drawing the host in the statusmap CGI. Coordinates should be given in positive integers, as they correspond to physical pixels in the generated image. The origin for drawing (0,0) is in the upper left hand corner of the image and extends in the positive x direction (to the right) along the top of the image and in the positive y direction (down) along the left hand side of the image.').'</p><p>'._('For reference, the size of the icons drawn is usually about 40x40 pixels (text takes a little extra space). The coordinates you specify here are for the upper left hand corner of the host icon that is drawn. Note: Don\'t worry about what the maximum x and y coordinates that you can use are. The CGI will automatically calculate the maximum dimensions of the image it creates based on the largest x and y coordinates you specify.').'</p><p><em>'._('Parameter name:').'</em> 2d_coords<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["host"]["icon_image_alt_text"] = '<p><strong>'._('Host - icon image alt').'<br> </strong></p><p>'._('This variable is used to define an optional string that is used in the ALT tag of the image specified by the').' <em>'._('icon image').'</em> <em></em> '._('argument.').'</p><p><em>'._('Parameter name:').'</em> icon_image_alt<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["host"]["3d_coords"] = '<p><strong>'._('Host - 3D coords').'<br> </strong></p><p>'._('This variable is used to define coordinates to use when drawing the host in the statuswrl CGI. Coordinates can be positive or negative real numbers. The origin for drawing is (0.0,0.0,0.0). For reference, the size of the host cubes drawn is 0.5 units on each side (text takes a little more space). The coordinates you specify here are used as the center of the host cube.').'</p><p><em>'._('Parameter name:').'</em> 3d_coords<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["common"]["custom_variables_name"] = '<p><strong>'._('Custom variables (custom object variables)').'<br></strong></p><p>'._('NagiosQL supports custom object variables.').'</p><p>'._('There are a few important things that you should note about custom variables:').'</p><ul><li>'._('Custom variable names must begin with an underscore (_) to prevent name collision with standard variables').' </li><li>Custom variable names are case-insensitive </li><li>Custom variables are inherited from object templates like normal variables </li><li>'._('Scripts can reference custom variable values with macros and environment variables ').'</li></ul><p><em>'._('Examples').'</em></p><p><span style="font-family: courier new,courier;">define host{<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; host_name	linuxserver<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; _mac_address	00:06:5B:A6:AD:AA	; &lt;-- Custom MAC_ADDRESS variable<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; _rack_number	R32		; &lt;-- Custom RACK_NUMBER variable<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; ...<br>}</span></p>';
$infolang["common"]["custom_variables_value"] = '<p><strong>'._('Custom variables (custom object variables)').'<br></strong></p><p>'._('NagiosQL supports custom object variables.').'</p><p>'._('There are a few important things that you should note about custom variables:').'</p><ul><li>'._('Custom variable names must begin with an underscore (_) to prevent name collision with standard variables').' </li><li>'._('Custom variable names are case-insensitive').' </li><li>'._('Custom variables are inherited from object templates like normal variables').' </li><li>'._('Scripts can reference custom variable values with macros and environment variables ').'</li></ul><p><em>'._('Examples').'</em></p><p><span style="font-family: courier new,courier;">define host{<br> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; host_name	linuxserver<br> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; _mac_address	00:06:5B:A6:AD:AA	; &lt;-- Custom MAC_ADDRESS variable<br> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; _rack_number	R32		; &lt;-- '._('Custom RACK_NUMBER variable').'<br> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; ...<br> }</span></p>';
$infolang["host"]["genericname"] = '<p><strong>'._('Host - generic name').'</strong></p><p>'._('It is possible to use a host definition as a template for other host configurations. If this definition should be used as template, a generic template name must be defined.</p><p>We do not recommend to do this - it is more open to define a separate host template than to use this option.').'</p><p><em>'._('Parameter name:').'</em> name<em><br>Required:</em> no</p>';
$infolang["service"]["config_name"] = '<p><strong>'._('Service - config name').'</strong></p><p>'._('This directive is used to specify a common config name for a group of service definitions. This is a NagiosQL parameter and it will not be written to the configuration file. Every service definitions with the same configuration name will stored in one file. The configuration name is also the file name of this configuration set.').'</p>';
$infolang["service"]["hosts"] = '<p><strong>'._('Service - host name').'<br> </strong></p><p>'._('This directive is used to specify the').' <em>'._('short name(s)').'</em> '._('of the host(s) that the service "runs" on or is associated with.').'</p><p><em>'._('Parameter name:').'</em> host_name<br> <em>'._('Required:').'</em> '._('yes (no, if a hostgroup is defined)').'</p>';
$infolang["service"]["hostgroups"] = '<p><strong>'._('Service').'</strong><strong> '._('- hostgroup name').'<br> </strong></p><p>'._('This directive is used to specify the').' <em>'._('short name(s)').'</em> '._('of the hostgroup(s) that the service "runs" on or is associated with. The hostgroup_name may be used instead of, or in addition to, the host_name directive').'.</p><p><em>'._('Parameter name:').'</em> hostgroup_name<br> <em>'._('Required:').'</em> '._('no (yes, if no host is defined)').'</p>';
$infolang["service"]["service_description"] = '<p><strong>Service</strong><strong> - '._('service description').'<br> </strong></p><p>'._('This directive is used to define the description of the service, which may contain spaces, dashes, and colons (semicolons, apostrophes, and quotation marks should be avoided). No two services associated with the same host can have the same description. Services are uniquely identified with their').' <em>host_name</em> '._('and').' <em>service_description</em> '._('directives.').'</p><p><em>'._('Parameter name:').'</em> service_description<br> <em>'._('Required:').'</em> '._('yes').'</p>';
$infolang["service"]["service_groups"] = '<p><strong>'._('Service').'</strong><strong> '._('- servicegroups').'<br> </strong></p><p>'._('This directive is used to identify the').' <em>'._('short name(s)').'</em> '._('of the servicegroup(s) that the service belongs to. Multiple servicegroups should be separated by commas. This directive may be used as an alternative to using the').' <em>'._('members').'</em> '._('directive in servicegroup definitions.').'</p><p><span style="color: #ff0000;"><span style="color: #000000;"><strong>NagiosQL:</strong> '._('If a servicegroup is defined here - this service will').' <span style="color: #ff0000;">'._('not be selected').'</span> '._('inside the member field of the same servicegroup definition!').' </span></span></p><p><em>'._('Parameter name:').'</em> servicegroups<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["service"]["display_name"] = '<p><strong>'._('Service').'</strong><strong> '._('- display name').'<br> </strong></p><p>'._('This directive is used to define an alternate name that should be displayed in the web interface for this service. If not specified, this defaults to the value you specify for the ').'<em>service_description</em> '._('directive.  Note:  The current CGIs do not use this option, although future versions of the web interface will.').'</p><p><em>'._('Parameter name:').'</em> display_name<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["service"]["check_command"] = '<p><strong>'._('Service').'</strong><strong>'._(' - check command').'<br> </strong></p><p>'._('This directive is used to specify the').' <em>'._('short name').'</em> '._('of the command that Nagios will run in order to check the status of the service. The maximum amount of time that the service check command can run is controlled by the service_check_timeout option.').'</p><p><em>'._('Parameter name:').'</em> check_command<br> <em>'._('Required:').'</em> '._('yes').'</p>';
$infolang["service"]["argument"] = '<p><strong>'._('Service - arguments').'</strong></p><p>'._('The values defined here will replace the according argument variable behind the selected command. Up to 8 argument variables are supported. Be sure, that you defines a valid value for each required argument variable').'.</p>';
$infolang["service"]["templateadd"] = '<p><strong>'._('Service - Templates').'</strong></p><p>'._('You can add one or more service templates to a service configuration. Nagios will add the definitions from each template to a service configuration.').'</p><p>'._('If you add more than one template - the templates from the bottom to the top will be used to overwrite configuration items which are defined inside templates before.').'</p><p>'._('The host configuration itselves will overwrite all values which are defined in templates before and pass all values which are not defined.').'</p>';
$infolang["service"]["initial_state"] = '<p><strong>'._('Service - initial state').'<br> </strong></p><p>'._('By default Nagios will assume that all services are in OK states when in starts. You can override the initial state for a service by using this directive. Valid options are:').' <strong><br>o</strong> = '._('OK,').'<br> <strong>w</strong> = '._('WARNING,').' <strong><br>u</strong> = '._('UNKNOWN, and').' <strong><br>c</strong> = '._('CRITICAL.').'</p><p><em>'._('Parameter name:').'</em> initial_state<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["service"]["retry_interval"] = '<p><strong>'._('Service - retry interval').'<br> </strong></p><p>'._('This directive is used to define the number of "time units" to wait before scheduling a re-check of the service. Services are rescheduled at the retry interval when they have changed to a non-OK state. Once the service has been retried').' <strong>max_check_attempts</strong> '._('times without a change in its status, it will revert to being scheduled at its "normal" rate as defined by the').' <strong>check_interval</strong> '._('value. Unless you\'ve changed the interval_length directive from the default value of 60, this number will mean minutes.  More information on this value can be found in the check scheduling documentation.').'</p><p><em>'._('Parameter name:').'</em> retry_interval<br> <em>'._('Required:').'</em> '._('yes').'</p>';
$infolang["service"]["max_check_attempts"] = '<p><strong>'._('Service - max check attempts').'<br> </strong></p><p>'._('This directive is used to define the number of times that Nagios will retry the service check command if it returns any state other than an OK state. Setting this value to 1 will cause Nagios to generate an alert without retrying the service check again.').'</p><p><em>'._('Parameter name:').'</em> max_check_attempts<br> <em>'._('Required:').'</em> '._('yes').'</p>';
$infolang["service"]["check_interval"] = '<p><strong>'._('Service - check interval').'<br> </strong></p><p>'._('This directive is used to define the number of "time units" to wait before scheduling the next "regular" check of the service. "Regular" checks are those that occur when the service is in an OK state or when the service is in a non-OK state, but has already been rechecked').' <strong>max_check_attempts</strong> '._('number of times.  Unless you\'ve changed the interval_length directive from the default value of 60, this number will mean minutes.  More information on this value can be found in the check scheduling documentation.').'</p><p><em>'._('Parameter name:').'</em> check_interval<br> <em>'._('Required:').'</em> '._('yes').'</p>';
$infolang["service"]["active_checks_enabled"] = '<p><strong>'._('Service - active checks enabled').'<br> </strong></p><p>'._('This directive is used to determine whether or not active checks of this service are enabled. Values:').' 0 = '._('disable active service checks,').' 1 = '._('enable active service checks.').'</p><p><em>'._('Parameter name:').'</em> active_checks_enabled<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["service"]["passive_checks_enabled"] = '<p><strong>'._('Service - passive checks enabled').'<br> </strong></p><p>'._('This directive is used to determine whether or not passive checks of this service are enabled. Values:').' 0 = '._('disable passive service checks,').' 1 = '._('enable passive service checks.').'</p><p><em>'._('Parameter name:').'</em> passive_checks_enabled<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["service"]["parallelize_checks"] = '<p><strong>'._('Service -').' </strong><strong>'._('parallelize check').'</strong></p><p>'._('This directive is used to determine whether or not the service check can be parallelized. By default, all service checks are parallelized. Disabling parallel checks of services can result in serious performance problems. More information on service check parallelization can be found in the nagios documentation.').'</p><p>'._('Values: 0 = service check cannot be parallelized (use with caution!), 1 = service check can be parallelized.').'</p><p><em>'._('Parameter name:').'</em> parallelize_check<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["service"]["check_period"] = '<p><strong>'._('Service - check period').'<br> </strong></p><p>'._('This directive is used to specify the short name of the time period during which active checks of this service can be made.').'</p><p><em>'._('Parameter name:').'</em> check_period<br> <em>'._('Required:').'</em> '._('yes').'</p>';
$infolang["service"]["freshness_threshold"] = '<p><strong>'._('Service -').' </strong><strong>'._('freshness threshold').'</strong></p><p>'._('This directive is used to specify the freshness threshold (in seconds) for this service. If you set this directive to a value of 0, Nagios will determine a freshness threshold to use automatically.').'</p><p><em>'._('Parameter name:').'</em> freshness_threshold<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["service"]["check_freshness"] = '<p><strong>'._('Service -').' </strong><strong>'._('check freshness').'</strong></p><p>'._('This directive is used to determine whether or not freshness checks are enabled for this service. Values:').' 0 = '._('disable freshness checks,').' 1 = '._('enable freshness ').'checks.</p><p><em>'._('Parameter name:').'</em> check_freshness<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["service"]["obsess_over_service"] = '<p><strong>'._('Service -').' </strong><strong>'._('obsess over service').'</strong></p><p>'._('This directive determines whether or not checks for the service will be "obsessed" over using the ocsp_command.').'</p><p><em>'._('Parameter name:').'</em> obsess_over_service<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["service"]["event_handler"] = '<p><strong>'._('Service -').' </strong><strong>'._('event handler').'</strong></p><p>'._('This directive is used to specify the ').'<em>'._('short name').'</em> '._('of the command that should be run whenever a change in the state of the service is detected (i.e. whenever it goes down or recovers). Read the documentation on event handlers for a more detailed explanation of how to write scripts for handling events. The maximum amount of time that the event handler command can run is controlled by the event_handler_timeout option.').'</p><p><em>'._('Parameter name:').'</em> event_handler<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["service"]["event_handler_enabled"] = '<p><strong>'._('Service -').' </strong><strong>'._('event handler enabled').'</strong></p><p>'._('This directive is used to determine whether or not the event handler for this service is enabled. Values:').' 0 = '._('disable service event handler,').' 1 = '._('enable service event handler.').'</p><p><em>'._('Parameter name:').'</em> event_handler_enabled<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["service"]["low_flap_threshold"] = '<p><strong>'._('Service -').' </strong><strong>'._('low flap threshold').'</strong></p><p>'._('This directive is used to specify the low state change threshold used in flap detection for this service. More information on flap detection can be found in the nagios documentation.  If you set this directive to a value of 0, the program-wide value specified by the low_service_flap_threshold  directive will be used.').'</p><p><em>'._('Parameter name:').'</em> low_flap_threshold<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["service"]["high_flap_threshold"] = '<p><strong>'._('Service -').' </strong><strong>'._('high flap threshold').'</strong></p><p>'._('This directive is used to specify the high state change threshold used in flap detection for this service. More information on flap detection can be found in the nagios documentation.  If you set this directive to a value of 0, the program-wide value specified by the high_service_flap_threshold directive will be used.').'</p><p><em>'._('Parameter name:').'</em> high_flap_threshold<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["service"]["flap_detection_enabled"] = '<p><strong>'._('Service -').' </strong><strong>'._('flap detection enabled').'</strong></p><p>'._('This directive is used to determine whether or not flap detection is enabled for this service. More information on flap detection can be found in the nagios documentation. Values:').' 0 = '._('disable service flap detection,').' 1 = '._('enable service flap detection.').'</p><p><em>'._('Parameter name:').'</em> flap_detection_enabled<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["service"]["flap_detection_options"] = '<p><strong>'._('Service -').' </strong><strong>'._('flap detection options').'</strong></p><p>'._('This directive is used to determine what service states the flap detection logic will use for this service.  Valid options are a combination of one or more of the following:').' <strong><br>o</strong> = '._('OK states,').' <br><strong>w</strong> = '._('WARNING states,').' <br><strong>c</strong> = '._('CRITICAL states,').' <br><strong>u</strong> = '._('UNKNOWN states.').'</p><p><em>'._('Parameter name:').'</em> flap_detection_options<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["service"]["retain_status_information"] = '<p><strong>'._('Service -').' </strong><strong>'._('retain status information').'</strong></p><p>'._('This directive is used to determine whether or not status-related information about the service is retained across program restarts. This is only useful if you have enabled state retention using the retain_state_information directive.').'  Value: 0 = '._('disable status information retention,').' 1 = '._('enable status information retention.').'</p><p><em>'._('Parameter name:').'</em> retain_status_information<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["service"]["retain_nonstatus_information"] = '<p><strong>'._('Service -').' </strong><strong>'._('retain nonstatus information').'</strong></p><p>'._('This directive is used to determine whether or not non-status information about the service is retained across program restarts. This is only useful if you have enabled state retention using the retain_state_information directive.').'  Value: 0 = '._('disable non-status information retention,').' 1 = '._('enable non-status information retention.').'</p><p><em>'._('Parameter name:').'</em> retain_nonstatus_information<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["service"]["process_perf_data"] = '<p><strong>'._('Service -').' </strong><strong>'._('process perf data').'</strong></p><p>'._('This directive is used to determine whether or not the processing of performance data is enabled for this service. Values:').' 0 = '._('disable performance data processing,').' 1 = '._('enable performance data processing.').'</p><p><em>'._('Parameter name:').'</em> process_perf_data<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["service"]["is_volatile"] = '<p><strong>'._('Service').'</strong><strong> - '._('is volatile').'<br> </strong></p><p>'._('This directive is used to denote whether the service is "volatile".  Services are normally').' <em>'._('not').'</em> '._('volatile.').'  '._('More information on volatile service and how they differ from normal services can be found in the nagios documentation. ').' Value: 0 = '._('service is not volatile,').' 1 = '._('service is volatile.').'</p><p><em>'._('Parameter name:').'</em> is_volatile<br> <em>'._('Required:').'</em>no</p>';
$infolang["service"]["contacts"] = '<p><strong>'._('Service -').' </strong><strong>'._('contacts').'</strong></p><p>'._('This is a list of the ').'<em>'._('short names').'</em> '._('of the contacts that should be notified whenever there are problems (or recoveries) with this service. Multiple contacts should be separated by commas. Useful if you want notifications to go to just a few people and don\'t want to configure contact groups. You must specify at least one contact or contact group in each service definition.').'</p><p><em>'._('Parameter name:').'</em> contacts<br> <em>'._('Required:').'</em> '._('yes (no, if a contact group is defined)').'</p>';
$infolang["service"]["contactgroups"] = '<p><strong>'._('Service -').' </strong><strong>'._('contact groups').'</strong></p><p>'._('This is a list of the').' <em>'._('short names').'</em> '._('of the contact groups that should be notified whenever there are problems (or recoveries) with this service. Multiple contact groups should be separated by commas. You must specify at least one contact or contact group in each service definition.').'</p><p><em>'._('Parameter name:').'</em> contact_groups<br> <em>'._('Required:').'</em> yes (no, if a contact is defined)</p>';
$infolang["service"]["notification_period"] = '<p><strong>'._('Service -').' </strong><strong>'._('notification period').'</strong></p><p>'._('This directive is used to specify the short name of the time period during which notifications of events for this service can be sent out to contacts. No service notifications will be sent out during times which is not covered by the time period.').'</p><p><em>'._('Parameter name:').'</em> notification_period<br> <em>'._('Required:').'</em> '._('yes').'</p>';
$infolang["service"]["notification_options"] = '<p><strong>'._('Service -').' </strong><strong>'._('notification options').'</strong></p><p>'._('This directive is used to determine when notifications for the service should be sent out. Valid options are a combination of one or more of the following:').'<br><strong><br>w</strong> = '._('send notifications on a WARNING state,').' <br><strong>u</strong> = '._('send notifications on an UNKNOWN state,').' <strong><br>c</strong> = '._('send notifications on a CRITICAL state,').' <br><strong>r</strong> = '._('send notifications on recoveries (OK state), ').'<strong><br>f</strong> = '._('send notifications when the service starts and stops flapping, and').' <br><strong>s</strong> = '._('send notifications when scheduled downtime starts and ends.').'</p><p>'._('If you do not specify any notification options, Nagios will assume that you want notifications to be sent out for all possible states.').'</p><p>'._('Example: If you specify').' <strong>w,r</strong> '._('in this field, notifications will only be sent out when the service goes into a WARNING state and when it recovers from a WARNING state.').'</p><p><em>'._('Parameter name:').'</em> notification_options<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["service"]["notification_interval"] = '<p><strong>'._('Service -').' </strong><strong>'._('notification interval').'</strong></p><p>'._('This directive is used to define the number of "time units" to wait before re-notifying a contact that this service is').' <em>'._('still').'</em> '._('in a non-OK state.  Unless you\'ve changed the interval_length directive from the default value of 60, this number will mean minutes.  If you set this value to 0, Nagios will <em>not</em> re-notify contacts about problems for this service - only one problem notification will be sent out.').'</p><p><em>'._('Parameter name:').'</em> notification_interval<br> <em>'._('Required:').'</em> '._('yes').'</p>';
$infolang["service"]["first_notification_delay"] = '<p><strong>'._('Service -').' </strong><strong>'._('first notification delay').'</strong></p><p>'._('This directive is used to define the number of "time units" to wait before sending out the first problem notification when this service enters a non-OK state. Unless you\'ve changed the interval_length directive from the default value of 60, this number will mean minutes. If you set this value to 0, Nagios will start sending out notifications immediately.').'</p><p><em>'._('Parameter name:').'</em> first_notification_delay<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["service"]["notification_enabled"] = '<p><strong>'._('Service -').' </strong><strong>'._('notifications enabled').'</strong><strong></strong></p><p>'._('This directive is used to determine whether or not notifications for this service are enabled. Values:').' 0 = '._('disable service notifications,').' 1 = '._('enable service notifications.').'</p><p><em>'._('Parameter name:').'</em> notifications_enabled<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["service"]["stalking_options"] = '<p><strong>'._('Service -').' </strong><strong>'._('stalking option').'s</strong></p><p>'._('This directive determines which service states "stalking" is enabled for. Valid options are a combination of one or more of the following: ').'<strong><br>o</strong> = '._('stalk on OK states,').' <br><strong>w</strong> = '._('stalk on WARNING states,').' <strong><br>u</strong> = '._('stalk on UNKNOWN states, and').' <strong><br>c</strong> = '._('stalk on CRITICAL states.').'</p><p>'._('More information on state stalking can be found in the nagios documentation.').'</p><p><em>'._('Parameter name:').'</em> stalking_options<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["service"]["notes"] = '<p><strong>'._('Service -').' </strong><strong>'._('notes').'</strong></p><p>'._('This directive is used to define an optional string of notes pertaining to the service. If you specify a note here, you will see the it in the extended information CGI (when you are viewing information about the specified service).').'</p><p><em>'._('Parameter name:').'</em> notes<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["service"]["icon_image"] = '<p><strong>'._('Service -').' </strong><strong>'._('icon image').'</strong><strong> </strong></p><p>'._('This variable is used to define the name of a GIF, PNG, or JPG image that should be associated with this service. This image will be displayed in the status and extended information CGIs.').'  '._('The image will look best if it is 40x40 pixels in size.').'  '._('Images for services are assumed to be in the').' <strong>logos/</strong> '._('subdirectory in your HTML images directory (i.e. ').'<em>/usr/local/nagios/share/images/logos</em>).</p><p><em>'._('Parameter name:').'</em> icon_image<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["service"]["notes_url"] = '<p><strong>'._('Service -').' </strong><strong>'._('notes url').'<br></strong></p><p>'._('This directive is used to define an optional URL that can be used to provide more information about the service. If you specify an URL, you will see a red folder icon in the CGIs (when you are viewing service information) that links to the URL you specify here. Any valid URL can be used. If you plan on using relative paths, the base path will the the same as what is used to access the CGIs').' (i.e. <em>/cgi-bin/nagios/</em>). '._('This can be very useful if you want to make detailed information on the service, emergency contact methods, etc. available to other support staff.').'</p><p><em>'._('Parameter name:').'</em> notes_url<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["service"]["icon_image_alt_text"] = '<p><strong>'._('Service -').' </strong><strong>'._('icon image alt').'</strong><strong> </strong></p><p>'._('This variable is used to define an optional string that is used in the ALT tag of the image specified by the ').'<em>&lt;icon_image&gt;</em> '._('argument.  The ALT tag is used in the status, extended information and statusmap CGIs.').'</p><p><em>'._('Parameter name:').'</em> icon_image_alt<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["service"]["action_url"] = '<p><strong>'._('Service - action').'</strong><strong> '._('url').'<br> </strong></p><p>'._('This directive is used to define an optional URL that can be used to provide more actions to be performed on the service. If you specify an URL, you will see a red "splat" icon in the CGIs (when you are viewing service information) that links to the URL you specify here. Any valid URL can be used. If you plan on using relative paths, the base path will the the same as what is used to access the CGIs (i.e. ').'<em>/cgi-bin/nagios/</em>).</p><p><em>'._('Parameter name:').'</em> action_url<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["hostgroup"]["hostgroup_name"] = '<p><strong>'._('Hostgroup -').' </strong><strong>hostgroup name</strong></p><p>'._('This directive is used to define a short name used to identify the host group.').'</p><p><em>'._('Parameter name:').'</em> hostgroup_name<br> <em>'._('Required:').'</em> '._('yes').'</p>';
$infolang["hostgroup"]["members"] = '<p><strong>'._('Hostgroup -').' </strong><strong>'._('members').'</strong></p><p>'._('This is a list of the').' <em>'._('short names').'</em> '._('of hosts that should be included in this group. Multiple host names should be separated by commas. This directive may be used as an alternative to (or in addition to) the').' <em>'._('hostgroups').'</em> '._('directive in host definitions.').'</p><p><strong>NagiosQL:</strong> '._('If you select a hostgroup inside a host definition using the').' <em>'._('hostgroups').'</em> '._('directive in').' <em>'._('host definition').'</em>'._(', this host will').' <span style="color: #ff0000;">'._('not be selected').'</span> '._('here because these are two different ways to specify a hostgroup!').'</p><p><em>'._('Parameter name:').'</em> members<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["hostgroup"]["description"] = '<p><strong>'._('Hostgroup -').' </strong><strong>'._('alias').'</strong></p><p>'._('This directive is used to define is a longer name or description used to identify the host group. It is provided in order to allow you to more easily identify a particular host group.').'</p><p><em>'._('Parameter name:').'</em> alias<br> <em>'._('Required:').'</em> '._('yes').'</p>';
$infolang["hostgroup"]["notes"] = '<p><strong>'._('Hostgroup -').' </strong><strong>'._('notes').'</strong></p><p>'._('This directive is used to define an optional string of notes pertaining to the host. If you specify a note here, you will see the it in the extended information CGI (when you are viewing information about the specified host).').'</p><p><em>'._('Parameter name:').'</em> notes<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["hostgroup"]["notes_url"] = '<p><strong>'._('Hostgroup -').' </strong><strong>'._('notes url').'<br></strong></p><p>'._('This variable is used to define an optional URL that can be used to provide more information about the host group. If you specify an URL, you will see a red folder icon in the CGIs (when you are viewing hostgroup information) that links to the URL you specify here. Any valid URL can be used. If you plan on using relative paths, the base path will the the same as what is used to access the CGIs (i.e. ').'<em>/cgi-bin/nagios/</em>). '._('This can be very useful if you want to make detailed information on the host group, emergency contact methods, etc. available to other support staff.').'</p><p><em>'._('Parameter name:').'</em> notes_url<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["hostgroup"]["action_url"] = '<p><strong>'._('Hostgroup -').' </strong><strong>'._('action url').'</strong></p><p>'._('This directive is used to define an optional URL that can be used to provide more actions to be performed on the host group. If you specify an URL, you will see a red "splat" icon in the CGIs (when you are viewing hostgroup information) that links to the URL you specify here. Any valid URL can be used. If you plan on using relative paths, the base path will the the same as what is used to access the CGIs (i.e. ').'<em>/cgi-bin/nagios/</em>).</p><p><em>'._('Parameter name:').'</em> action_url<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["hostgroup"]["hostgroup_members"] = '<p><strong>'._('Hostgroup -').' </strong><strong>'._('hostgroup members').'</strong></p><p>'._('This optional directive can be used to include hosts from other "sub" host groups in this host group. Specify a comma-delimited list of short names of other host groups whose members should be included in this group.').'</p><p><em>'._('Parameter name:').'</em> hostgroup_members<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["servicegroup"]["servicegroup_name"] = '<p><strong>'._('Servicegroup -').' </strong><strong>'._('servicegroup name').'</strong></p><p>'._('This directive is used to define a short name used to identify the service group.').'</p><p><em>'._('Parameter name:').'</em> servicegroup_name<br> <em>'._('Required:').'</em> '._('yes').'</p>';
$infolang["servicegroup"]["members"] = '<p><strong>'._('Servicegroup -').' </strong><strong>'._('members').'</strong></p><p>'._('This is a list of the').' <em>'._('descriptions').'</em> '._('of services (and the names of their corresponding hosts) that should be included in this group. Host and service names should be separated by commas. This directive may be used as an alternative to the').' <em>'._('servicegroups').'</em> '._('directive in service definitions.').'</p><p><strong>NagiosQL:</strong> '._('If you select a servicegroup inside a service definition using the').' <em>'._('servicegroups').'</em> '._('directive in').' <em>'._('service definition').'</em>, '._('this service will').' <span style="color: #ff0000;">'._('not be selected').'</span> h'._('ere because these are two different ways to specify a servicegroup!').'</p><p><em>'._('Parameter name:').'</em> members<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["servicegroup"]["description"] = '<p><strong>'._('Servicegroup -').' </strong><strong>'._('alias').'</strong><strong></strong></p><p>'._('This directive is used to define is a longer name or description used to identify the service group. It is provided in order to allow you to more easily identify a particular service group.').'</p><p><em>'._('Parameter name:').'</em> alias<br> <em>'._('Required:').'</em> '._('yes').'</p>';
$infolang["servicegroup"]["notes"] = '<p><strong>'._('Servicegroup -').' </strong><strong>'._('notes').'</strong></p><p>'._('This directive is used to define an optional string of notes pertaining to the service group. If you specify a note here, you will see the it in the extended information CGI (when you are viewing information about the specified service group).').'</p><p><em>'._('Parameter name:').'</em> notes<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["servicegroup"]["notes_url"] = '<p><strong>'._('Servicegroup -').' </strong><strong>'._('notes url').'</strong></p><p>'._('This directive is used to define an optional URL that can be used to provide more information about the service group. If you specify an URL, you will see a red folder icon in the CGIs (when you are viewing service group information) that links to the URL you specify here. Any valid URL can be used. If you plan on using relative paths, the base path will the the same as what is used to access the CGIs (i.e. ').'<em>/cgi-bin/nagios/</em>). '._('This can be very useful if you want to make detailed information on the service group, emergency contact methods, etc. available to other support staff.').'</p><p><em>'._('Parameter name:').'</em> notes_url<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["servicegroup"]["action_url"] = '<p><strong>'._('Servicegroup -').' </strong><strong>'._('action url').'</strong></p><p>'._('This directive is used to define an optional URL that can be used to provide more actions to be performed on the service group. If you specify an URL, you will see a red "splat" icon in the CGIs (when you are viewing service group information) that links to the URL you specify here. Any valid URL can be used. If you plan on using relative paths, the base path will the the same as what is used to access the CGIs ').'(i.e. <em>/cgi-bin/nagios/</em>).</p><p><em>'._('Parameter name:').'</em> action_url<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["servicegroup"]["servicegroup_members"] = '<p><strong>'._('Servicegroup -').' </strong><strong>'._('servicegroup members').'</strong></p><p>'._('This optional directive can be used to include services from other "sub" service groups in this service group. Specify a comma-delimited list of short names of other service groups whose members should be included in this group.').'</p><p><em>'._('Parameter name:').'</em> servicegroup_members<br> <em>'._('Required:').'</em> '._('yes').'</p>';
$infolang["hosttemplate"]["template_name"] = '<p><strong>'._('Hosttemplate - template name').'</strong></p><p>'._('This directive is used to define a short name used to identify the host template.').'</p><p><em>'._('Parameter name:').'</em> name<br> <em>'._('Required:').'</em> '._('yes').'</p>';
$infolang["servicetemplate"]["template_name"] = '<p><strong>'._('Servicetemplate - template name').'</strong></p><p>'._('This directive is used to define a short name used to identify the service template.').'</p><p><em>'._('Parameter name:').'</em> name<br> <em>'._('Required:').'</em> '._('yes').'</p>';
$infolang["contact"]["contact_name"] = '<p><strong>'._('Contact -').' </strong><strong>contact name</strong></p><p>'._('This directive is used to define a short name used to identify the contact.  It is referenced in contact group definitions.  Under the right circumstances, the').' $CONTACTNAME$ '._('macro will contain this value.').'</p><p><em>'._('Parameter name:').'</em> contact_name<br> <em>'._('Required:').'</em> '._('yes').'</p>';
$infolang["contact"]["contactgroups"] = '<p><strong>'._('Contact -').' </strong><strong>'._('contactgroups').'</strong></p><p>'._('This directive is used to identify the').' <em>'._('short name(s)').'</em> '._('of the contactgroup(s) that the contact belongs to. Multiple contactgroups should be separated by commas. This directive may be used as an alternative to (or in addition to) using the').' <em>'._('members').'</em> '._('directive in contactgroup definitions.').'</p><p><span style="color: #ff0000;"><span style="color: #000000;"><strong>NagiosQL:</strong> '._('If a contactgroup is defined here - this contact will').' <span style="color: #ff0000;">'._('not be selected').'</span> '._('inside the member field of the same contactgroup definition!').' </span></span></p><p><em>'._('Parameter name:').'</em> contactgroups<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["contact"]["alias"] = '<p><strong>'._('Contact -').' </strong><strong>'._('alias').'</strong></p><p>'._('This directive is used to define a longer name or description for the contact. Under the rights circumstances, the').' $CONTACTALIAS$ '._('macro will contain this value.  If not specified, the <em>contact_name</em> will be used as the alias.').'</p><p><em>'._('Parameter name:').'</em> alias<br> <em>'._('Required:').'</em> no (yes in Nagios 2.x)</p>';
$infolang["contact"]["email"] = '<p><strong>'._('Contact -').' </strong><strong>'._('email').'</strong></p><p>'._('This directive is used to define an email address for the contact. Depending on how you configure your notification commands, it can be used to send out an alert email to the contact. Under the right circumstances, the').' $CONTACTEMAIL$ '._('macro will contain this value.').'</p><p>'._('Parameter name:').' email<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["contact"]["pager"] = '<p><strong>'._('Contact -').' </strong><strong>'._('pager').'</strong></p><p>'._('This directive is used to define a pager number for the contact. It can also be an email address to a pager gateway (i.e. pagejoe@pagenet.com). Depending on how you configure your notification commands, it can be used to send out an alert page to the contact. Under the right circumstances, the').' $CONTACTPAGER$ '._('macro will contain this value.').'</p><p>'._('Parameter name:').' pager<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["contact"]["address"] = '<p><strong>'._('Contact -').' </strong><strong>address<em>x</em></strong></p><p>'._('Address directives are used to define additional "addresses" for the contact. These addresses can be anything - cell phone numbers, instant messaging addresses, etc. Depending on how you configure your notification commands, they can be used to send out an alert o the contact. Up to six addresses can be defined using these directives').' (<em>address1</em> '._('through').' <em>address6</em>). The $CONTACTADDRESS<em>x</em>$ '._('macro will contain this value.').'</p><p>'._('Parameter name: addressx (x as number from 1 to 6)').'<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["contact"]["host_notifications_enabled"] = '<p><strong>'._('Contact -').' </strong><strong>'._('host notifications enabled').'</strong></p><p>'._('This directive is used to determine whether or not the contact will receive notifications about host problems and recoveries. Values:').' 0 = '._('don\'t send notifications,').' 1 = '._('send notifications.').'</p><p><em>'._('Parameter name:').'</em> host_notifications_enabled<br> <em>'._('Required:').'</em> '._('yes').'</p>';
$infolang["contact"]["service_notifications_enabled"] = '<p><strong>'._('Contact -').' </strong><strong>'._('service notifications enabled').'</strong></p><p>'._('This directive is used to determine whether or not the contact will receive notifications about service problems and recoveries. Values:').' 0 = '._('don\'t send notifications,').' 1 = '._('send notifications.').'</p><p><em>'._('Parameter name:').'</em> service_notifications_enabled<br> <em>'._('Required:').'</em> '._('yes').'</p>';
$infolang["contact"]["host_notification_period"] = '<p><strong>'._('Contact -').' </strong><strong>'._('host notification period').'</strong></p><p>'._('This directive is used to specify the short name of the time period during which the contact can be notified about host problems or recoveries. You can think of this as an "on call" time for host notifications for the contact. Read the documentation on time periods for more information on how this works and potential problems that may result from improper use.').'</p><p><em>'._('Parameter name:').'</em> host_notification_period<br> <em>'._('Required:').'</em> '._('yes').'</p>';
$infolang["contact"]["service_notification_period"] = '<p><strong>'._('Contact -').' </strong><strong>'._('service notification period').'</strong><strong></strong></p><p>'._('This directive is used to specify the short name of the time period during which the contact can be notified about service problems or recoveries. You can think of this as an "on call" time for service notifications for the contact. Read the documentation on time periods for more information on how this works and potential problems that may result from improper use.').'</p><p><em>'._('Parameter name:').'</em> service_notification_period<br> <em>'._('Required:').'</em> '._('yes').'</p>';
$infolang["contact"]["host_notification_options"] = '<p><strong>'._('Contact -').' </strong><strong>'._('host notification options').'</strong></p><p>'._('This directive is used to define the host states for which notifications can be sent out to this contact. Valid options are a combination of one or more of the following:').' <strong><br>d</strong> = '._('notify on DOWN host states,').' <br><strong>u</strong> = '._('notify on UNREACHABLE host states,').' <strong><br>r</strong> = '._('notify on host recoveries (UP states), and').' <strong><br>f</strong> = '._('notify when the host starts and stops flapping.').'<br>'._('If you specify <strong>n</strong> (none) as an option, the contact will not receive any type of host notifications.').'</p><p><em>'._('Parameter name:').'</em> host_notification_options<br> <em>'._('Required:').'</em> '._('yes').'</p>';
$infolang["contact"]["host_notification_options"] = '<p><strong>'._('Contact -').' </strong><strong>'._('host notification options').'</strong></p><p>'._('This directive is used to define the host states for which notifications can be sent out to this contact. Valid options are a combination of one or more of the following:').' <br><strong>d</strong> = '._('notify on DOWN host states,').' <strong><br>u</strong> = '._('notify on UNREACHABLE host states,').' <strong><br>r</strong> = '._('notify on host recoveries (UP states),').' <strong><br>f</strong> = '._('notify when the host starts and stops flapping, and').' <br><strong>s</strong> = '._('send notifications when host or service scheduled downtime starts and ends.').'<br>'._('If you specify').' <strong>n</strong> '._('(none) as an option, the contact will not receive any type of host notifications.').'</p><p><em>'._('Parameter name:').'</em> host_notification_options<br> <em>'._('Required:').'</em> '._('yes').'</p>';
$infolang["contact"]["service_notification_options"] = '<p><strong>'._('Contact -').' </strong><strong>'._('service notification options').'</strong></p><p>'._('This directive is used to define the service states for which notifications can be sent out to this contact. Valid options are a combination of one or more of the following:').' <strong><br>w</strong> = '._('notify on WARNING service states,').' <strong><br>u</strong> = '._('notify on UNKNOWN service states,').' <strong><br>c</strong> = '._('notify on CRITICAL service states,').' <br><strong>r</strong> = '._('notify on service recoveries (OK states), and').' <br><strong>f</strong> = '._('notify when the service starts and stops flapping.').'<br>'._('If you specify <strong>n</strong> (none) as an option, the contact will not receive any type of host notifications.').'</p><p><em>'._('Parameter name:').'</em> service_notification_options<br> <em>'._('Required:').'</em> '._('yes').'</p>';
$infolang["contact"]["service_notification_options"] = '<p><strong>'._('Contact -').' </strong><strong>'._('service notification options').'</strong></p><p>'._('This directive is used to define the service states for which notifications can be sent out to this contact. Valid options are a combination of one or more of the following:').' <strong><br>w</strong> = '._('notify on WARNING service states,').' <br><strong>u</strong> = '._('notify on UNKNOWN service states,').' <br><strong>c</strong> = '._('notify on CRITICAL service states,').' <strong><br>r</strong> = '._('notify on service recoveries (OK states), and').' <strong><br></strong><strong>f</strong> = '._('notify when the host starts and stops flapping, and').' <strong><br>s</strong> = '._('send notifications when host or service scheduled downtime starts and ends.').'  <br>'._('If you specify').' <strong>n</strong> '._('(none) as an option, the contact will not receive any type of host notifications.').'</p><p><em>'._('Parameter name:').'</em> service_notification_options<br> <em>'._('Required:').'</em> '._('yes').'</p>';
$infolang["contact"]["host_notification_commands"] = '<p><strong>'._('Contact -').' </strong><strong>'._('host notification commands').'</strong></p><p>'._('This directive is used to define a list of the').' <em>'._('short names').'</em> '._('of the commands used to notify the contact of a').' <em>'._('host').'</em> '._('problem or recovery. Multiple notification commands should be separated by commas. All notification commands are executed when the contact needs to be notified. The maximum amount of time that a notification command can run is controlled by the notification_timeout option.').'</p><p><em>'._('Parameter name:').'</em> host_notification_commands<br> <em>'._('Required:').'</em> '._('yes').'</p>';
$infolang["contact"]["service_notification_commands"] = '<p><strong>'._('Contact -').' </strong><strong>'._('service notification commands').'</strong></p><p>'._('This directive is used to define a list of the <em>short names</em> of the commands used to notify the contact of a ').'<em>'._('service').'</em> '._('problem or recovery. Multiple notification commands should be separated by commas. All notification commands are executed when the contact needs to be notified. The maximum amount of time that a notification command can run is controlled by the ').'notification_timeout option.</p><p><em>'._('Parameter name:').'</em> service_notification_commands<br> <em>'._('Required:').'</em> '._('yes').'</p>';
$infolang["contact"]["retain_status_information"] = '<p><strong>'._('Contact -').' </strong><strong>'._('retain status information').'</strong></p><p>'._('This directive is used to determine whether or not status-related information about the contact is retained across program restarts. This is only useful if you have enabled state retention using the retain_state_information directive.').'  Value: 0 = '._('disable status information retention,').' 1 = '._('enable status information retention.').'</p><p>'._('Parameter name:').' retain_status_information<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["contact"]["can_submit_commands"] = '<p><strong>'._('Contact -').' </strong><strong>'._('can submit commands').'</strong></p><p>'._('This directive is used to determine whether or not the contact can submit external commands to Nagios from the CGIs. Values:').' 0 = '._('don\'t allow contact to submit commands,').' 1 = '._('allow contact to submit commands.').'</p><p>'._('Parameter name:').' can_submit_commands<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["contact"]["retain_nostatus_information"] = '<p><strong>'._('Contact -').' </strong><strong>'._('retain nonstatus information').'</strong></p><p>'._('This directive is used to determine whether or not non-status information about the contact is retained across program restarts. This is only useful if you have enabled state retention using the retain_state_information directive.').'  Value: 0 = '._('disable non-status information retention,').' 1 = '._('enable non-status information retention.').'</p><p>'._('Parameter name:').' retain_nonstatus_information<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["contact"]["templateadd"] = '<p><strong>'._('Contact - Templates').'</strong></p><p>'._('You can add one or more contact templates to a contact configuration. Nagios will add the definitions from each template to a contact configuration.').'</p><p>'._('If you add more than one template - the templates from the bottom to the top will be used to overwrite configuration items which are defined inside templates before.</p><p>The host configuration itselves will overwrite all values which are defined in templates before and pass all values which are not defined.').'</p>';
$infolang["contact"]["genericname"] = '<p><strong>'._('Contact - generic name').'</strong></p><p>'._('It is possible to use a contact definition as a template for other contact configurations. If this definition should be used as template, a generic template name must be defined.').'</p><p>'._('We do not recommend to do this - it is more open to define a separate contact template than use this option.').'</p><p><em>'._('Parameter name:').'</em> name<em><br>Required:</em> no</p>';
$infolang["contactgroup"]["contactgroup_name"] = '<p><strong>Contactgroup - contactgroup name</strong></p><p>'._('This directive is a short name used to identify the contact group.').'</p><p><em>'._('Parameter name:').'</em> contactgroup_name<em><br>'._('Required:').'</em> '._('yes').'</p>';
$infolang["contactgroup"]["members"] = '<p><strong>'._('Contactgroup -').' </strong><strong>'._('members').'</strong></p><p>'._('This directive is used to define a list of the').' <em>'._('short names').'</em> '._('of contacts that should be included in this group. Multiple contact names should be separated by commas. This directive may be used as an alternative to (or in addition to) using the').' <em>contactgroups</em> '._('directive in contact definitions.').'</p><p><strong>NagiosQL:</strong> '._('If you select a contactgroup inside a contact definition using the').'&nbsp;<em>'._('contactgroups').'</em> '._('directive in').'&nbsp;<em>'._('contact definition').'</em>'._(', this contact will').' <span style="color: #ff0000;">'._('not be selected').'</span> '._('here because these are two different ways to specify a contactgroup!').'</p><p><em>'._('Parameter name:').'</em> members<em><br>'._('Required:').'</em> '._('yes').'</p>';
$infolang["contactgroup"]["alias"] = '<p><strong>'._('Contactgroup -').' </strong><strong>'._('alias').'</strong></p><p>'._('This directive is used to define a longer name or description used to identify the contact group.').'</p><p><em>'._('Parameter name:').'</em> alias<em><br>'._('Required:').'</em> '._('yes').'</p>';
$infolang["contactgroup"]["contactgroup_members"] = '<p><strong>'._('Contactgroup -').' </strong><strong>'._('contactgroup members').'</strong></p><p>'._('This optional directive can be used to include contacts from other "sub" contact groups in this contact group. Specify a comma-delimited list of short names of other contact groups whose members should be included in this group.').'</p><p><em>'._('Parameter name:').'</em> contactgroup_members<em><br>Required:</em> no</p>';
$infolang["timeperiod"]["timeperiod_name"] = '<p><strong>'._('Timeperiod -').' </strong><strong>'._('timeperiod name').'</strong></p><p>'._('This directives is the short name used to identify the time period.').'</p><p>'._('Parameter name:').' timeperiod_name<br> <em>'._('Required:').'</em> '._('yes').'</p>';
$infolang["timeperiod"]["exclude"] = '<p><strong>'._('Timeperiod -').' </strong><strong>'._('exclude').'</strong></p><p>'._('This directive is used to specify the short names of other timeperiod definitions whose time ranges should be excluded from this timeperiod. Multiple timeperiod names should be separated with a comma.').'</p><p>Parameter name: exclude<br> <em>'._('Required:').'</em> '._('yes').'</p>';
$infolang["timeperiod"]["alias"] = '<p><strong>'._('Timeperiod -').' </strong><strong>'._('alias').'</strong></p><p>'._('This directive is a longer name or description used to identify the time period.').'</p><p>'._('Parameter name:').' alias<br> <em>'._('Required:').'</em> '._('yes').'</p>';
$infolang["timeperiod"]["templatename"] = '<p><strong>'._('Timeperiod -').' </strong><strong>'._('template name').'</strong></p><p>'._('Not yet implemented.').'</p><p>Parameter name: name<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["timeperiod"]["weekday"] = '<p><strong>'._('Timeperiod -').' </strong><strong>'._('time definition').'<br></strong></p><p>'._('The').' <em>'._('sunday').'</em> '._('through').' <em>'._('saturday').'</em> '._('directives are comma-delimited lists of time ranges that are "valid" times for a particular day of the week. Notice that there are seven different days for which you can define time ranges (Sunday through Saturday).').'</p><p>'._('Parameter name: [weekday] [exception]').'<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["timeperiod"]["timerange"] = '<p><strong>'._('Timeperiod -').' </strong><strong>'._('time range').'<br></strong></p><p>'._('Each time range is in the form of').' <strong>HH:MM-HH:MM</strong>, '._('where hours are specified on a 24 hour clock.  For example, ').'<strong>00:15-24:00</strong>'._(' means 12:15am in the morning for this day until 12:20am midnight (a 23 hour, 45 minute total time range). If you wish to exclude an entire day from the timeperiod, simply do not include it in the timeperiod definition.').'</p><p>'._('Parameter name: [weekday] [exception]').'<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["timeperiod"]["weekday"] = '<p><strong>'._('Timeperiod -').' </strong><strong>'._('time definition').'<br></strong></p><p>'._('The weekday directives').' ("<em>'._('sunday').'</em>" '._('through').' "<em>'._('saturday').'</em>")'._('are comma-delimited lists of time ranges that are "valid" times for a particular day of the week. Notice that there are seven different days for which you can define time ranges (Sunday through Saturday)').'.&nbsp;</p><p>'._('You can also specify several different types of exceptions to the standard rotating weekday schedule. Exceptions can take a number of different forms including single days of a specific or generic month, single weekdays in a month, or single calendar dates. You can also specify a range of days/dates and even specify skip intervals to obtain functionality described by "every 3 days between these dates". Rather than list all the possible formats for exception strings, Weekdays and different types of exceptions all have different levels of precedence, so its important to understand how they can affect each other. More information on this can be found in the documentation on timeperiods.').'</p><p>'._('Parameter name: [weekday] [exception]').'<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["timeperiod"]["timerange"] = '<p><strong>'._('Timeperiod -').' </strong><strong>'._('time range').'<br></strong></p><p>'._('Each time range is in the form of').' <strong>HH:MM-HH:MM</strong>'._(', where hours are specified on a 24 hour clock.  For example, ').'<strong>00:15-24:00</strong> '._('means 12:15am in the morning for this day until 12:00am midnight (a 23 hour, 45 minute total time range). If you wish to exclude an entire day from the timeperiod, simply do not include it in the timeperiod definition.').'</p><p>'._('Parameter name: [weekday] [exception]').'<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["contacttemplate"]["template_name"] = '<p><strong>'._('Contacttemplate - template name').'</strong></p><p>'._('This directive is used to define a short name used to identify the contact template.').'</p><p><em>'._('Parameter name:').'</em> name<br> <em>'._('Required:').'</em> '._('yes').'</p>';
$infolang["command"]["command_name"] = '<p><strong>'._('Command -').' </strong><strong>'._('command name').'</strong></p><p>'._('This directive is the short name used to identify the command.  It is referenced in contact, host, and service definitions (in notification, check, and event handler directives), among other places.').'</p><p><em>'._('Parameter name:').'</em> command_name<br> <em>'._('Required:').'</em> '._('yes').'</p>';
$infolang["command"]["command_line"] = '<p><strong>'._('Command -').' </strong><strong>'._('command line').'</strong></p><p>'._('This directive is used to define what is actually executed by Nagios when the command is used for service or host checks, notifications, or event handlers. Before the command line is executed, all valid macros are replaced with their respective values. See the documentation on macros for determining when you can use different macros. Note that the command line is').' <em>'._('not').'</em> '._('surrounded in quotes. Also, if you want to pass a dollar sign ($) on the command line, you have to escape it with another dollar sign.').'</p><p><strong>'._('NOTE').'</strong>: '._('You may not include a').' <strong>'._('semicolon').'</strong> '._('(;) in the').' <em>command_line</em> '._('directive, because everything after it will be ignored as a config file comment. You can work around this limitation by setting one of the').' <strong>$USER$</strong> '._('macros in your resource file to a semicolon and then referencing the appropriate').' $USER$ '._('macro in the').' <em>command_line</em> '._('directive in place of the semicolon.').'</p><p>'._('If you want to pass arguments to commands during runtime, you can use').' <strong>$ARGn$</strong> '._('macros in the').' <em>command_line</em> '._('directive of the command definition and then separate individual arguments from the command name (and from each other) using bang (!) characters in the object definition directive (host check command, service event handler command, etc) that references the command. More information on how arguments in command definitions are processed during runtime can be found in the documentation on macros.').'</p><p><em>'._('Parameter name:').'</em> command_line<br> <em>'._('Required:').'</em> '._('yes').'</p>';
$infolang["command"]["command_type"] = '<p><strong>'._('Command -').' </strong><strong>'._('command type').'</strong></p><p>'._('This directive is used to differ checks and misc commands. Its a NagiosQL definition only.').'</p><p>'._('Commands tagged as "check command" will be displayed in services and hosts as check command').'.</p><p>'._('Commands tagged as "misc command" will be displayed in contacts, services and hosts as event command.').'</p><p>'._('Not classified commands will be displayed everywhere.</p><p>This definition is only used to reduce the amount of commands shown in the selection fields and to have a more clear view').'.</p>';
$infolang["hostdependency"]["dependent_host"] = '<p><strong>'._('Hostdependency -').' </strong><strong>'._('dependent host name').'</strong></p><p>'._('This directive is used to identify the').' <em>'._('short name(s)').'</em> '._('of the').' <em>'._('dependent').'</em> '._('host(s).  Multiple hosts should be separated by commas').'</p><p><em>'._('Parameter name:').'</em> dependent_host_name<br> <em>'._('Required:').'</em> '._('yes (no, if a dependent hostgroup is defined)').'</p>';
$infolang["hostdependency"]["dependent_hostgroups"] = '<p><strong>'._('Hostdependency -').' </strong><strong>'._('dependent hostgroup name').'</strong></p><p>'._('This directive is used to identify the').' <em>'._('short name(s)').'</em> '._('of the').' <em>'._('dependent').'</em>'._('hostgroup(s). Multiple hostgroups should be separated by commas. The dependent_hostgroup_name may be used instead of, or in addition to, the dependent_host_name directive.').'</p><p><em>'._('Parameter name:').'</em> dependent_hostgroup_name<br> <em>'._('Required:').'</em> '._('no (yes, if no dependent host is defined)').'</p>';
$infolang["hostdependency"]["host"] = '<p><strong>'._('Hostdependency -').' </strong><strong>'._('host name').'</strong></p><p>'._('This directive is used to identify the').' <em>'._('short name(s)').'</em> '._('of the host(s)').' <em>'._('that is being depended upon').'</em> '._('(also referred to as the master host).  Multiple hosts should be separated by commas.').'</p><p><em>'._('Parameter name:').'</em> host_name<br> <em>'._('Required:').'</em> '._('yes (no, if&nbsp; a hostgroup is defined)').'</p>';
$infolang["hostdependency"]["hostgroup"] = '<p><strong>'._('Hostdependency -').' </strong><strong>'._('hostgroup name').'</strong></p><p>'._('This directive is used to identify the').' <em>'._('short name(s)').'</em> '._('of the host(s)').' <em>'._('that is being depended upon').'</em> '._('(also referred to as the master host).  Multiple hosts should be separated by commas.').'</p><p><em>'._('Parameter name:').'</em> hostgroup_name<br> <em>'._('Required:').'</em> '._('no (yes, if a no host is defined)').'</p>';
$infolang["hostdependency"]["config_name"] = '<p><strong>'._('Hostdependency - config name').'</strong></p><p>'._('This directive is used to specify a common config name for a hostdependency configration. This is a NagiosQL parameter and it will not be written to the configuration file.').'</p>';
$infolang["hostdependency"]["inherit_parents"] = '<p><strong>'._('Hostdependency -').' </strong><strong>'._('inherits parent').'</strong></p><p>'._('This directive indicates whether or not the dependency inherits dependencies of the host').' <em>'._('that is being depended upon').'</em> '._('(also referred to as the master host). In other words, if the master host is dependent upon other hosts and any one of those dependencies fail, this dependency will also fail.').'</p><p><em>'._('Parameter name:').'</em> inherits_parent<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["hostdependency"]["dependency_period"] = '<p><strong>'._('Hostdependency -').' </strong><strong>dependency_period</strong></p><p>'._('This directive is used to specify the short name of the time period during which this dependency is valid. If this directive is not specified, the dependency is considered to be valid during all times.').'</p><p><em>'._('Parameter name:').'</em> dependency_period<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["hostdependency"]["execution_failure_criteria"] = '<p><strong>'._('Hostdependency -').' </strong><strong>'._('execution failure criteria').'</strong></p><p>'._('This directive is used to specify the criteria that determine when the dependent host should').' <em>'._('not').'</em> '._('be actively checked.  If the').' <em>'._('master').'</em> '._('host is in one of the failure states we specify, the').' <em>'._('dependent').'</em> '._('host will not be actively checked. Valid options are a combination of one or more of the following (multiple options are separated with commas): ').'<br><strong>o</strong> = '._('fail on an UP state,').' <br><strong>d</strong> = '._('fail on a DOWN state,').' <br><strong>u</strong> = '._('fail on an UNREACHABLE state, and').' <strong><br>p</strong> = '._('fail on a pending state (e.g. the host has not yet been checked).').'</p><p>'._('If you specify ').'<strong>n</strong> '._('(none) as an option, the execution dependency will never fail and the dependent host will always be actively checked (if other conditions allow for it to be).').'</p><p>'._('Example: If you specify').' <strong>u,d</strong> '._('in this field, the').' <em>'._('dependent').'</em> '._('host will not be actively checked if the').' <em>'._('master').'</em> '._('host is in either an UNREACHABLE or DOWN state.').'</p><p><em>'._('Parameter name:').'</em> execution_failure_criteria<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["hostdependency"]["notification_failure_criteria"] = '<p><strong>'._('Hostdependency -').' </strong><strong>'._('notification failure criteria').'</strong></p><p>'._('This directive is used to define the criteria that determine when notifications for the dependent host should <em>not</em> be sent out.  If the <em>master</em> host is in one of the failure states we specify, notifications for the').' <em>'._('dependent').'</em> '._('host will not be sent to contacts.  Valid options are a combination of one or more of the following:').' <br><strong>o</strong> = '._('fail on an UP state,').' <br><strong>d</strong> = '._('fail on a DOWN state,').' <br><strong>u</strong> = '._('fail on an UNREACHABLE state, and').' <br><strong>p</strong> = '._('fail on a pending state (e.g. the host has not yet been checked).').'</p><p>'._('If you specify').' <strong>n</strong> '._('(none) as an option, the notification dependency will never fail and notifications for the dependent host will always be sent out.').'</p><p>'._('Example: If you specify').' <strong>d</strong> '._('in this field, the notifications for the').' <em>'._('dependent').'</em> '._('host will not be sent out if the').' <em>'._('master').'</em> '._('host is in a DOWN state.').'</p><p><em>'._('Parameter name:').'</em> notification_failure_criteria<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["hostescalation"]["host"] = '<p><strong>'._('Hostescalation -').' </strong><strong>'._('host name').'</strong></p><p>'._('This directive is used to identify the').' <em>'._('short name').'</em> '._('of the host that the escalation should apply to.').'</p><p><em>'._('Parameter name:').'</em> host_name<br> <em>'._('Required:').'</em> '._('yes (no, if a hostgroup name is defined').'</p>';
$infolang["hostescalation"]["hostgroup"] = '<p><strong>'._('Hostescalation -').' </strong><strong>'._('hostgroup name').'</strong><strong></strong></p><p>'._('This directive is used to identify the').' <em>'._('short name(s)').'</em> '._('of the hostgroup(s) that the escalation should apply to. Multiple hostgroups should be separated by commas. If this is used, the escalation will apply to all hosts that are members of the specified hostgroup(s).').'</p><p><em>'._('Parameter name:').'</em> hostgroup_name<br> <em>'._('Required:').'</em> no (yes, if no host ist defined)</p>';
$infolang["hostescalation"]["contact"] = '<p><strong>'._('Hostescalation -').' </strong><strong>'._('contacts').'</strong><strong></strong></p><p>'._('This is a list of the').' <em>'._('short names').'</em> '._('of the contacts that should be notified whenever there are problems (or recoveries) with this host. Multiple contacts should be separated by commas. Useful if you want notifications to go to just a few people and don\'t want to configure contact groups.  You must specify at least one contact or contact group in each host escalation definition.').'</p><p><em>'._('Parameter name:').'</em> contacts<br> <em>'._('Required:').'</em> '._('yes (no, if a contactgroup is defined)').'</p>';
$infolang["hostescalation"]["contactgroup"] = '<p><strong>'._('Hostescalation -').' </strong><strong>'._('contact groups').'</strong></p><p>'._('This directive is used to identify the').' <em>'._('short name').'</em> '._('of the contact group that should be notified when the host notification is escalated. Multiple contact groups should be separated by commas. You must specify at least one contact or contact group in each host escalation definition.').'</p><p><em>'._('Parameter name:').'</em> contact_groups<br> <em>'._('Required:').'</em> '._('yes (no, if a contact is defined)').'</p>';
$infolang["hostescalation"]["config_name"] = '<p><strong>Hostescalation - '._('config name').'</strong></p><p>'._('This directive is used to specify a common config name for a hostescalation configration. This is a NagiosQL parameter and it will not be written to the configuration file.').'</p>';
$infolang["hostescalation"]["escalation_period"] = '<p><strong>'._('Hostescalation -').' </strong><strong>'._('escalation period').'</strong></p><p>'._('This directive is used to specify the short name of the time period during which this escalation is valid. If this directive is not specified, the escalation is considered to be valid during all times.').'</p><p><em>'._('Parameter name:').'</em> escalation_period<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["hostescalation"]["escalation_options"] = '<p><strong>'._('Hostescalation -').' </strong><strong>escalation options</strong><strong></strong></p><p>'._('This directive is used to define the criteria that determine when this host escalation is used. The escalation is used only if the host is in one of the states specified in this directive. If this directive is not specified in a host escalation, the escalation is considered to be valid during all host states. Valid options are a combination of one or more of the following').': <br><strong>r</strong> = '._('escalate on an UP (recovery) state,').' <br><strong>d</strong> = '._('escalate on a DOWN state, and').' <strong><br>u</strong> = '._('escalate on an UNREACHABLE state.').'</p><p>'._('Example: If you specify').' <strong>d</strong> '._('in this field, the escalation will only be used if the host is in a DOWN state.').'</p><p><em>'._('Parameter name:').'</em> escalation_options<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["hostescalation"]["first_notification"] = '<p><strong>'._('Hostescalation -').' </strong><strong>'._('first notification').'</strong><strong></strong></p><p>'._('This directive is a number that identifies the <em>first</em> notification for which this escalation is effective. For instance, if you set this value to 3, this escalation will only be used if the host is down or unreachable long enough for a third notification to go out.').'</p><p><em>'._('Parameter name:').'</em> first_notification<br> <em>'._('Required:').'</em> '._('yes').'</p>';
$infolang["hostescalation"]["last_notification"] = '<p><strong>'._('Hostescalation -').' </strong><strong>'._('last notification').'</strong></p><p>'._('This directive is a number that identifies the').' <em>'._('last').'</em> '._('notification for which this escalation is effective. For instance, if you set this value to 5, this escalation will not be used if more than five notifications are sent out for the host. Setting this value to 0 means to keep using this escalation entry forever (no matter how many notifications go out).').'</p><p><em>'._('Parameter name:').'</em> last_notification<br> <em>'._('Required:').'</em> '._('yes').'</p>';
$infolang["hostescalation"]["notification_interval"] = '<p><strong>'._('Hostescalation -').' </strong><strong>'._('notification interval').'</strong></p><p>'._('This directive is used to determine the interval at which notifications should be made while this escalation is valid. If you specify a value of 0 for the interval, Nagios will send the first notification when this escalation definition is valid, but will then prevent any more problem notifications from being sent out for the host. Notifications are sent out again until the host recovers.</p><p>This is useful if you want to stop having notifications sent out after a certain amount of time. Note: If multiple escalation entries for a host overlap for one or more notification ranges, the smallest notification interval from all escalation entries is used.').'</p><p><em>'._('Parameter name:').'</em> notification_interval<br> <em>'._('Required:').'</em> '._('yes').'</p>';
$infolang["hostextinfo"]["host_name"] = '<p><strong>'._('Hostextinfo -').' </strong><strong>host name</strong></p><p>'._('This variable is used to identify the').' <em>'._('short name').'</em> '._('of the host which the data is associated with.').'</p><p><em>'._('Parameter name:').'</em> host_name<br> <em>'._('Required:').'</em> '._('yes').'</p>';
$infolang["hostextinfo"]["icon_image"] = '<p><strong>'._('Hostextinfo -').' </strong><strong>'._('icon image').'</strong></p><p>'._('This variable is used to define the name of a GIF, PNG, or JPG image that should be associated with this host. This image will be displayed in the status and extended information CGIs.  The image will look best if it is 40x40 pixels in size.').'</p><p>'._('Images for hosts are assumed to be in the').' <strong>logos/</strong> '._('subdirectory in your HTML images directory').' (i.e. <em>/usr/local/nagios/share/images/logos</em>).</p><p><em>'._('Parameter name:').'</em> icon_image<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["hostextinfo"]["notes"] = '<p><strong>'._('Hostextinfo -').' </strong><strong>'._('notes').'</strong><strong></strong></p><p>'._('This directive is used to define an optional string of notes pertaining to the host. If you specify a note here, you will see the it in the extended information CGI (when you are viewing information about the specified host).').'</p><p><em>'._('Parameter name:').'</em> notes<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["hostextinfo"]["icon_image_alt_text"] = '<p><strong>'._('Hostextinfo -').' </strong><strong>'._('icon image alt').'</strong><strong></strong></p><p>'._('This variable is used to define an optional string that is used in the ALT tag of the image specified by the ').'<em>&lt;icon_image&gt;</em> '._('argument.').'  '._('The ALT tag is used in the status, extended information and statusmap CGIs').'.</p><p><em>'._('Parameter name:').'</em> icon_image_alt<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["hostextinfo"]["notes_url"] = '<p><strong>'._('Hostextinfo -').' </strong><strong>'._('notes url').'</strong></p><p>'._('This variable is used to define an optional URL that can be used to provide more information about the host. If you specify an URL, you will see a link that says "Extra Host Notes" in the extended information CGI (when you are viewing information about the specified host).').' '._('Any valid URL can be used. If you plan on using relative paths, the base path will the the same as what is used to access the CGIs').' (i.e. <em>/cgi-bin/nagios/</em>). '._('This can be very useful if you want to make detailed information on the host, emergency contact methods, etc. available to other support staff.').'</p><p><em>'._('Parameter name:').'</em> notes_url<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["hostextinfo"]["vrml_image"] = '<p><strong>'._('Hostextinfo -').' </strong><strong>'._('vrml image').'</strong><strong></strong></p><p>'._('This variable is used to define the name of a GIF, PNG, or JPG image that should be associated with this host. This image will be used as the texture map for the specified host in the').' <a href="http://nagios.sourceforge.net/docs/3_0/cgis.html#statuswrl_cgi">'._('statuswrl').'</a> '._('CGI.').'  '._('Unlike the image you use for the').' <em>icon_image</em> '._('variable, this one should probably <em>not</em> have any transparency.  If it does, the host object will look a bit wierd.').'</p><p>'._('Images for hosts are assumed to be in the').' <strong>logos/</strong> '._('subdirectory in your HTML images directory').' (i.e. <em>/usr/local/nagios/share/images/logos</em>).</p><p><em>'._('Parameter name:').'</em> vrml_image<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["hostextinfo"]["action_url"] = '<p><strong>'._('Hostextinfo -').' </strong><strong>'._('action url').'</strong></p><p>'._('This directive is used to define an optional URL that can be used to provide more actions to be performed on the host. If you specify an URL, you will see a link that says "Extra Host Actions" in the extended information CGI (when you are viewing information about the specified host). Any valid URL can be used. If you plan on using relative paths, the base path will the the same as what is used to access the CGIs ').'(i.e. <em>/cgi-bin/nagios/</em>).</p><p><em>'._('Parameter name:').'</em> action_url<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["hostextinfo"]["status_image"] = '<p><strong>'._('Hostextinfo -').' </strong><strong>'._('statusmap image').'</strong></p><p>'._('This variable is used to define the name of an image that should be associated with this host in the statusmap CGI. You can specify a JPEG, PNG, and GIF image if you want, although I would strongly suggest using a GD2 format image, as other image formats will result in a lot of wasted CPU time when the statusmap image is generated.').'</p><p>'._('GD2 images can be created from PNG images by using the ').'<strong>pngtogd2</strong> '._('utility supplied with Thomas Boutell\'s gd library.  The GD2 images should be created in').' <em>'._('uncompressed').'</em> '._('format in order to minimize CPU load when the statusmap CGI is generating the network map image.').'</p><p>'._('The image will look best if it is 40x40 pixels in size. You can leave these option blank if you are not using the statusmap CGI. Images for hosts are assumed to be in the').' <strong>logos/</strong> '._('subdirectory in your HTML images directory').' (i.e. <em>/usr/local/nagios/share/images/logos</em>).</p><p><em>'._('Parameter name:').'</em> statusmap_image<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["hostextinfo"]["2d_coords"] = '<p><strong>'._('Hostextinfo -').' </strong><strong>'._('2d coords').'</strong></p><p>'._('This variable is used to define coordinates to use when drawing the host in the statusmap CGI. Coordinates should be given in positive integers, as they correspond to physical pixels in the generated image. The origin for drawing (0,0) is in the upper left hand corner of the image and extends in the positive x direction (to the right) along the top of the image and in the positive y direction (down) along the left hand side of the image. For reference, the size of the icons drawn is usually about 40x40 pixels (text takes a little extra space). The coordinates you specify here are for the upper left hand corner of the host icon that is drawn.').'</p><p>'._('Note: Don\'t worry about what the maximum x and y coordinates that you can use are. The CGI will automatically calculate the maximum dimensions of the image it creates based on the largest x and y coordinates you specify.').'</p><p><em>'._('Parameter name:').'</em> 2d_coords<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["hostextinfo"]["3d_coords"] = '<p><strong>'._('Hostextinfo -').' </strong><strong>'._('3d coords').'</strong></p><p>'._('This variable is used to define coordinates to use when drawing the host in the statuswrl CGI. Coordinates can be positive or negative real numbers. The origin for drawing is (0.0,0.0,0.0). For reference, the size of the host cubes drawn is 0.5 units on each side (text takes a little more space). The coordinates you specify here are used as the center of the host cube.').'</p><p><em>'._('Parameter name:').'</em> 3d_coords<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["serviceescalation"]["host"] = '<p><strong>'._('Serviceescalation -').' </strong><strong>'._('host name').'</strong><strong></strong></p><p>'._('This directive is used to identify the').' <em>'._('short name(s)').'</em> '._('of the host(s) that the service escalation should apply to or is associated with').'.</p><p><em>'._('Parameter name:').'</em> host_name<br> <em>'._('Required:').'</em> '._('yes (no, if a hostgroup name is defined)').'</p>';
$infolang["serviceescalation"]["hostgroup"] = '<p><strong>'._('Serviceescalation -').' </strong><strong>'._('hostgroup name').'</strong></p><p>'._('This directive is used to specify the').' <em>'._('short name(s)').'</em> '._('of the hostgroup(s) that the service escalation should apply to or is associated with. Multiple hostgroups should be separated by commas. The hostgroup_name may be used instead of, or in addition to, the host_name directive.').'</p><p><em>'._('Parameter name:').'</em> hostgroup_name<br> <em>'._('Required:').'</em> '._('yes (no, if a host name is defined)').'</p>';
$infolang["serviceescalation"]["contact"] = '<p><strong>'._('Serviceescalation -').' </strong><strong>'._('contacts').'</strong></p><p>'._('This is a list of the').' <em>'._('short names').'</em> '._('of the contacts that should be notified whenever there are problems (or recoveries) with this service. Multiple contacts should be separated by commas. Useful if you want notifications to go to just a few people and don\'t want to configure contact groups.  You must specify at least one contact or contact group in each service escalation definition.').'</p><p><em>'._('Parameter name:').'</em> '._('contacts').'<br> <em>'._('Required:').'</em> '._('yes (no, if a contact group is defined)').'</p>';
$infolang["serviceescalation"]["contactgroup"] = '<p><strong>'._('Serviceescalation -').' </strong><strong>'._('contact groups').'</strong></p><p>'._('This directive is used to identify the').' <em>'._('short name').'</em> '._('of the contact group that should be notified when the service notification is escalated. Multiple contact groups should be separated by commas. You must specify at least one contact or contact group in each service escalation definition.').'</p><p><em>'._('Parameter name:').'</em> contact_groups<br> <em>'._('Required:').'</em> '._('yes (no, if a contact is defined)').'</p>';
$infolang["serviceescalation"]["config_name"] = '<p><strong>'._('Serviceescalation - config name').'</strong></p><p>'._('This directive is used to specify a common config name for a serviceescalation configration. This is a NagiosQL parameter and it will not be written to the configuration file.').'</p>';
$infolang["serviceescalation"]["service"] = '<p><strong>'._('Serviceescalation -').' </strong><strong>'._('service description').'</strong><strong></strong></p><p>'._('This directive is used to identify the <em>description</em> of the service the escalation should apply').' to.</p><p><em>'._('Parameter name:').'</em> '._('service_description').'<br> <em>'._('Required:').'</em> '._('yes').'</p>';
$infolang["serviceescalation"]["first_notification"] = '<p><strong>'._('Serviceescalation -').' </strong><strong>'._('first notification').'</strong></p><p>'._('This directive is a number that identifies the').' <em>'._('first').'</em> '._('notification for which this escalation is effective. For instance, if you set this value to 3, this escalation will only be used if the service is in a non-OK state long enough for a third notification to go out.').'</p><p><em>'._('Parameter name:').'</em> '._('first_notification').'<br> <em>'._('Required:').'</em> '._('yes').'</p>';
$infolang["serviceescalation"]["last_notification"] = '<p><strong>'._('Serviceescalation -').' </strong><strong>'._('last notification').'</strong></p><p>'._('This directive is a number that identifies the').' <em>'._('last').'</em> '._('notification for which this escalation is effective. For instance, if you set this value to 5, this escalation will not be used if more than five notifications are sent out for the service. Setting this value to 0 means to keep using this escalation entry forever (no matter how many notifications go out).').'</p><p><em>'._('Parameter name:').'</em> '._('last_notification').'<br> <em>'._('Required:').'</em> '._('yes').'</p>';
$infolang["serviceescalation"]["notification_interval"] = '<p><strong>'._('Serviceescalation -').' </strong><strong>'._('notification interval').'</strong></p><p>'._('This directive is used to determine the interval at which notifications should be made while this escalation is valid. If you specify a value of 0 for the interval, Nagios will send the first notification when this escalation definition is valid, but will then prevent any more problem notifications from being sent out for the host. Notifications are sent out again until the host recovers.').'</p><p>'._('This is useful if you want to stop having notifications sent out after a certain amount of time. Note: If multiple escalation entries for a host overlap for one or more notification ranges, the smallest notification interval from all escalation entries is used.').'</p><p><em>'._('Parameter name:').'</em> '._('notification_interval').'<br> <em>'._('Required:').'</em> '._('yes').'</p>';
$infolang["serviceescalation"]["escalation_period"] = '<p><strong>'._('Serviceescalation -').' </strong><strong>'._('escalation period').'</strong></p><p>'._('This directive is used to specify the short name of the time period during which this escalation is valid. If this directive is not specified, the escalation is considered to be valid during all times.').'</p><p><em>'._('Parameter name:').'</em> '._('escalation_period').'<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["serviceescalation"]["escalation_options"] = '<p><strong>'._('Serviceescalation -').' </strong><strong>'._('escalation options').'</strong></p><p>'._('This directive is used to define the criteria that determine when this service escalation is used. The escalation is used only if the service is in one of the states specified in this directive. If this directive is not specified in a service escalation, the escalation is considered to be valid during all service states. Valid options are a combination of one or more of the following:').' <strong><br>r</strong> = '._('escalate on an OK (recovery) state,').' <br><strong>w</strong> = '._('escalate on a WARNING state,').' <strong><br>u</strong> = '._('escalate on an UNKNOWN state, and').' <br><strong>c</strong> = '._('escalate on a CRITICAL state.').'</p><p>'._('Example: If you specify').' <strong>w</strong> '._('in this field, the escalation will only be used if the service is in a WARNING state.').'</p><p><em>'._('Parameter name:').'</em> escalation_options<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["servicedependency"]["dependent_host"] = '<p><strong>'._('Servicedependency - ').'</strong><strong>'._('dependent host').'</strong></p><p>'._('This directive is used to identify the').' <em>'._('short name(s)').'</em> '._('of the host(s) that the').' <em>'._('dependent').'</em> '._('service "runs" on or is associated with. Multiple hosts should be separated by commas. Leaving this directive blank can be used to create "same host" dependencies.').'</p><p><em>'._('Parameter name:').'</em> '._('dependent_host').'<br> <em>'._('Required:').'</em> '._('yes (no, if a dependent hostgroup is defined)').'</p>';
$infolang["servicedependency"]["host"] = '<p><strong>'._('Servicedependency -').'</strong><strong> </strong><strong>'._('host name').'</strong></p><p>'._('This directive is used to identify the').' <em>'._('short name(s)').'</em> '._('of the host(s) that the service').' <em>'._('that is being depended upon').'</em> '._('(also referred to as the master service) "runs" on or is associated with.  Multiple hosts should be separated by commas.').'</p><p><em>'._('Parameter name:').'</em> host_name<br> <em>'._('Required:').'</em> yes (no, if a hostgroup is defined)</p>';
$infolang["servicedependency"]["dependent_hostgroup"] = '<p><strong>'._('Servicedependency - ').'</strong><strong>'._('dependent hostgroup').'</strong></p><p>'._('This directive is used to specify the').' <em>'._('short name(s)').'</em> '._('of the hostgroup(s) that the').' <em>'._('dependent').'</em> '._('service "runs" on or is associated with. Multiple hostgroups should be separated by commas. The dependent_hostgroup may be used instead of, or in addition to, the dependent_host directive.').'</p><p><em>'._('Parameter name:').'</em> dependent_hostgroup<br> <em>'._('Required:').'</em> '._('yes (no, if a dependent host is defined)').'</p>';
$infolang["servicedependency"]["hostgroup"] = '<p><strong>'._('Servicedependency -').'</strong><strong> </strong><strong>'._('hostgroup name').'</strong></p><p>'._('This directive is used to identify the').' <em>'._('short name(s)').'</em> '._('of the hostgroup(s)').' '._('that the service').' <em>'._('that is being depended upon').'</em> '._('(also referred to as the master service) "runs" on or is associated with. Multiple hostgroups should be separated by commas. The hostgroup_name may be used instead of, or in addition to, the host_name directive.').'</p><p><em>'._('Parameter name:').'</em> hostgroup_name<br> <em>'._('Required:').'</em> '._('yes (no, if a host is defined)').'</p>';
$infolang["servicedependency"]["dependent_services"] = '<p><strong>'._('Servicedependency -').'</strong><strong> '._('dependent service description').'</strong><strong></strong></p><p>'._('This directive is used to identify the').' <em>'._('description').'</em> '._('of the').' <em>'._('dependent').'</em> '._('service.').'</p><p><em>'._('Parameter name:').'</em> dependent_service_description<br> <em>'._('Required:').'</em> '._('yes').'</p>';
$infolang["servicedependency"]["services"] = '<p><strong>'._('Servicedependency -').'</strong><strong> </strong><strong>'._('service description').'</strong><strong></strong></p><p>'._('This directive is used to identify the').' <em>'._('description').'</em> '._('of the service <em>that is being depended upon').'</em> '._('(also referred to as the master service).').'</p><p><em>'._('Parameter name:').'</em> service_description<br> <em>'._('Required:').'</em> '._('yes').'</p>';
$infolang["servicedependency"]["config_name"] = '<p><strong>'._('Servicedependency - config name').'</strong></p><p>'._('This directive is used to specify a common config name for a servicedependency configration. This is a NagiosQL parameter and it will not be written to the configuration file.').'</p>';
$infolang["servicedependency"]["inherit_parents"] = '<p><strong>'._('Servicedependency -').'</strong><strong> </strong><strong>'._('inherits parent').'</strong></p><p>'._('This directive indicates whether or not the dependency inherits dependencies of the service <em>that is being depended upon').'</em>'._(' (also referred to as the master service). In other words, if the master service is dependent upon other services and any one of those dependencies fail, this dependency will also fail.').'</p><p><em>'._('Parameter name:').'</em> inherits_parent<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["servicedependency"]["dependency_period"] = '<p><strong>'._('Servicedependency -').'</strong><strong> </strong><strong>dependency period</strong><strong></strong></p><p>'._('This directive is used to specify the short name of the time period during which this dependency is valid. If this directive is not specified, the dependency is considered to be valid during all times.').'</p><p><em>'._('Parameter name:').'</em> dependency_period<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["servicedependency"]["execution_failure_criteria"] = '<p><strong>'._('Servicedependency -').'</strong><strong> </strong><strong>'._('execution failure criteria').'</strong><strong></strong></p><p>'._('This directive is used to specify the criteria that determine when the dependent service should').' <em>'._('not').'</em> '._('be actively checked.').'  '._('If the').' <em>'._('master').'</em> '._('service is in one of the failure states we specify, the').' <em>'._('dependent').'</em> '._('service will not be actively checked.').' '._('Valid options are a combination of one or more of the following (multiple options are separated with commas):').' <br><strong>o</strong> = '._('fail on an OK state,').' <br><strong>w</strong> = '._('fail on a WARNING state,').' <strong><br>u</strong> = '._('fail on an UNKNOWN state,').' <br><strong>c</strong> = '._('fail on a CRITICAL state, and').' <br><strong>p</strong> = '._('fail on a pending state (e.g. the service has not yet been checked).').'  <br>'._('If you specify <strong>n</strong> (none) as an option, the execution dependency will never fail and checks of the dependent service will always be actively checked (if other conditions allow for it to be).').'</p><p>'._('Example: If you specify').' <strong>o,c,u</strong> '._('in this field, the').' <em>'._('dependent').'</em> '._('service will not be actively checked if the').' <em>'._('master').'</em> '._('service is in either an OK, a CRITICAL, or an UNKNOWN state.').'</p><p><em>'._('Parameter name:').'</em> execution_failure_criteria<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["servicedependency"]["notification_failure_criteria"] = '<p><strong>'._('Servicedependency -').'</strong><strong> </strong><strong>'._('notification failure criteria').'</strong><strong></strong></p><p>'._('This directive is used to define the criteria that determine when notifications for the dependent service should').' <em>'._('not').'</em> '._('be sent out.').'  '._('If the ').'<em>'._('master').'</em> '._('service is in one of the failure states we specify, notifications for the').' <em>'._('dependent').'</em>' ._('service will not be sent to contacts.  Valid options are a combination of one or more of the following:').' <strong><br>o</strong> = '._('fail on an OK state,').' <br><strong>w</strong> = '._('fail on a WARNING state,').' <strong><br>u</strong> = '._('fail on an UNKNOWN state,').' <br><strong>c</strong> = '._('fail on a CRITICAL state, and').' <br><strong>p</strong> = '._('fail on a pending state (e.g. the service has not yet been checked).').'  <br>'._('If you specify').' <strong>n</strong> '._('(none) as an option, the notification dependency will never fail and notifications for the dependent service will always be sent out.').'</p><p>'._('Example: If you specify').' <strong>w</strong> '._('in this field, the notifications for the').' <em>'._('dependent').'</em> '._('service will not be sent out if the').' <em>'._('master').'</em> '._('service is in a WARNING state.').'</p><p><em>'._('Parameter name:').'</em> notification_failure_criteria<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["serviceextinfo"]["host_name"] = '<p><strong>'._('Serviceextinfo -').'</strong><strong> </strong><strong>'._('host name').'</strong></p><p>T'._('his directive is used to identify the <em>short name</em> of the host that the service is associated with.').'</p><p><em>'._('Parameter name:').'</em> host_name<br> <em>'._('Required:').'</em> '._('yes').'</p>';
$infolang["serviceextinfo"]["icon_image"] = '<p><strong>'._('Serviceextinfo -').'</strong><strong> </strong><strong>icon image</strong></p><p>'._('This variable is used to define the name of a GIF, PNG, or JPG image that should be associated with this host. This image will be displayed in the status and extended information CGIs.').'</p><p>'._('The image will look best if it is 40x40 pixels in size.  Images for hosts are assumed to be in the <strong>logos/</strong> subdirectory in your HTML images directory').' (i.e. <em>/usr/local/nagios/share/images/logos</em>).</p><p><em>'._('Parameter name:').'</em> icon_image<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["serviceextinfo"]["service_description"] = '<p><strong>'._('Serviceextinfo -').'</strong><strong> </strong><strong>'._('service description').'</strong></p><p>'._('This directive is description of the service which the data is associated with.').'</p><p><em>'._('Parameter name:').'</em> service_description<br> <em>'._('Required:').'</em> '._('yes').'</p>';
$infolang["serviceextinfo"]["notes"] = '<p><strong>'._('Serviceextinfo -').'</strong><strong> </strong><strong>'._('notes').'</strong></p><p>'._('This directive is used to define an optional string of notes pertaining to the service. If you specify a note here, you will see the it in the extended information CGI (when you are viewing information about the specified service).').'</p><p><em>'._('Parameter name:').'</em> notes<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["serviceextinfo"]["action_url"] = '<p><strong>'._('Serviceextinfo -').'</strong><strong> </strong><strong>'._('action url').'</strong></p><p>'._('This directive is used to define an optional URL that can be used to provide more actions to be performed on the service. If you specify an URL, you will see a link that says "Extra Service Actions" in the extended information CGI (when you are viewing information about the specified service). Any valid URL can be used. If you plan on using relative paths, the base path will the the same as what is used to access the CGIs').' (i.e. <em>/cgi-bin/nagios/</em>).</p><p><em>'._('Parameter name:').'</em> action_url<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["serviceextinfo"]["notes_url"] = '<p><strong>'._('Serviceextinfo -').'</strong><strong> </strong><strong>'._('notes url').'</strong></p><p>'._('This directive is used to define an optional URL that can be used to provide more information about the service. If you specify an URL, you will see a link that says "Extra Service Notes" in the extended information CGI (when you are viewing information about the specified service). Any valid URL can be used.</p><p>If you plan on using relative paths, the base path will the the same as what is used to access the CGIs').' (i.e. <em>/cgi-bin/nagios/</em>). '._('This can be very useful if you want to make detailed information on the service, emergency contact methods, etc. available to other support staff.').'</p><p><em>'._('Parameter name:').'</em> notes_url<br> <em>'._('Required:').'</em> '._('no').'</p>';
$infolang["serviceextinfo"]["icon_image_alt"] = '<p><strong>'._('Serviceextinfo -').'</strong><strong> </strong><strong>'._('icon image alt').'</strong><strong></strong></p><p>'._('This variable is used to define an optional string that is used in the ALT tag of the image specified by the ').'<em>&lt;icon_image&gt;</em> '._('argument.').'  '._('The ALT tag is used in the status, extended information and statusmap CGIs.').'</p><p><em>'._('Parameter name:').'</em> icon_image_alt<br> <em>'._('Required:').'</em> '._('no').'</p>';

function get_documentation_array($type, $opt)
{
    global $infolang;
    if (isset($infolang[$type][$opt])) {
        return $infolang[$type][$opt];
    }
    return '';
}

function get_documentation_fieldlist($type)
{
    global $infolang;
    if (isset($infolang[$type])) {
        return array_keys($infolang[$type]);
    }
    return '';
}