    <input type="hidden" id="selectedhostconfig" name="selectedhostconfig" value="<?= encode_form_val($selectedhostconfig) ?>" />
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />
<?php
    $bulk_fields_serial = base64_encode(json_encode($bulk_fields));
    /*<input type="hidden" id="backloaded-fields" value="<?= $bulk_fields ?>">*/
?>
    <input type="hidden" id="bulk_fields_serial" value="<?= $bulk_fields_serial ?>">
    <input type="hidden" name="snmpversion" id="snmpversion" value="<?= encode_form_val($snmpversion) ?>">
    <input type="hidden" name="selected_switches" id="selected_switches" value="">
    <input type="hidden" name="meraki_switches_data" id="meraki_switches_data" value="">
    <input type="hidden" name="debug_enabled" id="debug_enabled_hidden" value="<?= encode_form_val(grab_array_var($inargs, "debug_enabled")) ?>">
<?php
    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';
?>
    <div class="container m-0 g-0">
        <!--                         -->
        <!-- The configuration form. -->
        <!--                         -->
        <div id="configForm">

            <h2 class="mb-2"><?= _('Configuration Mode') ?></h2>

            <div class="row mb-4">
                <div class="col-sm-6">
                    <label class="form-label form-item-required"><?= _("Configuration Type") ?></label>
                    <div class="btn-group w-100" role="group" aria-label="Configuration Mode">
                        <input type="radio" class="btn-check" name="config_mode" id="config_mode_meraki" value="meraki" <?= is_checked($config_mode, "meraki", true) ?>>
                        <label class="btn btn-outline-primary" for="config_mode_meraki"><?= _("Use Meraki API") ?></label>
                        
                        <input type="radio" class="btn-check" name="config_mode" id="config_mode_manual" value="manual" <?= is_checked($config_mode, "manual") ?>>
                        <label class="btn btn-outline-primary" for="config_mode_manual"><?= _("Manual Configuration") ?></label>
                    </div>
                </div>
            </div>

            <div id="meraki_api_section">
                <div class="row mb-4">
                    <div class="col-sm-6">
                        <label for="meraki_api_key" class="form-label form-item-required"><?= _("Meraki API Key") ?> <?= xi6_info_tooltip(_("40-character Meraki API key for authentication")) ?></label>
                        <div class="input-group position-relative">
                            <input type="text" name="meraki_api_key" id="meraki_api_key" value="<?= encode_form_val($meraki_api_key) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter 40-character Meraki API Key") ?>" maxlength="40" minlength="40" pattern="[a-zA-Z0-9]{40}" size="40">
                            <div class="invalid-feedback">
                                <?= _("Please enter a valid 40-character Meraki API Key") ?>
                            </div>
                            <i id="meraki_api_key_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-6 d-flex align-items-end">
                        <button type="button" id="get_switch_info" class="btn btn-primary" onclick="getSwitchInfo()" disabled>
                            <i class="icon icon-search me-2"></i><?= _("Get Switch Info") ?>
                            <span id="switch_info_spinner" class="spinner-border spinner-border-sm ms-2" style="display: none;"></span>
                        </button>
                    </div>
                </div>

                <div id="switch_info_status" class="row mb-3" style="display: none;">
                    <div class="col-sm-12">
                        <div class="alert alert-info" role="alert">
                            <i class="icon icon-spinner icon-spin me-2"></i><?= _("Retrieving switch information...") ?>
                        </div>
                    </div>
                </div>

                <div id="switch_info_results" class="row mb-4" style="display: none;">
                    <div class="col-sm-12">
                        <h5 class="mb-3"><?= _("Available Switches") ?></h5>
                        <div class="table-responsive">
                            <table id="switch_table" class="table table-striped table-hover">
                                <thead class="table-dark">
                                    <tr>
                                        <th width="50"><?= _("Select") ?></th>
                                        <th><?= _("Name") ?></th>
                                        <th><?= _("IP Address") ?></th>
                                        <th><?= _("MAC Address") ?></th>
                                        <th><?= _("Serial") ?></th>
                                        <th><?= _("Model") ?></th>
                                        <th><?= _("SNMP Version") ?></th>
                                        <th><?= _("SNMP Info") ?></th>
                                    </tr>
                                </thead>
                                <tbody id="switch_table_body">
                                    <!-- Switch rows will be populated here -->
                                </tbody>
                            </table>
                        </div>
                        <div class="mt-3">
                            <button type="button" id="select_all_switches" class="btn btn-primary btn-sm">
                                <?= _("Select All") ?>
                            </button>
                            <button type="button" id="deselect_all_switches" class="btn btn-primary btn-sm ">
                                <?= _("Deselect All") ?>
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            <div id="manual_config_section" style="display: none;">
                <h2 class="mb-2"><?= _('Router/Switch Information') ?></h2>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="ip_address" class="form-label form-item-required"><?= _("IP Address") ?> <?= xi6_info_tooltip(_("The IP address of the network device to monitor.")) ?></label>
                    <div class="input-group position-relative">
                        <input type="text" name="ip_address" id="ip_address" value="<?= encode_form_val($address) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter IP Address") ?>" required>
                        <div class="invalid-feedback">
                            <?= _("Please enter the IP Address") ?>
                        </div>
                        <i id="ip_address_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="port" class="form-label form-item-required"><?= _("Port") ?> <?= xi6_info_tooltip(_("The port of the network device.")) ?></label>
                    <div class="input-group position-relative">
                        <input type="text" name="port" id="port" value="<?= encode_form_val($address_port) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter Port") ?>" required>
                        <div class="invalid-feedback">
                            <?= _("Please enter the Port") ?>
                        </div>
                        <i id="port_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <!-- SNMP Version Tabs -->
            <div class="col-sm-6 border-block mt-4">
                <ul class="nav nav-pills mb-3" id="pills-tab" role="tablist">
                    <li class="nav-item"><a class="nav-link" id="pills-snmpv1-tab" data-bs-toggle="pill" data-bs-target="#pills-snmpv1" type="button" role="tab" aria-controls="pills-snmpv1" aria-selected="false">SNMPv1</a></li>
                    <li class="nav-item"><a class="nav-link active" id="pills-snmpv2c-tab" data-bs-toggle="pill" data-bs-target="#pills-snmpv2c" type="button" role="tab" aria-controls="pills-snmpv2c" aria-selected="true">SNMPv2c</a></li>
                    <li class="nav-item"><a class="nav-link" id="pills-snmpv3-tab" data-bs-toggle="pill" data-bs-target="#pills-snmpv3" type="button" role="tab" aria-controls="pills-snmpv3" aria-selected="false">SNMPv3</a></li>
                </ul>

                <div class="tab-content" id="pills-tabContent">

                    <div id="pills-snmpv1" class="tab-pane fade show" role="tabpanel" aria-labelledby="pills-snmpv1-tab">

                        <div class="row mb-2">
                            <div class="col-sm">
                                <label for="snmpopts[snmpcommunity]" class="form-label form-item-required"><?= _("SNMP Community") ?> <?= xi6_info_tooltip(_("The SNMP community string required used to to query the network device")) ?></label>
                                <div class="input-group position-relative">
                                    <input type="text" name="snmpopts[snmpcommunity]" id="snmpopts[snmpcommunity]" value="<?= encode_form_val($snmpopts['snmpcommunity']) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter SNMP Community") ?>" required>
                                    <div class="invalid-feedback">
                                        <?= _("Please enter the SNMP Community") ?>
                                    </div>
                                    <i id="snmpopts_snmpcommunity_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                </div>
                            </div>
                        </div>
                    </div> <!-- Closes #snmpv1 -->

                    <div id="pills-snmpv2c" class="tab-pane fade show active" role="tabpanel" aria-labelledby="pills-snmpv2c-tab">

                        <div class="row mb-2">
                            <div class="col-sm">
                                <label for="snmpopts[snmpcommunity]" class="form-label form-item-required"><?= _("SNMP Community") ?> <?= xi6_info_tooltip(_("The SNMP community string required used to to query the network device")) ?></label>
                                <div class="input-group position-relative">
                                    <input type="text" name="snmpopts[snmpcommunity]" id="snmpopts[snmpcommunity]" value="<?= encode_form_val($snmpopts['snmpcommunity']) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter SNMP Community") ?>" required>
                                    <div class="invalid-feedback">
                                        <?= _("Please enter the SNMP Community") ?>
                                    </div>
                                    <i id="snmpopts_snmpcommunity_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                </div>
                            </div>
                        </div>
                    </div> <!-- Closes #snmpv2c -->

                    <div id="pills-snmpv3" class="tab-pane fade show" role="tabpanel" aria-labelledby="pills-snmpv3-tab">
                        <p><?= _("When using SNMP v3 authentication information is required.") ?>.</p>

                        <div class="row mb-2">
                            <div class="col-sm">
                                <label for="snmpopts[v3_security_level]" class="form-label form-item-required"><?= _("Security Level") ?> </label>
                                <div class="input-group position-relative">
                                    <select name="snmpopts[v3_security_level]" id="snmpopts[v3_security_level]" class="form-control form-select monitor rounded" placeholder="<?= _("Select a Security Level") ?> " required>
                                        <option value="authPriv" <?= is_selected($snmpopts["v3_security_level"], "authPriv") ?>>authPriv</option>
                                        <option value="authNoPriv" <?= is_selected($snmpopts["v3_security_level"], "authNoPriv") ?>>authNoPriv</option>
                                        <option value="noAuthNoPriv" <?= is_selected($snmpopts["v3_security_level"], "noAuthNoPriv") ?>>noAuthNoPriv</option>
                                    </select>
                                    <div class="invalid-feedback">
                                        <?= _("Please select a Security Level") ?>
                                    </div>
                                    <i id="snmpopts_v3_security_level_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                </div>
                            </div>
                        </div>

                        <div class="row mb-2">
                            <div class="col-sm">
                                <label for="snmpopts[v3_username]" class="form-label form-item-required"><?= _("Username") ?> </label>
                                <div class="input-group position-relative">
                                    <input type="text" id="snmpopts[v3_username]" name="snmpopts[v3_username]" value="<?= encode_form_val($snmpopts["v3_username"]) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter Username") ?>" required>
                                    <div class="invalid-feedback">
                                        <?= _("Please enter the Username") ?>
                                    </div>
                                    <i id="snmpopts_v3_username_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                </div>
                            </div>
                        </div>

                        <div class="row mb-2">
                            <div class="col-sm">
                                <label for="snmpopts[v3_auth_password]" class="form-label form-item-required"><?= _("Authentication Password") ?> </label>
                                <div class="input-group position-relative">
                                    <input type="text" id="snmpopts[v3_auth_password]" name="snmpopts[v3_auth_password]" value="<?= grab_array_var($snmpopts, "v3_auth_password"); ?>" class="form-control monitor rounded authPriv-enable authNoPriv-enable noAuthNoPriv-disable" placeholder="<?= _("Enter Authentication Password") ?>" required>
                                    <div class="invalid-feedback">
                                        <?= _("Please enter the Authentication Password") ?>
                                    </div>
                                    <i id="snmpopts_v3_auth_password_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                </div>
                            </div>
                        </div>

                        <div class="row mb-2">
                            <div class="col-sm">
                                <label for="snmpopts[v3_auth_proto]" class="form-label form-item-required"><?= _("Authentication Protocol") ?> </label>
                                <div class="input-group position-relative">
                                    <select name="snmpopts[v3_auth_proto]" id="snmpopts[v3_auth_proto]" class="form-select monitor rounded authPriv-enable authNoPriv-enable noAuthNoPriv-disable" placeholder="<?= _("Select Authentication Protocol") ?> " required>
                                        <option value="MD5" <?= is_selected(grab_array_var($snmpopts, "v3_auth_proto"), "MD5") ?>>MD5</option>
                                        <option value="SHA" <?= is_selected(grab_array_var($snmpopts, "v3_auth_proto"), "SHA") ?>>SHA</option>
                                    </select>
                                    <div class="invalid-feedback">
                                        <?= _("Please select Authentication Protocol") ?>
                                    </div>
                                    <i id="snmpopts_v3_auth_proto_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                </div>
                            </div>
                        </div>

                        <div class="row mb-2">
                            <div class="col-sm">
                                <label for="snmpopts[v3_priv_password]" class="form-label form-item-required"><?= _("Privacy Password") ?> </label>
                                <div class="input-group position-relative">
                                    <input type="text" id="snmpopts[v3_priv_password]" name="snmpopts[v3_priv_password]" value="<?= grab_array_var($snmpopts, "v3_priv_password") ?>" class="form-control monitor rounded authPriv-enable authNoPriv-disable noAuthNoPriv-disable" placeholder="<?= _("Enter Privacy Password") ?>" required>
                                    <div class="invalid-feedback">
                                        <?= _("Please enter the Privacy Password") ?>
                                    </div>
                                    <i id="snmpopts_v3_priv_password_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                </div>
                            </div>
                        </div>

                        <div class="row mb-2">
                            <div class="col-sm">
                                <label for="snmpopts[v3_priv_proto]" class="form-label form-item-required"><?= _("Privacy Protocol") ?> </label>
                                <div class="input-group position-relative">
                                    <select name="snmpopts[v3_priv_proto]" id="snmpopts[v3_priv_proto]" class="form-select monitor rounded authPriv-enable authNoPriv-disable noAuthNoPriv-disable" placeholder="<?= _("Select Privacy Protocol") ?> " required>
<?php
            $xisys = $cfg['root_dir'].'/var/xi-sys.cfg';
            $ini = parse_ini_file($xisys);

            $des_option = '';

            if ($ini['dist'] != "el9" && $ini['dist'] != "ubuntu22" && $ini['dist'] != "ubuntu24") {
?>
                                        <option value="DES" <?= is_selected((array_key_exists("v3_priv_proto", $snmpopts) && !empty($snmpopts["v3_priv_proto"]) ? $snmpopts["v3_priv_proto"] : "DES"), "DES") ?>>DES</option>
<?php
            }
?>
                                        <option value="AES" <?= is_selected((array_key_exists("v3_priv_proto", $snmpopts) && !empty($snmpopts["v3_priv_proto"]) ? $snmpopts["v3_priv_proto"] : "AES"), "AES") ?>>AES128</option>
                                    </select>
                                    <div class="invalid-feedback">
                                        <?= _("Please select Privacy Protocol") ?>
                                    </div>
                                    <i id="snmpopts_v3_priv_proto_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                </div>
                            </div>
                        </div>
                    </div> <!-- Closes #snmpv3 -->
                </div> <!-- End #tabs -->
            </div> <!-- #tabs - border-block -->

            <h2 class="mt-4"><?= _("Bulk Configuration")  ?></h2>
            <p><?= _('If you have many devices with the same port bandwidth and desired alerting thresholds, paste each configuration as a CSV in the space below.') ?></p>
            <ul class="list-group w-75">
                <li class="list-group-item"><?= _('The "IP Address" is required. Optionally, columns for "hostname", "snmpcommunity", can be included.') ?></li>
                <li class="list-group-item"><?= _('Additionally, with SNMP v3 columns "v3_security_level", "v3_username", "v3_auth_password", "v3_priv_password", "v3_auth_proto", and/or "v3_priv_proto", can be included.') ?></li>
            </ul>
<?php
    $example1 =
"192.168.1.23
192.168.1.34
10.1.1.134";

    # TODO: When second field is chosen, display example2.
    $example2 =
"192.168.1.23,Server
192.168.1.34,WebSphere
10.1.1.134,DBServer";
?>
            <div class="col-sm-10">
                <div class="row mt-4 mb-3" id="bulk-append-fields">
                    <div class="col-sm pe-0">
                        <label for="field1" class="form-label form-item-required"><?= _('Field') ?> 1 <?= xi6_info_tooltip(_('Specify the type of data present in the fields of data, below')) ?></label>
                        <div class="input-group position-relative">
                            <select name="bulk_fields[]" id="bulk_fields[]" class="form-select form-select-sm form-control-sm monitor rounded">
                                <option value="ip_address"><?= _('IP Address') ?></option>
                            </select>
                        </div>
                    </div>
                </div>

                <div class="row mb-4">
                    <div class="col-sm pe-0">
                        <label for="bulk_options" class="form-label"><?= _('Data') ?><?= xi6_info_tooltip(_('The addresses of new hosts that should be created by cloning the template host and services specified above. Multiple fields should be separated by a comma. One entry per line')) ?></label>
                        <textarea name="bulk_options" id="bulk_options" style="font-family: Consolas, Courier New, monospace;" class="form-control form-control-sm" placeholder="<?= $example1 ?>" rows="10"><?= $bulk_options ?></textarea>
                    </div>
                </div>

                <!-- # 2-3 -->
                <div id="sample-fields-v12c" class="hide">
                    <div class="col-sm ps-1 pe-0 bulk-remove-me">
                        <label for="field" class="form-label form-item-required"><?= _('Field') ?> </label>
                        <div class="input-group position-relative">
                            <select name="bulk_fields[]" id="bulk_fields[]" class="form-select form-select-sm form-control-sm monitor rounded">
                                <option value=""><?= _('IGNORE') ?></option>
                                <option value="hostname"><?= _("Hostname") ?></option>
                                <option value="snmpcommunity"><?= _('SNMP Community') ?></option>
                            </select>
                        </div>
                    </div>
                </div>

                <!-- # 2-7 -->
                <div id="sample-fields-v3" class="hide">
                    <div class="col-sm ps-1 pe-0 bulk-remove-me">
                        <label for="field" class="form-label form-item-required"><?= _('Field') ?> </label>
                        <div class="input-group position-relative">
                            <select name="bulk_fields[]" id="bulk_fields[]" class="form-select form-select-sm form-control-sm monitor rounded">
                                <option value=""><?= _('IGNORE') ?></option>
                                <option value="hostname"><?= _("Hostname") ?></option>
                                <option value="v3_username"><?= _('Username') ?></option>
                                <option value="v3_auth_password"><?= _('Auth Password') ?></option>
                                <option value="v3_priv_password"><?= _('Priv Password') ?></option>
                                <option value="v3_auth_proto"><?= _('Auth Protocol') ?></option>
                                <option value="v3_priv_proto"><?= _('Priv Protocol') ?></option>
                            </select>
                        </div>
                    </div>
                </div>
            </div>

            </div> <!-- End manual_config_section -->

            <h2 class="mt-4 mb-2"><?= _("Monitoring Options") ?></h2>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="interface_reference_style" class="form-label form-item-required"><?= _("Interface Reference Style"); ?> <?= xi6_info_tooltip(_("This determines how the monitoring engine will find your interface ports. Please select a stable identifier")); ?></label>
                    <div class="input-group position-relative">
                        <select name="interface_reference_style" id="interface_reference_style" class="form-select monitor rounded" required>
                            <option value="nr" <?= is_selected($interface_reference_style, "nr"); ?>><?= _("Port Number"); ?></option>
                            <option value="name" <?= is_selected($interface_reference_style, "name"); ?>><?= _("Port Name"); ?></option>
                            <option value="descr" <?= is_selected($interface_reference_style, "descr"); ?>><?= _("Port Description"); ?></option>
                            <!--<option value="eth" <?= is_selected($interface_reference_style, "eth"); ?>><?= _("Port Physical Address"); ?></option>-->
                            <option value="type" <?= is_selected($interface_reference_style, "type"); ?>><?= _("Port Type"); ?></option>
                        </select>
                    </div>
                </div>
            </div>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="portnames" class="form-label form-item-required"><?= _("Monitoring Scheme") ?> <?= xi6_info_tooltip(_("This determines how your services will be named")) ?></label>
                    <div class="input-group position-relative">
                        <select name="portnames" id="portnames" class="form-select monitor rounded" placeholder="<?= _("Select Port Naming Monitoring Scheme") ?> " required>
                            <option value="number" <?= is_selected($portnames, "number") ?>><?= encode_form_val(_("<Use Interface Reference Style>")); ?></option>
                            <option value="name" <?= is_selected($portnames, "name") ?>><?= _("Port Name") ?></option>
                            <option value="description" <?= is_selected($portnames, "description") ?>><?= _("Port Description") ?></option>
                            <option value="alias" <?= is_selected($portnames, "alias") ?>><?= _("Port Alias") ?></option>
                        </select>
                        <div class="invalid-feedback">
                            <?= _("Please select the Port Naming Monitoring scheme") ?>
                        </div>
                        <i id="portnames_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-sm-8">
                    <div class="form-check mt-0 pt-1">
                        <input type="checkbox" id="scaninterfaces" class="form-check-input" name="scaninterfaces" <?= is_checked($scaninterfaces, "on") ?>>
                        <label for="scaninterfaces" class="form-check-label bold"><?= _("Scan Interfaces") ?> <?= xi6_info_tooltip(_("Scan the m_switch or router to auto-detect interfaces, that can be monitored for link up/down status and bandwidth usage. The scanning process may take several seconds to complete.")) ?></label>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-sm-8">
                    <div class="form-check mt-0 pt-1">
                        <input type="checkbox" id="admindown" class="form-check-input" name="admindown" <?= is_checked($admindown) ?>>
                        <label for="admindown" class="form-check-label bold"><?= _("Administratively Down Interfaces") ?> <?= xi6_info_tooltip(_("Include administratively down interfaces in the scan for monitoring link status and bandwidth usage.")) ?></label>    
                    </div>
                </div>
            </div>

            <h2 class="mt-4 mb-2"><?= _("Default Values") ?></h2>
            <div class="row">
                <div class="col-sm-8">
                    <fieldset class="row g-2 mb-1 wz-fieldset">
                        <div class="col-sm-3 mt-0 pt-1">
                            <label for="warn_speed_in_percent" class="form-label form-item-required bold"><?= _('Input Rate') ?></label>
                        </div>
                        <div class="col-sm-3 mt-0">
                            <div class="input-group input-group-sm">
                                <span class="input-group-text">
                                    <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                                </span>
                                <input type="text" id="warn_speed_in_percent" name="warn_speed_in_percent" value="<?= $warn_speed_in_percent ?>" class="form-control monitor" required>
                                <span class="input-group-text rounded-end">%</span>
                                <div class="invalid-feedback">
                                    <?= _("Please enter the warning threshold") ?>
                                 </div>
                                <i id="warn_speed_in_percent_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            
                            </div>
                        </div>
                        <div class="col-sm-3 mt-0">
                            <div class="input-group input-group-sm">
                                <span class="input-group-text">
                                    <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                                </span>
                                <input type="text" id="crit_speed_in_percent" name="crit_speed_in_percent" value="<?= encode_form_val($crit_speed_in_percent) ?>" class="form-control monitor" required>
                                <span class="input-group-text rounded-end">%</span>
                                <div class="invalid-feedback">
                                    <?= _("Please enter the critical threshold") ?>
                                </div>
                                <i id="crit_speed_in_percent_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                    </fieldset>
                </div>
            </div>

            <div class="row">
                <div class="col-sm-8">
                    <fieldset class="row g-2 mb-1 wz-fieldset">
                        <div class="col-sm-3 mt-0 pt-1">
                            <label for="warn_speed_out_percent" class="form-label form-item-required bold"><?= _('Output Rate') ?></label>
                        </div>
                        <div class="col-sm-3 mt-0">
                            <div class="input-group input-group-sm position-relative">
                                <span class="input-group-text">
                                    <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                                </span>
                                <input type="text" id="warn_speed_out_percent" name="warn_speed_out_percent" value="<?= $warn_speed_out_percent ?>" class="form-control monitor" required>
                                <span class="input-group-text rounded-end">%</span>
                                <div class="invalid-feedback">
                                    <?= _("Please enter the warning threshold") ?>
                                </div>
                                <i id="warn_speed_out_percent_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                        <div class="col-sm-3 mt-0">
                            <div class="input-group input-group-sm position-relative">
                                <span class="input-group-text">
                                    <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                                </span>
                                <input type="text" id="crit_speed_out_percent" name="crit_speed_out_percent" value="<?= encode_form_val($crit_speed_out_percent) ?>" class="form-control monitor" required> 
                                <span class="input-group-text rounded-end">%</span>
                                <div class="invalid-feedback">
                                    <?= _("Please enter the critical threshold") ?>
                                </div>
                                <i id="crit_speed_out_percent_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                    </fieldset>
                </div>
            </div>

            <div class="row mb-2">
                <div class="col-sm-8">
                    <fieldset class="row g-2 mb-1 wz-fieldset">
                        <div class="col-sm-3 mt-0 pt-1">
                            <label for="default_port_speed" class="form-label form-item-required"><?= _("Default Port Speed") ?></label>
                        </div>
                        <div class="col-sm-3 mt-0 pt-1">
                            <div class="input-group input-group-sm position-relative">
                                <input type="text" name="default_port_speed" id="default_port_speed" value="<?= $default_port_speed ?>" class="form-control monitor" required>
                                <span class="input-group-text rounded-end">Mbps</span>
                                <div class="invalid-feedback">
                                    <?= _("Please enter the Default Port Speed") ?>
                                </div>
                                <i id="default_port_speed_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                    </fieldset>
                </div>
            </div>
        </div> <!-- config -->
    </div> <!-- container -->

    <script type="text/javascript">
        $(document).ready(function() {
            // Ensure Meraki API is selected by default on page load
            $('#config_mode_meraki').prop('checked', true);
            
            // Handle configuration mode toggle
            handleConfigModeToggle();
            
            // Set up event handlers for configuration mode changes
            $('input[name="config_mode"]').change(function() {
                handleConfigModeToggle();
            });

            // Set up event handlers for switch selection buttons
            $('#select_all_switches').click(function() {
                $('#switch_table_body input[type="checkbox"]').prop('checked', true);
            });

            $('#deselect_all_switches').click(function() {
                $('#switch_table_body input[type="checkbox"]').prop('checked', false);
            });

            // Set up debug checkbox handler
            $('#debug_enabled').change(function() {
                $('#debug_enabled_hidden').val($(this).is(':checked') ? '1' : '');
            });

            // Set up Meraki API key input handler to enable/disable Get Switch Info button
            $('#meraki_api_key').on('input', function() {
                var apiKey = $(this).val().trim();
                if (apiKey.length > 0) {
                    $('#get_switch_info').prop('disabled', false);
                } else {
                    $('#get_switch_info').prop('disabled', true);
                }
            });

            // Check initial state of API key field on page load
            var initialApiKey = $('#meraki_api_key').val().trim();
            if (initialApiKey.length > 0) {
                $('#get_switch_info').prop('disabled', false);
            }

            // Intercept form submission to populate hidden fields with selected switches
            $('form').on('submit', function(e) {
                updateSelectedSwitchesData();
                // Update debug hidden field
                $('#debug_enabled_hidden').val($('#debug_enabled').is(':checked') ? '1' : '');
            });
            
            // On page load, determine which snmp version is selected,
            // and populate the Bulk Configuration fields accordingly
            set_bulk_config_fields();

            $("#pills-snmpv1-tab, #pills-snmpv2c-tab, #pills-snmpv3-tab").click(function() {
                $("#bulk-append-fields").find(".bulk-remove-me").remove();

                set_bulk_config_fields(this.id);
            });

            // Then, if the back button was pressed, select the fields that were chosen last time()
            var backpop_array = ['<?= implode("','", $bulk_fields) ?>'];
            var fields = $("select[name*=\"bulk_fields[]\"");
            console.log(backpop_array);
            console.log(fields);

            // backpop_array will be an array of the empty string if "Next" was pressed
            if (backpop_array.length > 1) {

                for (x in backpop_array) {
                    $(fields[x]).val(backpop_array[x]);
                }
            }

            security_level = $('.form-control[name=\"snmpopts[v3_security_level]\"]').val();
            enable_fields_by_security_level(security_level);

            $(".form-control[name=\"snmpopts[v3_security_level]\"]").change(function () {
                enable_fields_by_security_level($(this).val());
            });

            // Initial check
            select_default_proto();
            update_security_display();

            // Detection
            $("[name='snmpopts[v3_security_level]']").change(function() {
                select_default_proto();
            });

            // Upon clicking the tabs, set the invisible radio selector
            // to be true, based on the tab clicked
            $("#pills-snmpv1-tab").click(function() {
                $("#snmpversion").val("1");
                update_security_display();
            });

            $("#pills-snmpv2c-tab").click(function() {
                $("#snmpversion").val("2c");
                update_security_display();
            });

            $("#pills-snmpv3-tab").click(function() {
                $("#snmpversion").val("3");
                update_security_display();
            });

            // I wasn't able to determine why jQuery wouldn't be able to trigger a click event,
            // but it turns out that the built-in browser API is working fine. -swolf 2024-07-18
            const initial_snmp_version = $('#snmpversion').val();
            $('#pills-snmpv'+initial_snmp_version +'-tab')[0].click();

            // Disable any fields that are not required for v3's various security levels.
            function select_default_proto(level_val) {
                var level_val = $("[name='snmpopts[v3_security_level]']").val();

                if (level_val == "authNoPriv") {
                    $("[name='snmpopts[v3_auth_proto]']").val("MD5");
                    $("[name='snmpopts[v3_priv_proto]']").val("");
                    $('label[for="snmpopts\[v3_auth_password\]"]').addClass('form-item-required');
                    $('label[for="snmpopts\[v3_auth_proto\]"]').addClass('form-item-required');
                    $('label[for="snmpopts\[v3_priv_password\]"]').removeClass('form-item-required');
                    $('label[for="snmpopts\[v3_priv_proto\]"]').removeClass('form-item-required');
                } else if (level_val == "authPriv") {
                    $("[name='snmpopts[v3_auth_proto]']").val("MD5");

                    // "DES" does not always exist, so set to first one.
                    //$("[name='snmpopts[v3_priv_proto]']").val("DES");
                    $("[name='snmpopts[v3_priv_proto]'] > option:first").prop("selected", true);

                    $('label[for="snmpopts\[v3_priv_password\]"]').addClass('form-item-required');
                    $('label[for="snmpopts\[v3_priv_proto\]"]').addClass('form-item-required');
                    $('label[for="snmpopts\[v3_auth_password\]"]').addClass('form-item-required');
                    $('label[for="snmpopts\[v3_auth_proto\]"]').addClass('form-item-required');
                } else {
                    $("[name='snmpopts[v3_auth_proto]']").val("");
                    $("[name='snmpopts[v3_priv_proto]']").val("");
                    $('label[for="snmpopts\[v3_auth_password\]"]').removeClass('form-item-required');
                    $('label[for="snmpopts\[v3_auth_proto\]"]').removeClass('form-item-required');
                    $('label[for="snmpopts\[v3_priv_password\]"]').removeClass('form-item-required');
                    $('label[for="snmpopts\[v3_priv_proto\]"]').removeClass('form-item-required');
                }
            }
        });

        function handleConfigModeToggle() {
            var configMode = $('input[name="config_mode"]:checked').val();
            
            if (configMode === 'meraki') {
                // Show Meraki API section
                $('#meraki_api_section').show();
                // Hide manual configuration section
                $('#manual_config_section').hide();
                // Make Meraki API key required
                $('#meraki_api_key').attr('required', true);
                // Remove required attributes from manual configuration fields
                $('#manual_config_section input[required], #manual_config_section select[required]').removeAttr('required');
            } else {
                // Hide Meraki API section
                $('#meraki_api_section').hide();
                // Show manual configuration section
                $('#manual_config_section').show();
                // Remove required attribute from Meraki API key
                $('#meraki_api_key').removeAttr('required');
                // Restore required attributes for manual configuration fields
                restoreRequiredAttributes();
            }
        }

        function getSwitchInfo() {
            console.log('getSwitchInfo() function called');
            var apiKey = $('#meraki_api_key').val().trim();
            console.log('API Key:', apiKey);
            
            // Validate API key
            if (!apiKey || apiKey.length !== 40) {
                alert('<?= _("Please enter a valid 40-character Meraki API key") ?>');
                return;
            }
            
            // Show loading state
            $('#get_switch_info').prop('disabled', true);
            $('#switch_info_spinner').show();
            $('#switch_info_status').show();
            $('#switch_info_results').hide();
            
            // Make AJAX request to fetch switch information
            $.ajax({
                url: base_url + "includes/configwizards/m_switch/getmer.ajax.php",
                type: 'POST',
                data: {
                    meraki_api_key: apiKey
                },
                dataType: 'json',
                success: function(response) {
                    // Hide loading state
                    $('#get_switch_info').prop('disabled', false);
                    $('#switch_info_spinner').hide();
                    $('#switch_info_status').hide();
                    
                    // Add debugging
                    console.log('AJAX Success Response:', response);
                    
                    if (response.error) {
                        alert('<?= _("Error: ") ?>' + response.error);
                    } else if (response.length === 0) {
                        alert('<?= _("No switches found in your organization") ?>');
                    } else {
                        console.log('Found ' + response.length + ' switches');
                        displaySwitchTable(response);
                        $('#switch_info_results').show();
                    }
                },
                error: function(xhr, status, error) {
                    // Hide loading state
                    $('#get_switch_info').prop('disabled', false);
                    $('#switch_info_spinner').hide();
                    $('#switch_info_status').hide();
                    
                    var errorMessage = '<?= _("An error occurred while fetching switch information.") ?>';
                    
                    // Add debugging information
                    console.log('AJAX Error Details:');
                    console.log('Status:', status);
                    console.log('Error:', error);
                    console.log('Response Status:', xhr.status);
                    console.log('Response Text:', xhr.responseText);
                    
                    if (xhr.status === 404) {
                        errorMessage = '<?= _("Could not find getmer.ajax.php file. Please check the file path.") ?>';
                    } else if (xhr.status === 500) {
                        errorMessage = '<?= _("Server error occurred. Please check the server logs.") ?>';
                    } else if (xhr.responseText) {
                        try {
                            var errorResponse = JSON.parse(xhr.responseText);
                            errorMessage = errorResponse.error || errorMessage;
                        } catch (e) {
                            errorMessage = '<?= _("Server returned: ") ?>' + xhr.responseText.substring(0, 100);
                        }
                    }
                    
                    alert('<?= _("Error: ") ?>' + errorMessage + '\n<?= _("Check browser console for details.") ?>');
                }
            });
        }

        function displaySwitchTable(switches) {
            var tbody = $('#switch_table_body');
            tbody.empty();
            
            // Store switches data globally for later use
            window.merakiSwitches = switches;
            
            switches.forEach(function(sw, index) {
                var row = $('<tr>');
                
                // Checkbox - selected by default
                var checkbox = $('<input type="checkbox" class="form-check-input" data-switch-index="' + index + '" checked>');
                row.append($('<td>').append(checkbox));
                
                // Name
                row.append($('<td>').text(sw.name || 'N/A'));
                
                // IP Address
                row.append($('<td>').text(sw.lanIp || 'N/A'));
                
                // MAC Address
                row.append($('<td>').text(sw.mac || 'N/A'));
                
                // Serial
                row.append($('<td>').text(sw.serial || 'N/A'));
                
                // Model
                row.append($('<td>').text(sw.model || 'N/A'));
                
                // SNMP Version
                row.append($('<td>').text(sw.snmpversion || 'N/A'));
                
                // SNMP Info
                var snmpInfo = '';
                if (sw.snmpopts) {
                    if (sw.snmpopts.snmpcommunity && sw.snmpopts.snmpcommunity !== 'public') {
                        snmpInfo += 'Community: ' + sw.snmpopts.snmpcommunity + '<br>';
                    }
                    if (sw.snmpopts.v3_username) {
                        snmpInfo += 'v3 User: ' + sw.snmpopts.v3_username + '<br>';
                    }
                    if (sw.snmpopts.v3_auth_proto) {
                        snmpInfo += 'Auth: ' + sw.snmpopts.v3_auth_proto + '<br>';
                    }
                    if (sw.snmpopts.v3_priv_proto) {
                        snmpInfo += 'Priv: ' + sw.snmpopts.v3_priv_proto + '<br>';
                    }
                    if (!snmpInfo) {
                        snmpInfo = 'Default (public)';
                    }
                } else {
                    snmpInfo = 'N/A';
                }
                row.append($('<td>').html(snmpInfo));
                
                tbody.append(row);
            });
        }

        function updateSelectedSwitchesData() {
            var selectedSwitches = [];
            var selectedIndices = [];
            
            // Get all checked switches
            $('#switch_table_body input[type="checkbox"]:checked').each(function() {
                var index = $(this).data('switch-index');
                selectedIndices.push(index);
                
                if (window.merakiSwitches && window.merakiSwitches[index]) {
                    selectedSwitches.push(window.merakiSwitches[index]);
                }
            });
            
            // Update hidden fields
            $('#selected_switches').val(JSON.stringify(selectedIndices));
            $('#meraki_switches_data').val(JSON.stringify(selectedSwitches));
            
            // If we have selected switches, use the first one to populate form fields
            if (selectedSwitches.length > 0) {
                var firstSwitch = selectedSwitches[0];
                
                // Update IP address and port in monitoring options
                if (firstSwitch.lanIp) {
                    $('#ip_address').val(firstSwitch.lanIp);
                }
                
                // Update SNMP version
                if (firstSwitch.snmpversion) {
                    $('#snmpversion').val(firstSwitch.snmpversion);
                    
                    // Trigger SNMP version tab selection
                    if (firstSwitch.snmpversion === '3') {
                        $('#pills-snmpv3-tab')[0].click();
                    } else {
                        $('#pills-snmpv2c-tab')[0].click();
                    }
                }
                
                // Update SNMP options
                if (firstSwitch.snmpopts) {
                    // Community string for v2c
                    if (firstSwitch.snmpopts.snmpcommunity) {
                        $('input[name="snmpopts[snmpcommunity]"]').val(firstSwitch.snmpopts.snmpcommunity);
                    }
                    
                    // v3 options
                    if (firstSwitch.snmpopts.v3_username) {
                        $('input[name="snmpopts[v3_username]"]').val(firstSwitch.snmpopts.v3_username);
                    }
                    if (firstSwitch.snmpopts.v3_auth_password) {
                        $('input[name="snmpopts[v3_auth_password]"]').val(firstSwitch.snmpopts.v3_auth_password);
                    }
                    if (firstSwitch.snmpopts.v3_priv_password) {
                        $('input[name="snmpopts[v3_priv_password]"]').val(firstSwitch.snmpopts.v3_priv_password);
                    }
                    if (firstSwitch.snmpopts.v3_auth_proto) {
                        $('select[name="snmpopts[v3_auth_proto]"]').val(firstSwitch.snmpopts.v3_auth_proto);
                    }
                    if (firstSwitch.snmpopts.v3_priv_proto) {
                        $('select[name="snmpopts[v3_priv_proto]"]').val(firstSwitch.snmpopts.v3_priv_proto);
                    }
                    if (firstSwitch.snmpopts.v3_security_level) {
                        $('select[name="snmpopts[v3_security_level]"]').val(firstSwitch.snmpopts.v3_security_level);
                    }
                }
            }
            
            console.log('Selected switches data updated:', selectedSwitches.length + ' switches selected');
        }

        function restoreRequiredAttributes() {
            // Restore required attributes for manual configuration based on original logic
            $('#ip_address').attr('required', true);
            $('#port').attr('required', true);
            $('#interface_reference_style').attr('required', true);
            $('#portnames').attr('required', true);
            $('#warn_speed_in_percent').attr('required', true);
            $('#crit_speed_in_percent').attr('required', true);
            $('#warn_speed_out_percent').attr('required', true);
            $('#crit_speed_out_percent').attr('required', true);
            $('#default_port_speed').attr('required', true);
            
            // Handle SNMP version specific requirements
            var snmpVersion = $('#snmpversion').val();
            if (snmpVersion === '3') {
                $('#pills-snmpv3 :input').attr('required', true);
            } else {
                $('#pills-snmpv3 :input').removeAttr('required');
                $('input[name="snmpopts[snmpcommunity]"]').attr('required', true);
            }
            
            // Call existing security display update
            update_security_display();
        }

        function update_security_display() {
            var version_val = $("#snmpversion").val();
            console.log("update_security_display - version_val: ", version_val)
            if (version_val == "3") {                
                $('#pills-snmpv3 :input').attr('required', true);                
            } else {
                $('#pills-snmpv3 :input').removeAttr('required');
            }
        }

        function enable_fields_by_security_level(level) {
            $("." + level + "-enable").attr("disabled", false);
            $("." + level + "-disable").attr("disabled", true);
        }

        function set_bulk_config_fields(button_id) {
            var new_fields = $("#sample-fields-v12c");
            var selectObj = new_fields.find("select");

            if (button_id === "pills-snmpv3-tab") {
                // version 3
                new_fields = $("#sample-fields-v3");
                selectObj = new_fields.find("select");
            }

            var idx = 1;
            var fieldName = new_fields.find("label").text().replace(/[0-9]/g, '');
            var fieldLabel = new_fields.find("label").attr("for").replace(/[0-9]/g, '');

            selectObj.children("option").each(function(idx) {
                idx++;
                // Skip the "IGNORE" entry, while adding fields, from the sample select statements.
                if ($(this).val() === "") {
                    return;
                }

                new_fields.find("label").text(fieldName+idx);
                new_fields.find("label").attr("for", fieldLabel+idx);

                $("#bulk-append-fields").append(new_fields.html());
            });
        }
    </script>

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
