    <!--                                   -->
    <!-- The initial data set from Step 1. -->
    <!--                                   -->
    <input type="hidden" id="hostname" name="hostname" value="<?= encode_form_val($hostname) ?>">
    <input type="hidden" id="operation" name="operation" value="<?= encode_form_val($operation) ?>">
    <input type="hidden" id="selectedhostconfig" name="selectedhostconfig" value="<?= encode_form_val($selectedhostconfig) ?>">
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />

    <input type="hidden" name="snmpversion" value="<?= encode_form_val($snmpversion) ?>">
    <input type="hidden" name="interface_reference_style" value="<?= encode_form_val($interface_reference_style); ?>">
    <input type="hidden" name="ip_address" value="<?= encode_form_val($address) ?>">
    <input type="hidden" name="port" value="<?= encode_form_val($address_port) ?>">
    <input type="hidden" name="vendor" value="<?= encode_form_val($vendor) ?>">
<?php
    foreach ($snmpopts as $key => $val) {
?>
    <input type="hidden" name="snmpopts[<?= $key ?>]" value="<?= $val ?>">
<?php
    }
?>
    <input type="hidden" name="snmpopts_serial" value="<?= $snmpopts_serial ?>">
    <input type="hidden" name="portnames" value="<?= encode_form_val($portnames) ?>">
    <input type="hidden" name="scaninterfaces" value="<?= encode_form_val($scaninterfaces) ?>">
    <input type="hidden" name="admindown" value="<?= encode_form_val($admindown) ?>">
    <input type="hidden" name="bulk_options" value="<?= encode_form_val($bulk_options) ?>">
    <input type="hidden" name="bulk_fields_serial" value="<?= $bulk_fields_serial ?>">
    <input type="hidden" name="warn_speed_in_percent" value="<?= encode_form_val($warn_speed_in_percent) ?>">
    <input type="hidden" name="crit_speed_in_percent" value="<?= encode_form_val($crit_speed_in_percent) ?>">
    <input type="hidden" name="warn_speed_out_percent" value="<?= encode_form_val($warn_speed_out_percent) ?>">
    <input type="hidden" name="crit_speed_out_percent" value="<?= encode_form_val($crit_speed_out_percent) ?>">
    <input type="hidden" name="config_mode" value="<?= encode_form_val($config_mode) ?>">
    <input type="hidden" name="meraki_switches_data" value="<?= encode_form_val($meraki_switches_data) ?>">
<?php
        # Store all_switches data for JavaScript processing
        if (!empty($all_switches)) {
            echo '<input type="hidden" id="all_switches_data" value="' . encode_form_val(json_encode($all_switches)) . '">';
        }
    ?>

<style type="text/css">
    .min-width-8em { min-width: 8em; }
    .min-width-20em { min-width: 20em; }
    .switch-header-row { background-color: black !important; color: white !important; }
    .switch-header-row td { background-color: black !important; color: white !important; }
</style>

<?php
    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';
?>
    <div class="container-fluid m-0 g-0">

        <?php if ($config_mode !== 'meraki' || empty($all_switches)) { ?>
        <h2 class="mb-2"><?= _('Switch Details') ?></h2>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="ip_address" class="form-label"><?= _('Switch/Router Address') ?> </label>
                <div class="input-group position-relative">
                    <input type="text" name="ip_address" id="ip_address" value="<?= encode_form_val($address) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Switch/Router Address") ?>" disabled="on">
                    <div class="invalid-feedback">
                        <?= _("Please enter the IP Address") ?>
                    </div>
                    <i id="ip_address_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="hostname" class="form-label"><?= _('Host Name') ?> <?= xi6_info_tooltip(_("The name you'd like to have associated with this m_switch or router.")) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="hostname" id="hostname" value="<?= encode_form_val($hostname) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Host Name") ?>" >
                    <div class="invalid-feedback">
                        <?= _("Please enter the Host Name") ?>
                    </div>
                    <i id="hostname_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>
        <?php } else { ?>
        <!-- Hidden fields for Meraki mode -->
        <input type="hidden" name="ip_address" id="ip_address" value="<?= encode_form_val($address) ?>">
        <input type="hidden" name="hostname" id="hostname" value="<?= encode_form_val($hostname) ?>">
        <?php } ?>

        <h2 class="mt-4"><?= _('Services') ?></h2>
        <?php if (!empty($all_switches)) { ?>
        <p><?= sprintf(_("Specify which ports to monitor for your %d selected switches."), count($all_switches)) ?></p>
        <?php } else { ?>
        <p><?= _("Specify which ports to monitor for this switch.") ?></p>
        <?php } ?>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="ping" class="form-check-input" name="services[ping]"  checked="on">
                        <label for="ping" class="form-check-label bold"><?= _('Ping') ?> <?= xi6_info_tooltip(_("Monitors the m_switch/router with an ICMP ping. Useful for watching network latency and general uptime.")) ?></label>
                    </div>
                </fieldset>
            </div>
        </div>

<?php
    # For multiple switches, read ports from all switches' walk files
    $ports = array();
    if (!empty($all_switches)) {
        # Meraki mode with multiple switches
        foreach ($all_switches as $i => $switch) {
            if (!empty($switch['lanIp'])) {
                $switch_ports = m_switch_configwizard_read_walk_file($switch['lanIp'], $interface_reference_style);
                if (!empty($switch_ports)) {
                    # Prefix port IDs with switch info to make them unique
                    $switch_name = !empty($switch['name']) ? preg_replace('/[^a-zA-Z0-9\-_]/', '_', $switch['name']) : $switch['lanIp'];
                    foreach ($switch_ports as $port_id => $port_info) {
                        $unique_port_id = $switch['lanIp'] . '_' . $port_id;
                        $port_info['switch_ip'] = $switch['lanIp'];
                        $port_info['switch_name'] = $switch_name;
                        $port_info['original_port_id'] = $port_id;
                        $ports[$unique_port_id] = $port_info;
                    }
                }
            }
        }
    } else {
        # Single switch mode (manual or single Meraki switch)
        $ports = m_switch_configwizard_read_walk_file($address, $interface_reference_style);
    }
?>
<?php
    if (count($ports) > 0) {
        // we need to double check for duplcate names before we go any further
        foreach ($ports as $outer_number => $outer_arr) {
            $outer_name = grab_array_var($outer_arr, "name");
            $outer_description = grab_array_var($outer_arr, "description");
            $outer_alias = grab_array_var($outer_arr, "alias");

            $name_match = 1;
            $description_match = 1;
            $alias_match = 1;

            foreach ($ports as $inner_number => $inner_arr) {
                if ($outer_number === $inner_number)
                    continue;

                $inner_name = grab_array_var($inner_arr, "name");
                $inner_description = grab_array_var($inner_arr, "description");
                $inner_alias = grab_array_var($inner_arr, "alias");

                if ($outer_name == $inner_name) {
                    $ports[$outer_number]['name'] = $outer_name.' '.$name_match++;
                    $ports[$inner_number]['name'] = $inner_name.' '.$name_match++;
                }

                if ($outer_description == $inner_description) {
                    $ports[$outer_number]['description'] = $outer_description.' '.$description_match++;
                    $ports[$inner_number]['description'] = $inner_description.' '.$description_match++;
                }

                if ($outer_alias == $inner_alias) {
                    $ports[$outer_number]['alias'] = $outer_alias.' '.$alias_match++;
                    $ports[$inner_number]['alias'] = $inner_alias.' '.$alias_match++;
                }
            }
        }

?>
        <h2 class="mt-4"><?= _('Bandwidth and Port Status') ?></h2>
        <p><?= _("Select the ports for which you'd like to monitor bandwidth and port status. You may specify an optional port name to be associated with specific ports.") ?></p>

        <div class="table-responsive table-responsive-sm">
            <table class="table table-sm table-striped table-bordered">
                <thead>
                    <tr class="fa-12">
                        <th scope="col" class="p-2 align-top">
                            <?= _('Port') ?>
                            <div class="text-nowrap min-width-8em">
                                <a class="btn btn-link p-0" id="m_switchCheckAll" title="<?= _('Check All Ports') ?>"><i class="fa fa-check-square-o" aria-hidden="true"></i></a>
                                <a class="btn btn-link p-0" id="m_switchUncheckAll" title="<?= _('Uncheck All Ports') ?>"><i class="fa fa-square-o" aria-hidden="true"></i></a>
                            </div>
                        </th>
                        <th scope="col" class="p-2 align-top">
                            <?= _('Port Name') ?>
                        </th>
                        <th scope="col" class="p-2 align-top">
                            <?= _('Port Description') ?>
                        </th>
                        <th scope="col" class="p-2 align-top">
                            <?= _('Port Alias') ?>
                        </th>
                        <th scope="col" class="p-2 align-top">
                            <?= _('Max Speed') ?>
                        </th>
                        <th scope="col" class="p-2 align-top">
                            <?= _('Service Description') ?>
                        </th>
                        <th scope="col" class="p-2 align-top">
                            <?= _('Bandwidth') ?>
                            <div class="text-nowrap min-width-8em">
                                <a class="btn btn-link p-0" id="bandwidthCheckAll" title="<?= _('Check All Ports') ?>"><i class="fa fa-check-square-o" aria-hidden="true"></i></a>
                                <a class="btn btn-link p-0" id="bandwidthUncheckAll" title="<?= _('Uncheck All Ports') ?>"><i class="fa fa-square-o" aria-hidden="true"></i></a>
                            </div>
                        </th>
                        <th scope="col" class="p-2 align-top">
                            <?= _('Port Status') ?>
                            <div class="text-nowrap min-width-8em">
                                <a class="btn btn-link p-0" id="statusCheckAll" title="<?= _('Check All Ports') ?>"><i class="fa fa-check-square-o" aria-hidden="true"></i></a>
                                <a class="btn btn-link p-0" id="statusUncheckAll" title="<?= _('Uncheck All Ports') ?>"><i class="fa fa-square-o" aria-hidden="true"></i></a>
                            </div>
                        </th>
                    </tr>
                </thead>
                <tbody>
<?php
        $x = 0;
        $current_switch = '';
        $switch_count = 0;

        foreach ($ports as $port_id => $parr) {
            $max_bytes = grab_array_var($parr, "max_bytes", 0);
            $port_name = grab_array_var($parr, "name", $port_id);
            $port_description = grab_array_var($parr, "description", $port_id);
            $port_alias = grab_array_var($parr, "alias", $port_id);
            $raw_port_id = grab_array_var($parr, "raw_port_id", $port_id);
            
            // For multi-switch mode, get switch info
            $switch_ip = grab_array_var($parr, "switch_ip", "");
            $switch_name = grab_array_var($parr, "switch_name", "");
            $original_port_id = grab_array_var($parr, "original_port_id", $port_id);
            
            // Add delimiter between switches in multi-switch mode
            if (!empty($all_switches) && $switch_ip !== $current_switch) {
                if ($switch_count > 0) {
                    // Add a separator row between switches
                    echo '<tr class="table-secondary"><td colspan="8"><hr class="my-2"></td></tr>';
                }
                
                // Add switch header row
                $switch_display_name = !empty($switch_name) ? $switch_name : $switch_ip;
                echo '<tr class="switch-header-row">';
                echo '<td colspan="8" class="fw-bold text-start py-3">';
                echo '<i class="fa fa-server me-2"></i>' . encode_form_val($switch_display_name);
                if (!empty($switch_name) && $switch_name !== $switch_ip) {
                    echo ' <small class="text-muted">(' . encode_form_val($switch_ip) . ')</small>';
                }
                echo '</td></tr>';
                
                $current_switch = $switch_ip;
                $switch_count++;
            }

            $port_id = str_replace($badchars, " ", $port_id);
            $port_name = str_replace($badchars, " ", $port_name);
            $port_description = str_replace($badchars, " ", $port_description);
            $port_alias = str_replace($badchars, " ", $port_alias);


            // For multi-switch mode, use original port ID for service description
            $display_port_id = !empty($original_port_id) ? $original_port_id : $port_id;
            $service_description = $display_port_id;
            if (is_numeric($display_port_id)) {
                $service_description = _('Port ').$display_port_id;
            }

            if ($portnames == 'name')
                $service_description = $port_name;

            if ($portnames == 'description')
                $service_description = $port_description;

            if ($portnames == 'alias')
                $service_description = $port_alias;

            $x++;

            $max_speed = m_switch_configwizard_get_readable_port_line_speed($max_bytes, $speed, $label);
            $warn_in_speed = ($speed * ($warn_speed_in_percent / 100));
            $warn_out_speed = ($speed * ($warn_speed_out_percent / 100));
            $crit_in_speed = ($speed * ($crit_speed_in_percent / 100));
            $crit_out_speed = ($speed * ($crit_speed_out_percent / 100));

            // Possible refomat speed values/labels
            m_switch_configwizard_recalculate_speeds($warn_in_speed, $warn_out_speed, $crit_in_speed, $crit_out_speed, $label);

            // configure the display rates so that they fit in the text boxes (which are size=3)
            $warn_in = m_switch_configwizard_get_sane_display_rate($warn_in_speed);
            $warn_out = m_switch_configwizard_get_sane_display_rate($warn_out_speed);
            $crit_in = m_switch_configwizard_get_sane_display_rate($crit_in_speed);
            $crit_out = m_switch_configwizard_get_sane_display_rate($crit_out_speed);
?>
            <tr class="fa-12">
                <td>
                    <input type="checkbox" class="form-check-input me-1 portbox" id="port_<?= $port_id ?>" name="services[port][<?= $port_id ?>]" checked>
                    <label class="form-label">
                        <?= encode_form_val($service_description); ?>
                    </label>
                </td>
                <td class="min-width-20em">
                    <?= encode_form_val($port_name) ?>
                </td>
                <td class="min-width-20em">
                    <?= encode_form_val($port_description) ?>
                </td>
                <td class="text-nowrap">
                    <?= encode_form_val($port_alias) ?>
                </td>
                <td class="text-nowrap">
                    <?= $max_speed ?>
                </td>
                <td>
                    <input type="text" name="serviceargs[portname][<?= $port_id ?>]" value="<?= encode_form_val($service_description) ?>" class="form-control form-control-sm">
                </td>
                <td>
                    <table class="table table-sm bandwidth">
                        <tr class="fa-12">
                            <td>
                                <input type="checkbox" class="form-check-input bandwidthbox" id="bandwidth_<?= $port_id ?>" name="serviceargs[bandwidth][<?= $port_id ?>]" checked>
                            </td>
                            <td><label class="form-label min-width-8em"><?= _('Rate In') ?></label></td>
                            <td><label class="form-label min-width-8em"><?= _('Rate Out') ?></label></td>
                            <td><label class="form-label min-width-8em"><?= _('Rate In') ?></label></td>
                            <td><label class="form-label min-width-8em"><?= _('Rate Out') ?></label></td>
                            <td><label class="form-label min-width-8em"></label></td>
                        </tr>
                        <tr class="fa-12">
                            <td></td>
                            <td>
                                <div class="input-group input-group-sm flex-nowrap">
                                    <span class="input-group-text">
                                        <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                                    </span>
                                    <input type="text" name="serviceargs[bandwidth_warning_input_value][<?= $port_id ?>]" value="<?= number_format($warn_in) ?>" class="form-control form-control-sm monitor rounded-end">
                                    <i id="serviceargs_bandwidth_warning_input_value_<?= $port_id ?>_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                </div>
                            </td>
                            <td>
                                <div class="input-group input-group-sm flex-nowrap">
                                    <span class="input-group-text">
                                        <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                                    </span>
                                    <input type="text" name="serviceargs[bandwidth_warning_output_value][<?= $port_id ?>]" value="<?= number_format($warn_out) ?>" class="form-control form-control-sm monitor rounded-end">
                                    <i id="serviceargs_bandwidth_warning_output_value_<?= $port_id ?>_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                </div>
                            </td>
                            <td>
                                <div class="input-group input-group-sm flex-nowrap">
                                    <span class="input-group-text">
                                        <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                                    </span>
                                    <input type="text" name="serviceargs[bandwidth_critical_input_value][<?= $port_id ?>]" value="<?= number_format($crit_in) ?>" class="form-control form-control-sm monitor rounded-end">
                                    <i id="serviceargs_bandwidth_critical_input_value_<?= $port_id ?>_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                </div>
                            </td>
                            <td>
                                <div class="input-group input-group-sm flex-nowrap">
                                    <span class="input-group-text">
                                        <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                                    </span>
                                    <input type="text" name="serviceargs[bandwidth_critical_output_value][<?= $port_id ?>]" value="<?= number_format($crit_out) ?>" class="form-control form-control-sm monitor rounded-end">
                                    <i id="serviceargs_bandwidth_critical_output_value_<?= $port_id ?>_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                </div>
                            </td>
                            <td>
                                <select name="serviceargs[bandwidth_speed_label][<?= $port_id ?>]" class="form-control form-control-sm form-select form-select-sm">
                                    <option value="Gbps" <?= is_selected("Gbps", $label) ?>><?= _('Gbps') ?></option>
                                    <option value="Mbps" <?= is_selected("Mbps", $label) ?>><?= _('Mbps') ?></option>
                                    <option value="Kbps" <?= is_selected("Kbps", $label) ?>><?= _('Kbps') ?></option>
                                    <option value="bps" <?= is_selected("bps", $label) ?>><?= _('bps') ?></option>
                                </select>
                            </td>
                        </tr>
                    </table>
                </td>
                <td class="text-center">
                    <input type="checkbox" class="form-check-input statusbox" id="portstatus_<?= $port_id ?>" name="serviceargs[portstatus][<?= $port_id ?>]" checked>
                </td>
                <input type="hidden" name="serviceargs[raw_port_id][<?= $port_id; ?>]" value="<?= encode_form_val($raw_port_id); ?>" />
                <?php if (!empty($switch_ip)) { ?>
                <input type="hidden" name="serviceargs[switch_ip][<?= $port_id; ?>]" value="<?= encode_form_val($switch_ip); ?>" />
                <input type="hidden" name="serviceargs[original_port_id][<?= $port_id; ?>]" value="<?= encode_form_val($original_port_id); ?>" />
                <?php } ?>
            </tr>
<?php
        }
?>
          </tbody>
        </table>
    </div>
<?php
    } else {
?>
        <div class="alert alert-danger w-75">
            <div class="align-items-center d-flex pb-3">
                <i class="material-symbols-outlined md-400">warning</i>
                <span class="fw-bold ps-2 pe-2"><?= _('No ports were detected on the m_switch') ?></span>
            </div>
            <div class="card card-p">
                <h2 class="mb-2 text-dark"><?= _('Possible reasons for this include...') ?></h2>
                <ul class="list-group">
                    <li class="list-group-item"><?= _('The m_switch is currently down') ?>.</li>
                    <li class="list-group-item"><?= _('The m_switch does not exist at the address you specified') ?>.</li>
                    <li class="list-group-item"><?= _('SNMP support on the m_switch is disabled') ?>.</li>
                </ul>
            </div>
        </div>
<?php
        if (is_admin() == true) {
            $cfgmaker_cmd = m_switch_configwizard_get_cfgmaker_cmd($snmpopts, $address, $address_port, $snmpversion, $default_port_speed, $admindown);
?>
        <div class="alert alert-danger w-75 mt-4">
            <div class="align-items-center d-flex pb-3">
                <i class="material-symbols-outlined">construction</i>
                <span class="fw-bold ps-2"><?= _('Troubleshooting Tip') ?></span>
            </div>
            <div class="card card-p">
                <p class="text-start">
                    <?= _('If you keep experiencing problems with the m_switch wizard scan, login to the Nagios XI server as the root user and execute the following command') ?>:
                </p>
                <pre><code><?= $cfgmaker_cmd ?></code></pre>
                <p class="text-start">
                    <?= _('Send the output of the command and a description of your problem to the Nagios support team by posting to our online ') ?><a href="http://support.nagios.com/forum/" target="_blank"><?= _('support forum') ?></a>.
                </p>
            </div>
        </div>
<?php
        }
    }
?>
    </div> <!-- container -->

    <script type="text/javascript">
        //check all ports
        var allChecked = false;

        $(document).ready(function () {
            // Bind events
            $("#m_switchCheckAll").on("click", function() {
                m_switchCheckAll();
            })
            $("#m_switchUncheckAll").on("click", function() {
                m_switchUncheckAll();
            })
            $("#bandwidthCheckAll").on("click", function() {
                bandwidthCheckAll();
            })
            $("#bandwidthUncheckAll").on("click", function() {
                bandwidthUncheckAll();
            })
            $("#statusCheckAll").on("click", function() {
                statusCheckAll();
            })
            $("#statusUncheckAll").on("click", function() {
                statusUncheckAll();
            })
        });

        function m_switchCheckAll() {
            $(".portbox:checkbox").each(function() {
              this.checked = "checked";
            });
        }

        function m_switchUncheckAll() {
            $(".portbox:checkbox").each(function() {
              this.checked = "";
            });
        }

        function bandwidthCheckAll() {
            $(".bandwidthbox:checkbox").each(function() {
              this.checked = "checked";
            });
        }

        function bandwidthUncheckAll() {
            $(".bandwidthbox:checkbox").each(function() {
              this.checked = "";
            });
        }

        function statusCheckAll() {
            $(".statusbox:checkbox").each(function() {
              this.checked = "checked";
            });
        }

        function statusUncheckAll() {
            $(".statusbox:checkbox").each(function() {
              this.checked = "";
            });
        }
    </script>

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
