function updatePreview() {
    // Update opacity and width value displays
    document.getElementById("textopacity").oninput = function() {
        document.getElementById("textopacityvalue").textContent = this.value + "%";
    };
    document.getElementById("bgopacity").oninput = function() {
        document.getElementById("bgopacityvalue").textContent = this.value + "%";
    };
    document.getElementById("borderopacity").oninput = function() {
        document.getElementById("borderopacityvalue").textContent = this.value + "%";
    };
    document.getElementById("borderwidth").oninput = function() {
        document.getElementById("borderwidthvalue").textContent = this.value + "px";
    };
    document.getElementById("borderradius").oninput = function() {
        document.getElementById("borderradiusvalue").textContent = this.value + "px";
    };

    var preview = document.getElementById("dashletPreview");
    var content = document.getElementById("previewContent");
    if (!preview || !content) return;

    var text = document.getElementById("displaytext").value;
    content.innerHTML = text ? text.replace(/\n/g, "<br>") : "";
    
    // Apply font settings
    content.style.fontFamily = document.getElementById("fontfamily").value;
    var weightSelect = document.getElementById("fontweight");
    content.style.fontWeight = weightSelect.value;
    
    // Update text color and opacity
    var textColor = document.getElementById("textcolor").value;

    // Apply italic style
    var italicCheckbox = document.getElementById("italic");
    if (italicCheckbox.checked) {
        content.style.fontStyle = "italic";
    } else {
        content.style.fontStyle = "normal";
    }

    var underlineCheckbox = document.getElementById("underline");
    var strikethroughCheckbox = document.getElementById("strikethrough");

    // Combine text decoration styles
    var textDecoration = [];
    if (underlineCheckbox.checked) {
        textDecoration.push("underline");
    }
    if (strikethroughCheckbox.checked) {
        textDecoration.push("line-through");
    }

    content.style.textDecoration = textDecoration.join(" ");
    
    // Convert text color to rgba
    var textRgb = textColor.match(/^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i);
    if (textRgb) {
        var r = parseInt(textRgb[1], 16);
        var g = parseInt(textRgb[2], 16);
        var b = parseInt(textRgb[3], 16);
        var textOpacity = document.getElementById("textopacity").value / 100;
        content.style.color = `rgba(${r},${g},${b},${textOpacity})`;
    }
    content.style.opacity = 1; // Reset content opacity
    
    // Update background color and opacity
    var bgColor = document.getElementById("bgcolor").value;
    var bgTransparent = document.getElementById("bgtransparent").checked;
    
    if (!bgTransparent) {
        var bgRgb = bgColor.match(/^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i);
        if (bgRgb) {
            var r = parseInt(bgRgb[1], 16);
            var g = parseInt(bgRgb[2], 16);
            var b = parseInt(bgRgb[3], 16);
            var bgOpacity = document.getElementById("bgopacity").value / 100;
            preview.style.backgroundColor = `rgba(${r},${g},${b},${bgOpacity})`;
        }
    } else {
        preview.style.backgroundColor = "transparent";
    }
    preview.style.opacity = 1; // Reset preview opacity
    
    // Update border color, width, and opacity
    var borderColor = document.getElementById("bordercolor").value;
    var borderWidth = document.getElementById("borderwidth").value;
    var borderTransparent = document.getElementById("bordertransparent").checked;
    
    if (!borderTransparent) {
        var borderRgb = borderColor.match(/^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i);
        if (borderRgb) {
            var r = parseInt(borderRgb[1], 16);
            var g = parseInt(borderRgb[2], 16);
            var b = parseInt(borderRgb[3], 16);
            var borderOpacity = document.getElementById("borderopacity").value / 100;
            preview.style.border = `${borderWidth}px solid rgba(${r},${g},${b},${borderOpacity})`;
        }
    } else {
        preview.style.border = `${borderWidth}px solid transparent`;
    }
    
    // Update border radius
    var borderRadius = document.getElementById("borderradius").value;
    preview.style.borderRadius = borderRadius + "px";
    
    // Update text scaling
    var container = preview.getBoundingClientRect();
    var fontSize = 100;
    content.style.fontSize = fontSize + "px";
    
    // Binary search for the best font size
    var minSize = 1;
    var maxSize = 1000;
    
    while (minSize <= maxSize) {
        fontSize = Math.floor((minSize + maxSize) / 2);
        content.style.fontSize = fontSize + "px";
        
        if (content.scrollHeight <= container.height - 20 && 
            content.scrollWidth <= container.width - 20) {
            minSize = fontSize + 1;
        } else {
            maxSize = fontSize - 1;
        }
    }
    
    // Set final font size
    fontSize = Math.max(1, maxSize);
    content.style.fontSize = fontSize + "px";
}
