CREATE TABLE IF NOT EXISTS `nagiosxi`.`xi_dashboards` (
    `id` int NOT NULL AUTO_INCREMENT,
    `name` varchar(255) NOT NULL,
    `user_id` int DEFAULT NULL,
    `dashboard_id` varchar(36) DEFAULT NULL,
    `is_global` tinyint(1) DEFAULT 0,
    PRIMARY KEY (`id`),
    UNIQUE (`dashboard_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;

CREATE TABLE IF NOT EXISTS `nagiosxi`.`xi_dashlets` (
    `id` int NOT NULL AUTO_INCREMENT,
    `name` varchar(255) NOT NULL,
    `title` varchar(255) DEFAULT NULL,
    `dashboard_id` varchar(36) DEFAULT NULL,
    `dashlet_id` varchar(36) DEFAULT NULL,
    `options` json DEFAULT NULL,
    `height` int DEFAULT NULL,
    `width` int DEFAULT NULL,
    `x` int DEFAULT NULL,
    `y` int DEFAULT NULL,
    INDEX `dashboard_id` (`dashboard_id`),
    PRIMARY KEY (`id`),
    UNIQUE (`dashlet_id`),
    FOREIGN KEY (`dashboard_id`) REFERENCES `xi_dashboards` (`dashboard_id`)
        ON DELETE CASCADE
        ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;

# Page Usage History

CREATE TABLE IF NOT EXISTS `nagiosxi`.`xi_usage_pages` (
    `row_id` int auto_increment,
    `user_id` int not null,
    `usage_date` date default(CURRENT_DATE) not null,
    `page_title` varchar(255) not null,
    `page_source` varchar(255) not null,
    `page_id` varchar(255) not null default '',
    `usage_count` int default 0,
    primary key(`row_id`),
    unique key(`user_id`, `usage_date`, `page_title`, `page_source`, `page_id`),
    index usage_date_idx (`usage_date`),
    index usage_date_user_idx (`usage_date`, `user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;

# Plugin Usage History

CREATE TABLE IF NOT EXISTS `nagiosxi`.`xi_usage_plugins` (
    `row_id` int auto_increment,
    `user_id` int not null,
    `usage_date` date default(CURRENT_DATE) not null,
    `plugin_name` varchar(255) not null,
    `usage_count` int default 0,
    primary key(`row_id`),
    unique key(`user_id`, `usage_date`, `plugin_name`),
    index usage_date_idx (`usage_date`),
    index usage_date_user_idx (`usage_date`, `user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;

# Wizard Usage History

CREATE TABLE IF NOT EXISTS `nagiosxi`.`xi_usage_wizards` (
    `row_id` int auto_increment,
    `user_id` int not null,
    `usage_date` date default(CURRENT_DATE) not null,
    `wizard_name` varchar(255) not null,
    `step1_count` int default 0,
    `success_count` int default 0,
    `fail_count` int default 0,
    primary key(`row_id`),
    unique key(`user_id`, `usage_date`, `wizard_name`),
    index usage_date_idx (`usage_date`),
    index usage_date_user_idx (`usage_date`, `user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;

# Daily Usage History

CREATE TABLE IF NOT EXISTS `nagiosxi`.`xi_usage_daily` (
    `row_id` int auto_increment,
    `user_id` int not null,
    `usage_type` varchar(255) not null,
    `usage_date` date default(CURRENT_DATE) not null,
    `usage_count` int default 0,
    primary key(`row_id`),
    unique key(`user_id`, `usage_type`, `usage_date`),
    index usage_date_idx (`usage_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;
