    <!--                                   -->
    <!-- The initial data set from Step 1. -->
    <!--                                   -->
    <input type="hidden" id="hostname" name="hostname" value="<?= encode_form_val($hostname) ?>">
    <input type="hidden" id="operation" name="operation" value="<?= encode_form_val($operation) ?>">
    <input type="hidden" id="selectedhostconfig" name="selectedhostconfig" value="<?= encode_form_val($selectedhostconfig) ?>">
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />

    <input type="hidden" name="url" value="<?= encode_form_val($url) ?>">
<?php
    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';
?>
    <div class="container m-0 g-0">

        <h2 class="mb-2"><?= _('URL Details') ?></h2>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="hostname" class="form-label"><?= _('Host Name') ?> <?= xi6_info_tooltip(_('The name you would like to have associated with the website server.')) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="hostname" id="hostname" value="<?= encode_form_val($hostname) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Host Name") ?>" >
                    <div class="invalid-feedback">
                        <?= _("Please enter the Host Name") ?>
                    </div>
                    <i id="hostname_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="servicename" class="form-label"><?= _('Service Name Prefix') ?> <?= xi6_info_tooltip(_('The service name prefix that you would like to have used for specific URL services you select below. This prefix helps to identify this URL when monitoring different URLs on the same web server.')) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="servicename" id="servicename" value="<?= encode_form_val($servicename) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Service Name Prefix") ?>" >
                    <div class="invalid-feedback">
                        <?= _("Please enter the Service Name") ?>
                    </div>
                    <i id="servicename_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="ip" class="form-label"><?= _('IP Address') ?> </label>
                <div class="input-group position-relative">
                    <input type="text" name="ip" id="ip" value="<?= encode_form_val($ip) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter IP Address") ?>" >
                    <div class="invalid-feedback">
                        <?= _("Please enter the IP Address") ?>
                    </div>
                    <i id="ip_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <h2 class="mt-4 mb-2"><?= _('URL Options') ?></h2>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="ssl" class="form-check-input" name="ssl"  <?= is_checked($ssl, "on") ?> >
                        <label for="ssl" class="form-check-label bold"><?= _('Use SSL') ?> <?= xi6_info_tooltip(_('Monitor the URL using SSL/HTTPS.')) ?></label>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row mb-3">
            <div class="col-sm-6">
                <label for="port" class="form-label"><?= _('Port') ?> <?= xi6_info_tooltip(_('The port to use when contacting the website.')) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="port" id="port" value="<?= encode_form_val($port) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Port") ?>" >
                    <div class="invalid-feedback">
                        <?= _("Please enter the Port") ?>
                    </div>
                    <i id="port_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-6 border-block ms-3">
                <label class="form-label fs-6"><?= _('Basic Auth Credentials') ?> <?= xi6_info_tooltip('The username and password to use to authenticate to the URL (optional). If specified, basic authentication is used.') ?></label>
                <div class="row mb-2">
                    <div class="col-sm">
                        <label for="username" class="form-label"><?= _("Username") ?> <?= xi6_info_tooltip(_("The username for the website.")) ?></label>
                        <div class="input-group position-relative">
                        <input type="text" name="username" id="username" value="<?= encode_form_val($username) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Username") ?>">
                        <div class="invalid-feedback">
                            Please enter the username of your SQL Server account.
                        </div>
                            <i id="username_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </div>
                <div id="changePasswordOption" class="row mb-3 mt-4 visually-hidden">
                    <div class="col-sm">
                        <input type="checkbox" id="changePassword" class="form-check-input" name="changePassword">
                        <label for="changePassword" class="form-check-label bold"><?= _('Change Password') ?> <?= xi6_info_tooltip(_("Use to change the password, otherwise, the existing password will be preserved.")) ?></label>
                    </div>
                </div>
                <div id="setPassword" class="row mb-2">
                    <div class="col-sm">
                        <label for="password" class="form-label"><?= _("Password") ?> <?= xi6_info_tooltip(_("The password for the website.")) ?></label>
                        <div class="input-group input-group-sm">
                            <input type="password" name="password" id="password" value="<?=  encode_form_val($password) ?>" class="usermacro-detection form-control form-control-sm rounded-start" autocomplete="off" placeholder="<?= _("Enter Password") ?>">
                            <button type="button" class="btn btn-outline-secondary btn-show-secret rounded-end" id="password-secret" title="<?= _("Show password") ?>">
                                <span class="material-symbols-outlined md-22 md-pointer">Visibility</span>
                                <i id="password_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </button>
                            <div class="invalid-feedback">
                                Please enter the password of your SQL Server account.
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <h2 class="mt-4"><?= _('URL Services') ?></h2>
        <p><?= _('Specify which services you would like to monitor for the URL') ?></p>

        <div class="row">
            <div class="form-check col-sm-10 mt-0 pt-1 mb-2">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm mt-0 pt-1">
                        <input type="checkbox" class="form-check-input" id="http" name="services[http]" <?= is_checked($services['http'], "on") ?>>
                        <label for="http" class="form-check-label bold"><?= _('URL Status') ?> <?= xi6_info_tooltip(_("Includes basic monitoring of the URL to ensure the web server responds with a valid HTTP response.")) ?></label>
                        <div class="row">
                            <div class="col-sm-9 mt-2 mb-2 pt-0 ps-3">
                                <div class="input-group input-group-sm">
                                    <span class="input-group-text">
                                        <span class="form-label m-0 ms-1 align-middle"><?= _('Service Name') ?></span>
                                    </span>
                                    <input type="text" id="httpservicename" name="serviceargs[httpservicename]" value="<?= encode_form_val($serviceargs['httpservicename']) ?>" class="form-control form-control-sm monitor rounded-end">

                                    <i id="httpservicename_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="form-check col-sm-10 mt-0 pt-1 mb-2">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm mt-0 pt-1">
                        <input type="checkbox" class="form-check-input" id="httpcontent" name="services[httpcontent]" <?= is_checked($services['httpcontent'], "on") ?>>
                        <label for="httpcontent" class="form-check-label bold"><?= _('URL Content') ?> <?= xi6_info_tooltip(_("Monitors the URL to ensure the specified string is found in the content of the web page. A content mismatch may indicate that your website has experienced a security breach or is not functioning correctly.")) ?></label>
                        <div class="row">
                            <div class="col-sm-9 mt-2 pt-0 ps-3">
                                <div class="input-group input-group-sm">
                                    <span class="input-group-text">
                                        <label class="form-label m-0 ms-1 align-middle"><?= _('Service Name') ?></label>
                                    </span>
                                    <input type="text" id="httpcontentservicename" name="serviceargs[httpcontentservicename]" value="<?= encode_form_val($serviceargs['httpcontentservicename']) ?>" class="form-control form-control-sm monitor rounded-end">
                                    <i id="httpcontentservicename_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-9 mt-2 mb-2 pt-0 ps-3">
                                <label class="form-label m-0 ms-1 align-middle"><?= _('Expected Content') ?></label>
                                <div class="input-group input-group-sm">
                                    <input type="text" id="httpcontentstr" name="serviceargs[httpcontentstr]" value="<?= encode_form_val($serviceargs["httpcontentstr"]) ?>" class="form-control form-control-sm monitor rounded-end" placeholder="<?= _('Some string') ?>...">
                                    <i id="httpcontentstr_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="form-check col-sm-10 mt-0 pt-1 mb-2">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm mt-0 pt-1">
                        <input type="checkbox" id="httpregex" class="form-check-input" name="services[httpregex]"  <?= is_checked($services['httpregex'], "on") ?> >
                        <label for="httpregex" class="form-check-label bold"><?= _('URL Content Regular Expression Match') ?> <?= xi6_info_tooltip(_("Monitors the URL to ensure the specified regular expression is found in the content of the web page. A content mismatch may indicate that your website has experienced a security breach or is not functioning correctly.")) ?></label>
                        <div class="row">
                            <div class="col-sm-9 mt-2 pt-0 ps-3">
                                <div class="input-group input-group-sm">
                                    <span class="input-group-text">
                                        <label class="form-label m-0 ms-1 align-middle"><?= _('Service Name') ?></label>
                                    </span>
                                    <input type="text" id="httpregexservicename" name="serviceargs[httpregexservicename]" value="<?= encode_form_val($serviceargs['httpregexservicename']) ?>" class="form-control form-control-sm monitor rounded-end">
                                    <i id="httpregexservicename_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-9 mt-2 mb-2 pt-0 ps-3">
                                <label class="form-label m-0 ms-1 align-middle"><?= _('Regular Expression') ?> <?= xi6_info_tooltip('Regular Expression used to find matching text on the web page.') ?></label>
                                <div class="input-group input-group-sm">
                                    <input type="text" id="httpregexstr" name="serviceargs[httpregexstr]" value="<?= encode_form_val($serviceargs['httpregexstr']) ?>" class="form-control form-control-sm monitor rounded-end">
                                    <i id="httpregexstr_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

    </div> <!-- container -->

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
