<?php
// timeline.inc.php
// - Template file for highcharts timeline graph

// Pass all args into template and return JSON code 
/**
 * @param $args
 *
 * @return string
 */
function fetch_timeline($args)
{
    global $cfg;

    // Allow for height & width to be passed for resizing
    $hs_url = grab_array_var($args, "hs_url");
    $render_mode = grab_array_var($args, "render_mode", "");
    $random = uniqid();

    // If no hovering
    $no_hover = "";
    $no_hover_fill = "";
    if ($render_mode == "pdf") {
        $no_hover = "enableMouseTracking: false,";
        $no_hover_fill = "fillColor: '#FFFFFF'";
    }

    $tickPixelInterval = "";
    // if true show each day of the month
    if ($args['tickPixelInterval'] == 1) {
        $tickPixelInterval = "tickPixelInterval: 50,
                              dateTimeLabelFormats: {
                                day: '%d'
                              },";
    }

    // Create readable graph
    $args['title'] = str_replace("_", " ", $args['title']); // Replaces underscores with spaces
    $args['title'] = encode_form_val(urldecode($args['title']));

    $units = explode(" ", $args['UOM']);
    if (count($units) == 3) {
        if ($units[0] == $units[1] && $units[2] == "") {
            $args['UOM'] = $units[0]; // Fix double units of measurement
        }
    }

    // Special export settings for local exporting
    $filename = str_replace(array("  ", " ", ":", "__", "_-_"),
                            array(" ", "_", "-", "_", "-"),
                            strtolower($args['title']));
    $filename = trim($filename, "_");
    $exporting_url = get_exporting_url();
    $exporting = "exporting: {
        url: '{$exporting_url}',
        sourceHeight: $('#{$args['container']}').height(),
        sourceWidth: $('#{$args['container']}').width(),
        filename: '{$filename}',
        chartOptions: { chart: { spacing: [25, 25, 25, 20], marginRight: 40 } }
    },";

    // Set line and other colors
    $line_color = '#EEE';
    $dot_color = '#DFDFDF';
    if (get_theme() == 'xi5dark') {
        $line_color = '#444';
        $dot_color = '#333';
    }
    if (get_theme() == "colorblind") { 
        $color1 = '#56B4E9';
        $color2 = '#F0E442';
        $color3 = '#D55E00';
        $color4 = '#CC79A7';
    }
    else {
        $color1 = '#4089F9';
        $color2 = '#23B55E';
        $color3 = '#FFA121';
        $color4 = '#F24800';
    }

    // Begin heredoc string syntax 
    $graph = <<<GRAPH
        
        var COUNT_{$random} = {$args['count']}; //total rrd entries fetched 
        var UOM_{$random} = '{$args['UOM']}';
        var START_{$random} = {$args['start']};   //Date.UTC(2011, 1, 21) ->added below for correct datatype
        var TITLE_{$random} = '{$args['title']}';
        var CONTAINER_{$random} = '{$args['container']}';
    
        // Reset default colors
        Highcharts.setOptions({
            // colors: ['#4089F9', '#23B55E', '#FFA121', '#F24800', '#454545', '#7472DF', '#FF9655', '#FFF263', '#6AF9C4']
            colors: ['{$color1}', '{$color2}', '{$color3}', '{$color4}', '#454545', '#7472DF', '#FF9655', '#FFF263', '#6AF9C4']
        });

        //data points added below for correct datatype interpretation               
        //use browser's timezone offset for date        
        Highcharts.setOptions({
            global: { useUTC: false },
        });
                
            var chart;
            $(document).ready(function() {
                chart = new Highcharts.Chart({
                    {$exporting}
                    chart: {
                        renderTo: CONTAINER_{$random},
                        zoomType: 'x',
                        spacingRight: 20,
                        animation: false,
                        plotBorderWidth: 1,
                        plotBorderColor: '{$line_color}'
                    },
                    credits: {
                        enabled: false
                    },
                    title: {
                        text: TITLE_{$random},
                        style: {
                            fontWeight: 'bold',
                            "font-family": "'verdana', 'serif'",
                            "font-size": 15
                        }
                    },
                    xAxis: {
                        {$tickPixelInterval}
                        type: 'datetime',
                        maxZoom: {$args['increment']}*1000,  //max zoom is 5 minutes 
                        title: {
                            text: null
                        },
                        gridLineWidth: 1,
                        gridLineColor: '{$dot_color}',
                        gridLineDashStyle: 'dot',
                        lineColor: '{$line_color}',
                        tickColor: '{$line_color}'
                    },
                    yAxis: {
                        title: {
                            text: UOM_{$random}  // unit of measurement from perf data 
                        },
                        showFirstLabel: false,
                        startOnTick: false,
                        gridLineWidth: 1,
                        gridLineColor: '{$line_color}'
                    },
                    tooltip: {
                        shared: true,
                        useHTML: true,
                        formatter: function() {
                            html = Highcharts.dateFormat("%A %b, %e - %l:%M %p", parseInt(this.x));
                            for (var i = 0; i < this.points.length; i++) {
                                html += '<br><span style="color:' + this.points[i].series.color + '">\u25CF</span> <b>' + this.points[i].series.name + '</b>: ' + Math.round(this.points[i].y * 1000) / 1000;
                            }
                            return html;
                        }                  
                    },
                    legend: {
                        enabled: true,
                        itemStyle: {
                            fontWeight: 'normal'
                        }
                    },
                    plotOptions: {
                        line: {
                            {$no_hover}
                            lineWidth: 1,
                            marker: {
                                enabled: false,
                                states: {
                                    hover: {
                                        enabled: true,
                                        radius: 4
                                    }
                                }
                            },
                            shadow: false,
                            states: {
                                hover: {
                                    lineWidth: 1
                                }
                            },
                            pointPaddng: 0,
                            groupPadding: 0
                        },
                        spline: {
                            {$no_hover}
                            lineWidth: 1,
                            marker: {
                                enabled: false,
                                states: {
                                    hover: {
                                        enabled: true,
                                        radius: 4
                                    }
                                }
                            },
                            shadow: false,
                            states: {
                                hover: {
                                    lineWidth: 1
                                }
                            }
                        }
                    },
GRAPH;
// End heredoc syntax

    if (!$args['nodata']) {
        $graph .= "series: [";

        // Loop for multiple data sets in perfdata 
        $series = array();
        for ($i = 0; $i < count($args['datastrings']); $i++) {

            $series[] = "
                    {
                        type: \"line\",
                        name: \"{$args['names'][$i]}\",
                        pointInterval: {$args['increment']}*1000,
                        pointStart: {$args['start']},
                        data: [
                            " . implode(', ', $args['datastrings'][$i]) . "
                        ],
                        animation: false,
                        {$no_hover_fill}
                    }";
        }

        $graph .= implode(',', $series);
        $graph .= "]";
    }

    // End the highcharts graph syntax
    $graph .= " }, function(chart) {
                    chart.title.addClass('chartbutton');
                    chart.title.on('click', function() {
                        window.location = '" . $hs_url . "';
                    })
            });             
        });";

    return $graph;
}