<?php
//
// modern_gauge URL Dashlet 
// Copyright (c) 2008-2022 Nagios Enterprises, LLC. All rights reserved.
//

include_once(dirname(__FILE__) . '/../dashlethelper.inc.php');
include_once(dirname(__FILE__) . '/gaugeshelper.php');

// Run the initialization function
modern_gauge_init();

function modern_gauge_init()
{
	$name = "modern_gauge";
	
	$args = array(
		DASHLET_NAME => $name,
		DASHLET_VERSION => "1.0.3",
		DASHLET_DATE => "12/06/2023",
		DASHLET_AUTHOR => "Nagios Enterprises, LLC",
		DASHLET_DESCRIPTION => _("Modern Gauge Dashlet.	"),
		DASHLET_FILTER_GROUPS => array("metrics"),
		DASHLET_COPYRIGHT => "Copyright (c) 2010-2023 Nagios Enterprises, LLC",
		DASHLET_LICENSE => "BSD",
		DASHLET_HOMEPAGE => "https://www.nagios.com",
		DASHLET_REFRESHRATE => 60,
		DASHLET_FUNCTION => "modern_gauge_func",
		DASHLET_TITLE => _("Modern Gauge Dashlet"),
		DASHLET_OUTBOARD_CLASS=> "modern_gauge_outboardclass",
		DASHLET_INBOARD_CLASS => "modern_gauge_inboardclass",
		DASHLET_PREVIEW_CLASS => "modern_gauge_previewclass",
		DASHLET_JS_FILE => "modern_gauge.js",
		DASHLET_WIDTH => "260",
		DASHLET_HEIGHT => "260",
		DASHLET_OPACITY => "1.0",
        DASHLET_ISCUSTOM => false
	);
		
	register_dashlet($name, $args);
}
	

function modern_gauge_func($mode=DASHLET_MODE_PREVIEW, $id="", $args=null)
{
	$output = "";

	switch ($mode) {

		case DASHLET_MODE_GETCONFIGHTML:
			//input form for dashlet vars 
			if ($args == null) {
                $output = '<script type="text/javascript">load_gauge_hosts();</script>';
                $output .= '<div class="popup-form-box"><label>' . _('Host') . '</label>
                            <div><select id="gauges_form_name" class="form-control" name="host" onchange="getgaugejson()">
                                    <option selected></option>';
                $output .= '</select> <i class="fa fa-spinner fa-spin fa-14 hide host-loader" title="'._('Loading').'"></i></div></div>';
                $output .= '<div class="popup-form-box"><label>' . _('Services') . '</label>
                                <div id="gauges_services">
                                    <select id="gauges_form_services" class="form-control" name="service" onchange="getgaugeservices()" disabled>
                                        <option selected></option>
                                    </select> <i class="fa fa-spinner fa-spin fa-14 hide service-loader" title="'._('Loading').'"></i>
                                    <div id="empty-services" class="hide">'._("No services found").'</div>
                                </div>
                            </div>';
                $output .= '<div class="popup-form-box"><label>' . _('Datasource') . '</label>
                                <div id="gauges_datasource">
                                    <select id="gauges_form_ds" class="form-control" name="ds" disabled>
                                        <option selected></option>
                                    </select> <i class="fa fa-spinner fa-spin fa-14 hide ds-loader" title="'._('Loading').'"></i>
                                    <div id="empty-ds" class="hide">'._("No data sources found").'</div>
                                </div>
                            </div>';
                $output .= '';
            }
            break;

		case DASHLET_MODE_OUTBOARD:
		case DASHLET_MODE_INBOARD:

			$theme = get_theme();


			$output = "";
			$output .= "
						<script>
							// Inject the PHP variable into the JavaScript variable
							var theme = '$theme';
						</script>
						";
            if (empty($args['ds'])) {
                $output .= "ERROR: Missing Arguments- Data source was not provided";
                break;
            }

			// Random dashlet id 
			$rand = rand();

			$n = 0;
            $ajaxargs = "{";
            foreach ($args as $idx => $val) {
                if ($n > 0)
                    $ajaxargs .= ", ";
                $ajaxargs .= "\"$idx\" : \"$val\"";
                $n++;
            }
            $ajaxargs .= "}";

			$host = grab_array_var($args, "host", "");
			$service = urldecode(grab_array_var($args, "service", ""));
			$ds = grab_array_var($args, "ds", "");

			// HTML output (heredoc string syntax)
			ob_start();
			insert_modern_gauge_html($rand);
			?>
			<script>
				var args = [<?= json_encode($args) ?>];
				var url = "<?= get_dashlet_url_base("modern_gauge") . "/getdata.php?host={$host}&service={$service}&ds={$ds}" ?>";

				$.ajax({"url": url, dataType: "json",
					"success": function(result) {
						updategauge("<?= $id ?>", result, "<?= $host ?>", "<?= $service ?>");
					}
				});

				setTimeout(() => {
					// window.location.reload();
				}, "<?= get_dashlet_refresh_rate(60, "perfdata_chart") ?>");


				var elem = $('#dashletcontainer-<?= $id ?>');

				//// add modification menu
				// toggle menu button
				var dashletmodifications = document.querySelector('#dashletcontainer-<?= $id ?> .dashlettopbox .dashboarddashletcontrol .dashletedit');
				dashletmodifications.classList.add('tt-bind');
				dashletmodifications.style.width = '16px';
				dashletmodifications.style.height = '16px';
				dashletmodifications.style.display = 'block';
				dashletmodifications.style.textAlign = 'center';
				dashletmodifications.style.marginLeft = '3px';
				dashletmodifications.setAttribute('data-original-title', 'Customize');
				dashletmodifications.querySelector('a').onclick = function() { toggle(this.nextElementSibling); }

				var dashmodbtn = dashletmodifications.querySelector('a').appendChild(document.createElement('i'));
				dashmodbtn.classList.add('material-symbols-outlined');
				dashmodbtn.innerHTML = 'edit';

				function toggle(item){
					if (item.style.display === 'none') {
						item.style.display = 'block';
					} else {
						item.style.display = 'none';
					}
				}

				// modifications menu
				var dashModMenu = dashletmodifications.appendChild(document.createElement('div'));
				dashModMenu.classList.add('dashlet-modify-menu');
				dashModMenu.style.height = '40px';
				dashModMenu.style.display = 'none';
				dashModMenu.style.backgroundColor = 'grey';
	
				var dashModMenuForm = dashModMenu.appendChild(document.createElement('div'));
				dashModMenuForm.style.backgroundColor = '#555';
				dashModMenuForm.style.width = '125px';
				dashModMenuForm.style.height = '40px';
				dashModMenuForm.style.alignItems = 'center';
				dashModMenuForm.style.verticalAlign = 'middle';


				var dMMFTogglezones = dashModMenuForm.appendChild(document.createElement('button'));
				dMMFTogglezones.innerHTML = 'Toggle Zones';
				dMMFTogglezones.value = 'ToggleZones';
				dMMFTogglezones.classList.add('togglezones');
				dMMFTogglezones.style.width = '125px';
				// dMMFTogglezones.style.height = '20px';
				dMMFTogglezones.style.backgroundColor = '#444';
				dMMFTogglezones.style.border = '3px solid #555';
				dMMFTogglezones.onclick = function() { 
					if(localStorage.getItem('hidezones<?= $id ?>') == 1) { 
						localStorage.setItem('hidezones<?= $id ?>', 0); 
						showzones('#dashlet-'+'<?= $id ?>');
					}else{ 
						localStorage.setItem('hidezones<?= $id ?>', 1);
						hidezones('#dashlet-'+'<?= $id ?>');
					}
				}
				if(localStorage.getItem('hidezones<?= $id ?>') == null) {localStorage.setItem('hidezones<?= $id ?>', 0);}
				if(localStorage.getItem('hidezones<?= $id ?>') == 1){ hidezones('#dashlet-'+'<?= $id ?>'); } else { showzones('#dashlet-'+'<?= $id ?>');}

				var dMMFTogglepercent = dashModMenuForm.appendChild(document.createElement('button'));
				dMMFTogglepercent.innerHTML = 'Toggle Percent';
				dMMFTogglepercent.value = 'TogglePercent';
				dMMFTogglepercent.classList.add('togglepercent');
				dMMFTogglepercent.style.width = '125px';
				dMMFTogglepercent.style.backgroundColor = '#444';
				dMMFTogglepercent.style.border = '3px solid #555';
				dMMFTogglepercent.onclick = function() { 
					if(localStorage.getItem('hidepercent<?= $id ?>') == 1) { 
						localStorage.setItem('hidepercent<?= $id ?>', 0); 
						showpercent('#dashlet-'+'<?= $id ?>');
					}else{ 
						localStorage.setItem('hidepercent<?= $id ?>', 1); 
						hidepercent('#dashlet-'+'<?= $id ?>');
					}
				}
				if(localStorage.getItem('hidepercent<?= $id ?>') == null) {localStorage.setItem('hidepercent<?= $id ?>', 0);}
				if(localStorage.getItem('hidepercent<?= $id ?>') == 1){ hidepercent('#dashlet-'+'<?= $id ?>'); } else { }
			</script>
			<?php
			$output .= ob_get_clean();
			
			break;

		case DASHLET_MODE_PREVIEW:
			
			if(!is_neptune()) {
                $output="<img src='".get_dashlet_url_base("modern_gauge")."/modern_gauge.png' alt='No Preview Available' width='50%'/>";
			} else if (get_theme() == "neptunelight") {
                $output="<img src='".get_dashlet_url_base("modern_gauge")."/modern_gauge_neptune_light_preview.png' alt='No Preview Available' width='50%'/>";
            } else {
                $output="<img src='".get_dashlet_url_base("modern_gauge")."/neptune_preview.png' alt='No Preview Available' width='50%'/>";
            }
            break;	
		}
		
	return $output;
}

function insert_modern_gauge_html($id) {
	?>
    <div class="modern_gauge_dashlet_<?= $id ?>">
	  
      <svg class="modern_gauge_svg" viewBox="-50 -50 100 100">
        <circle cx="0" cy="0" r="45"></circle>
        <circle cx="0" cy="0" r="45"></circle>
        <circle cx="0" cy="0" r="45"></circle>
        <circle cx="0" cy="0" r="45"></circle>
        
        <line class="war" stroke="yellow"/>
        <line class="crt" stroke="red"/>
      </svg>
      <div class="gaugetext">
        <h2>0<span></span></h2>
        <p id="serviceName"></p>
		<p id="value"></p>
      </div>
    </div>

	<style>
	  .modern_gauge_dashlet_<?= $id ?> {
		position: relative;
		width: 100%;
		height: 100%;
		--num:0;
		--warinit:0;
		--crtinit:0;
		display: flex;
		justify-content: center;
		align-items: center;
	  }
	  
	  .modern_gauge_dashlet_<?= $id ?> svg.modern_gauge_svg {
		position: relative;
		width: 180px;
		height: 180px;
		transform: rotate(-90deg);
		margin: auto;
	  }
	  /* line markers */
	  .modern_gauge_dashlet_<?= $id ?> svg.modern_gauge_svg line {
		opacity: 0.2;
		display: none;
	  }
	  /* all circles */
	  .modern_gauge_dashlet_<?= $id ?> svg.modern_gauge_svg circle {
		fill: transparent;
		stroke-width: 10;
		transition: 1s all;
		transition-timing-function: cubic-bezier(0.05, 0.55, 0.85, 1.0);
	  }
	  /* background circle */
	  .modern_gauge_dashlet_<?= $id ?> svg circle:nth-child(1){
		stroke: #222222;
		transition: none;
	  }
	  /* current status circle */
	  .modern_gauge_dashlet_<?= $id ?> svg circle:nth-child(4){
		--color: var(--color-okay);
		stroke: var(--color);
		z-index: 15;
		stroke-opacity: 1;
	  }
	  /* warning range circle segment */
	  .modern_gauge_dashlet_<?= $id ?> svg circle:nth-child(3){
		stroke: var(--color-warning);
		z-index: 5;
		stroke-opacity: 0.3;
		transition: none;
	  }
	  /* critical range circle segment */
	  .modern_gauge_dashlet_<?= $id ?> svg circle:nth-child(2){
		stroke: var(--color-critical);
		z-index: 10;
		stroke-opacity: 0.25;
		transition: none;
	  }
	  
	  
	  .modern_gauge_dashlet_<?= $id ?> .gaugetext {
		position: absolute;
		left: 50%;
		top: 50%;
		transform: translate(-50%, -30%);
		display: flex;
		flex-direction: column;
		align-items: center;
		text-align: center;
	  }
	  .modern_gauge_dashlet_<?= $id ?> .gaugetext h2 {
		margin: 0;
		padding: 0;
		text-align: center;
		display: flex;
		align-items: center;
		justify-content: center;
		font-family: inherit;
		color: var(--color);
		font-size: 2.5em;
	  }
	  .modern_gauge_dashlet_<?= $id ?> .gaugetext h2 span {
		font-weight:300;
		font-size:0.4em;
		transform: translateY(7px);
		color:#CCC;
		font-family: sans-serif;
	  }
	  .modern_gauge_dashlet_<?= $id ?> .gaugetext p#serviceName {
		font-weight:300;
		font-size:1.1em;
		margin-top: 30px;
		padding-bottom: 0;
		color:#CCC;
		text-align: center;
		transform: translateY(-1em);
		font-family: sans-serif;
	  }
	  .modern_gauge_dashlet_<?= $id ?> .gaugetext p#value {
		font-weight:300;
		font-size:1.3em;
		margin-top: 6px;
		padding-bottom: 0px;
		color:#CCC;
		text-align: center;
		transform: translateY(-1em);
		font-family: sans-serif;
		--show-percent: "%";
	  }
	  .modern_gauge_dashlet_<?= $id ?> .gaugetext p#value:after {
		content: var(--show-percent);
		font-weight:250;
		color:#DDD;
		font-size:0.9em;
		margin: 0px;
		transition: 1s all;
	  }
	  </style>
	  <?php
}