<?php
//
// NagVis Integration Component
// Copyright (c) 2010-2023 - Nagios Enterprises, LLC. All rights reserved.
//

require_once(dirname(__FILE__) . '/../componenthelper.inc.php');

// Initialization stuff
pre_init();
init_session();

// Grab GET or POST variables and check authentication
grab_request_vars();
check_prereqs();
check_authentication(false);

// This component does not use do_page_start() from pageparts.inc.php, so we have to add
// the call for telemetry here.
$user_id = grab_array_var($_SESSION, 'user_id');

record_page_usage($user_id, 'NagVis', basename(__FILE__), '');


route_redirect();


// We will redirect whatever the page details are into NagVis,
// this is used to create PDF page reports of NagVis dashboards/pages
function route_redirect()
{
	$uri = $_SERVER['REQUEST_URI'];
	$uri_parts = explode('?', $uri);
	$url = preg_replace('~(^https?://[^/]+)/nagiosxi~', '$1/nagvis', get_base_url(), 1) . 'frontend/nagvis-js/index.php?' . $uri_parts[1];
	header("Location: " . $url);
}
