    <input type="hidden" id="services_serial" name="services_serial" value="<?= (!empty($services)) ? base64_encode(json_encode($services)) : "" ?>" />
    <input type="hidden" id="serviceargs_serial" name="serviceargs_serial" value="<?= (!empty($serviceargs)) ? base64_encode(json_encode($serviceargs)) : "" ?>" />
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />

<?php
    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';
?>
    <div class="container m-0 g-0">
        <!--                         -->
        <!-- The configuration form. -->
        <!--                         -->
        <div id="configForm">
            <h2 class="mb-2"><?= _('Windows Machine Information') ?></h2>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="ip_address" class="form-label form-item-required"><?= _('IP Address') ?> <?= xi6_info_tooltip(_('The IP address of the Windows machine you would like to monitor.')) ?></label>
                    <div class="input-group position-relative">
                        <input type="text" name="ip_address" id="ip_address" value="<?= encode_form_val($address) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter IP Address") ?>" required>
                        <div class="invalid-feedback">
                            Please enter the IP Address
                        </div>
                        <i id="ip_address_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="osversion" class="form-label form-item-required"><?= _('Operating System') ?> </label>
                    <div class="input-group position-relative">
                        <select name="osversion" id="osversion" class="form-select monitor rounded" placeholder="<?= _("Select Operating System") ?> " required>
                            <option value="" disabled selected hidden>Choose an Operating System...</option>
                            <option value="win11" <?= is_selected($osversion, "win11") ?>><?= _('Windows 11') ?></option>
                            <option value="win10" <?= is_selected($osversion, "win10") ?>><?= _('Windows 10') ?></option>
                            <option value="win8" <?= is_selected($osversion, "win8") ?>><?= _('Windows 8.x') ?></option>
                            <option value="win7" <?= is_selected($osversion, "win7") ?>><?= _('Windows 7') ?></option>
                            <option value="win2k22" <?= is_selected($osversion, "win2k22") ?>><?= _('Windows Server 2022') ?></option>
                            <option value="win2k19" <?= is_selected($osversion, "win2k19") ?>><?= _('Windows Server 2019') ?></option>
                            <option value="win2k16" <?= is_selected($osversion, "win2k16") ?>><?= _('Windows Server 2016') ?></option>
                            <option value="win2k12" <?= is_selected($osversion, "win2k12") ?>><?= _('Windows Server 2012') ?></option>
                            <option value="win2k8" <?= is_selected($osversion, "win2k8") ?>><?= _('Windows Server 2008') ?></option>
                            <option value="win2k3" <?= is_selected($osversion, "win2k3") ?>><?= _('Windows Server 2003') ?></option>
                            <option value="winvista" <?= is_selected($osversion, "winvista") ?>><?= _('Windows Vista') ?></option>
                            <option value="win2k" <?= is_selected($osversion, "win2k") ?>><?= _('Windows 2000') ?></option>
                            <option value="winxp" <?= is_selected($osversion, "winxp") ?>><?= _('Windows XP') ?></option>
                            <option value="other" <?= is_selected($osversion, "other") ?>><?= _('Other') ?></option>
                        </select>
                        <div class="invalid-feedback">
                            Please select Operating System
                        </div>
                        <i id="osversion_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <h2 class="mt-4"><?= _('SNMP Settings') ?></h2>
            <p><?= _('Specify the settings used to monitor the Windows machine via SNMP') ?></p>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="snmpversion" class="form-label form-item-required"><?= _('SNMP Version') ?> <?= xi6_info_tooltip(_('The SNMP protocol version used to commicate with the machine. You many need to use SNMP v1 if your Windows system language is not English.')) ?></label>
                    <div class="input-group position-relative">
                        <select name="snmpversion" id="snmpversion" class="form-select monitor rounded" placeholder="<?= _("Select SNMP Version") ?> " required>
                            <option value="1" <?= is_selected($snmpversion, "1") ?>>1</option>
                            <option value="2c" <?= is_selected($snmpversion, "2c") ?>>2c</option>
                            <option value="3" <?= is_selected($snmpversion, "3") ?>>3</option>
                        </select>
                        <div class="invalid-feedback">
                            Please select SNMP Version
                        </div>
                        <i id="snmpversion_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="port" class="form-label form-item-required"><?= _('SNMP Port') ?> <?= xi6_info_tooltip(_('The SNMP port to use, the default is port 161.')) ?></label>
                    <div class="input-group position-relative">
                        <input type="text" name="port" id="port" value="<?= encode_form_val($port) ?>" class="form-control monitor rounded" placeholder="<?= _("161") ?>">
                        <div class="invalid-feedback">
                            Please enter the SNMP Port - default 161
                        </div>
                        <i id="port_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <h2 class="mt-4 mb-2"><?= _('SNMP Version Settings') ?></h2>

            <div id="auth2">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <label for="snmpcommunity" class="form-label form-item-required"><?= _('SNMP Community') ?> <?= xi6_info_tooltip(_('The SNMP community string required used to to query the Windows machine.')) ?></label>
                        <div class="input-group position-relative">
                            <input type="text" name="snmpcommunity" id="snmpcommunity" value="<?= encode_form_val($snmpcommunity) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter SNMP Community") ?>" required>
                            <div class="invalid-feedback">
                                Please enter the SNMP Community
                            </div>
                            <i id="snmpcommunity_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </div>
            </div>

            <div id="auth3" class="hide">
                <p><?= _('When using SNMP v3 you must specify authentication information') ?></p>

                <div class="row mb-2">
                    <div class="col-sm-6">
                        <label for="snmpopts[v3_security_level]" class="form-label form-item-required"><?= _('Security Level') ?> </label>
                        <div class="input-group position-relative">
                            <select id="snmpopts[v3_security_level]" name="snmpopts[v3_security_level]" class="form-select monitor rounded security_level">
                                <option value="authPriv" <?= is_selected($snmpopts["v3_security_level"], "authPriv") ?>>authPriv</option>
                                <option value="authNoPriv" <?= is_selected($snmpopts["v3_security_level"], "authNoPriv") ?>>authNoPriv</option>
                                <option value="noAuthNoPriv" <?= is_selected($snmpopts["v3_security_level"], "noAuthNoPriv") ?>>noAuthNoPriv</option>
                            </select>
                            <div class="invalid-feedback">
                                Please select Security Level
                            </div>
                            <i id="snmpopts_v3_security_level_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </div>

                <div class="row mb-2">
                    <div class="col-sm-6">
                        <label for="snmpopts[v3_username]" class="form-label form-item-required"><?= _('Username') ?> </label>
                        <div class="input-group position-relative">
                            <input type="text" name="snmpopts[v3_username]" id="snmpopts[v3_username]" value="<?= encode_form_val($snmpopts["v3_username"]) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter Username") ?>" required>
                            <div class="invalid-feedback">
                                Please enter the Username
                            </div>
                            <i id="snmpopts_v3_username_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </div>

                <div class="row mb-2">
                    <div class="col-sm-6">
                        <label for="snmpopts[v3_auth_password]" class="form-label form-item-required"><?= _('Authentication Password') ?> </label>
                        <div class="input-group position-relative">
                            <input type="text" name="snmpopts[v3_auth_password]" id="snmpopts[v3_auth_password]" value="<?= encode_form_val($snmpopts["v3_auth_password"]) ?>" class="form-control monitor rounded authPriv-enable authNoPriv-enable noAuthNoPriv-disable" placeholder="<?= _("Enter Authentication Password") ?>" required>
                            <div class="invalid-feedback">
                                Please enter the Authentication Password
                            </div>
                            <i id="snmpopts_v3_auth_password_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </div>

                <div class="row mb-2">
                    <div class="col-sm-6">
                        <label for="snmpopts[v3_auth_proto]" class="form-label form-item-required"><?= _('Authentication Protocol') ?> </label>
                        <div class="input-group position-relative">
                            <select name="snmpopts[v3_auth_proto]" id="snmpopts[v3_auth_proto]" class="form-select monitor rounded authPriv-enable authNoPriv-enable noAuthNoPriv-disable" placeholder="<?= _("Select Authentication Protocol") ?> " required>
                                <option value="md5" <?= is_selected($snmpopts["v3_auth_proto"], "md5") ?>>MD5</option>
                                <option value="sha" <?= is_selected($snmpopts["v3_auth_proto"], "sha") ?>>SHA</option>
                            </select>
                            <div class="invalid-feedback">
                                Please select Authentication Protocol
                            </div>
                            <i id="snmpopts_v3_auth_proto_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </div>

                <div class="row mb-2">
                    <div class="col-sm-6">
                        <label for="snmpopts[v3_privacy_password]" class="form-label form-item-required"><?= _('Privacy Password') ?> </label>
                        <div class="input-group position-relative">
                            <input type="text" name="snmpopts[v3_privacy_password]" id="snmpopts[v3_privacy_password]" value="<?= encode_form_val($snmpopts["v3_privacy_password"]) ?>" class="form-control monitor rounded authPriv-enable authNoPriv-disable noAuthNoPriv-disable" placeholder="<?= _("Enter Privacy Password") ?>" required>
                            <div class="invalid-feedback">
                                Please enter the Privacy Password
                            </div>
                            <i id="snmpopts_v3_privacy_password_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </div>

                <div class="row mb-2">
                    <div class="col-sm-6">
                        <label for="snmpopts[v3_priv_proto]" class="form-label form-item-required"><?= _('Privacy Protocol') ?> </label>
                        <div class="input-group position-relative">
                            <select name="snmpopts[v3_priv_proto]" id="snmpopts[v3_priv_proto]" class="form-select monitor rounded authPriv-enable authNoPriv-disable noAuthNoPriv-disable" placeholder="<?= _("Select Privacy Protocol") ?> " required>
<?php
            $xisys = $cfg['root_dir'] . '/var/xi-sys.cfg';
            $ini = parse_ini_file($xisys);

            $des_option = '';

            if ($ini['dist'] != "el9" && $ini['dist'] != "ubuntu22") {
?>
                                <option value="des" <?= is_selected($snmpopts["v3_priv_proto"], "des") ?>>DES</option>
<?php
            }
?>
                                <option value="aes" <?= is_selected($snmpopts["v3_priv_proto"], "aes") ?>>AES</option>
                            </select>
                            <div class="invalid-feedback">
                                Please select Privacy Protocol
                            </div>
                            <i id="snmpopts_v3_priv_proto_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </div>
            </div> <!-- auth3 -->
        </div> <!-- config -->
    </div> <!-- container -->

    <script type="text/javascript">
        $(document).ready(function() {
            // Initial check
            update_security_display();
            select_default_proto();

            // Detection
            $("#snmpversion").change(function() {
                update_security_display();
            });

            $("[name='snmpopts[v3_security_level]']").change(function() {
                select_default_proto();
            });

            function update_security_display(version_val) {
                var version_val = $("#snmpversion").val();
                if (version_val == "3") {
                    $("#auth3").show();
                    $('#auth3 :input').attr('required', true)
                    $("#auth2").hide();
                } else {
                    $('#auth3 :input').removeAttr('required')
                    $("#auth3").hide();
                    $("#auth2").show();
                }
            }

            function select_default_proto(level_val) {
                var level_val = $("[name='snmpopts[v3_security_level]']").val();

                if (level_val == "authNoPriv") {
                    $("[name='snmpopts[v3_auth_proto]']").val("md5");
                    $("[name='snmpopts[v3_priv_proto]']").val("");
                } else if (level_val == "authPriv") {
                    $("[name='snmpopts[v3_auth_proto]']").val("md5");
                    $("[name='snmpopts[v3_priv_proto]']").val("des");
                }
            }

            security_level = $(".security_level").val();
            enable_fields_by_security_level(security_level);
            $(".security_level").change(function () {
                enable_fields_by_security_level($(this).val());
            });
        });

        function enable_fields_by_security_level(level) {
            $("." + level + "-enable").attr("disabled", false);
            $("." + level + "-disable").attr("disabled", true);
        }
    </script>

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
