    <!--                                   -->
    <!-- The initial data set from Step 1. -->
    <!--                                   -->
    <input type="hidden" id="hostname" name="hostname" value="<?= encode_form_val($hostname) ?>">
    <input type="hidden" id="operation" name="operation" value="<?= encode_form_val($operation) ?>">
    <input type="hidden" id="selectedhostconfig" name="selectedhostconfig" value="<?= encode_form_val($selectedhostconfig) ?>">
    <input type="hidden" id="services_serial" name="services_serial" value="<?= (!empty($services)) ? base64_encode(json_encode($services)) : "" ?>" />
    <input type="hidden" id="serviceargs_serial" name="serviceargs_serial" value="<?= (!empty($serviceargs)) ? base64_encode(json_encode($serviceargs)) : "" ?>" />
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />

    <input type="hidden" name="ip_address" value="<?= encode_form_val($address) ?>">
    <input type="hidden" name="model" value="<?= encode_form_val($model) ?>">
<?php
    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';
?>
    <div class="container m-0 g-0">

        <h2 class="mb-2"><?= _('Websensor Details') ?></h2>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="ip_address" class="form-label"><?= _('Address') ?> </label>
                <div class="input-group position-relative">
                    <input type="text" name="ip_address" id="ip_address" value="<?= encode_form_val($address) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter Address") ?>" disabled="on">
                    <div class="invalid-feedback">
                        <?= _("Please enter the ".$labelText) ?>
                    </div>
                    <i id="ip_address_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="hostname" class="form-label"><?= _('Host Name') ?> <?= xi6_info_tooltip(_('The name you would like to have associated with this Websensor')) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="hostname" id="hostname" value="<?= encode_form_val($hostname) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter Host Name") ?>">
                    <div class="invalid-feedback">
                        <?= _("Please enter the ".$labelText) ?>
                    </div>
                    <i id="hostname_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <!--                         -->
        <!-- The metrics to monitor. -->
        <!--                         -->
        <h2 class="mt-4"><?= _('Device Metrics') ?></h2>
        <p><?= _('Specify which metrics you would like to monitor on the Websensor') ?>.</p>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="services[ping]" class="form-check-input" name="services[ping]"  checked="on">
                        <label for="services[ping]" class="form-check-label bold"><?= _('Ping') ?> <?= xi6_info_tooltip(_('Monitors the Websensor with an ICMP ping. Useful for watching network latency and general uptime')) ?></label>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="services[temp]" class="form-check-input" name="services[temp]"  checked="on">
                        <label for="services[temp]" class="form-check-label bold"><?= _('Temperature') ?> <?= xi6_info_tooltip(_('Monitors the temperature readings from the device')) ?></label>
                    </div>
                    <div class="col-sm-6 mt-0">
                        <div class="row g-0 p-0">
                            <div class="col-sm-6 mt-0 pe-1">
                        		<div class="input-group input-group-sm">
                            		<span class="input-group-text">
										<i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400">warning</i><span class="form-label m-0 ms-1 align-middle"><?= _('Below') ?></span>
                            		</span>
                            		<input type="text" id="serviceargs[temp_warning_low]" name="serviceargs[temp_warning_low]" value="<?= encode_form_val($temp_warning_low) ?>" class="form-control form-control-sm monitor">
		                            
                            		<i id="serviceargs_temp_warning_low_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        		</div>
                            </div>
                			<div class="col-sm-6 mt-0">
		                        <div class="input-group input-group-sm">
		                            <span class="input-group-text">
		                                <span class="form-label m-0 ms-1 align-middle"><?= _('Above') ?></span>
		                            </span>
		                            <input type="text" id="serviceargs[temp_warning_high]" name="serviceargs[temp_warning_high]" value="<?= encode_form_val($temp_warning_high) ?>" class="form-control form-control-sm monitor">
		                            <span class="input-group-text">Deg. F</span>
		                            <i id="serviceargs_temp_warning_high_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
		                        </div>
		                    </div>
		                </div>
                        <div class="row g-0 p-0">
                            <div class="col-sm-6 mt-0 pe-1">
                        		<div class="input-group input-group-sm">
                            		<span class="input-group-text">
										<i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i><span class="form-label m-0 ms-1 align-middle"><?= _('Below') ?></span>
                            		</span>
                            		<input type="text" id="serviceargs[temp_critical_low]" name="serviceargs[temp_critical_low]" value="<?= encode_form_val($temp_critical_low) ?>" class="form-control form-control-sm monitor">
		                            
                            		<i id="serviceargs_temp_critical_low_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        		</div>
                            </div>
                			<div class="col-sm-6 mt-0">
		                        <div class="input-group input-group-sm">
		                            <span class="input-group-text">
		                                <span class="form-label m-0 ms-1 align-middle"><?= _('Above') ?></span>
		                            </span>
		                            <input type="text" id="serviceargs[temp_critical_high]" name="serviceargs[temp_critical_high]" value="<?= encode_form_val($temp_critical_high) ?>" class="form-control form-control-sm monitor">
		                            <span class="input-group-text">Deg. F</span>
		                            <i id="serviceargs_temp_critical_high_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
		                        </div>
		                    </div>
		                </div>
		            </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="services[humidity]" class="form-check-input" name="services[humidity]"  checked="on">
                        <label for="services[humidity]" class="form-check-label bold"><?= _('Humidity') ?> <?= xi6_info_tooltip(_('Monitors the humidity readings from the device')) ?></label>
                    </div>
                    <div class="col-sm-6 mt-0">
                        <div class="row g-0 p-0">
                            <div class="col-sm-6 mt-0 pe-1">
                        		<div class="input-group input-group-sm">
                            		<span class="input-group-text">
										<i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400">warning</i><span class="form-label m-0 ms-1 align-middle"><?= _('Below') ?></span>
                            		</span>
                            		<input type="text" id="serviceargs[humidity_warning_low]" name="serviceargs[humidity_warning_low]" value="<?= encode_form_val($humidity_warning_low) ?>" class="form-control form-control-sm monitor">
		                            
                            		<i id="serviceargs_humidity_warning_low_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        		</div>
                            </div>
                			<div class="col-sm-6 mt-0">
		                        <div class="input-group input-group-sm">
		                            <span class="input-group-text">
		                                <span class="form-label m-0 ms-1 align-middle"><?= _('Above') ?></span>
		                            </span>
		                            <input type="text" id="serviceargs[humidity_warning_high]" name="serviceargs[humidity_warning_high]" value="<?= encode_form_val($humidity_warning_high) ?>" class="form-control form-control-sm monitor">
		                            <span class="input-group-text">%</span>
		                            <i id="serviceargs_humidity_warning_high_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
		                        </div>
		                    </div>
		                </div>
                        <div class="row g-0 p-0">
                            <div class="col-sm-6 mt-0 pe-1">
                        		<div class="input-group input-group-sm">
                            		<span class="input-group-text">
										<i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i><span class="form-label m-0 ms-1 align-middle"><?= _('Below') ?></span>
                            		</span>
                            		<input type="text" id="serviceargs[humidity_critical_low]" name="serviceargs[humidity_critical_low]" value="<?= encode_form_val($humidity_critical_low) ?>" class="form-control form-control-sm monitor">
		                            
                            		<i id="serviceargs_humidity_critical_low_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        		</div>
                            </div>
                			<div class="col-sm-6 mt-0">
		                        <div class="input-group input-group-sm">
		                            <span class="input-group-text">
		                                <span class="form-label m-0 ms-1 align-middle"><?= _('Above') ?></span>
		                            </span>
		                            <input type="text" id="serviceargs[humidity_critical_high]" name="serviceargs[humidity_critical_high]" value="<?= encode_form_val($humidity_critical_high) ?>" class="form-control form-control-sm monitor">
		                            <span class="input-group-text">%</span>
		                            <i id="serviceargs_humidity_critical_high_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
		                        </div>
		                    </div>
		                </div>
		            </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="services[illumination]" class="form-check-input" name="services[illumination]"  checked="on">
                        <label for="services[illumination]" class="form-check-label bold"><?= _('Illumination') ?> <?= xi6_info_tooltip(_('Monitors the illumination (light level) readings from the device')) ?></label>
                    </div>
                    <div class="col-sm-6 mt-0">
                        <div class="row g-0 p-0">
                            <div class="col-sm-6 mt-0 pe-1">
                        		<div class="input-group input-group-sm">
                            		<span class="input-group-text">
										<i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400">warning</i><span class="form-label m-0 ms-1 align-middle"><?= _('Below') ?></span>
                            		</span>
                            		<input type="text" id="serviceargs[illumination_warning_low]" name="serviceargs[illumination_warning_low]" value="<?= encode_form_val($illumination_warning_low) ?>" class="form-control form-control-sm monitor">
		                            
                            		<i id="serviceargs_illumination_warning_low_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        		</div>
                            </div>
                			<div class="col-sm-6 mt-0">
		                        <div class="input-group input-group-sm">
		                            <span class="input-group-text">
		                                <span class="form-label m-0 ms-1 align-middle"><?= _('Above') ?></span>
		                            </span>
		                            <input type="text" id="serviceargs[illumination_warning_high]" name="serviceargs[illumination_warning_high]" value="<?= encode_form_val($illumination_warning_high) ?>" class="form-control form-control-sm monitor">
		                            
		                            <i id="serviceargs_illumination_warning_high_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
		                        </div>
		                    </div>
		                </div>
                        <div class="row g-0 p-0">
                            <div class="col-sm-6 mt-0 pe-1">
                        		<div class="input-group input-group-sm">
                            		<span class="input-group-text">
										<i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i><span class="form-label m-0 ms-1 align-middle"><?= _('Below') ?></span>
                            		</span>
                            		<input type="text" id="serviceargs[illumination_critical_low]" name="serviceargs[illumination_critical_low]" value="<?= encode_form_val($illumination_critical_low) ?>" class="form-control form-control-sm monitor">
		                            
                            		<i id="serviceargs_illumination_critical_low_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        		</div>
                            </div>
                			<div class="col-sm-6 mt-0">
		                        <div class="input-group input-group-sm">
		                            <span class="input-group-text">
		                                <span class="form-label m-0 ms-1 align-middle"><?= _('Above') ?></span>
		                            </span>
		                            <input type="text" id="serviceargs[illumination_critical_high]" name="serviceargs[illumination_critical_high]" value="<?= encode_form_val($illumination_critical_high) ?>" class="form-control form-control-sm monitor">
		                            
		                            <i id="serviceargs_illumination_critical_high_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
		                        </div>
		                    </div>
		                </div>
		            </div>
                </fieldset>
            </div>
        </div>

    </div> <!-- container -->

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
