    <!--                                   -->
    <!-- The initial data set from Step 1. -->
    <!--                                   -->
    <input type="hidden" id="hostname" name="hostname" value="<?= encode_form_val($hostname) ?>">
    <input type="hidden" id="operation" name="operation" value="<?= encode_form_val($operation) ?>">
    <input type="hidden" id="selectedhostconfig" name="selectedhostconfig" value="<?= encode_form_val($selectedhostconfig) ?>">
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : '' ?>" />
        
    <input type="hidden" name="ip_address" value="<?= encode_form_val($address) ?>">
    <input type="hidden" name="winrm_username" value="<?= encode_form_val($winrm_username) ?>">
    <input type="hidden" name="winrm_password" value="<?= encode_form_val($winrm_password) ?>">
    <input type="hidden" name="use_https" value="<?= encode_form_val($use_https) ?>">
<?php
    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';
?>
    <div class="container m-0 g-0">
        
        <h2 class="mb-2"><?= _('Server Details') ?></h2>
        
        <div class="row mb-2">
            <div class="col-sm-6">
                <label class="form-label"><?= _('IP Address') ?></label>
                <div class="input-group position-relative">
                    <input type="text" size="40" name="ip_address" id="ip_address" value="<?= encode_form_val($address) ?>" class="form-control form-control-sm" disabled>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label class="form-label"><?= _('Host Name') ?> <?= xi6_info_tooltip(_('The name to associate with this server.')) ?></label>
                <div class="input-group position-relative">
                    <input type="text" size="20" name="hostname" id="hostname" value="<?= encode_form_val($hostname) ?>" class="form-control form-control-sm">
                </div>
            </div>
        </div>
            
            
        <!--                         -->
        <!-- The metrics to monitor. -->
        <!--                         -->
        <h2 class="mt-4"><?= _('Server Metrics') ?></h2>

        <p><?= _('Specify which services to monitor for this server.') ?></p>

        <div class="col-sm-8 border-block mt-4 mb-3">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="memory_usage" class="form-check-input" name="services[memory_usage][monitor]" <?= (array_key_exists('monitor', $services['memory_usage']) ? is_checked($services['memory_usage']['monitor'], 'on') : '') ?>>
                        <label for="memory_usage" class="form-check-label bold">
                            <?= _('Memory Usage') ?><?= xi6_info_tooltip(_('Monitor the amount of memory used on the server.')) ?>
                        </label>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <span class="form-label m-0 ms-1 align-middle">
                                    <?= _('Unit') ?>
                                </span>
                            </span>
                            <select name="services[memory_usage][outputType]" id="services[memory_usage][outputType]" class="form-control form-select input-group input-group-sm">
                                <option value="MB" <?= is_selected($services["memory_usage"]["outputType"], "MB") ?>><?= _('MB') ?></option>
                                <option value="GB" <?= is_selected($services["memory_usage"]["outputType"], "GB") ?>><?= _('GB') ?></option>
                                <option value="TB" <?= is_selected($services["memory_usage"]["outputType"], "TB") ?>><?= _('TB') ?></option>
                            </select>
                        </div>
                    </div>  
                    <div class="col-sm-2 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                            </span>
                            <input type="text" id="services[memory_usage][warning]" name="services[memory_usage][warning]" value="<?= encode_form_val($services['memory_usage']['warning']) ?>" class="form-control form-control-sm monitor rounded-end">
                            <i id="services_memory_usage_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-2 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i>
                            </span>
                            <input type="text" id="services[memory_usage][critical]" name="services[memory_usage][critical]" value="<?= encode_form_val($services['memory_usage']['critical']) ?>" class="form-control form-control-sm monitor rounded-end">
                            <i id="services_memory_usage_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>
        
        <div class="col-sm-8 border-block mb-3">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="services[cpu_usage][monitor]" class="form-check-input" name="services[cpu_usage][monitor]" <?= (array_key_exists('monitor', $services['cpu_usage']) ? is_checked($services['cpu_usage']['monitor'], 'on') : '') ?>>
                        <label for="cpu_usage" class="form-check-label bold">
                            <?= _('CPU Usage') ?><?= xi6_info_tooltip(_("Monitor the cpu_usage (processor usage) on the machine.")) ?>
                        </label>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                            </span>
                            <input type="text" id="services[cpu_usage][warning]" name="services[cpu_usage][warning]" value="<?= encode_form_val($services['cpu_usage']['warning']) ?>" class="form-control form-control-sm monitor">
                            <span class="input-group-text rounded-end">%</span>
                            <i id="services_cpu_usage_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i>
                            </span>
                            <input type="text" id="services[cpu_usage][critical]" name="services[cpu_usage][critical]" value="<?= encode_form_val($services['cpu_usage']['critical']) ?>" class="form-control form-control-sm monitor">
                            <span class="input-group-text rounded-end">%</span>
                            <i id="services_cpu_usage_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="col-sm-8 border-block mb-3">
            <div class="row">
                <div class="col-sm-8">
                    <fieldset class="row g-2 mb-1 wz-fieldset">
                        <div class="form-check col-sm-3 mt-0 pt-1">
                            <input type="checkbox" id="disk_usage" class="form-check-input" name="services[disk_usage][monitor]" <?= (array_key_exists('monitor', $services['disk_usage']) ? is_checked($services['disk_usage']['monitor'], 'on') : '') ?>>
                            <label for="disk_usage" class="form-check-label bold"><?= _('Disk Usage') ?> <?= xi6_info_tooltip(_("Monitor Disk Usage.")) ?></label>
                        </div>
                    </fieldset>
                </div>
            </div>
 
            <div class="adddeleterow">
<?php
    $count = count($services["disk_usage"]);
                        
    if ($count > 2) {
        $count--;
    }

    // Changing this to 1 will make it only one row...       
    for ($increment_table = 0; $increment_table < $count; $increment_table++) {
?>
                <div class="row <?= ($count < 1) ? 'pt-2' : '' ?>">
                    <div class="col-sm-12">
                        <fieldset class="row g-2 mb-1 wz-fieldset">
                            <div class="form-check col-sm-2 mt-0">
                                <div class="input-group input-group-sm">
                                    <span class="input-group-text">
                                        <span class="form-label m-0 ms-1 align-middle">
                                            <?= _('Drive') ?>
                                        </span>
                                    </span>
                                    <input type="text" name="services[disk_usage][<?= $increment_table ?>][disk_name]"
                                    value="<?= isset($services['disk_usage'][$increment_table]['disk_name']) ? encode_form_val($services['disk_usage'][$increment_table]['disk_name']) : '' ?>"
                                    class="form-control input-group input-group-sm">
                                </div>
                            </div>
                            <div class="col-sm-3 mt-0">
                                <div class="input-group input-group-sm">
                                    <span class="input-group-text">
                                        <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                                    </span>
                                    <input type="text" id="services[disk_warning][<?= $increment_table ?>]" name="services[disk_usage][<?= $increment_table ?>][warning]" value="<?= isset($services['disk_usage'][$increment_table]['warning']) ? encode_form_val($services['disk_usage'][$increment_table]['warning']) : '' ?>" class="form-control form-control-sm monitor">
                                    <span class="input-group-text rounded-end">%</span>
                                    <i id="services_disk_warning_<?= $increment_table ?>_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                </div>
                            </div>
                            <div class="col-sm-3 mt-0">
                                <div class="input-group input-group-sm">
                                    <span class="input-group-text">
                                        <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i>
                                    </span>
                                    <input type="text" id="services[disk_usage][<?= $increment_table ?>]" name="services[disk_usage][<?= $increment_table ?>][critical]" value="<?= isset($services['disk_usage'][$increment_table]['critical']) ? encode_form_val($services['disk_usage'][$increment_table]['critical']) : '' ?>" class="form-control form-control-sm monitor">
                                    <span class="input-group-text rounded-end">%</span>
                                    <i id="services_disk_critical_<?= $increment_table ?>_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                </div>
                            </div>
                        </fieldset>
                    </div>
                </div>
<?php
    }
?>
            </div> <!-- adddeleterow -->
        </div> <!-- border-block -->

        <div class="col-sm-8 border-block mb-3">
            <div class="row">
                <div>
                    <fieldset class="row g-2 mb-1 wz-fieldset">
                        <div class="form-check col-sm-3 mt-0 pt-1">
                            <input type="checkbox" id="windows_services" class="form-check-input" name="services[windows_services][monitor]" <?= (array_key_exists('monitor', $services['windows_services']) ? is_checked($services['windows_services']['monitor'], 'on') : '') ?>>
                            <label for="windows_services" class="form-check-label bold"><?= _('Windows Services') ?> <?= xi6_info_tooltip(_('Monitor Windows Services.')) ?></label>
                        </div>
                    </fieldset>
                    <div class="col-sm-12">
                        <fieldset class="row g-2">
                            <div class="col-sm-4">
                                <label class="form-label bold mb-0 ms-3 ps-1">
                                    <?= _('Services') ?>
                                </label>
                            </div>
                            <div class="col-sm-4">
                                <label class="form-check-label bold">
                                    <?= _('Display Name') ?>
                                </label>
                            </div>
                            <div class="col-sm-4">
                                <label class="form-check-label bold">
                                    <?= _('Expected State') ?>
                                </label>
                            </div>
                        </fieldset>
                    </div>
                </div>
            </div>
            <div class="adddeleterow">
<?php
    $count = count($services["windows_services"]);

    if ($count > 2) {
        $count--;
    }

    for ($increment_table = 0; $increment_table < $count; $increment_table++) {
?>
                <div class="row <?= ($count < 1) ? 'pt-2' : '' ?>">
                    <div class="col-sm-12">
                        <fieldset class="row g-2 mb-1 wz-fieldset">
                            <div class="form-check col-sm-4 mt-0">
                                <div class="input-group input-group-sm">
                                    <input type="text" name="services[windows_services][<?= $increment_table ?>][service_name]"
                                        value="<?= isset($services['windows_services'][$increment_table]['service_name']) ? encode_form_val($services['windows_services'][$increment_table]['service_name']) : '' ?>"
                                        class="form-control input-group input-group-sm">
                                </div>
                            </div>
                            <div class="col-sm-4 mt-0">
                                <div class="input-group input-group-sm">
                                    <input type="text" name="services[windows_services][<?= $increment_table ?>][display_name]"
                                        value="<?= isset($services['windows_services'][$increment_table]['display_name']) ? encode_form_val($services['windows_services'][$increment_table]['display_name']) : '' ?>"
                                        class="form-control input-group input-group-sm">
                                </div>
                            </div>
                            <div class="col-sm-4 mt-0">
                                <div class="input-group input-group-sm">
                                    <select name="services[windows_services][<?= $increment_table ?>][expected_state]" id="services[windows_services][<?= $increment_table ?>][expected_state]"
                                        class="form-control form-select input-group input-group-sm">
                                        <option value="Running" <?= isset($services["windows_services"][$increment_table]["expected_state"]) ? is_selected($services["windows_services"][$increment_table]["expected_state"], "Running")  : '' ?>>
                                            <?= _('Running') ?>
                                        </option>
                                        <option value="Stopped" <?= isset($services["windows_services"][$increment_table]["expected_state"]) ? is_selected($services["windows_services"][$increment_table]["expected_state"], "Stopped")  : '' ?>>
                                            <?= _('Stopped') ?>
                                        </option>
                                    </select>
                                </div>
                            </div>
                        </fieldset>
                    </div>
                </div>
<?php
    }
?>
            </div> <!-- adddeleterow -->
        </div> <!-- border-block -->

        <div class="col-sm-8 border-block mb-2">
            <div class="row">
                <div class="col-sm-12">
                    <fieldset class="row g-2 mb-1 wz-fieldset">
                        <div class="col-sm-3 mt-0 pt-1">
                            <input type="checkbox" id="windows_processes" class="form-check-input" name="services[windows_processes][monitor]" <?= (array_key_exists('monitor', $services['windows_processes']) ? is_checked($services['windows_processes']['monitor'], 'on') : '') ?>>
                            <label for="windows_processes" class="form-check-label bold"><?= _('Windows Processes') ?><?= xi6_info_tooltip(_('Monitor Windows Processes.')) ?></label>
                        </div>
                    </fieldset>
                </div>
            </div>
 
            <div class="row">
                <div class="col-sm-12">
                    <fieldset class="row g-2">
                        <div class="col-sm-2">
                            <label class="form-label bold mb-0 ms-3 ps-1">
                                <?= _('Process') ?>
                            </label>
                        </div>
                        <div class="col-sm-2">
                            <label class="form-check-label bold">
                                <?= _('Display Name') ?>
                            </label>
                        </div>
                        <div class="col-sm-4">
                            <label class="form-check-label bold">
                                <?= _('Metric') ?>
                            </label>
                        </div>
                        <div class="col-sm-2">
                            <label class="form-check-label bold">
                                <?= _('Warning #') ?>
                            </label>
                        </div>
                        <div class="col-sm-2">
                            <label class="form-check-label bold">
                                <?= _('Critical #') ?>
                            </label>
                        </div>
                    </fieldset>
                </div>
            </div>

            <div class="adddeleterow">
<?php
    $count = count($services["windows_processes"]);
                                
    if ($count > 2) {
        $count--;
    }
                                
    for ($increment_table = 0; $increment_table < $count; $increment_table++) {
?>
                <div class="row <?= ($count < 1) ? 'pt-2' : '' ?>">
                    <div class="col-sm-12">
                        <fieldset class="row g-2 mb-1 wz-fieldset">
                            <div class="form-check col-sm-2 mt-0">
                                <div class="input-group input-group-sm">
                                    <input type="text"
                                        name="services[windows_processes][<?= $increment_table ?>][process_name]"
                                        value="<?= isset($services['windows_processes'][$increment_table]['process_name']) ? encode_form_val($services['windows_processes'][$increment_table]['process_name']) : '' ?>"
                                        class="form-control input-group input-group-sm">
                                </div>
                            </div>
                            <div class="col-sm-2 mt-0">
                                <div class="input-group input-group-sm">
                                    <input type="text"
                                        name="services[windows_processes][<?= $increment_table ?>][display_name]"
                                        value="<?= isset($services['windows_processes'][$increment_table]['display_name']) ? encode_form_val($services['windows_processes'][$increment_table]['display_name']) : '' ?>"
                                        class="form-control input-group input-group-sm">
                                </div>
                            </div>
                            <div class="col-sm-2 mt-0">
                                <div class="input-group input-group-sm">
                                    <select name="services[windows_processes][<?= $increment_table ?>][metric]" id="services[windows_processes][<?= $increment_table ?>][metric]" class="form-control form-select input-group input-group-sm" onchange="toggleOutputTypeSelect(<?= $increment_table ?>);">
                                        <option value="Memory" <?= isset($services["windows_processes"][$increment_table]["metric"]) ? is_selected($services["windows_processes"][$increment_table]["metric"], "Memory") : '' ?>>
                                            <?= _('Memory') ?>
                                        </option>
                                        <option value="CPU" <?= isset($services["windows_processes"][$increment_table]["metric"]) ? is_selected($services["windows_processes"][$increment_table]["metric"], "CPU (%)") : '' ?>>
                                            <?= _('CPU (%)') ?>
                                        </option>
                                        <option value="Count" <?= isset($services["windows_processes"][$increment_table]["metric"]) ? is_selected($services["windows_processes"][$increment_table]["metric"], "Count") : '' ?>>
                                            <?= _('Count') ?>
                                        </option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-sm-2 mt-0">
                                <div class="input-group input-group-sm">
                                    <select name="services[windows_processes][<?= $increment_table ?>][outputType]" id="services[windows_processes][<?= $increment_table ?>][outputType]" class="form-control form-select input-group input-group-sm" style="<?= isset($services["windows_processes"][$increment_table]["metric"]) ? ($services["windows_processes"][$increment_table]["metric"] == "Memory" ? "inline-block" : "none") : '' ?>">
                                        <option value="MB" <?= isset($services["windows_processes"][$increment_table]["outputType"]) ? is_selected($services["windows_processes"][$increment_table]["outputType"], "MB") : '' ?>>
                                            <?= _('MB') ?>
                                        </option>
                                        <option value="GB" <?= isset($services["windows_processes"][$increment_table]["outputType"]) ? is_selected($services["windows_processes"][$increment_table]["outputType"], "GB") : '' ?>>
                                            <?= _('GB') ?>
                                        </option>
                                        <option value="KB" <?= isset($services["windows_processes"][$increment_table]["outputType"]) ? is_selected($services["windows_processes"][$increment_table]["outputType"], "KB") : '' ?>>
                                            <?= _('KB') ?>
                                        </option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-sm-2 mt-0">
                                <div class="input-group input-group-sm">
                                    <div class="input-group input-group-sm">
                                        <span class="input-group-text">
                                            <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                                        </span>
                                        <input type="text" name="services[windows_processes][<?= $increment_table ?>][warning]" value="<?= isset($services['windows_processes'][$increment_table]['warning']) ? encode_form_val($services['windows_processes'][$increment_table]['warning']) : '' ?>" class="form-control input-group input-group-sm rounded-end" id="windows_processes_warning_<?= $increment_table ?>">
                                        <i id="services_windows_processes_warning_<?= $increment_table ?>_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-2 mt-0">
                                <div class="input-group input-group-sm">
                                    <div class="input-group input-group-sm">
                                        <span class="input-group-text">
                                            <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i>
                                        </span>
                                        <input type="text" name="services[windows_processes][<?= $increment_table ?>][critical]" value="<?= isset($services['windows_processes'][$increment_table]['critical']) ? encode_form_val($services['windows_processes'][$increment_table]['critical']) : '' ?>" class="form-control input-group input-group-sm rounded-end" id="windows_processes_critical_<?= $increment_table ?>">
                                        <i id="services_windows_processes_critical_<?= $increment_table ?>_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                    </div>
                                </div>
                            </div>
                        </fieldset>
                    </div>
                </div>
<?php
    }
?>
            </div> <!-- adddeleterow -->
        </div> <!-- border-block -->
    </div> <!-- container -->


    <script type="text/javascript">
  let rowCount = <?= count($services["windows_processes"]) ?>;

  function toggleOutputTypeSelect(rowId) {
    var metricSelect = document.getElementById("services[windows_processes][" + rowId + "][metric]");
    var outputTypeSelect = document.getElementById("services[windows_processes][" + rowId + "][outputType]");

    // if either null, return
    if (!metricSelect || !outputTypeSelect) return;

    if (metricSelect.value === "Memory") {
      outputTypeSelect.style.display = "inline-block";
    } else {
      outputTypeSelect.style.display = "none";
    }
  }

  function initializeOutputTypeSelect() {
    for (var i = 0; i < rowCount; i++) {
      toggleOutputTypeSelect(i);
    }
  }

  window.addEventListener("load", initializeOutputTypeSelect);

  $(document).on("click focus", ".wizard-add-row", function () {
    initializeOutputTypeSelect();
    rowCount++;
  });

  $(document).on("click focus", ".wizard-del-row", function () {
    initializeOutputTypeSelect();
    rowCount--;
  });
</script>

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
