    <!--                                   -->
    <!-- The initial data set from Step 1. -->
    <!--                                   -->
    <input type="hidden" id="hostname" name="hostname" value="<?= (!empty($hostname)) ? encode_form_val($hostname) : "" ?>">
    <input type="hidden" id="operation" name="operation" value="<?= (!empty($operation)) ? encode_form_val($operation) : "" ?>">
    <input type="hidden" id="selectedhostconfig" name="selectedhostconfig" value="<?= (!empty($selectedhostconfig)) ? encode_form_val($selectedhostconfig) : "" ?>">
    <input type="hidden" id="services_serial" name="services_serial" value="<?= (!empty($services)) ? base64_encode(json_encode($services)) : "" ?>" />
    <input type="hidden" id="serviceargs_serial" name="serviceargs_serial" value="<?= (!empty($serviceargs)) ? base64_encode(json_encode($serviceargs)) : "" ?>" />
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />

    <input type="hidden" name="ip_address" value="<?= (!empty($address)) ? encode_form_val($address) : "" ?>">
<?php
    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';
?>
    <div class="container m-0 g-0">

        <h2 class="mb-2"><?= sprintf(_('%s Server'), $short_name) ?></h2>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="ip_address" class="form-label"><?= _('Address') ?> </label>
                <div class="input-group position-relative">
                    <input type="text" name="ip_address" id="ip_address" value="<?= (!empty($address)) ? encode_form_val($address) : "" ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Address") ?>" disabled="on">
                    <div class="invalid-feedback">
                        <?= (isset($labelText)) ? _("Please enter the ".$labelText) : "" ?>
                    </div>
                    <i id="ip_address_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="hostname" class="form-label form-item-required"><?= _('Host Name') ?> <?= xi6_info_tooltip(sprintf(_('The name you would like to have associated with this %s server'), $short_name)) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="hostname" id="hostname" value="<?= (!empty($hostname)) ? encode_form_val($hostname) : "" ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Host Name") ?>" >
                    <div class="invalid-feedback">
                        <?= (isset($labelText)) ? _("Please enter the ".$labelText) : "" ?>
                    </div>
                    <i id="hostname_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <h2 class="mt-4 mb-2"><?= _('LDAP Connection Settings') ?></h2>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="base" class="form-label form-item-required"><?= _('LDAP Base') ?> <?= xi6_info_tooltip($ldap_base_subtext) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="base" id="base" value="<?= (!empty($base)) ? encode_form_val($base) : "" ?>" class="form-control form-control-sm monitor rounded" placeholder="ou=unit,o=org,c=at">
                    <div class="invalid-feedback">
                        <?= (isset($labelText)) ? _("Please enter the ".$labelText) : "" ?>
                    </div>
                    <i id="base_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="bind_dn" class="form-label"><?= _('Bind DN') ?> <?= xi6_info_tooltip($bind_dn_subtext) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="bind_dn" id="bind_dn" value="<?= (!empty($bind_dn)) ? encode_form_val($bind_dn) : "" ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Bind DN") ?>" >
                    <div class="invalid-feedback">
                        <?= (isset($labelText)) ? _("Please enter the ".$labelText) : "" ?>
                    </div>
                    <i id="bind_dn_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div id="changePasswordOption" class="row mb-3 mt-4 visually-hidden">
            <div class="col-sm">
                <input type="checkbox" id="changePassword" class="form-check-input" name="changePassword">
                <label for="changePassword" class="form-check-label bold"><?= _("Change Password") ?> <?= xi6_info_tooltip(_("Use to change the Password, otherwise, the existing Password will be preserved.")) ?></label>
            </div>
        </div>

        <div id="setPassword" class="row mb-2">
            <div class="col-sm-6">
                <label for="password" class="form-label"><?= _('Password') ?> <?= xi6_info_tooltip(sprintf(_('The password used to login to the %s server (if required)'), $short_name)) ?></label>
                <div class="input-group">
                    <input type="password" name="password" id="password" value="<?= (!empty($password)) ? encode_form_val($password) : "" ?>" class="usermacro-detection form-control rounded-start" autocomplete="off" placeholder="<?= _("Enter Password") ?>" >
                    <button type="button" class="btn btn-outline-secondary btn-show-secret rounded-end tt-bind" id="password-secret" title="<?= _("Password") ?>">
                        <span class="material-symbols-outlined md-22 md-pointer">Visibility</span>
                        <i id="password_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </button>
                    <div class="invalid-feedback">
                        <?= (isset($labelText)) ? _("Please enter the ".$labelText) : "" ?>
                    </div>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="version" class="form-label form-item-required"><?= _('Version') ?> <?= xi6_info_tooltip(_('Version of LDAP protocol to use')) ?></label>
                <div class="input-group position-relative">
                    <select name="version" id="version" class="form-select form-control-sm monitor rounded" placeholder="<?= _("Select Version") ?>" >
                        <option value="2" <?= is_selected($version, '2') ?>>2</option>
                        <option value="3" <?= is_selected($version, '3') ?>>3</option>
                    </select>
                    <div class="invalid-feedback">
                        <?= (isset($labelText)) ? _("Please select ".$labelText) : "" ?>
                    </div>
                    <i id="version_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="security" class="form-label form-item-required"><?= _('Security') ?> <?= xi6_info_tooltip(_('Security to use for LDAP connection (optional)')) ?></label>
                <div class="input-group position-relative">
                    <select name="security" id="security" class="form-select form-control-sm monitor rounded" placeholder="<?= _("Select Security") ?>" >
                        <option value="" <?= is_selected($security, '') ?>><?= _('None') ?></option>
                        <option value="ssl" <?= is_selected($security, 'ssl') ?>><?= _('SSL') ?></option>
                        <option value="starttls" <?= is_selected($security, 'starttls') ?>>STARTTLS</option>
                    </select>
                    <div class="invalid-feedback">
                        <?= (isset($labelText)) ? _("Please select ".$labelText) : "" ?>
                    </div>
                    <i id="security_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="port" class="form-label"><?= _('Port Override') ?> <?= xi6_info_tooltip(sprintf(_('The port number the %s server runs on. Defaults to port 389 (non-SSL) or 636 (SSL)'), $short_name)) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="port" id="port" value="<?= (!empty($port)) ? encode_form_val($port) : "" ?>" class="form-control form-control-sm monitor rounded" placeholder="389" >
                    <div class="invalid-feedback">
                        <?= (isset($labelText)) ? _("Please enter the ".$labelText) : "" ?>
                    </div>
                    <i id="port_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

    </div> <!-- container -->

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
