import React from 'react'
import ReactDOM from 'react-dom/client'
import { ResponsiveCalendar } from '@nivo/calendar'

import './index.css'

interface AppProps {
  ajaxPath: string,
  start: string,
  end: string,
  theme: string,
}

class App extends React.Component<AppProps, {}> {
  state: any = {};

  lightTheme: any = {
    text: {
      fontSize: 11,
      fill: '#111',
      outlineWidth: 0,
      outlineColor: 'transparent',
    },
    tooltip: {
      container: {
        color: '#111',
        backgroundColor: '#FFF',
      }
    }
  };
  darkTheme: any = {
    text: {
      fontSize: 11,
      fill: '#EEEEEE',
      outlineWidth: 0,
      outlineColor: 'transparent',
    },
    tooltip: {
      container: {
        color: '#BBB',
        backgroundColor: '#222',
      }
    }
  };
  neptuneTheme: any = {
    text: {
      fontSize: 11,
      fill: 'hsl(214.29, 30.43%, 90.98%)', // --foreground
      outlineWidth: 0,
      outlineColor: 'transparent',
    },
    tooltip: {
      container: {
        color: 'hsl(214.29, 30.43%, 90.98%)', // --foreground
        backgroundColor: `hsl(213.33, 32.14%, 10.98%)`, // --background
        border: `1px solid hsl(213.85, 31.71%, 24.12%)`, // --border
      }
    }
  };
  neptuneLightTheme: any = {
    text: {
      fontSize: 11,
      fill: 'hsl(0, 0%, 10%)', // --foreground
      outlineWidth: 0,
      outlineColor: 'transparent',
    },
    tooltip: {
      container: {
        color: 'hsl(0, 0%, 10%)', // --foreground
        backgroundColor: `hsl(0, 0%, 99%)`, // --background
        border: `1px solid hsl(0, 0%, 84%)`, // --border
      }
    }
  };

  componentDidMount() {

    var xhr = new XMLHttpRequest();
    //var json_obj, status = false;
    let theme = this.lightTheme;
    if (this.props.theme == 'xi5dark') {
      theme = this.darkTheme;
    }
    else if (this.props.theme == 'neptune') {
      theme = this.neptuneTheme;
    }
    else if (this.props.theme == 'neptunelight') {
      theme = this.neptuneLightTheme;
    }
    else if (this.props.theme == 'colorblind') {
      theme = this.lightTheme; // no-op, but we like to be explicit!
    }
    xhr.open("GET", this.props.ajaxPath, true);
    xhr.onload = function () {
      if (xhr.readyState === 4) {
        if (xhr.status === 200) {
          var json_obj = JSON.parse(xhr.responseText);
          this.setState({ json_obj, theme });
        } else {
          console.error(xhr.statusText);
        }
      }
    }.bind(this);
    xhr.onerror = function () {
      console.error(xhr.statusText);
    };
    xhr.send(null);
  }

  render() {
    let data = this.state.json_obj;
    let theme = this.state.theme;
    let bg = "#FFFFFF";
    let colors = [ '#B2FF5F', '#FFE4AF', '#FFC85F', '#FF795F' ];
    if (this.props.theme == 'colorblind') {
      colors = [ '#56B4E9', '#FFE4AF', '#FFC85F', '#CC79A7']
    } else if (this.props.theme == 'neptune') {
      bg = "#0E141B";
    } else if (this.props.theme == 'neptunelight') {
      bg = "#F6F6F6";
    } else if (this.props.theme == 'xi5dark') {
      bg = "#111";
    }

    let foundStateChange = false;
    for (let i = 0; data && i < data.length; i += 1) {
      if (data[i].hasOwnProperty('value') && data[i].value > 0) {
        foundStateChange = true;
        break;
      }
    }

    if (!foundStateChange) {
      colors = [ colors[0] ];
    }

    // data = [
    //   {
    //     "value": 114,
    //     "day": "2015-12-08"
    //   }
    // ];
    return (
      <div style={{height: "400px", width: "1000px", backgroundColor: bg}}>
        {data ?
          <ResponsiveCalendar
            data={data}
            from={this.props.start}
            to={this.props.end}
            theme={theme}
            emptyColor="#AAA"
            colors={colors}
            margin={{ top: 0, right: 20, bottom: 0, left: 20 }}
            yearSpacing={40}
            monthSpacing={20}
            monthBorderWidth={0}
            monthBorderColor="#ffffff"
            daySpacing={2}
            dayBorderWidth={0}
            dayBorderColor="#ffffff"
            legends={[
              {
                anchor: 'bottom-right',
                direction: 'row',
                translateY: 36,
                itemCount: 4,
                itemWidth: 42,
                itemHeight: 36,
                itemsSpacing: 14,
                itemDirection: 'right-to-left'
              }
            ]}
          />
          : <h1>Loading...</h1>}
      </div>
    );
  }
}


const params = new URLSearchParams(window.location.href);
// const container = params.get('container');
const nsp = params.get('nsp');
const path = window.location.pathname;
let ajaxPath = path.slice(0, path.lastIndexOf('/') + 1) + "ajax.php?nsp=" + nsp;
const end = params.get('end') ?? '1979-01-01';
const endArr = end.split('-');
const endYear = parseInt(endArr[0]);
const endMonth = parseInt(endArr[1]) - 1; // Javascript is stupid and expects months to be zero-indexed
const endDate = parseInt(endArr[2]);

const theme = params.get('theme') ?? 'default';

//debugger;
const lookback_raw = params.get('lookback');
let lookback = parseInt(lookback_raw ?? '365');
if (isNaN(lookback)) {
  lookback = 365;
}

let startDate = new Date();
startDate.setFullYear(endYear, endMonth, endDate)
startDate.setDate(startDate.getDate() - lookback);
const start = startDate.toISOString().split('T')[0];

ajaxPath += "&end=" + end + "&lookback=" + lookback;

ReactDOM.createRoot(document.getElementById('root')!).render(
  <App ajaxPath={ajaxPath} end={end} start={start} theme={theme} />
)
