    <!--                                   -->
    <!-- The initial data set from Step 1. -->
    <!--                                   -->
    <input type="hidden" id="hostname" name="hostname" value="<?= encode_form_val($hostname) ?>">
    <input type="hidden" id="operation" name="operation" value="<?= encode_form_val($operation) ?>">
    <input type="hidden" id="selectedhostconfig" name="selectedhostconfig" value="<?= encode_form_val($selectedhostconfig) ?>">
    <input type="hidden" id="services_serial" name="services_serial" value="<?= (!empty($services)) ? base64_encode(json_encode($services)) : "" ?>" />
    <input type="hidden" id="serviceargs_serial" name="serviceargs_serial" value="<?= (!empty($serviceargs)) ? base64_encode(json_encode($serviceargs)) : "" ?>" />
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />

<?php
    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';
?>
    <div class="container m-0 g-0">
    <input type="hidden" name="ip_address" value="<?= encode_form_val($address) ?>">
    <input type="hidden" name="port" value="<?= encode_form_val($port) ?>">
    <input type="hidden" name="username" value="<?= encode_form_val($username) ?>">
    <input type="hidden" name="password" value="<?= encode_form_val($password) ?>">
    <input type="hidden" name="database" value="<?= encode_form_val($database) ?>">

    <h5 class="ul"><?= _('Postgres Server') ?></h5>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="ip_address" class="form-label"><?= _('Address') ?> </label>
                <div class="input-group position-relative">
                    <input type="text" name="ip_address" id="ip_address" value="<?= encode_form_val($address) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Address") ?>" disabled="on">
                    <div class="invalid-feedback">
                        <?= _("Please enter the IP Address") ?>
                    </div>
                    <i id="ip_address_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="hostname" class="form-label"><?= _('Host Name:') ?> <?= xi6_info_tooltip(_('The name you would like to have associated with this Postgres server')) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="hostname" id="hostname" value="<?= encode_form_val($hostname) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Host Name:") ?>" >
                    <div class="invalid-feedback">
                        <?= _("Please enter the Host Name") ?>
                    </div>
                    <i id="hostname_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="port" class="form-label"><?= _('Port') ?> </label>
                <div class="input-group position-relative">
                    <input type="text" name="port" id="port" value="<?= encode_form_val($port) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Port") ?>" disabled="on">
                    <div class="invalid-feedback">
                        <?= _("Please enter the Port") ?>
                    </div>
                    <i id="port_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="username" class="form-label"><?= _('Username') ?> </label>
                <div class="input-group position-relative">
                    <input type="text" name="username" id="username" value="<?= encode_form_val($username) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Username") ?>" disabled="on">
                    <div class="invalid-feedback">
                        <?= _("Please enter the Username") ?>
                    </div>
                    <i id="username_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div id="changePasswordOption" class="row mb-3 mt-4 visually-hidden">
            <div class="col-sm">
                <input type="checkbox" id="changePassword" class="form-check-input" name="changePassword">
                <label for="changePassword" class="form-check-label bold"><?= _("Change Password") ?> <?= xi6_info_tooltip(_("Use to change the Password, otherwise, the existing Password will be preserved.")) ?></label>
            </div>
        </div>

        <div id="setPassword" class="row mb-2">
            <div class="col-sm-6">
                <label for="password" class="form-label"><?= _('Password') ?> </label>
                <div class="input-group input-group-sm">
                    <input type="password" name="password" id="password" value="<?= encode_form_val($password) ?>" class="usermacro-detection form-control form-control-sm rounded-start" autocomplete="off" placeholder="<?= _("Enter Password") ?>" >
                    <button type="button" class="btn btn-outline-secondary btn-show-secret rounded-end" id="password-secret" title="<?= _("Show Password") ?>">
                        <span class="material-symbols-outlined md-22 md-pointer">Visibility</span>
                        <i id="password_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </button>
                    <div class="invalid-feedback">
                        <?= _("Please enter the Password") ?>
                    </div>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="database" class="form-label"><?= _('Database') ?> </label>
                <div class="input-group position-relative">
                    <input type="text" name="database" id="database" value="<?= encode_form_val($database) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Database") ?>" disabled="on">
                    <div class="invalid-feedback">
                        <?= _("Please enter the Database") ?>
                    </div>
                    <i id="database_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <!--                         -->
        <!-- The metrics to monitor. -->
        <!--                         -->
        <script type="text/javascript">
$(document).ready(function() {
    manageMultiSelectForTable("#metrics");
    $(".multi-select-remove").prop('disabled', false);

    $("#metrics").on("change", function($this) {
        manageMultiSelectForTable("#metrics")
    });

    $(".multiselect").on("mouseenter", function($this) {
        $(this).trigger("focus");
    });

    $(".multi-select-remove").on("click", function($this) {
        val = $(this).attr("value");
        elem = "input[name=\'services[" + val + "]\']";
        optn = $('#metrics option[value="'+ val +'"]');
        $(elem).prop( "checked", false );
        $(elem).closest(".row").hide();
        optn.prop('selected', false);
    });

    function manageMultiSelectForTable(selector) {
        selVal =  $(selector).val();
        $(".service-item").prop( "checked", false );
        $(".service-item").closest(".row").hide();

        $.each(selVal, function(i, val) {
            elem = "input[name=\'services[" + val + "]\']";
            $(elem).prop( "checked", true );
            $(elem).closest(".row").show();
        });
    }


});
</script>

    <h5 class="ul"><?= _('Postgres Database Metrics') ?></h5>
    <p><?= _('Specify the metrics you would like to monitor for the Postgres database') ?></p>

    <div class="row">
        <div class="col-sm-3">
            <div class="multi-select-label"><?= _('Make your Selections')?><?= xi6_info_tooltip(_("Click with shift or CRTL/CMD key to adjust your selection.")) ?></div>
                    <?= $select_html ?>
        </div>
        <div class="col-sm-9">
            <div class="row">
                <div class="col-sm-12">
                    <div class="multi-select-label"><?= _('Selected Metrics')?></div>
                </div>
            </div>

            <div id="services-list" class="select-table-wrap">
            <div class="row">
                <div class="col-sm-12">
                    <fieldset class="row g-2 mb-1 wz-fieldset">
                        <div class="form-check col-sm-4 mt-0 pt-1">
                            <input type="checkbox" id="cs" class="form-check-input service-item" name="services[connection]"  <?= is_checked(grab_array_var($services, "connection"), "on") ?> >
                            <label for="cs" class="form-check-label bold"><?= _('Connection Status') ?> <?= xi6_info_tooltip(_("Monitor the ability to connect to the database")) ?></label>
                        </div>
                        <div class="col-sm-3 mt-0">
                            <div class="input-group input-group-sm">
                                <input type="text" value="n/a" class="form-control form-control-sm monitor" disabled>

                                <i id="serviceargs_database_size_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                        <div class="col-sm-3 mt-0">
                            <div class="input-group input-group-sm">
                                <input type="text" value="n/a" class="form-control form-control-sm monitor" disabled>

                                <i id="serviceargs_database_size_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                        <div class="col-sm-2 mt-0">
                            <div class="input-group input-group-sm">
                                <button type="button" class="btn-close multi-select-remove" value="connection" disabled aria-label="Remove"></button>
                            </div>
                        </div>
                    </fieldset>
                </div>
            </div>

            <div class="row">
                <div class="col-sm-12">
                    <fieldset class="row g-2 mb-1 wz-fieldset">
                        <div class="form-check col-sm-4 mt-0 pt-1">
                            <input type="checkbox" id="ds" class="form-check-input service-item" name="services[database_size]"  <?= is_checked(grab_array_var($services, "database_size"), "on") ?> >
                            <label for="ds" class="form-check-label bold"><?= _('Database Size') ?> <?= xi6_info_tooltip(_("Monitor the size of the database")) ?></label>
                        </div>
                        <div class="col-sm-3 mt-0">
                            <div class="input-group input-group-sm">
                                <span class="input-group-text">
                                    <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                                </span>
                                <input type="text" id="serviceargs[database_size_warning]" name="serviceargs[database_size_warning]" value="<?= encode_form_val($serviceargs['database_size_warning']) ?>" class="form-control form-control-sm monitor">

                                <i id="serviceargs_database_size_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                        <div class="col-sm-3 mt-0">
                            <div class="input-group input-group-sm">
                                <span class="input-group-text">
                                    <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                                </span>
                                <input type="text" id="serviceargs[database_size_critical]" name="serviceargs[database_size_critical]" value="<?= encode_form_val($serviceargs['database_size_critical']) ?>" class="form-control form-control-sm monitor">

                                <i id="serviceargs_database_size_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                        <div class="col-sm-2 mt-0">
                            <div class="input-group input-group-sm">
                                <button type="button" class="btn-close multi-select-remove" value="database_size" disabled aria-label="Remove"></button>
                            </div>
                        </div>
                    </fieldset>
                </div>
            </div>

            <div class="row">
                <div class="col-sm-12">
                    <fieldset class="row g-2 mb-1 wz-fieldset">
                        <div class="form-check col-sm-4 mt-0 pt-1">
                            <input type="checkbox" id="ts" class="form-check-input service-item" name="services[table_sizes]"  <?= is_checked(grab_array_var($services, "table_sizes"), "on") ?> >
                            <label for="ts" class="form-check-label bold"><?= _('Table Sizes') ?> <?= xi6_info_tooltip(_("Monitor the size of the tables in the database")) ?></label>
                        </div>
                        <div class="col-sm-3 mt-0">
                            <div class="input-group input-group-sm">
                                <span class="input-group-text">
                                    <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                                </span>
                                <input type="text" id="serviceargs[table_sizes_warning]" name="serviceargs[table_sizes_warning]" value="<?= encode_form_val($serviceargs['table_sizes_warning']) ?>" class="form-control form-control-sm monitor">

                                <i id="serviceargs_table_sizes_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                        <div class="col-sm-3 mt-0">
                            <div class="input-group input-group-sm">
                                <span class="input-group-text">
                                    <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                                </span>
                                <input type="text" id="serviceargs[table_sizes_critical]" name="serviceargs[table_sizes_critical]" value="<?= encode_form_val($serviceargs['table_sizes_critical']) ?>" class="form-control form-control-sm monitor">

                                <i id="serviceargs_table_sizes_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                        <div class="col-sm-2 mt-0">
                            <div class="input-group input-group-sm">
                                <button type="button" class="btn-close multi-select-remove" value="table_sizes" disabled aria-label="Remove"></button>
                            </div>
                        </div>
                    </fieldset>
                </div>
            </div>

            <div class="row">
                <div class="col-sm-12">
                    <fieldset class="row g-2 mb-1 wz-fieldset">
                        <div class="form-check col-sm-4 mt-0 pt-1">
                            <input type="checkbox" id="rs" class="form-check-input service-item" name="services[relation_sizes]"  <?= is_checked(grab_array_var($services, "relation_sizes"), "on") ?> >
                            <label for="rs" class="form-check-label bold"><?= _('Relation Sizes') ?> <?= xi6_info_tooltip(_("Monitor the size of the relations in the database")) ?></label>
                        </div>
                        <div class="col-sm-3 mt-0">
                            <div class="input-group input-group-sm">
                                <span class="input-group-text">
                                    <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                                </span>
                                <input type="text" id="serviceargs[relation_sizes_warning]" name="serviceargs[relation_sizes_warning]" value="<?= encode_form_val($serviceargs['relation_sizes_warning']) ?>" class="form-control form-control-sm monitor">

                                <i id="serviceargs_relation_sizes_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                        <div class="col-sm-3 mt-0">
                            <div class="input-group input-group-sm">
                                <span class="input-group-text">
                                    <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                                </span>
                                <input type="text" id="serviceargs[relation_sizes_critical]" name="serviceargs[relation_sizes_critical]" value="<?= encode_form_val($serviceargs['relation_sizes_critical']) ?>" class="form-control form-control-sm monitor">

                                <i id="serviceargs_relation_sizes_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                        <div class="col-sm-2 mt-0">
                            <div class="input-group input-group-sm">
                                <button type="button" class="btn-close multi-select-remove" value="relation_sizes" disabled aria-label="Remove"></button>
                            </div>
                        </div>
                    </fieldset>
                </div>
            </div>

            <div class="row">
                <div class="col-sm-12">
                    <fieldset class="row g-2 mb-1 wz-fieldset">
                        <div class="form-check col-sm-4 mt-0 pt-1">
                            <input type="checkbox" id="s" class="form-check-input service-item" name="services[sequences]"  <?= is_checked(grab_array_var($services, "sequences"), "on") ?> >
                            <label for="s" class="form-check-label bold"><?= _('Sequences') ?> <?= xi6_info_tooltip(_("Monitor the percent of remaining sequences in the database")) ?></label>
                        </div>
                        <div class="col-sm-3 mt-0">
                            <div class="input-group input-group-sm">
                                <span class="input-group-text">
                                    <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                                </span>
                                <input type="text" id="serviceargs[sequences_warning]" name="serviceargs[sequences_warning]" value="<?= encode_form_val($serviceargs['sequences_warning']) ?>" class="form-control form-control-sm monitor">

                                <i id="serviceargs_sequences_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                        <div class="col-sm-3 mt-0">
                            <div class="input-group input-group-sm">
                                <span class="input-group-text">
                                    <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                                </span>
                                <input type="text" id="serviceargs[sequences_critical]" name="serviceargs[sequences_critical]" value="<?= encode_form_val($serviceargs['sequences_critical']) ?>" class="form-control form-control-sm monitor">

                                <i id="serviceargs_sequences_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                        <div class="col-sm-2 mt-0">
                            <div class="input-group input-group-sm">
                                <button type="button" class="btn-close multi-select-remove" value="sequences" disabled aria-label="Remove"></button>
                            </div>
                        </div>
                    </fieldset>
                    </div>
                </div>
            </div>
        </div>
        </div>

    </div> <!-- container -->

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>

