    <input type="hidden" id="services_serial" name="services_serial" value="<?= (!empty($services)) ? base64_encode(json_encode($services)) : "" ?>" />
    <input type="hidden" id="serviceargs_serial" name="serviceargs_serial" value="<?= (!empty($serviceargs)) ? base64_encode(json_encode($serviceargs)) : "" ?>" />
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />

    <div class="container m-0 g-0">
<?php
# New/Copy/Update
#    include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';

    $versionString = shell_exec('python3 -c "import sys; print(sys.version_info[0])" 2>/dev/null');

    if ($versionString === null) {
?>
        <ul class="actionMessage">
            <li><b><?php echo _("Python 3 is required to run this wizard."); ?></b></li>
        </ul>
<?php
    }
?>
        <!--                         -->
        <!-- The configuration form. -->
        <!--                         -->
        <div id="configForm">
            <h5 class="ul"><?= _('Windows Server Information') ?></h5>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label class="form-label form-item-required"><?= _("Address") ?> <?= xi6_info_tooltip(_("The IP address of the Windows Machine to monitor")) ?></label>
                    <div class="input-group position-relative">
                        <input type="text" name="ip_address" id="ip_address" value="<?= encode_form_val($address) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter IP Address/Hostname") ?>" required>
                        <div class="invalid-feedback">
                            Please enter ip address or hostname.
                        </div>
                        <i id="ip_address_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label class="form-label form-item-required"><?= _("Username") ?> <?= xi6_info_tooltip(_("The username to use when connecting to the server.")) ?></label>
                    <div class="input-group position-relative">
                        <input type="text" name="winrm_username" id="winrm_username" value="<?= encode_form_val($winrm_username) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Username") ?>" required>
                        <div class="invalid-feedback">
                            Please enter the username.
                        </div>
                        <i id="winrm_username_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label class="form-label form-item-required"><?= _("Password") ?> <?= xi6_info_tooltip(_("The password to use when connecting to the server.")) ?></label>
                    <div class="input-group position-relative">                        
                        <input type="password" name="winrm_password" id="winrm_password" value="<?= encode_form_val($winrm_password) ?>" class="usermacro-detection form-control rounded-start usermacro-detection" autocomplete="off" placeholder="<?= _("Enter Password") ?>"  required>
                        <button type="button" class="btn btn-outline-secondary btn-show-secret rounded-end tt-bind" id="password-secret" title="<?= _("Show") ?>">
                            <span class="material-symbols-outlined md-22 md-pointer">Visibility</span>
                            <i id="password_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </button>
                        <div class="invalid-feedback">
                            Please enter the password.
                        </div>
                        <i id=""winrm_password_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <div class="row mb-3 mt-4">
                <div class="col-sm">
                    <input type="checkbox" id="use_https" class="form-check-input" name="use_https" <?= is_checked($use_https, 'on') ?>>
                    <label for="use_https" class="form-check-label bold">
                        <?= _('Enable HTTPS') ?><?= xi6_info_tooltip(_('Specefies using the HTTPS protocol. (Recommended)')) ?>
                    </label>
                </div>
            </div>
        </div> <!-- config -->
    </div> <!-- container -->

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
