#!/usr/bin/php -q
<?php
//
// Deletes reports created for downloads
// Chrome needs the file to exist when the download button is clicked, so we can't just unlink after displaying
//
// Copyright (c) 2008-2025 Nagios Enterprises, LLC. All rights reserved.
//

define("SUBSYSTEM", 1);

require_once(dirname(__FILE__).'/../html/config.inc.php');
require_once(dirname(__FILE__).'/../html/includes/utils.inc.php');

$older_than = 60;

do_report_cleanup($older_than);

function do_report_cleanup($older_than)
{
    $cmd = "find " . get_tmp_dir() . " -maxdepth 1 \( -iname '*.pdf' \) -type f -mmin +" . $older_than . " -exec rm -f {} \\; -print | wc -l";
    exec($cmd, $out);
    
    $output = implode("\n", $out);
    echo "\n";
    print_timestamp();    
    if (is_numeric($output) || $output === 0) {
        echo "REMOVED " . $output . " FILES";
    } else {
        echo "ERROR=";
        echo $output;
        echo "\nCMD=" . $cmd;
    }
    return;
}