<?php

namespace api\v2;
use api\v2\Base;
use Exception;

use function api\v2\import_common;
import_common();

/**
 * Manages dashboards including retrieval, creation, deletion, and updates.
 */
class dashboards_v2 extends Base {

    /**
     * Auth function for get request method on api/v2/account/dashboards 
     * All necessary auth is done in check_authentication so this just returns true.
     */
    public function authorized_for_get() {
        return true;
    }

    /**
     * Retrieves a dashboard by ID, or all dashboards if no ID is specified.
     * @return array The dashboard data or an error message if not found.
     */
    public function get() {
        global $db_tables;

        $id = grab_request_var('id', '');
        $response = [];
        $global_dashboard_access = get_user_meta(0, 'global_dashboard_access', 1);
        $user_id = $_SESSION['user_id'];
        if ($global_dashboard_access == 0 && !is_admin()) {
            if($id == '') {
                $sql = "SELECT * FROM " . $db_tables[DB_NAGIOSXI]["dashboards"] . " WHERE user_id= '" . $user_id . "' AND is_global= 0 ORDER BY id ASC";
                $dashboards = exec_sql_query(DB_NAGIOSXI, $sql);
                $rows = $dashboards->GetRows();
            } else {
                $sql = "SELECT * FROM " . $db_tables[DB_NAGIOSXI]["dashboards"] . " WHERE dashboard_id='" . $id . "' AND user_id= '" . $user_id . "' AND is_global= 0 ORDER BY id ASC";
                $dashboards = exec_sql_query(DB_NAGIOSXI, $sql);
                $rows = $dashboards->GetRows();
            }
        } else {
            if($id == '') {
                $sql = "SELECT * FROM " . $db_tables[DB_NAGIOSXI]["dashboards"] . " WHERE user_id= '" . $user_id . "' OR is_global= 1 ORDER BY id ASC";
                $dashboards = exec_sql_query(DB_NAGIOSXI, $sql);
                $rows = $dashboards->GetRows();
            } else {
                $sql = "SELECT * FROM " . $db_tables[DB_NAGIOSXI]["dashboards"] . " WHERE dashboard_id='" . $id . "' AND (user_id= '" . $user_id . "' OR is_global= 1) ORDER BY id ASC";
                $dashboards = exec_sql_query(DB_NAGIOSXI, $sql);
                $rows = $dashboards->GetRows();
            }
        }
        foreach ($rows as &$row) {
            if (isset($row['is_global'])) {
                $row['is_global'] = (bool)$row['is_global'];
            }
        }
        $response = $rows;
        return $response;
    }

    /**
     * Auth function for post request method on api/v2/account/dashboards 
     * All necessary auth is done in check_authentication so this just returns true.
     */
    public function authorized_for_post() {
        return true;
    }

    /**
     * Adds a new dashboard with provided parameters.
     * @return array Confirmation message of dashboard creation.
     */
    public function post() {
        global $db_tables;
        check_nagios_session_protector();
        $name = grab_request_var("name", "");
        if (empty($name)) {
            throw new Exception(_("No name specified!"), 500);
        }
        $global_dashboard_access = get_user_meta(0, 'global_dashboard_access', 1);
        $is_global = grab_request_var("is_global", 0);
        $dashboard_id = random_string(6);
        $user_id = $_SESSION['user_id'];

        $sql = "INSERT INTO " . $db_tables[DB_NAGIOSXI]["dashboards"] . " (dashboard_id, name, user_id, is_global) VALUES ('" . escape_sql_param($dashboard_id, DB_NAGIOSXI) . "', '" . escape_sql_param($name, DB_NAGIOSXI) . "', '" . escape_sql_param($user_id, DB_NAGIOSXI) . "', " . escape_sql_param($is_global, DB_NAGIOSXI) . ")";
        $response = exec_sql_query(DB_NAGIOSXI, $sql);

        return [
            "message" => _("Successfully added dashboard"),
            "dashboard_id" => $dashboard_id,
        ];
    }

    /**
     * Auth function for post request method on api/v2/account/dashboards 
     * All necessary auth is done in check_authentication so this just returns true.
     */
    public function authorized_for_put() {
        return true;
    }

    /**
     * Adds a new dashboard with provided parameters.
     * @return array Confirmation message of dashboard creation.
     */
    public function put() {
        global $db_tables;
        check_nagios_session_protector();

        $dashboard_id = grab_request_var("dashboard_id", "");
        $dashlets = grab_request_var("dashlets", []);
        $name = grab_request_var("name", '');
        $user_id = $_SESSION['user_id'];

        // Handle name update
        if (!empty($name) && !empty($dashboard_id)) {
            $sql = "UPDATE " . $db_tables[DB_NAGIOSXI]["dashboards"] . "
                    SET name = '" . escape_sql_param($name, DB_NAGIOSXI) . "'
                    WHERE dashboard_id = '" . escape_sql_param($dashboard_id, DB_NAGIOSXI) . "'
                    AND user_id = '" . escape_sql_param($user_id, DB_NAGIOSXI) . "'";
            $res = exec_sql_query(DB_NAGIOSXI, $sql);
            if (!$res) {
                throw new \Exception(_("Failed to rename dashboard."), 500);
            }
        }

        // Handle dashlet layout update (existing logic)
        if (!empty($dashlets)) {
            foreach ($dashlets as $dashlet) {
                $dashlet_id = $dashlet['dashlet_id'];
                $height = $dashlet['height'];
                $width = $dashlet['width'];
                $x = $dashlet['x'];
                $y = $dashlet['y'];
                $sql = "UPDATE " . $db_tables[DB_NAGIOSXI]["dashlets"] . " SET
                        height = " . escape_sql_param($height, DB_NAGIOSXI) . ",
                        width = " . escape_sql_param($width, DB_NAGIOSXI) . ",
                        x = " . escape_sql_param($x, DB_NAGIOSXI) . ",
                        y = " . escape_sql_param($y, DB_NAGIOSXI) . "
                        WHERE dashlet_id = '" . escape_sql_param($dashlet_id, DB_NAGIOSXI) . "'";
                $response = exec_sql_query(DB_NAGIOSXI, $sql);
            }
        }

        return ["message" => _("Successfully edited dashboard")];
    }

    /**
     * Auth function for delete request method on api/v2/account/dashboards 
     * All necessary auth is done in check_authentication so this just returns true.
     */
    public function authorized_for_delete() {
        return true;
    }

    /**
     * Deletes a specified dashboard by its ID.
     * @return array Confirmation or error message based on the operation result.
     */
    public function delete() {
        check_nagios_session_protector();
        global $db_tables;

        $user_id = $_SESSION['user_id'];
        $dashboard_id = grab_request_var("id", -1);

        $sql = "DELETE FROM " . $db_tables[DB_NAGIOSXI]["dashboards"] . " WHERE dashboard_id='" . $dashboard_id . "'";
        $response = exec_sql_query(DB_NAGIOSXI, $sql);
        if (!$response) {
            throw new Exception(_("Could not delete dashboard."), 500);
        }

        // Add a default dashboard if that was the last one
        // $dashboards = get_dashboards(0);
        // if (count($dashboards) == 0) {
        //     $opts = array();
        //     add_dashboard(0, "Default Dashboard", $opts);
        // }
        return ["message" => _("Successfully deleted dashboard")];
    }
}