<?php

namespace api\v2\objects;
use api\v2\Base;

use function api\v2\import_common;
import_common();

/**
 * API wrapper for get_rrd_data, look into the function to learn more about the structure of the output
 */
class rrdexport extends Base {
    public function authorized_for_get() {
        return true;
    }

    public function get() {
        // return localhost data if no host is specified
        $host = grab_request_var("host_name", "localhost");

        $service = grab_request_var("service_description", "_HOST_");
        $start = grab_request_var("start", "");
        $end = grab_request_var("end", "");
        $step = grab_request_var("step", "");
        $columns_to_display = grab_request_var("columns", array());
        $maxrows = grab_request_var("maxrows", "");

        // Call the function to get the RRD data
        $response = get_rrd_data($host, $service, "json", $start, $end, $step, $columns_to_display, $maxrows);

        if (empty($response)) {
            return array("recordcount" => 0);
        }

        return json_decode($response);
    }
}