<?php

namespace api\v2\system;
use api\v2\Base;

use function api\v2\import_common;
import_common();

/**
 * Gets information and status regarding product updates, like the update URL and whether an update is available
 */
class update extends Base {
    public function authorized_for_get() {
        return true;
    }

    public function get() {
        $last_update_check_succeeded = get_option("last_update_check_succeeded");
        $update_available = get_option("update_available");
        $hide_updates = false;
        if (custom_branding()) {
            global $bcfg;
            if ($bcfg['hide_updates']) {
                $hide_updates = true;
            }
        }
        $response = [
            "update_url" => get_update_check_url(),
            "lastUpdateCheckSucceeded" => $last_update_check_succeeded,
            "updateAvailable" => $update_available,
            "hideUpdates" => $hide_updates,
        ];
        return $response;
    }
}