<?php
//
// Copyright (c) 2008-2020 Nagios Enterprises, LLC. All rights reserved.
//

require_once(dirname(__FILE__) . '/../../common.inc.php');


// Initialization stuff
pre_init();
init_session();

// Grab GET or POST variables and check pre-reqs
grab_request_vars();
check_prereqs();
check_authentication();


route_request();


function route_request()
{
    $pageopt = grab_request_var("pageopt", "info");
    switch ($pageopt) {
        default:
            route_to_neptune();
            show_page();
            break;
    }
}


function show_page()
{
    do_page_start(array("page_title" => _('SNMP Walk Jobs')), true);
?>
    <h1><?php echo _('SNMP Walk Jobs'); ?></h1>
   
<?php
    do_page_end(true);
    exit();
}