/**
 * Highmaps JS v11.2.0 (2023-10-30)
 *
 * Tilemap module
 *
 * (c) 2010-2021 Highsoft AS
 *
 * License: www.highcharts.com/license
 */!function(e){"object"==typeof module&&module.exports?(e.default=e,module.exports=e):"function"==typeof define&&define.amd?define("highcharts/modules/tilemap",["highcharts","highcharts/modules/map"],function(t){return e(t),e.Highcharts=t,e}):e("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(e){"use strict";var t=e?e._modules:{};function i(e,t,i,a){e.hasOwnProperty(t)||(e[t]=a.apply(null,i),"function"==typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:t,module:e[t]}})))}i(t,"Series/Tilemap/TilemapPoint.js",[t["Core/Axis/Color/ColorAxisComposition.js"],t["Core/Series/SeriesRegistry.js"],t["Core/Utilities.js"]],function(e,t,i){let{series:{prototype:{pointClass:a}},seriesTypes:{heatmap:{prototype:{pointClass:s}}}}=t,{extend:n}=i;class r extends s{constructor(){super(...arguments),this.options=void 0,this.radius=void 0,this.series=void 0,this.tileEdges=void 0}haloPath(){return this.series.tileShape.haloPath.apply(this,arguments)}}return n(r.prototype,{setState:a.prototype.setState,setVisible:e.pointSetVisible}),r}),i(t,"Series/Tilemap/TilemapSeriesDefaults.js",[],function(){return{marker:null,states:{hover:{halo:{enabled:!0,size:2,opacity:.5,attributes:{zIndex:3}}}},pointPadding:2,tileShape:"hexagon"}}),i(t,"Series/Tilemap/TilemapShapes.js",[t["Core/Globals.js"],t["Core/Series/SeriesRegistry.js"],t["Core/Utilities.js"]],function(e,t,i){let{noop:a}=e,{heatmap:s,scatter:n}=t.seriesTypes,{clamp:r,pick:o}=i;function l(e,t,i){let a=e.options;return{xPad:-((a.colsize||1)/t),yPad:-((a.rowsize||1)/i)}}let p={hexagon:{alignDataLabel:n.prototype.alignDataLabel,getSeriesPadding:function(e){return l(e,3,2)},haloPath:function(e){if(!e)return[];let t=this.tileEdges;return[["M",t.x2-e,t.y1+e],["L",t.x3+e,t.y1+e],["L",t.x4+1.5*e,t.y2],["L",t.x3+e,t.y3-e],["L",t.x2-e,t.y3-e],["L",t.x1-1.5*e,t.y2],["Z"]]},translate:function(){let e;let t=this.options,i=this.xAxis,a=this.yAxis,s=t.pointPadding||0,n=(t.colsize||1)/3,l=(t.rowsize||1)/2;for(let t of(this.generatePoints(),this.points)){let p=r(Math.floor(i.len-i.translate(t.x-2*n,0,1,0,1)),-i.len,2*i.len),h=r(Math.floor(i.len-i.translate(t.x-n,0,1,0,1)),-i.len,2*i.len),d=r(Math.floor(i.len-i.translate(t.x+n,0,1,0,1)),-i.len,2*i.len),u=r(Math.floor(i.len-i.translate(t.x+2*n,0,1,0,1)),-i.len,2*i.len),g=r(Math.floor(a.translate(t.y-l,0,1,0,1)),-a.len,2*a.len),c=r(Math.floor(a.translate(t.y,0,1,0,1)),-a.len,2*a.len),y=r(Math.floor(a.translate(t.y+l,0,1,0,1)),-a.len,2*a.len),x=o(t.pointPadding,s),f=x*Math.abs(h-p)/Math.abs(y-c),m=i.reversed?-f:f,P=i.reversed?-x:x,S=a.reversed?-x:x;t.x%2&&(e=e||Math.round(Math.abs(y-g)/2)*(a.reversed?-1:1),g+=e,c+=e,y+=e),t.plotX=t.clientX=(h+d)/2,t.plotY=c,p+=m+P,h+=P,d-=P,u-=m+P,g-=S,y+=S,t.tileEdges={x1:p,x2:h,x3:d,x4:u,y1:g,y2:c,y3:y},t.shapeType="path",t.shapeArgs={d:[["M",h,g],["L",d,g],["L",u,c],["L",d,y],["L",h,y],["L",p,c],["Z"]]}}this.translateColors()}},diamond:{alignDataLabel:n.prototype.alignDataLabel,getSeriesPadding:function(e){return l(e,2,2)},haloPath:function(e){if(!e)return[];let t=this.tileEdges;return[["M",t.x2,t.y1+e],["L",t.x3+e,t.y2],["L",t.x2,t.y3-e],["L",t.x1-e,t.y2],["Z"]]},translate:function(){let e;let t=this.options,i=this.xAxis,a=this.yAxis,s=t.pointPadding||0,n=t.colsize||1,l=(t.rowsize||1)/2;for(let t of(this.generatePoints(),this.points)){let p=r(Math.round(i.len-i.translate(t.x-n,0,1,0,0)),-i.len,2*i.len),h=r(Math.round(i.len-i.translate(t.x+n,0,1,0,0)),-i.len,2*i.len),d=r(Math.round(a.translate(t.y-l,0,1,0,0)),-a.len,2*a.len),u=r(Math.round(a.translate(t.y,0,1,0,0)),-a.len,2*a.len),g=r(Math.round(a.translate(t.y+l,0,1,0,0)),-a.len,2*a.len),c=r(Math.round(i.len-i.translate(t.x,0,1,0,0)),-i.len,2*i.len),y=o(t.pointPadding,s),x=y*Math.abs(c-p)/Math.abs(g-u),f=i.reversed?-x:x,m=a.reversed?-y:y;t.x%2&&(e=Math.abs(g-d)/2*(a.reversed?-1:1),d+=e,u+=e,g+=e),t.plotX=t.clientX=c,t.plotY=u,p+=f,h-=f,d-=m,g+=m,t.tileEdges={x1:p,x2:c,x3:h,y1:d,y2:u,y3:g},t.shapeType="path",t.shapeArgs={d:[["M",c,d],["L",h,u],["L",c,g],["L",p,u],["Z"]]}}this.translateColors()}},circle:{alignDataLabel:n.prototype.alignDataLabel,getSeriesPadding:function(e){return l(e,2,2)},haloPath:function(e){return n.prototype.pointClass.prototype.haloPath.call(this,e+(e&&this.radius))},translate:function(){let e=this.options,t=this.xAxis,i=this.yAxis,a=e.pointPadding||0,s=(e.rowsize||1)/2,n=e.colsize||1,o,l,p,h,d=!1;for(let e of(this.generatePoints(),this.points)){let u=r(Math.round(t.len-t.translate(e.x,0,1,0,0)),-t.len,2*t.len),g=r(Math.round(i.translate(e.y,0,1,0,0)),-i.len,2*i.len),c=a,y=!1;void 0!==e.pointPadding&&(c=e.pointPadding,y=!0,d=!0),(!h||d)&&(p=Math.floor(Math.sqrt((o=Math.abs(r(Math.floor(t.len-t.translate(e.x+n,0,1,0,0)),-t.len,2*t.len)-u))*o+(l=Math.abs(r(Math.floor(i.translate(e.y+s,0,1,0,0)),-i.len,2*i.len)-g))*l)/2),h=Math.min(o,p,l)-c,d&&!y&&(d=!1)),e.x%2&&(g+=l*(i.reversed?-1:1)),e.plotX=e.clientX=u,e.plotY=g,e.radius=h,e.shapeType="circle",e.shapeArgs={x:u,y:g,r:h}}this.translateColors()}},square:{alignDataLabel:s.prototype.alignDataLabel,translate:s.prototype.translate,getSeriesPadding:a,haloPath:s.prototype.pointClass.prototype.haloPath}};return p}),i(t,"Series/Tilemap/TilemapSeries.js",[t["Core/Globals.js"],t["Core/Series/SeriesRegistry.js"],t["Series/Tilemap/TilemapPoint.js"],t["Series/Tilemap/TilemapSeriesDefaults.js"],t["Series/Tilemap/TilemapShapes.js"],t["Core/Utilities.js"]],function(e,t,i,a,s,n){let{noop:r}=e,{column:o,heatmap:l,scatter:p}=t.seriesTypes,{addEvent:h,extend:d,merge:u,pushUnique:g}=n,c=[];function y(){if(this.recomputingForTilemap||"colorAxis"===this.coll)return;let e=this,t=e.series.map(function(t){return t.getSeriesPixelPadding&&t.getSeriesPixelPadding(e)}).reduce(function(e,t){return(e&&e.padding)>(t&&t.padding)?e:t},void 0)||{padding:0,axisLengthFactor:1},i=Math.round(t.padding*t.axisLengthFactor);t.padding&&(e.len-=i,e.recomputingForTilemap=!0,e.setAxisTranslation(),delete e.recomputingForTilemap,e.minPixelPadding+=t.padding,e.len+=i)}class x extends l{constructor(){super(...arguments),this.data=void 0,this.options=void 0,this.points=void 0,this.tileShape=void 0}static compose(e){g(c,e)&&h(e,"afterSetAxisTranslation",y)}alignDataLabel(){return this.tileShape.alignDataLabel.apply(this,arguments)}drawPoints(){for(let e of(o.prototype.drawPoints.call(this),this.points))e.graphic&&e.graphic[this.chart.styledMode?"css":"animate"](this.colorAttribs(e))}getSeriesPixelPadding(e){let t=e.isXAxis,i=this.tileShape.getSeriesPadding(this);if(!i)return{padding:0,axisLengthFactor:1};let a=Math.round(e.translate(t?2*i.xPad:i.yPad,0,1,0,1)),s=Math.round(e.translate(t?i.xPad:0,0,1,0,1));return{padding:(e.single?Math.abs(a-s)/2:Math.abs(a-s))||0,axisLengthFactor:t?2:1.1}}setOptions(){let e=super.setOptions.apply(this,arguments);return this.tileShape=s[e.tileShape],e}translate(){return this.tileShape.translate.apply(this,arguments)}}return x.defaultOptions=u(l.defaultOptions,a),d(x.prototype,{getSymbol:r,markerAttribs:p.prototype.markerAttribs,pointAttribs:o.prototype.pointAttribs,pointClass:i}),t.registerSeriesType("tilemap",x),x}),i(t,"masters/modules/tilemap.src.js",[t["Core/Globals.js"],t["Series/Tilemap/TilemapSeries.js"]],function(e,t){t.compose(e.Axis)})});//# sourceMappingURL=tilemap.js.map