/**
 * Highcharts Gantt JS v11.2.0 (2023-10-30)
 *
 * Tree Grid
 *
 * (c) 2016-2021 Jon Arild Nygard
 *
 * License: www.highcharts.com/license
 */!function(e){"object"==typeof module&&module.exports?(e.default=e,module.exports=e):"function"==typeof define&&define.amd?define("highcharts/modules/treegrid",["highcharts"],function(t){return e(t),e.Highcharts=t,e}):e("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(e){"use strict";var t=e?e._modules:{};function i(e,t,i,s){e.hasOwnProperty(t)||(e[t]=s.apply(null,i),"function"==typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:t,module:e[t]}})))}i(t,"Core/Axis/BrokenAxis.js",[t["Core/Axis/Stacking/StackItem.js"],t["Core/Utilities.js"]],function(e,t){var i;let{addEvent:s,find:o,fireEvent:r,isArray:n,isNumber:l,pick:a}=t;return function(i){let d=[];function h(){void 0!==this.brokenAxis&&this.brokenAxis.setBreaks(this.options.breaks,!1)}function c(){this.brokenAxis?.hasBreaks&&(this.options.ordinal=!1)}function p(){let e=this.brokenAxis;if(e?.hasBreaks){let t=this.tickPositions,i=this.tickPositions.info,s=[];for(let i=0;i<t.length;i++)e.isInAnyBreak(t[i])||s.push(t[i]);this.tickPositions=s,this.tickPositions.info=i}}function f(){this.brokenAxis||(this.brokenAxis=new x(this))}function u(){let{isDirty:e,options:{connectNulls:t},points:i,xAxis:s,yAxis:o}=this;if(e){let e=i.length;for(;e--;){let r=i[e],n=null===r.y&&!1===t,l=!n&&(s?.brokenAxis?.isInAnyBreak(r.x,!0)||o?.brokenAxis?.isInAnyBreak(r.y,!0));r.visible=!l&&!1!==r.options.visible}}}function g(){this.drawBreaks(this.xAxis,["x"]),this.drawBreaks(this.yAxis,a(this.pointArrayMap,["y"]))}function m(e,t){let i,s,o;let n=this,d=n.points;if(e?.brokenAxis?.hasBreaks){let h=e.brokenAxis;t.forEach(function(t){i=h?.breakArray||[],s=e.isXAxis?e.min:a(n.options.threshold,e.min);let c=e?.options?.breaks?.filter(function(e){let t=!0;for(let s=0;s<i.length;s++){let o=i[s];if(o.from===e.from&&o.to===e.to){t=!1;break}}return t});d.forEach(function(n){o=a(n["stack"+t.toUpperCase()],n[t]),i.forEach(function(t){if(l(s)&&l(o)){let i="";s<t.from&&o>t.to||s>t.from&&o<t.from?i="pointBreak":(s<t.from&&o>t.from&&o<t.to||s>t.from&&o>t.to&&o<t.from)&&(i="pointInBreak"),i&&r(e,i,{point:n,brk:t})}}),c?.forEach(function(t){r(e,"pointOutsideOfBreak",{point:n,brk:t})})})})}}function k(){let t=this.currentDataGrouping,i=t?.gapSize,s=this.points.slice(),o=this.yAxis,r=this.options.gapSize,n=s.length-1;if(r&&n>0){let t,l;for("value"!==this.options.gapUnit&&(r*=this.basePointRange),i&&i>r&&i>=this.basePointRange&&(r=i);n--;)if(l&&!1!==l.visible||(l=s[n+1]),t=s[n],!1!==l.visible&&!1!==t.visible){if(l.x-t.x>r){let i=(t.x+l.x)/2;s.splice(n+1,0,{isNull:!0,x:i}),o.stacking&&this.options.stacking&&((o.stacking.stacks[this.stackKey][i]=new e(o,o.options.stackLabels,!1,i,this.stack)).total=0)}l=t}}return this.getGraphPath(s)}i.compose=function(e,i){if(t.pushUnique(d,e)&&(e.keepProps.push("brokenAxis"),s(e,"init",f),s(e,"afterInit",h),s(e,"afterSetTickPositions",p),s(e,"afterSetOptions",c)),t.pushUnique(d,i)){let e=i.prototype;e.drawBreaks=m,e.gappedPath=k,s(i,"afterGeneratePoints",u),s(i,"afterRender",g)}return e};class x{static isInBreak(e,t){let i=e.repeat||1/0,s=e.from,o=e.to-e.from,r=t>=s?(t-s)%i:i-(s-t)%i;return e.inclusive?r<=o:r<o&&0!==r}static lin2Val(e){let t=this.brokenAxis,i=t&&t.breakArray;if(!i||!l(e))return e;let s=e,o,r;for(r=0;r<i.length&&!((o=i[r]).from>=s);r++)o.to<s?s+=o.len:x.isInBreak(o,s)&&(s+=o.len);return s}static val2Lin(e){let t=this.brokenAxis,i=t&&t.breakArray;if(!i||!l(e))return e;let s=e,o,r;for(r=0;r<i.length;r++)if((o=i[r]).to<=e)s-=o.len;else if(o.from>=e)break;else if(x.isInBreak(o,e)){s-=e-o.from;break}return s}constructor(e){this.hasBreaks=!1,this.axis=e}findBreakAt(e,t){return o(t,function(t){return t.from<e&&e<t.to})}isInAnyBreak(e,t){let i=this.axis,s=i.options.breaks||[],o=s.length,r,n,d;if(o&&l(e)){for(;o--;)x.isInBreak(s[o],e)&&(r=!0,n||(n=a(s[o].showPoints,!i.isXAxis)));d=r&&t?r&&!n:r}return d}setBreaks(e,t){let i=this,s=i.axis,o=n(e)&&!!e.length&&!!Object.keys(e[0]).length;s.isDirty=i.hasBreaks!==o,i.hasBreaks=o,e!==s.options.breaks&&(s.options.breaks=s.userOptions.breaks=e),s.forceRedraw=!0,s.series.forEach(function(e){e.isDirty=!0}),o||s.val2lin!==x.val2Lin||(delete s.val2lin,delete s.lin2val),o&&(s.userOptions.ordinal=!1,s.lin2val=x.lin2Val,s.val2lin=x.val2Lin,s.setExtremes=function(e,t,o,r,n){if(i.hasBreaks){let s;let o=this.options.breaks||[];for(;s=i.findBreakAt(e,o);)e=s.to;for(;s=i.findBreakAt(t,o);)t=s.from;t<e&&(t=e)}s.constructor.prototype.setExtremes.call(this,e,t,o,r,n)},s.setAxisTranslation=function(){if(s.constructor.prototype.setAxisTranslation.call(this),i.unitLength=void 0,i.hasBreaks){let e=s.options.breaks||[],t=[],o=[],n=a(s.pointRangePadding,0),d=0,h,c,p=s.userMin||s.min,f=s.userMax||s.max,u,g;e.forEach(function(e){c=e.repeat||1/0,l(p)&&l(f)&&(x.isInBreak(e,p)&&(p+=e.to%c-p%c),x.isInBreak(e,f)&&(f-=f%c-e.from%c))}),e.forEach(function(e){if(u=e.from,c=e.repeat||1/0,l(p)&&l(f)){for(;u-c>p;)u-=c;for(;u<p;)u+=c;for(g=u;g<f;g+=c)t.push({value:g,move:"in"}),t.push({value:g+e.to-e.from,move:"out",size:e.breakSize})}}),t.sort(function(e,t){return e.value===t.value?("in"===e.move?0:1)-("in"===t.move?0:1):e.value-t.value}),h=0,u=p,t.forEach(function(e){1===(h+="in"===e.move?1:-1)&&"in"===e.move&&(u=e.value),0===h&&l(u)&&(o.push({from:u,to:e.value,len:e.value-u-(e.size||0)}),d+=e.value-u-(e.size||0))}),i.breakArray=o,l(p)&&l(f)&&l(s.min)&&(i.unitLength=f-p-d+n,r(s,"afterBreaks"),s.staticScale?s.transA=s.staticScale:i.unitLength&&(s.transA*=(f-s.min+n)/i.unitLength),n&&(s.minPixelPadding=s.transA*(s.minPointOffset||0)),s.min=p,s.max=f)}}),a(t,!0)&&s.chart.redraw()}}i.Additions=x}(i||(i={})),i}),i(t,"Core/Axis/GridAxis.js",[t["Core/Axis/Axis.js"],t["Core/Globals.js"],t["Core/Utilities.js"]],function(e,t,i){var s,o;let{dateFormats:r}=t,{addEvent:n,defined:l,erase:a,find:d,isArray:h,isNumber:c,merge:p,pick:f,timeUnits:u,wrap:g}=i;(o=s||(s={}))[o.top=0]="top",o[o.right=1]="right",o[o.bottom=2]="bottom",o[o.left=3]="left";let m=[];function k(e){return i.isObject(e,!0)}function x(e,t){let i={width:0,height:0};if(t.forEach(function(t){let s=e[t],o=0,r=0,n;k(s)&&(o=(n=k(s.label)?s.label:{}).getBBox?n.getBBox().height:0,n.textStr&&!c(n.textPxLength)&&(n.textPxLength=n.getBBox().width),r=c(n.textPxLength)?Math.round(n.textPxLength):0,n.textStr&&(r=Math.round(n.getBBox().width)),i.height=Math.max(o,i.height),i.width=Math.max(r,i.width))}),"treegrid"===this.options.type&&this.treeGrid&&this.treeGrid.mapOfPosToGridNode){let e=this.treeGrid.mapOfPosToGridNode[-1].height||0;i.width+=this.options.labels.indentation*(e-1)}return i}function b(){let{grid:e}=this;(e&&e.columns||[]).forEach(function(e){e.getOffset()})}function y(e){let t=this.options,i=t.grid||{};if(!0===i.enabled){let{axisTitle:t,height:i,horiz:o,left:r,offset:n,opposite:l,options:a,top:d,width:h}=this,c=this.tickSize(),p=t&&t.getBBox().width,u=a.title.x,g=a.title.y,m=f(a.title.margin,o?5:10),k=t?this.chart.renderer.fontMetrics(t).f:0,x=c?c[0]/2:0,b=(o?d+i:r)+(o?1:-1)*(l?-1:1)*x+(this.side===s.bottom?k:0);e.titlePosition.x=o?r-(p||0)/2-m+u:b+(l?h:0)+n+u,e.titlePosition.y=o?b-(l?i:0)+(l?k:-k)/2+n+g:d-m+g}}function v(){let{chart:t,options:{grid:i={}},userOptions:s}=this;if(i.enabled&&function(e){let t=e.options;t.labels.align=f(t.labels.align,"center"),e.categories||(t.showLastLabel=!1),e.labelRotation=0,t.labels.rotation=0,t.minTickInterval=1}(this),i.columns){let o=this.grid.columns=[],r=this.grid.columnIndex=0;for(;++r<i.columns.length;){let n=p(s,i.columns[i.columns.length-r-1],{isInternal:!0,linkedTo:0,type:"category",scrollbar:{enabled:!1}});delete n.grid.columns;let l=new e(this.chart,n,"yAxis");l.grid.isColumn=!0,l.grid.columnIndex=r,a(t.axes,l),a(t[this.coll]||[],l),o.push(l)}}}function G(){let e=this.grid,t=this.options,i=t.grid||{};if(!0===i.enabled){let i=this.min||0,o=this.max||0;if(this.maxLabelDimensions=this.getMaxLabelDimensions(this.ticks,this.tickPositions),this.rightWall&&this.rightWall.destroy(),this.grid&&this.grid.isOuterAxis()&&this.axisLine){let e=t.lineWidth;if(e){let r=this.getLinePath(e),n=r[0],l=r[1],a=(this.tickSize("tick")||[1])[0],d=(a-1)*(this.side===s.top||this.side===s.left?-1:1);if("M"===n[0]&&"L"===l[0]&&(this.horiz?(n[2]+=d,l[2]+=d):(n[1]+=d,l[1]+=d)),!this.horiz&&this.chart.marginRight){let e=["L",this.left,n[2]||0],s=[n,e],r=["L",this.chart.chartWidth-this.chart.marginRight,this.toPixels(o+this.tickmarkOffset)],a=["M",l[1]||0,this.toPixels(o+this.tickmarkOffset)],d=[a,r];this.grid.upperBorder||i%1==0||(this.grid.upperBorder=this.grid.renderBorder(s)),this.grid.upperBorder&&(this.grid.upperBorder.attr({stroke:t.lineColor,"stroke-width":t.lineWidth}),this.grid.upperBorder.animate({d:s})),this.grid.lowerBorder||o%1==0||(this.grid.lowerBorder=this.grid.renderBorder(d)),this.grid.lowerBorder&&(this.grid.lowerBorder.attr({stroke:t.lineColor,"stroke-width":t.lineWidth}),this.grid.lowerBorder.animate({d:d}))}this.grid.axisLineExtra?(this.grid.axisLineExtra.attr({stroke:t.lineColor,"stroke-width":t.lineWidth}),this.grid.axisLineExtra.animate({d:r})):this.grid.axisLineExtra=this.grid.renderBorder(r),this.axisLine[this.showAxis?"show":"hide"]()}}if((e&&e.columns||[]).forEach(e=>e.render()),!this.horiz&&this.chart.hasRendered&&(this.scrollbar||this.linkedParent&&this.linkedParent.scrollbar)){let e,t;let s=this.tickmarkOffset,r=this.tickPositions[this.tickPositions.length-1],n=this.tickPositions[0];for(;(e=this.hiddenLabels.pop())&&e.element;)e.show();for(;(t=this.hiddenMarks.pop())&&t.element;)t.show();(e=this.ticks[n].label)&&(i-n>s?this.hiddenLabels.push(e.hide()):e.show()),(e=this.ticks[r].label)&&(r-o>s?this.hiddenLabels.push(e.hide()):e.show());let l=this.ticks[r].mark;l&&r-o<s&&r-o>0&&this.ticks[r].isLast&&this.hiddenMarks.push(l.hide())}}}function P(){let e=this.tickPositions&&this.tickPositions.info,t=this.options,i=t.grid||{},s=this.userOptions.labels||{};i.enabled&&(this.horiz?(this.series.forEach(e=>{e.options.pointRange=0}),e&&t.dateTimeLabelFormats&&t.labels&&!l(s.align)&&(!1===t.dateTimeLabelFormats[e.unitName].range||e.count>1)&&(t.labels.align="left",l(s.x)||(t.labels.x=3))):"treegrid"!==this.options.type&&this.grid&&this.grid.columns&&(this.minPointOffset=this.tickInterval))}function A(e){let t;let i=this.options,s=e.userOptions,o=i&&k(i.grid)?i.grid:{};!0===o.enabled&&(t=p(!0,{className:"highcharts-grid-axis "+(s.className||""),dateTimeLabelFormats:{hour:{list:["%H:%M","%H"]},day:{list:["%A, %e. %B","%a, %e. %b","%E"]},week:{list:["Week %W","W%W"]},month:{list:["%B","%b","%o"]}},grid:{borderWidth:1},labels:{padding:2,style:{fontSize:"0.9em"}},margin:0,title:{text:null,reserveSpace:!1,rotation:0},units:[["millisecond",[1,10,100]],["second",[1,10]],["minute",[1,5,15]],["hour",[1,6]],["day",[1]],["week",[1]],["month",[1]],["year",null]]},s),"xAxis"===this.coll&&(l(s.linkedTo)&&!l(s.tickPixelInterval)&&(t.tickPixelInterval=350),!l(s.tickPixelInterval)&&l(s.linkedTo)&&!l(s.tickPositioner)&&!l(s.tickInterval)&&(t.tickPositioner=function(e,i){let s=this.linkedParent&&this.linkedParent.tickPositions&&this.linkedParent.tickPositions.info;if(s){let o=t.units||[],r,n=1,l="year";for(let e=0;e<o.length;e++){let t=o[e];if(t&&t[0]===s.unitName){r=e;break}}let a=c(r)&&o[r+1];if(a){l=a[0]||"year";let e=a[1];n=e&&e[0]||1}else"year"===s.unitName&&(n=10*s.count);let d=u[l];return this.tickInterval=d*n,this.chart.time.getTimeTicks({unitRange:d,count:n,unitName:l},e,i,this.options.startOfWeek)}})),p(!0,this.options,t),this.horiz&&(i.minPadding=f(s.minPadding,0),i.maxPadding=f(s.maxPadding,0)),c(i.grid.borderWidth)&&(i.tickWidth=i.lineWidth=o.borderWidth))}function T(e){let t=e.userOptions,i=t&&t.grid||{},s=i.columns;i.enabled&&s&&p(!0,this.options,s[s.length-1])}function B(){(this.grid.columns||[]).forEach(e=>e.setScale())}function C(e){let{horiz:t,maxLabelDimensions:i,options:{grid:s={}}}=this;if(s.enabled&&i){let o=2*this.options.labels.distance,r=t?s.cellHeight||o+i.height:o+i.width;h(e.tickSize)?e.tickSize[0]=r:e.tickSize=[r,0]}}function O(){this.axes.forEach(e=>{(e.grid&&e.grid.columns||[]).forEach(e=>{e.setAxisSize(),e.setAxisTranslation()})})}function I(e){let{grid:t}=this;(t.columns||[]).forEach(t=>t.destroy(e.keepEvents)),t.columns=void 0}function w(e){let t=e.userOptions||{},i=t.grid||{};i.enabled&&l(i.borderColor)&&(t.tickColor=t.lineColor=i.borderColor),this.grid||(this.grid=new M(this)),this.hiddenLabels=[],this.hiddenMarks=[]}function E(e){let t=this.label,i=this.axis,o=i.reversed,r=i.chart,n=i.options,l=n.grid||{},a=i.options.labels,d=a.align,h=s[i.side],p=e.tickmarkOffset,f=i.tickPositions,u=this.pos-p,g=c(f[e.index+1])?f[e.index+1]-p:(i.max||0)+p,m=i.tickSize("tick"),k=m?m[0]:0,x=m?m[1]/2:0;if(!0===l.enabled){let s,n,l,c;if("top"===h?n=(s=i.top+i.offset)-k:"bottom"===h?s=(n=r.chartHeight-i.bottom+i.offset)+k:(s=i.top+i.len-(i.translate(o?g:u)||0),n=i.top+i.len-(i.translate(o?u:g)||0)),"right"===h?c=(l=r.chartWidth-i.right+i.offset)+k:"left"===h?l=(c=i.left+i.offset)-k:(l=Math.round(i.left+(i.translate(o?g:u)||0))-x,c=Math.min(Math.round(i.left+(i.translate(o?u:g)||0))-x,i.left+i.len)),this.slotWidth=c-l,e.pos.x="left"===d?l:"right"===d?c:l+(c-l)/2,e.pos.y=n+(s-n)/2,t){let i=r.renderer.fontMetrics(t),s=t.getBBox().height;if(a.useHTML)e.pos.y+=i.b+-(s/2);else{let t=Math.round(s/i.h);e.pos.y+=(i.b-(i.h-i.f))/2+-((t-1)*i.h/2)}}e.pos.x+=i.horiz&&a.x||0}}function L(e){let{axis:i,value:s}=e;if(i.options.grid&&i.options.grid.enabled){let o;let r=i.tickPositions,n=(i.linkedParent||i).series[0],l=s===r[0],a=s===r[r.length-1],h=n&&d(n.options.data,function(e){return e[i.isXAxis?"x":"y"]===s});h&&n.is("gantt")&&(o=p(h),t.seriesTypes.gantt.prototype.pointClass.setGanttPointAliases(o)),e.isFirst=l,e.isLast=a,e.point=o}}function N(){let e=this.options,t=e.grid||{},i=this.categories,s=this.tickPositions,o=s[0],r=s[s.length-1],n=this.linkedParent&&this.linkedParent.min,l=this.linkedParent&&this.linkedParent.max,a=n||this.min,d=l||this.max,h=this.tickInterval;!0===t.enabled&&!i&&(this.horiz||this.isLinked)&&(o<a&&o+h>a&&!e.startOnTick&&(s[0]=a),r>d&&r-h<d&&!e.endOnTick&&(s[s.length-1]=d))}function S(e){var t;let{options:{grid:i={}}}=this;return!0===i.enabled&&this.categories?this.tickInterval:e.apply(this,(t=arguments,Array.prototype.slice.call(t,1)))}class M{constructor(e){this.axis=e}isOuterAxis(){let e=this.axis,t=e.chart,i=e.grid.columnIndex,s=e.linkedParent&&e.linkedParent.grid.columns||e.grid.columns,o=i?e.linkedParent:e,r=-1,n=0;return(t[e.coll]||[]).forEach((t,i)=>{t.side!==e.side||t.options.isInternal||(n=i,t!==o||(r=i))}),n===r&&(!c(i)||s.length===i)}renderBorder(e){let t=this.axis,i=t.chart.renderer,s=t.options,o=i.path(e).addClass("highcharts-axis-line").add(t.axisBorder);return i.styledMode||o.attr({stroke:s.lineColor,"stroke-width":s.lineWidth,zIndex:7}),o}}return r.E=function(e){return this.dateFormat("%a",e,!0).charAt(0)},r.W=function(e){let t=this,i=new this.Date(e);["Hours","Milliseconds","Minutes","Seconds"].forEach(function(e){t.set(e,i,0)});let s=(this.get("Day",i)+6)%7,o=new this.Date(i.valueOf());this.set("Date",o,this.get("Date",i)-s+3);let r=new this.Date(this.get("FullYear",o),0,1);return 4!==this.get("Day",r)&&(this.set("Month",i,0),this.set("Date",i,1+(11-this.get("Day",r))%7)),(1+Math.floor((o.valueOf()-r.valueOf())/6048e5)).toString()},{compose:function(e,t,s){return i.pushUnique(m,e)&&(e.keepProps.push("grid"),e.prototype.getMaxLabelDimensions=x,g(e.prototype,"unsquish",S),n(e,"init",w),n(e,"afterGetOffset",b),n(e,"afterGetTitlePosition",y),n(e,"afterInit",v),n(e,"afterRender",G),n(e,"afterSetAxisTranslation",P),n(e,"afterSetOptions",A),n(e,"afterSetOptions",T),n(e,"afterSetScale",B),n(e,"afterTickSize",C),n(e,"trimTicks",N),n(e,"destroy",I)),i.pushUnique(m,t)&&n(t,"afterSetChartSize",O),i.pushUnique(m,s)&&(n(s,"afterGetLabelPosition",E),n(s,"labelFormat",L)),e}}}),i(t,"Gantt/Tree.js",[t["Core/Utilities.js"]],function(e){let{extend:t,isNumber:i,pick:s}=e;function o(e,r,n,l,a,d){let h=d&&d.after,c=d&&d.before,p={data:l,depth:n-1,id:e,level:n,parent:r||""},f=0,u=0,g,m;"function"==typeof c&&c(p,d);let k=(a[e]||[]).map(t=>{let s=o(t.id,e,n+1,t,a,d),r=t.start||NaN,l=!0===t.milestone?r:t.end||NaN;return g=!i(g)||r<g?r:g,m=!i(m)||l>m?l:m,f=f+1+s.descendants,u=Math.max(s.height+1,u),s});return l&&(l.start=s(l.start,g),l.end=s(l.end,m)),t(p,{children:k,descendants:f,height:u}),"function"==typeof h&&h(p,d),p}return{getNode:o,getTree:function(e,t){let i=function(e){let t=e.reduce((e,t)=>{let i=s(t.parent,"");return void 0===e[i]&&(e[i]=[]),e[i].push(t),e},{});return t}(e);return o("",null,1,null,i,t)}}}),i(t,"Core/Axis/TreeGrid/TreeGridTick.js",[t["Core/Utilities.js"]],function(e){let{addEvent:t,isObject:i,isNumber:s,pick:o,wrap:r}=e,n=[];function l(){this.treeGrid||(this.treeGrid=new h(this))}function a(e,t,r,n,l,a,d,h,c){let p,f,u,g,m;let k=o(this.options&&this.options.labels,a),x=this.pos,b=this.axis,y=b.options,v="treegrid"===y.type,G=e.apply(this,[t,r,n,l,k,d,h,c]);return v&&(p=k&&i(k.symbol,!0)?k.symbol:{},f=k&&s(k.indentation)?k.indentation:0,m=(g=(u=b.treeGrid.mapOfPosToGridNode)&&u[x])&&g.depth||1,G.x+=(p.width||0)+2*(p.padding||0)+(m-1)*f),G}function d(e){let r,n,l;let a=this,d=a.pos,h=a.axis,c=a.label,p=h.treeGrid.mapOfPosToGridNode,f=h.options,u=o(a.options&&a.options.labels,f&&f.labels),g=u&&i(u.symbol,!0)?u.symbol:{},m=p&&p[d],k=m&&m.depth,x="treegrid"===f.type,b=h.tickPositions.indexOf(d)>-1,y="highcharts-treegrid-node-",v=h.chart.styledMode;x&&m&&c&&c.element&&c.addClass(y+"level-"+k),e.apply(a,Array.prototype.slice.call(arguments,1)),x&&c&&c.element&&m&&m.descendants&&m.descendants>0&&(r=h.treeGrid.isCollapsed(m),function(e,t){let i=e.treeGrid,r=!i.labelIcon,n=t.renderer,l=t.xy,a=t.options,d=a.width||0,h=a.height||0,c={x:l.x-d/2-(a.padding||0),y:l.y-h/2},p=t.collapsed?90:180,f=t.show&&s(c.y),u=i.labelIcon;u||(i.labelIcon=u=n.path(n.symbols[a.type](a.x||0,a.y||0,d,h)).addClass("highcharts-label-icon").add(t.group)),u[f?"show":"hide"](),n.styledMode||u.attr({cursor:"pointer",fill:o(t.color,"#666666"),"stroke-width":1,stroke:a.lineColor,strokeWidth:a.lineWidth||0}),u[r?"attr":"animate"]({translateX:c.x,translateY:c.y,rotation:p})}(a,{color:!v&&c.styles&&c.styles.color||"",collapsed:r,group:c.parentGroup,options:g,renderer:c.renderer,show:b,xy:c.xy}),n=y+(r?"collapsed":"expanded"),l=y+(r?"expanded":"collapsed"),c.addClass(n).removeClass(l),v||c.css({cursor:"pointer"}),[c,a.treeGrid.labelIcon].forEach(e=>{e&&!e.attachedTreeGridEvents&&(t(e.element,"mouseover",function(){c.addClass("highcharts-treegrid-node-active"),c.renderer.styledMode||c.css({textDecoration:"underline"})}),t(e.element,"mouseout",function(){!function(e,t){let s=i(t.style)?t.style:{};e.removeClass("highcharts-treegrid-node-active"),e.renderer.styledMode||e.css({textDecoration:s.textDecoration})}(c,u)}),t(e.element,"click",function(){a.treeGrid.toggleCollapse()}),e.attachedTreeGridEvents=!0)}))}class h{static compose(i){e.pushUnique(n,i)&&(t(i,"init",l),r(i.prototype,"getLabelPosition",a),r(i.prototype,"renderLabel",d),i.prototype.collapse=function(e){this.treeGrid.collapse(e)},i.prototype.expand=function(e){this.treeGrid.expand(e)},i.prototype.toggleCollapse=function(e){this.treeGrid.toggleCollapse(e)})}constructor(e){this.tick=e}collapse(e){let t=this.tick,i=t.axis,s=i.brokenAxis;if(s&&i.treeGrid.mapOfPosToGridNode){let r=t.pos,n=i.treeGrid.mapOfPosToGridNode[r],l=i.treeGrid.collapse(n);s.setBreaks(l,o(e,!0))}}destroy(){this.labelIcon&&this.labelIcon.destroy()}expand(e){let t=this.tick,i=t.axis,s=i.brokenAxis;if(s&&i.treeGrid.mapOfPosToGridNode){let r=t.pos,n=i.treeGrid.mapOfPosToGridNode[r],l=i.treeGrid.expand(n);s.setBreaks(l,o(e,!0))}}toggleCollapse(e){let t=this.tick,i=t.axis,s=i.brokenAxis;if(s&&i.treeGrid.mapOfPosToGridNode){let r=t.pos,n=i.treeGrid.mapOfPosToGridNode[r],l=i.treeGrid.toggleCollapse(n);s.setBreaks(l,o(e,!0))}}}return h}),i(t,"Series/TreeUtilities.js",[t["Core/Color/Color.js"],t["Core/Utilities.js"]],function(e,t){let{extend:i,isArray:s,isNumber:o,isObject:r,merge:n,pick:l}=t;return{getColor:function(t,i){let s,o,r,n,a,d;let h=i.index,c=i.mapOptionsToLevel,p=i.parentColor,f=i.parentColorIndex,u=i.series,g=i.colors,m=i.siblings,k=u.points,x=u.chart.options.chart;return t&&(s=k[t.i],o=c[t.level]||{},s&&o.colorByPoint&&(n=s.index%(g?g.length:x.colorCount),r=g&&g[n]),u.chart.styledMode||(a=l(s&&s.options.color,o&&o.color,r,p&&(t=>{let i=o&&o.colorVariation;return i&&"brightness"===i.key&&h&&m?e.parse(t).brighten(i.to*(h/m)).get():t})(p),u.color)),d=l(s&&s.options.colorIndex,o&&o.colorIndex,n,f,i.colorIndex)),{color:a,colorIndex:d}},getLevelOptions:function(e){let t={},i,a,d,h,c,p;if(r(e))for(h=o(e.from)?e.from:1,p=e.levels,a={},i=r(e.defaults)?e.defaults:{},s(p)&&(a=p.reduce((e,t)=>{let s,a,d;return r(t)&&o(t.level)&&(a=l((d=n({},t)).levelIsConstant,i.levelIsConstant),delete d.levelIsConstant,delete d.level,r(e[s=t.level+(a?0:h-1)])?n(!0,e[s],d):e[s]=d),e},{})),c=o(e.to)?e.to:1,d=0;d<=c;d++)t[d]=n({},i,r(a[d])?a[d]:{});return t},setTreeValues:function e(t,s){let o=s.before,r=s.idRoot,n=s.mapIdToNode,a=n[r],d=!1!==s.levelIsConstant,h=s.points,c=h[t.i],p=c&&c.options||{},f=[],u=0;t.levelDynamic=t.level-(d?0:a.level),t.name=l(c&&c.name,""),t.visible=r===t.id||!0===s.visible,"function"==typeof o&&(t=o(t,s)),t.children.forEach((o,r)=>{let n=i({},s);i(n,{index:r,siblings:t.children.length,visible:t.visible}),o=e(o,n),f.push(o),o.visible&&(u+=o.val)});let g=l(p.value,u);return t.visible=g>=0&&(u>0||t.visible),t.children=f,t.childrenTotal=u,t.isLeaf=t.visible&&!u,t.val=g,t},updateRootId:function(e){let t,i;return r(e)&&(i=r(e.options)?e.options:{},t=l(e.rootNode,i.rootId,""),r(e.userOptions)&&(e.userOptions.rootId=t),e.rootNode=t),t}}}),i(t,"Core/Axis/TreeGrid/TreeGridAxis.js",[t["Core/Axis/BrokenAxis.js"],t["Core/Axis/GridAxis.js"],t["Gantt/Tree.js"],t["Core/Axis/TreeGrid/TreeGridTick.js"],t["Series/TreeUtilities.js"],t["Core/Utilities.js"]],function(e,t,i,s,o,r){let n;let{getLevelOptions:l}=o,{addEvent:a,find:d,fireEvent:h,isArray:c,isObject:p,isString:f,merge:u,pick:g,wrap:m}=r,k=[];function x(e,t){let i=e.collapseEnd||0,s=e.collapseStart||0;return i>=t&&(s-=.5),{from:s,to:i,showPoints:!1}}function b(e,t,s){let o=[],r=[],n={},l="boolean"==typeof t&&t,a={},h=-1,c=i.getTree(e,{after:function(e){let t=a[e.pos],i=0,s=0;t.children.forEach(function(e){s+=(e.descendants||0)+1,i=Math.max((e.height||0)+1,i)}),t.descendants=s,t.height=i,t.collapsed&&r.push(t)},before:function(e){let t,i;let s=p(e.data,!0)?e.data:{},r=f(s.name)?s.name:"",c=n[e.parent],u=p(c,!0)?a[c.pos]:null;l&&p(u,!0)&&(t=d(u.children,function(e){return e.name===r}))?(i=t.pos,t.nodes.push(e)):i=h++,!a[i]&&(a[i]=t={depth:u?u.depth+1:0,name:r,id:s.id,nodes:[e],children:[],pos:i},-1!==i&&o.push(r),p(u,!0)&&u.children.push(t)),f(e.id)&&(n[e.id]=e),t&&!0===s.collapsed&&(t.collapsed=!0),e.pos=i}});return{categories:o,mapOfIdToNode:n,mapOfPosToGridNode:a=function(e,t){let i=function(e,s,o){let r=e.nodes,n=s+(-1===s?0:t-1),l=(n-s)/2,a=s+l;return r.forEach(function(e){let t=e.data;p(t,!0)&&(t.y=s+(t.seriesIndex||0),delete t.seriesIndex),e.pos=a}),o[a]=e,e.pos=a,e.tickmarkOffset=l+.5,e.collapseStart=n+.5,e.children.forEach(function(e){i(e,n+1,o),n=(e.collapseEnd||0)-.5}),e.collapseEnd=n+.5,o};return i(e["-1"],-1,{})}(a,s),collapsedNodes:r,tree:c}}function y(e){let t=e.target,i=t.axes;i.filter(function(e){return"treegrid"===e.options.type}).forEach(function(t){let i=t.options||{},s=i.labels,o=i.uniqueNames,r=i.max,n=!t.treeGrid.mapOfPosToGridNode||t.series.some(function(e){return!e.hasRendered||e.isDirtyData||e.isDirty}),a=0,d,h;if(n){if(d=t.series.reduce(function(e,t){return t.visible&&((t.options.data||[]).forEach(function(i){t.options.keys&&t.options.keys.length&&(i=t.pointClass.prototype.optionsToObject.call({series:t},i),t.pointClass.setGanttPointAliases(i)),p(i,!0)&&(i.seriesIndex=a,e.push(i))}),!0===o&&a++),e},[]),r&&d.length<r)for(let e=d.length;e<=r;e++)d.push({name:e+"​"});h=b(d,o||!1,!0===o?a:1),t.categories=h.categories,t.treeGrid.mapOfPosToGridNode=h.mapOfPosToGridNode,t.hasNames=!0,t.treeGrid.tree=h.tree,t.series.forEach(function(e){let t=(e.options.data||[]).map(function(t){return c(t)&&e.options.keys&&e.options.keys.length&&d.forEach(function(e){t.indexOf(e.x)>=0&&t.indexOf(e.x2)>=0&&(t=e)}),p(t,!0)?u(t):t});e.visible&&e.setData(t,!1)}),t.treeGrid.mapOptionsToLevel=l({defaults:s,from:1,levels:s&&s.levels,to:t.treeGrid.tree&&t.treeGrid.tree.height}),"beforeRender"===e.type&&(t.treeGrid.collapsedNodes=h.collapsedNodes)}})}function v(e,t){let i=this.treeGrid.mapOptionsToLevel||{},s="treegrid"===this.options.type,o=this.ticks,r=o[t],l,a,d;s&&this.treeGrid.mapOfPosToGridNode?((l=i[(d=this.treeGrid.mapOfPosToGridNode[t]).depth])&&(a={labels:l}),!r&&n?o[t]=r=new n(this,t,void 0,void 0,{category:d.name,tickmarkOffset:d.tickmarkOffset,options:a}):(r.parameters.category=d.name,r.options=a,r.addLabel())):e.apply(this,Array.prototype.slice.call(arguments,1))}function G(e,t,i,s){let o=this,r="treegrid"===i.type;o.treeGrid||(o.treeGrid=new A(o)),r&&(a(t,"beforeRender",y),a(t,"beforeRedraw",y),a(t,"addSeries",function(e){if(e.options.data){let t=b(e.options.data,i.uniqueNames||!1,1);o.treeGrid.collapsedNodes=(o.treeGrid.collapsedNodes||[]).concat(t.collapsedNodes)}}),a(o,"foundExtremes",function(){o.treeGrid.collapsedNodes&&o.treeGrid.collapsedNodes.forEach(function(e){let t=o.treeGrid.collapse(e);o.brokenAxis&&(o.brokenAxis.setBreaks(t,!1),o.treeGrid.collapsedNodes&&(o.treeGrid.collapsedNodes=o.treeGrid.collapsedNodes.filter(t=>e.collapseStart!==t.collapseStart||e.collapseEnd!==t.collapseEnd)))})}),a(o,"afterBreaks",function(){"yAxis"===o.coll&&!o.staticScale&&o.chart.options.chart.height&&(o.isDirty=!0)}),i=u({grid:{enabled:!0},labels:{align:"left",levels:[{level:void 0},{level:1,style:{fontWeight:"bold"}}],symbol:{type:"triangle",x:-5,y:-5,height:10,width:10,padding:5}},uniqueNames:!1},i,{reversed:!0,grid:{columns:void 0}})),e.apply(o,[t,i,s]),r&&(o.hasNames=!0,o.options.showLastLabel=!0)}function P(e){let t=this.options,i="treegrid"===t.type;i?(this.min=g(this.userMin,t.min,this.dataMin),this.max=g(this.userMax,t.max,this.dataMax),h(this,"foundExtremes"),this.setAxisTranslation(),this.tickmarkOffset=.5,this.tickInterval=1,this.tickPositions=this.treeGrid.mapOfPosToGridNode?this.treeGrid.getTickPositions():[]):e.apply(this,Array.prototype.slice.call(arguments,1))}class A{static compose(o,l,a,d){if(r.pushUnique(k,o)){-1===o.keepProps.indexOf("treeGrid")&&o.keepProps.push("treeGrid");let e=o.prototype;m(e,"generateTick",v),m(e,"init",G),m(e,"setTickInterval",P),e.utils={getNode:i.getNode}}return r.pushUnique(k,d)&&!n&&(n=d),t.compose(o,l,d),e.compose(o,a),s.compose(d),o}constructor(e){this.axis=e}setCollapsedStatus(e){let t=this.axis,i=t.chart;t.series.forEach(function(t){let s=t.options.data;if(e.id&&s){let o=i.get(e.id),r=s[t.data.indexOf(o)];o&&r&&(o.collapsed=e.collapsed,r.collapsed=e.collapsed)}})}collapse(e){let t=this.axis,i=t.options.breaks||[],s=x(e,t.max);return i.push(s),e.collapsed=!0,t.treeGrid.setCollapsedStatus(e),i}expand(e){let t=this.axis,i=t.options.breaks||[],s=x(e,t.max);return e.collapsed=!1,t.treeGrid.setCollapsedStatus(e),i.reduce(function(e,t){return(t.to!==s.to||t.from!==s.from)&&e.push(t),e},[])}getTickPositions(){let e=this.axis,t=Math.floor(e.min/e.tickInterval)*e.tickInterval,i=Math.ceil(e.max/e.tickInterval)*e.tickInterval;return Object.keys(e.treeGrid.mapOfPosToGridNode||{}).reduce(function(s,o){let r=+o;return r>=t&&r<=i&&!(e.brokenAxis&&e.brokenAxis.isInAnyBreak(r))&&s.push(r),s},[])}isCollapsed(e){let t=this.axis,i=t.options.breaks||[],s=x(e,t.max);return i.some(function(e){return e.from===s.from&&e.to===s.to})}toggleCollapse(e){return this.isCollapsed(e)?this.expand(e):this.collapse(e)}}return A}),i(t,"masters/modules/treegrid.src.js",[t["Core/Globals.js"],t["Core/Axis/TreeGrid/TreeGridAxis.js"]],function(e,t){t.compose(e.Axis,e.Chart,e.Series,e.Tick)})});//# sourceMappingURL=treegrid.js.map