// Store scales per dashlet ID
var minemapDimensions = {};

function scaleMinemapTable() {
    $(".minemap_map_inboard").each(function() {
        var $container = $(this);
        var dashletId = $container.closest(".dashlet").attr("id");
        var $table = $container.find("table");

        // If we have stored dimensions for this dashlet, apply them immediately
        if (minemapDimensions[dashletId]) {
            applyStoredDimensions($container, minemapDimensions[dashletId]);
            return;
        }
        
        // First time calculation
        $table.css("transform", "none");
        var containerWidth = $container.width();
        var tableWidth = $table.outerWidth();
        var tableHeight = $table.outerHeight();
        var scale = Math.min(containerWidth / tableWidth, 0.95);
        var totalHeight = (tableHeight * scale) + 
                         $container.find(".infotable_title").outerHeight() + 
                         $container.find(".ajax_date").outerHeight() + 4;

        // Store dimensions
        minemapDimensions[dashletId] = {
            scale: scale,
            totalHeight: totalHeight,
            tableHeight: tableHeight * scale
        };

        // Apply dimensions
        applyStoredDimensions($container, minemapDimensions[dashletId]);
    });
}

function applyStoredDimensions($container, dimensions) {
    var $table = $container.find("table");
    var $dashlet = $container.closest(".dashlet");
    // Apply scale immediately
    $table.css({
        "transform": "scale(" + dimensions.scale + ")",
        "transform-origin": "0 0"
    });

    // Apply heights
    $container.find(".table-container").height(dimensions.tableHeight);
    $container.height(dimensions.totalHeight);
    $dashlet.height(dimensions.totalHeight + 30);
    $container.parent().height(dimensions.totalHeight * $container.css("transform").split(",")[0].split("(")[1]);
}

// Initialize on page load
$(document).ready(function() {
    scaleMinemapTable();
    
    // Handle window resize
    var resizeTimer;
    $(window).resize(function() {
        clearTimeout(resizeTimer);
        resizeTimer = setTimeout(function() {
            minemapDimensions = {}; // Clear stored dimensions
            scaleMinemapTable();
        }, 250);
    });
});

// Handle Ajax updates
$(document).ajaxComplete(function(event, xhr, settings) {
    if (settings.url && settings.url.includes("getxicoreajax")) {
        requestAnimationFrame(scaleMinemapTable);
    }
});